/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic.logging;

import com.intellij.diagnostic.logging.AdditionalTabComponent;
import com.intellij.diagnostic.logging.LogConsole;
import com.intellij.diagnostic.logging.LogContentPreprocessor;
import com.intellij.diagnostic.logging.LogFilter;
import com.intellij.diagnostic.logging.LogFilterListener;
import com.intellij.diagnostic.logging.LogFilterModel;
import com.intellij.diagnostic.logging.LogFragment;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.ui.FilterComponent;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LogConsoleBase
extends AdditionalTabComponent
implements LogConsole,
LogFilterListener {
    private static final Logger LOG = Logger.getInstance((String)"com.intellij.diagnostic.logging.LogConsoleImpl");
    private ConsoleView myConsole;
    private final LightProcessHandler myProcessHandler;
    private ReaderThread myReaderThread;
    private StringBuffer myOriginalDocument;
    private String myLineUnderSelection;
    private int myLineOffset;
    private LogContentPreprocessor myContentPreprocessor;
    private String myTitle;
    private boolean myWasInitialized;
    private final JPanel myTopComponent;
    private ActionGroup myActions;
    private final boolean myBuildInActions;
    private LogFilterModel myModel;
    private FilterComponent myFilter;
    private JPanel mySearchComponent;
    private JComboBox myLogFilterCombo;
    private JPanel myTextFilterWrapper;

    public LogConsoleBase(Project project, @Nullable Reader reader, String title, boolean buildInActions, LogFilterModel model) {
        super((LayoutManager)new BorderLayout());
        this.$$$setupUI$$$();
        this.myProcessHandler = new LightProcessHandler();
        this.myOriginalDocument = null;
        this.myLineUnderSelection = null;
        this.myLineOffset = -1;
        this.myTitle = null;
        this.myTopComponent = new JPanel(new BorderLayout());
        this.myFilter = new FilterComponent("LOG_FILTER_HISTORY", 5){

            public void filter() {
                LogConsoleBase.this.myModel.updateCustomFilter(this.getFilter());
            }
        };
        this.myTitle = title;
        this.myModel = model;
        this.myReaderThread = new ReaderThread(reader);
        this.myBuildInActions = buildInActions;
        TextConsoleBuilder builder = TextConsoleBuilderFactory.getInstance().createBuilder(project);
        this.myConsole = builder.getConsole();
        this.myConsole.attachToProcess((ProcessHandler)this.myProcessHandler);
        this.myModel.addFilterListener((LogFilterListener)this);
    }

    public LogConsoleBase(Project project, File file, long skippedContents, String title, boolean buildInActions, LogFilterModel model) {
        this(project, LogConsoleBase.getReader(file, skippedContents), title, buildInActions, model);
    }

    public LogConsoleBase(Project project, Reader reader, long skippedContents, String title, boolean buildInActions, LogFilterModel model) {
        this(project, LogConsoleBase.getReader(reader, skippedContents), title, buildInActions, model);
    }

    @Nullable
    private static Reader getReader(Reader reader, long skippedContents) {
        reader = new BufferedReader(reader);
        try {
            reader.skip(skippedContents);
        }
        catch (IOException e) {
            reader = null;
        }
        return reader;
    }

    @Nullable
    private static Reader getReader(File file, long skippedContents) {
        BufferedReader reader = null;
        try {
            try {
                FileInputStream inputStream = new FileInputStream(file);
                reader = new BufferedReader(new InputStreamReader(inputStream));
                if (file.length() >= skippedContents) {
                    inputStream.skip(skippedContents);
                }
            }
            catch (FileNotFoundException e) {
                if (FileUtil.createIfDoesntExist((File)file)) {
                    reader = new BufferedReader(new FileReader(file));
                }
            }
        }
        catch (Throwable e) {
            reader = null;
        }
        return reader;
    }

    public void setFilterModel(LogFilterModel model) {
        if (this.myModel != null) {
            this.myModel.removeFilterListener((LogFilterListener)this);
        }
        this.myModel = model;
        this.myModel.addFilterListener((LogFilterListener)this);
    }

    public LogFilterModel getFilterModel() {
        return this.myModel;
    }

    public LogContentPreprocessor getContentPreprocessor() {
        return this.myContentPreprocessor;
    }

    public void setContentPreprocessor(LogContentPreprocessor contentPreprocessor) {
        this.myContentPreprocessor = contentPreprocessor;
    }

    private JComponent createToolbar() {
        String customFilter = this.myModel.getCustomFilter();
        this.myFilter.reset();
        this.myFilter.setSelectedItem(customFilter != null ? customFilter : "");
        new AnAction(){
            {
                this.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(9, 64)), (JComponent)((Object)LogConsoleBase.this));
            }

            public void actionPerformed(AnActionEvent e) {
                LogConsoleBase.this.myFilter.requestFocusInWindow();
            }
        };
        if (this.myBuildInActions) {
            JComponent tbComp = ActionManager.getInstance().createActionToolbar("unknown", this.getOrCreateActions(), true).getComponent();
            this.myTopComponent.add((Component)tbComp, "Center");
            this.myTopComponent.add((Component)this.getSearchComponent(), "East");
        }
        return this.myTopComponent;
    }

    public ActionGroup getOrCreateActions() {
        AnAction[] actions;
        if (this.myActions != null) {
            return this.myActions;
        }
        DefaultActionGroup group = new DefaultActionGroup();
        for (AnAction action : actions = this.myConsole.createConsoleActions()) {
            group.add(action);
        }
        group.addSeparator();
        this.myActions = group;
        return this.myActions;
    }

    public void onFilterStateChange(LogFilter filter) {
        this.filterConsoleOutput(new Condition<String>(){

            public boolean value(String line) {
                return LogConsoleBase.this.myModel.isApplicable(line);
            }
        });
    }

    public void onTextFilterChange() {
        this.filterConsoleOutput(new Condition<String>(){

            public boolean value(String line) {
                return LogConsoleBase.this.myModel.isApplicable(line);
            }
        });
    }

    @NotNull
    public JComponent getComponent() {
        if (!this.myWasInitialized) {
            this.myWasInitialized = true;
            this.add(this.myConsole.getComponent(), "Center");
            this.add(this.createToolbar(), "North");
        }
        LogConsoleBase logConsoleBase = this;
        if (logConsoleBase == null) {
            throw new IllegalStateException("@NotNull method com/intellij/diagnostic/logging/LogConsoleBase.getComponent must not return null");
        }
        return logConsoleBase;
    }

    public abstract boolean isActive();

    public void activate() {
        if (this.myReaderThread == null) {
            return;
        }
        if (this.isActive() && !this.myReaderThread.myRunning) {
            this.myFilter.setSelectedItem(this.myModel.getCustomFilter());
            this.myReaderThread.startRunning();
            ApplicationManager.getApplication().executeOnPooledThread((Runnable)this.myReaderThread);
        } else if (!this.isActive() && this.myReaderThread.myRunning) {
            this.myReaderThread.stopRunning();
        }
    }

    public void stateChanged(ChangeEvent e) {
        this.activate();
    }

    public String getTabTitle() {
        return this.myTitle;
    }

    public void dispose() {
        this.myModel.removeFilterListener((LogFilterListener)this);
        if (this.myReaderThread != null && this.myReaderThread.myReader != null) {
            this.myReaderThread.stopRunning();
            try {
                this.myReaderThread.myReader.close();
            }
            catch (IOException e) {
                LOG.warn((Throwable)e);
            }
            this.myReaderThread.myReader = null;
            this.myReaderThread = null;
        }
        if (this.myConsole != null) {
            Disposer.dispose((Disposable)this.myConsole);
            this.myConsole = null;
        }
        if (this.myFilter != null) {
            this.myFilter.dispose();
            this.myFilter = null;
        }
        this.myOriginalDocument = null;
    }

    private void stopRunning() {
        if (this.myReaderThread != null && !this.isActive()) {
            this.myReaderThread.stopRunning();
        }
    }

    protected synchronized void addMessage(String text) {
        if (text == null) {
            return;
        }
        if (this.myContentPreprocessor != null) {
            List fragments = this.myContentPreprocessor.parseLogLine(text + "\n");
            this.myOriginalDocument = this.getOriginalDocument();
            for (LogFragment fragment : fragments) {
                this.myProcessHandler.notifyTextAvailable(fragment.getText(), fragment.getOutputType());
                if (this.myOriginalDocument == null) continue;
                this.myOriginalDocument.append(fragment.getText());
            }
        } else {
            Key key;
            if (this.myModel.isApplicable(text) && (key = this.myModel.processLine(text)) != null) {
                this.myProcessHandler.notifyTextAvailable(text + "\n", key);
            }
            this.myOriginalDocument = this.getOriginalDocument();
            if (this.myOriginalDocument != null) {
                this.myOriginalDocument.append(text).append("\n");
            }
        }
    }

    public void attachStopLogConsoleTrackingListener(final ProcessHandler process) {
        if (process != null) {
            ProcessAdapter stopListener = new ProcessAdapter(){

                public void processTerminated(ProcessEvent event) {
                    process.removeProcessListener((ProcessListener)this);
                    LogConsoleBase.this.stopRunning();
                }
            };
            process.addProcessListener((ProcessListener)stopListener);
        }
    }

    private StringBuffer getOriginalDocument() {
        Editor editor;
        if (this.myOriginalDocument == null && (editor = this.getEditor()) != null) {
            this.myOriginalDocument = new StringBuffer(editor.getDocument().getText());
        }
        return this.myOriginalDocument;
    }

    @Nullable
    private Editor getEditor() {
        return this.myConsole != null ? (Editor)PlatformDataKeys.EDITOR.getData((DataProvider)this.myConsole) : null;
    }

    private synchronized void filterConsoleOutput(Condition<String> isApplicable) {
        this.myOriginalDocument = this.getOriginalDocument();
        if (this.myOriginalDocument != null) {
            int line;
            Editor editor = this.getEditor();
            LOG.assertTrue(editor != null);
            Document document = editor.getDocument();
            int caretOffset = editor.getCaretModel().getOffset();
            if (caretOffset > -1 && (line = document.getLineNumber(caretOffset)) > -1 && line < document.getLineCount()) {
                int startOffset = document.getLineStartOffset(line);
                this.myLineUnderSelection = document.getText().substring(startOffset, document.getLineEndOffset(line));
                this.myLineOffset = caretOffset - startOffset;
            }
            this.myConsole.clear();
            String[] lines = this.myOriginalDocument.toString().split("\n");
            int offset = 0;
            boolean caretPositioned = false;
            for (String line2 : lines) {
                if (!this.printMessageToConsole(line2, isApplicable) || caretPositioned) continue;
                if (Comparing.strEqual((String)this.myLineUnderSelection, (String)line2)) {
                    caretPositioned = true;
                    offset += this.myLineOffset != -1 ? this.myLineOffset : 0;
                    continue;
                }
                offset += line2.length() + 1;
            }
            this.myConsole.scrollTo(offset);
        }
    }

    private boolean printMessageToConsole(String line, Condition<String> isApplicable) {
        ConsoleViewContentType type;
        Key key;
        if (this.myContentPreprocessor != null) {
            List fragments = this.myContentPreprocessor.parseLogLine(line + '\n');
            for (LogFragment fragment : fragments) {
                ConsoleViewContentType consoleViewType = ConsoleViewContentType.getConsoleViewType((Key)fragment.getOutputType());
                if (consoleViewType == null) continue;
                this.myConsole.print(fragment.getText(), consoleViewType);
            }
        } else if (isApplicable.value((Object)line) && (key = this.myModel.processLine(line)) != null && (type = ConsoleViewContentType.getConsoleViewType((Key)key)) != null) {
            this.myConsole.print(line + "\n", type);
        }
        return true;
    }

    public ActionGroup getToolbarActions() {
        return this.getOrCreateActions();
    }

    public String getToolbarPlace() {
        return "unknown";
    }

    public JComponent getToolbarContextComponent() {
        return this.myConsole.getComponent();
    }

    public JComponent getPreferredFocusableComponent() {
        return this.myConsole.getPreferredFocusableComponent();
    }

    public String getTitle() {
        return this.myTitle;
    }

    public synchronized void clear() {
        this.myConsole.clear();
        this.myOriginalDocument = null;
    }

    public JComponent getSearchComponent() {
        List filters = this.myModel.getLogFilters();
        this.myLogFilterCombo.setModel(new DefaultComboBoxModel<LogFilter>(filters.toArray(new LogFilter[filters.size()])));
        for (LogFilter filter : filters) {
            if (!this.myModel.isFilterSelected(filter)) continue;
            this.myLogFilterCombo.setSelectedItem(filter);
            break;
        }
        this.myLogFilterCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LogFilter filter = (LogFilter)LogConsoleBase.this.myLogFilterCombo.getSelectedItem();
                LogConsoleBase.this.myModel.selectFilter(filter);
            }
        });
        this.myTextFilterWrapper.removeAll();
        this.myTextFilterWrapper.add((Component)this.myFilter);
        return this.mySearchComponent;
    }

    public boolean isContentBuiltIn() {
        return this.myBuildInActions;
    }

    public void writeToConsole(String text, Key outputType) {
        this.myProcessHandler.notifyTextAvailable(text, outputType);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JComboBox jComboBox;
        JPanel jPanel2;
        this.mySearchComponent = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myLogFilterCombo = jComboBox = new JComboBox();
        jPanel2.add(jComboBox, new GridConstraints(0, 2, 1, 1, 8, 1, 0, 0, new Dimension(100, -1), null, null));
        this.myTextFilterWrapper = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(0, 3, 1, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(0, 0, 1, 1, 0, 1, 6, 1, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/DiagnosticBundle").getString("log.console.filter.show.prefix"));
        jPanel2.add((Component)jLabel, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.mySearchComponent;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    protected class ReaderThread
    implements Runnable {
        private BufferedReader myReader;
        private boolean myRunning = false;

        public ReaderThread(Reader reader) {
            this.myReader = reader != null ? new BufferedReader(reader) : null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this.myReader == null) {
                return;
            }
            while (this.myRunning) {
                try {
                    int i = 0;
                    while (i++ < 100 && this.myRunning && this.myReader != null && this.myReader.ready()) {
                        LogConsoleBase.this.addMessage(this.myReader.readLine());
                    }
                    ReaderThread readerThread = this;
                    synchronized (readerThread) {
                        this.wait(100L);
                    }
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                }
                catch (InterruptedException e) {
                    Disposer.dispose((Disposable)LogConsoleBase.this);
                }
            }
        }

        public void startRunning() {
            this.myRunning = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stopRunning() {
            this.myRunning = false;
            ReaderThread readerThread = this;
            synchronized (readerThread) {
                this.notifyAll();
            }
        }
    }

    private static class LightProcessHandler
    extends ProcessHandler {
        private LightProcessHandler() {
        }

        protected void destroyProcessImpl() {
            throw new UnsupportedOperationException();
        }

        protected void detachProcessImpl() {
            throw new UnsupportedOperationException();
        }

        public boolean detachIsDefault() {
            return false;
        }

        @Nullable
        public OutputStream getProcessInput() {
            return null;
        }
    }
}

