/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.ui.breakpoints.AddWildcardBreakpointDialog;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.breakpoints.BreakpointFactory;
import com.intellij.debugger.ui.breakpoints.BreakpointPanel;
import com.intellij.debugger.ui.breakpoints.MethodBreakpoint;
import com.intellij.debugger.ui.breakpoints.MethodBreakpointPropertiesPanel;
import com.intellij.debugger.ui.breakpoints.WildcardMethodBreakpoint;
import com.intellij.debugger.ui.breakpoints.actions.AddAction;
import com.intellij.debugger.ui.breakpoints.actions.BreakpointPanelAction;
import com.intellij.debugger.ui.breakpoints.actions.GotoSourceAction;
import com.intellij.debugger.ui.breakpoints.actions.RemoveAction;
import com.intellij.debugger.ui.breakpoints.actions.SwitchViewAction;
import com.intellij.debugger.ui.breakpoints.actions.ToggleFlattenPackagesAction;
import com.intellij.debugger.ui.breakpoints.actions.ToggleGroupByClassesAction;
import com.intellij.debugger.ui.breakpoints.actions.ViewSourceAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Key;
import java.awt.event.ActionEvent;
import javax.swing.Icon;
import org.jdom.Element;

public class MethodBreakpointFactory
extends BreakpointFactory {
    @Override
    public Breakpoint createBreakpoint(Project project, Element element) {
        return element.getAttributeValue("wildcard_breakpoint") != null ? new WildcardMethodBreakpoint(project) : new MethodBreakpoint(project);
    }

    @Override
    public Icon getIcon() {
        return MethodBreakpoint.ICON;
    }

    @Override
    public Icon getDisabledIcon() {
        return MethodBreakpoint.DISABLED_ICON;
    }

    @Override
    public BreakpointPanel createBreakpointPanel(Project project, final DialogWrapper parentDialog) {
        BreakpointPanel panel = new BreakpointPanel(project, new MethodBreakpointPropertiesPanel(project), new BreakpointPanelAction[]{new SwitchViewAction(), new AddWildcardBreakpointAction(project), new GotoSourceAction(project){

            @Override
            public void actionPerformed(ActionEvent e) {
                super.actionPerformed(e);
                parentDialog.close(0);
            }
        }, new ViewSourceAction(project), new RemoveAction(project), new ToggleGroupByClassesAction(), new ToggleFlattenPackagesAction()}, this.getBreakpointCategory(), DebuggerBundle.message((String)"method.breakpoints.tab.title", (Object[])new Object[0]), "debugging.methodBreakpoint");
        panel.getTree().setGroupByMethods(false);
        return panel;
    }

    public Key<MethodBreakpoint> getBreakpointCategory() {
        return MethodBreakpoint.CATEGORY;
    }

    private static class AddWildcardBreakpointAction
    extends AddAction {
        private final Project myProject;

        public AddWildcardBreakpointAction(Project project) {
            this.myProject = project;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AddWildcardBreakpointDialog dialog = new AddWildcardBreakpointDialog(this.myProject);
            dialog.show();
            if (!dialog.isOK()) {
                return;
            }
            WildcardMethodBreakpoint methodBreakpoint = DebuggerManagerEx.getInstanceEx(this.myProject).getBreakpointManager().addMethodBreakpoint(dialog.getClassPattern(), dialog.getMethodName());
            if (methodBreakpoint != null) {
                this.getPanel().addBreakpoint(methodBreakpoint);
            }
        }
    }
}

