/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints;

import com.intellij.CommonBundle;
import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerInvocationUtil;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.InstanceFilter;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.JVMNameUtil;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.engine.requests.RequestManagerImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.breakpoints.BreakpointManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.markup.GutterDraggableObject;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.MarkupEditorFilterFactory;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.jsp.JspFile;
import com.intellij.ui.classFilter.ClassFilter;
import com.intellij.util.StringBuilderSpinAllocator;
import com.intellij.xdebugger.impl.actions.ViewBreakpointsAction;
import com.intellij.xdebugger.ui.DebuggerColors;
import com.intellij.xml.util.XmlStringUtil;
import com.sun.jdi.ReferenceType;
import java.awt.Cursor;
import java.awt.dnd.DragSource;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BreakpointWithHighlighter
extends Breakpoint {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.ui.breakpoints.BreakpointWithHighlighter");
    private RangeHighlighter myHighlighter;
    private SourcePosition mySourcePosition;
    private boolean myVisible = true;
    private Icon myIcon = this.getSetIcon(false);
    @Nullable
    private String myClassName;
    @Nullable
    private String myPackageName;
    @Nullable
    private String myInvalidMessage;

    protected abstract void createRequestForPreparedClass(DebugProcessImpl var1, ReferenceType var2);

    protected abstract Icon getDisabledIcon(boolean var1);

    protected abstract Icon getInvalidIcon(boolean var1);

    protected abstract Icon getSetIcon(boolean var1);

    protected abstract Icon getVerifiedIcon(boolean var1);

    protected abstract Icon getVerifiedWarningsIcon(boolean var1);

    @Override
    public Icon getIcon() {
        return this.myIcon;
    }

    @Override
    public String getClassName() {
        return this.myClassName;
    }

    @Override
    @Nullable
    public String getShortClassName() {
        SourcePosition pos = this.getSourcePosition();
        if (pos != null && pos.getFile() instanceof JspFile) {
            return this.getClassName();
        }
        return super.getShortClassName();
    }

    @Override
    public String getPackageName() {
        return this.myPackageName;
    }

    protected Breakpoint init() {
        if (!this.isValid()) {
            this.getDocument().getMarkupModel(this.myProject).removeHighlighter(this.myHighlighter);
            return null;
        }
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            this.updateUI();
            this.updateGutter();
        }
        return this;
    }

    private void updateCaches(DebugProcessImpl debugProcess) {
        this.myIcon = this.calcIcon(debugProcess);
        this.myClassName = JVMNameUtil.getSourcePositionClassDisplayName(debugProcess, this.getSourcePosition());
        this.myPackageName = JVMNameUtil.getSourcePositionPackageDisplayName(debugProcess, this.getSourcePosition());
    }

    private Icon calcIcon(DebugProcessImpl debugProcess) {
        boolean muted;
        boolean bl = muted = debugProcess != null && this.isMuted(debugProcess);
        if (!this.ENABLED) {
            return this.getDisabledIcon(muted);
        }
        this.myInvalidMessage = "";
        if (!this.isValid()) {
            return this.getInvalidIcon(muted);
        }
        if (debugProcess == null) {
            return this.getSetIcon(muted);
        }
        RequestManagerImpl requestsManager = debugProcess.getRequestsManager();
        boolean isVerified = this.myCachedVerifiedState || requestsManager.isVerified(this);
        String warning = requestsManager.getWarning(this);
        if (warning != null) {
            this.myInvalidMessage = warning;
            if (!isVerified) {
                return this.getInvalidIcon(muted);
            }
            return this.getVerifiedWarningsIcon(muted);
        }
        if (isVerified) {
            return this.getVerifiedIcon(muted);
        }
        return this.getSetIcon(muted);
    }

    protected BreakpointWithHighlighter(Project project) {
        super(project);
    }

    public BreakpointWithHighlighter(Project project, RangeHighlighter highlighter) {
        super(project);
        this.myHighlighter = highlighter;
        highlighter.setEditorFilter(MarkupEditorFilterFactory.createIsNotDiffFilter());
        this.reload();
    }

    public RangeHighlighter getHighlighter() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        return this.myHighlighter;
    }

    @Override
    public boolean isValid() {
        return BreakpointWithHighlighter.isPositionValid(this.getSourcePosition());
    }

    private static boolean isPositionValid(final SourcePosition sourcePosition) {
        return (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

            public Boolean compute() {
                return sourcePosition != null && sourcePosition.getFile().isValid() ? Boolean.TRUE : Boolean.FALSE;
            }
        });
    }

    public SourcePosition getSourcePosition() {
        return this.mySourcePosition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDescription() {
        StringBuilder buf = StringBuilderSpinAllocator.alloc();
        try {
            buf.append("<html><body>");
            buf.append(this.getDisplayName());
            if (this.myInvalidMessage != null && !"".equals(this.myInvalidMessage)) {
                buf.append("<br><font color='red'>");
                buf.append(DebuggerBundle.message((String)"breakpoint.warning", (Object[])new Object[]{this.myInvalidMessage}));
                buf.append("</font>");
            }
            buf.append("&nbsp;<br>&nbsp;");
            buf.append(DebuggerBundle.message((String)"breakpoint.property.name.suspend.policy", (Object[])new Object[0])).append(" : ");
            if ("SuspendAll".equals(this.SUSPEND_POLICY)) {
                buf.append(DebuggerBundle.message((String)"breakpoint.properties.panel.option.suspend.all", (Object[])new Object[0]));
            } else if ("SuspendThread".equals(this.SUSPEND_POLICY)) {
                buf.append(DebuggerBundle.message((String)"breakpoint.properties.panel.option.suspend.thread", (Object[])new Object[0]));
            } else if ("SuspendNone".equals(this.SUSPEND_POLICY)) {
                buf.append(DebuggerBundle.message((String)"breakpoint.properties.panel.option.suspend.none", (Object[])new Object[0]));
            }
            buf.append("&nbsp;<br>&nbsp;");
            buf.append(DebuggerBundle.message((String)"breakpoint.property.name.log.message", (Object[])new Object[0])).append(": ");
            buf.append(this.LOG_ENABLED ? CommonBundle.getYesButtonText() : CommonBundle.getNoButtonText());
            if (this.LOG_EXPRESSION_ENABLED) {
                buf.append("&nbsp;<br>&nbsp;");
                buf.append(DebuggerBundle.message((String)"breakpoint.property.name.log.expression", (Object[])new Object[0])).append(": ");
                buf.append(XmlStringUtil.escapeString((String)this.getLogMessage().getText()));
            }
            if (this.CONDITION_ENABLED && this.getCondition() != null && !"".equals(this.getCondition().getText())) {
                buf.append("&nbsp;<br>&nbsp;");
                buf.append(DebuggerBundle.message((String)"breakpoint.property.name.condition", (Object[])new Object[0])).append(": ");
                buf.append(XmlStringUtil.escapeString((String)this.getCondition().getText()));
            }
            if (this.COUNT_FILTER_ENABLED) {
                buf.append("&nbsp;<br>&nbsp;");
                buf.append(DebuggerBundle.message((String)"breakpoint.property.name.pass.count", (Object[])new Object[0])).append(": ");
                buf.append(this.COUNT_FILTER);
            }
            if (this.CLASS_FILTERS_ENABLED) {
                ClassFilter[] classFilters;
                buf.append("&nbsp;<br>&nbsp;");
                buf.append(DebuggerBundle.message((String)"breakpoint.property.name.class.filters", (Object[])new Object[0])).append(": ");
                for (ClassFilter classFilter : classFilters = this.getClassFilters()) {
                    buf.append(classFilter.getPattern()).append(" ");
                }
            }
            if (this.INSTANCE_FILTERS_ENABLED) {
                InstanceFilter[] instanceFilters;
                buf.append("&nbsp;<br>&nbsp;");
                buf.append(DebuggerBundle.message((String)"breakpoint.property.name.instance.filters", (Object[])new Object[0]));
                for (InstanceFilter instanceFilter : instanceFilters = this.getInstanceFilters()) {
                    buf.append(Long.toString(instanceFilter.getId())).append(" ");
                }
            }
            buf.append("</body></html>");
            String string = buf.toString();
            return string;
        }
        finally {
            StringBuilderSpinAllocator.dispose((StringBuilder)buf);
        }
    }

    @Override
    public final void reload() {
        PsiFile psiFile;
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.getHighlighter().isValid() && (psiFile = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(this.getHighlighter().getDocument())) != null) {
            this.mySourcePosition = SourcePosition.createFromOffset((PsiFile)psiFile, (int)this.getHighlighter().getStartOffset());
            this.reload(psiFile);
            return;
        }
        this.mySourcePosition = null;
    }

    @Override
    public void createRequest(DebugProcessImpl debugProcess) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        if (!this.ENABLED || !debugProcess.isAttached() || this.isMuted(debugProcess) || !debugProcess.getRequestsManager().findRequests(this).isEmpty()) {
            return;
        }
        if (!this.isValid()) {
            return;
        }
        this.createOrWaitPrepare(debugProcess, this.getSourcePosition());
        this.updateUI();
    }

    protected boolean isMuted(DebugProcessImpl debugProcess) {
        return debugProcess.areBreakpointsMuted();
    }

    @Override
    public void processClassPrepare(DebugProcess debugProcess, ReferenceType classType) {
        if (!this.ENABLED || !this.isValid()) {
            return;
        }
        this.createRequestForPreparedClass((DebugProcessImpl)debugProcess, classType);
        this.updateUI();
    }

    @Override
    public final void updateUI(final Runnable afterUpdate) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        final Project project = this.getProject();
        DebuggerInvocationUtil.swingInvokeLater(project, new Runnable(){

            @Override
            public void run() {
                if (!BreakpointWithHighlighter.this.isValid()) {
                    return;
                }
                DebuggerContextImpl context = DebuggerManagerEx.getInstanceEx(project).getContext();
                final DebugProcessImpl debugProcess = context.getDebugProcess();
                if (debugProcess == null || !debugProcess.isAttached()) {
                    BreakpointWithHighlighter.this.updateCaches(null);
                    BreakpointWithHighlighter.this.updateGutter();
                    afterUpdate.run();
                } else {
                    debugProcess.getManagerThread().invoke(new DebuggerCommandImpl(){

                        @Override
                        protected void action() throws Exception {
                            ApplicationManager.getApplication().runReadAction(new Runnable(){

                                @Override
                                public void run() {
                                    BreakpointWithHighlighter.this.updateCaches(debugProcess);
                                }
                            });
                            DebuggerInvocationUtil.swingInvokeLater(project, new Runnable(){

                                @Override
                                public void run() {
                                    BreakpointWithHighlighter.this.updateGutter();
                                    afterUpdate.run();
                                }
                            });
                        }
                    });
                }
            }
        });
    }

    private void updateGutter() {
        if (this.myVisible) {
            if (this.getHighlighter() != null && this.getHighlighter().isValid() && this.isValid()) {
                this.setupGutterRenderer();
            } else {
                DebuggerManagerEx.getInstanceEx(this.myProject).getBreakpointManager().removeBreakpoint(this);
            }
        }
    }

    @Override
    public void delete() {
        RangeHighlighter highlighter;
        if (this.isVisible() && (highlighter = this.getHighlighter()) != null) {
            DebuggerInvocationUtil.invokeLater(this.getProject(), new Runnable(){

                @Override
                public void run() {
                    if (highlighter.isValid()) {
                        MarkupModel markupModel = highlighter.getDocument().getMarkupModel(BreakpointWithHighlighter.this.myProject);
                        markupModel.removeHighlighter(highlighter);
                        BreakpointWithHighlighter.super.delete();
                    }
                }
            });
        }
    }

    public boolean isAt(Document document, int offset) {
        RangeHighlighter highlighter = this.getHighlighter();
        return highlighter != null && highlighter.isValid() && document.equals(highlighter.getDocument()) && this.getSourcePosition().getLine() == document.getLineNumber(offset);
    }

    protected void reload(PsiFile psiFile) {
    }

    @Override
    public PsiClass getPsiClass() {
        SourcePosition sourcePosition = this.getSourcePosition();
        return BreakpointWithHighlighter.getPsiClassAt(sourcePosition);
    }

    protected static PsiClass getPsiClassAt(final SourcePosition sourcePosition) {
        return (PsiClass)ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiClass>(){

            public PsiClass compute() {
                return JVMNameUtil.getClassAt(sourcePosition);
            }
        });
    }

    private void setupGutterRenderer() {
        this.getHighlighter().setGutterIconRenderer(new GutterIconRenderer(){

            @NotNull
            public Icon getIcon() {
                Icon icon = BreakpointWithHighlighter.this.getIcon();
                if (icon == null) {
                    throw new IllegalStateException("@NotNull method com/intellij/debugger/ui/breakpoints/BreakpointWithHighlighter$5.getIcon must not return null");
                }
                return icon;
            }

            public String getTooltipText() {
                return BreakpointWithHighlighter.this.getDescription();
            }

            public AnAction getClickAction() {
                return new AnAction(){

                    public void actionPerformed(AnActionEvent e) {
                        DebuggerManagerEx.getInstanceEx(BreakpointWithHighlighter.this.myProject).getBreakpointManager().removeBreakpoint(BreakpointWithHighlighter.this);
                    }
                };
            }

            public AnAction getMiddleButtonClickAction() {
                return new AnAction(){

                    public void actionPerformed(AnActionEvent e) {
                        BreakpointWithHighlighter.this.ENABLED = !BreakpointWithHighlighter.this.ENABLED;
                        DebuggerManagerEx.getInstanceEx(BreakpointWithHighlighter.this.getProject()).getBreakpointManager().fireBreakpointChanged(BreakpointWithHighlighter.this);
                        BreakpointWithHighlighter.this.updateUI();
                    }
                };
            }

            public ActionGroup getPopupMenuActions() {
                return BreakpointWithHighlighter.this.createMenuActions();
            }

            public GutterDraggableObject getDraggableObject() {
                return new GutterDraggableObject(){

                    public void removeSelf() {
                    }

                    public boolean copy(int line) {
                        return BreakpointWithHighlighter.this.moveTo(SourcePosition.createFromLine((PsiFile)BreakpointWithHighlighter.this.getSourcePosition().getFile(), (int)line));
                    }

                    public Cursor getCursor(int line) {
                        SourcePosition newPosition = SourcePosition.createFromLine((PsiFile)BreakpointWithHighlighter.this.getSourcePosition().getFile(), (int)line);
                        return BreakpointWithHighlighter.this.canMoveTo(newPosition) ? DragSource.DefaultMoveDrop : DragSource.DefaultMoveNoDrop;
                    }
                };
            }
        });
    }

    public abstract Key<? extends BreakpointWithHighlighter> getCategory();

    public boolean canMoveTo(SourcePosition position) {
        if (position == null || !position.getFile().isValid()) {
            return false;
        }
        PsiFile psiFile = position.getFile();
        Document document = PsiDocumentManager.getInstance((Project)this.getProject()).getDocument(psiFile);
        if (document == null) {
            return false;
        }
        int spOffset = position.getOffset();
        if (spOffset < 0) {
            return false;
        }
        BreakpointManager breakpointManager = DebuggerManagerEx.getInstanceEx(this.getProject()).getBreakpointManager();
        return breakpointManager.findBreakpoint(document, spOffset, this.getCategory()) == null;
    }

    public boolean moveTo(SourcePosition position) {
        if (!this.canMoveTo(position)) {
            return false;
        }
        PsiFile psiFile = position.getFile();
        Document document = PsiDocumentManager.getInstance((Project)this.getProject()).getDocument(psiFile);
        if (document == null) {
            return false;
        }
        RangeHighlighter newHighlighter = BreakpointWithHighlighter.createHighlighter(this.myProject, document, position.getLine());
        if (newHighlighter == null) {
            return false;
        }
        RangeHighlighter oldHighlighter = this.myHighlighter;
        this.myHighlighter = newHighlighter;
        this.reload();
        if (!this.isValid()) {
            document.getMarkupModel(this.myProject).removeHighlighter(this.myHighlighter);
            this.myHighlighter = oldHighlighter;
            this.reload();
            return false;
        }
        document.getMarkupModel(this.myProject).removeHighlighter(oldHighlighter);
        DebuggerManagerEx.getInstanceEx(this.getProject()).getBreakpointManager().fireBreakpointChanged(this);
        this.updateUI();
        return true;
    }

    public boolean isVisible() {
        return this.myVisible;
    }

    public void setVisible(boolean visible) {
        this.myVisible = visible;
    }

    public Document getDocument() {
        return this.getHighlighter().getDocument();
    }

    public int getLineIndex() {
        SourcePosition sourcePosition = this.getSourcePosition();
        return sourcePosition != null ? sourcePosition.getLine() : -1;
    }

    protected static RangeHighlighter createHighlighter(Project project, Document document, int lineIndex) {
        if (lineIndex < 0 || lineIndex >= document.getLineCount()) {
            return null;
        }
        EditorColorsScheme scheme = EditorColorsManager.getInstance().getGlobalScheme();
        TextAttributes attributes = scheme.getAttributes(DebuggerColors.BREAKPOINT_ATTRIBUTES);
        RangeHighlighter highlighter = ((MarkupModelEx)document.getMarkupModel(project)).addPersistentLineHighlighter(lineIndex, 2001, attributes);
        if (!highlighter.isValid()) {
            return null;
        }
        highlighter.setErrorStripeTooltip((Object)DebuggerBundle.message((String)"breakpoint.tooltip.text", (Object[])new Object[]{lineIndex + 1}));
        return highlighter;
    }

    @Override
    public void readExternal(Element breakpointNode) throws InvalidDataException {
        int line;
        VirtualFile vFile;
        String packageName;
        super.readExternal(breakpointNode);
        String url = breakpointNode.getAttributeValue("url");
        String className = breakpointNode.getAttributeValue("class");
        if (className != null) {
            this.myClassName = className;
        }
        if ((packageName = breakpointNode.getAttributeValue("package")) != null) {
            this.myPackageName = packageName;
        }
        if ((vFile = VirtualFileManager.getInstance().findFileByUrl(url)) == null) {
            throw new InvalidDataException(DebuggerBundle.message((String)"error.breakpoint.file.not.found", (Object[])new Object[]{url}));
        }
        Document doc = FileDocumentManager.getInstance().getDocument(vFile);
        if (doc == null) {
            throw new InvalidDataException(DebuggerBundle.message((String)"error.cannot.load.breakpoint.file", (Object[])new Object[]{url}));
        }
        try {
            line = Integer.parseInt(breakpointNode.getAttributeValue("line"));
        }
        catch (Exception e) {
            throw new InvalidDataException("Line number is invalid for breakpoint");
        }
        if (line < 0) {
            throw new InvalidDataException("Line number is invalid for breakpoint");
        }
        RangeHighlighter highlighter = BreakpointWithHighlighter.createHighlighter(this.myProject, doc, line);
        if (highlighter == null) {
            throw new InvalidDataException("");
        }
        this.myHighlighter = highlighter;
        this.reload();
    }

    @Override
    public void writeExternal(Element parentNode) throws WriteExternalException {
        super.writeExternal(parentNode);
        PsiFile psiFile = this.getSourcePosition().getFile();
        VirtualFile virtualFile = psiFile.getVirtualFile();
        String url = virtualFile != null ? virtualFile.getUrl() : "";
        parentNode.setAttribute("url", url);
        parentNode.setAttribute("line", Integer.toString(this.getSourcePosition().getLine()));
        if (this.myClassName != null) {
            parentNode.setAttribute("class", this.myClassName);
        }
        if (this.myPackageName != null) {
            parentNode.setAttribute("package", this.myPackageName);
        }
    }

    private ActionGroup createMenuActions() {
        final BreakpointManager breakpointManager = DebuggerManagerEx.getInstanceEx(this.myProject).getBreakpointManager();
        ViewBreakpointsAction viewBreakpointsAction = new ViewBreakpointsAction(DebuggerBundle.message((String)"breakpoint.manager.action.view.breakpoints.text", (Object[])new Object[0]), this);
        DefaultActionGroup group = new DefaultActionGroup();
        class SetEnabledAction
        extends AnAction {
            private final boolean myNewValue;
            private final Breakpoint myBreakpoint;

            public SetEnabledAction(Breakpoint breakpoint, boolean newValue) {
                super(newValue ? DebuggerBundle.message((String)"action.enable.text", (Object[])new Object[0]) : DebuggerBundle.message((String)"action.disable.text", (Object[])new Object[0]));
                this.myBreakpoint = breakpoint;
                this.myNewValue = newValue;
            }

            public void actionPerformed(AnActionEvent e) {
                this.myBreakpoint.ENABLED = this.myNewValue;
                breakpointManager.fireBreakpointChanged(this.myBreakpoint);
                this.myBreakpoint.updateUI();
            }
        }
        group.add((AnAction)new SetEnabledAction(this, !this.ENABLED));
        class RemoveAction
        extends AnAction {
            private Breakpoint myBreakpoint;

            public RemoveAction(Breakpoint breakpoint) {
                super(DebuggerBundle.message((String)"action.remove.text", (Object[])new Object[0]));
                this.myBreakpoint = breakpoint;
            }

            public void actionPerformed(AnActionEvent e) {
                if (this.myBreakpoint != null) {
                    breakpointManager.removeBreakpoint(this.myBreakpoint);
                    this.myBreakpoint = null;
                }
            }
        }
        group.add((AnAction)new RemoveAction(this));
        group.addSeparator();
        group.add((AnAction)viewBreakpointsAction);
        return group;
    }
}

