/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui;

import com.intellij.debugger.DebuggerInvocationUtil;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerContextListener;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.DebuggerStateManager;
import com.intellij.debugger.ui.DebuggerSessionTab;
import com.intellij.debugger.ui.PositionHighlighter;
import com.intellij.debugger.ui.impl.MainWatchPanel;
import com.intellij.debugger.ui.tree.render.BatchEvaluator;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ModuleRunProfile;
import com.intellij.execution.configurations.RemoteConnection;
import com.intellij.execution.configurations.RemoteState;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentListener;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColorsListener;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DebuggerPanelsManager
implements ProjectComponent {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.ui.DebuggerPanelsManager");
    private final Project myProject;
    private final ExecutionManager myExecutionManager;
    private final PositionHighlighter myEditorManager;
    private final HashMap<ProcessHandler, DebuggerSessionTab> mySessionTabs = new HashMap();

    public DebuggerPanelsManager(Project project, final EditorColorsManager colorsManager, ExecutionManager executionManager) {
        this.myProject = project;
        this.myExecutionManager = executionManager;
        this.myEditorManager = new PositionHighlighter(this.myProject, this.getContextManager());
        final EditorColorsListener myColorsListener = new EditorColorsListener(){

            public void globalSchemeChange(EditorColorsScheme scheme) {
                DebuggerPanelsManager.this.myEditorManager.updateContextPointDescription();
            }
        };
        colorsManager.addEditorColorsListener(myColorsListener);
        Disposer.register((Disposable)project, (Disposable)new Disposable(){

            public void dispose() {
                colorsManager.removeEditorColorsListener(myColorsListener);
            }
        });
        this.getContextManager().addListener(new DebuggerContextListener(){

            @Override
            public void changeEvent(final DebuggerContextImpl newContext, int event) {
                if (event == 6) {
                    DebuggerInvocationUtil.invokeLater(DebuggerPanelsManager.this.myProject, new Runnable(){

                        @Override
                        public void run() {
                            DebuggerPanelsManager.this.toFront(newContext.getDebuggerSession());
                        }
                    });
                }
            }
        });
    }

    private DebuggerStateManager getContextManager() {
        return DebuggerManagerEx.getInstanceEx(this.myProject).getContextManager();
    }

    @Nullable
    public RunContentDescriptor attachVirtualMachine(Executor executor, ProgramRunner runner, ExecutionEnvironment environment, RunProfileState state, RunContentDescriptor reuseContent, RemoteConnection remoteConnection, boolean pollConnection) throws ExecutionException {
        DebuggerSessionTab prevSession;
        ProcessHandler prevHandler;
        DebuggerSession debuggerSession = DebuggerManagerEx.getInstanceEx(this.myProject).attachVirtualMachine(executor, runner, (ModuleRunProfile)environment.getRunProfile(), state, remoteConnection, pollConnection);
        if (debuggerSession == null) {
            return null;
        }
        DebugProcessImpl debugProcess = debuggerSession.getProcess();
        if (debugProcess.isDetached() || debugProcess.isDetaching()) {
            return null;
        }
        if (state instanceof RemoteState) {
            debugProcess.putUserData(BatchEvaluator.REMOTE_SESSION_KEY, Boolean.TRUE);
        }
        DebuggerSessionTab sessionTab = new DebuggerSessionTab(this.myProject, debuggerSession.getSessionName(), environment.getRunProfile().getIcon());
        Disposer.register((Disposable)this.myProject, (Disposable)sessionTab);
        RunContentDescriptor runContentDescriptor = sessionTab.attachToSession(debuggerSession, runner, environment);
        if (reuseContent != null && (prevHandler = reuseContent.getProcessHandler()) != null && (prevSession = this.mySessionTabs.get(prevHandler)) != null) {
            sessionTab.reuse(prevSession);
        }
        this.mySessionTabs.put(runContentDescriptor.getProcessHandler(), sessionTab);
        return runContentDescriptor;
    }

    public void projectOpened() {
        final RunContentManager contentManager = this.myExecutionManager.getContentManager();
        LOG.assertTrue(contentManager != null, (Object)"Content manager is null");
        final RunContentListener myContentListener = new RunContentListener(){

            public void contentSelected(RunContentDescriptor descriptor) {
                DebuggerSessionTab sessionTab;
                DebuggerSessionTab debuggerSessionTab = sessionTab = descriptor != null ? DebuggerPanelsManager.this.getSessionTab(descriptor.getProcessHandler()) : null;
                if (sessionTab != null) {
                    DebuggerPanelsManager.this.getContextManager().setState(sessionTab.getContextManager().getContext(), sessionTab.getSession().getState(), 8, null);
                } else {
                    DebuggerPanelsManager.this.getContextManager().setState(DebuggerContextImpl.EMPTY_CONTEXT, 6, 8, null);
                }
            }

            public void contentRemoved(RunContentDescriptor descriptor) {
                DebuggerSessionTab sessionTab = DebuggerPanelsManager.this.getSessionTab(descriptor.getProcessHandler());
                if (sessionTab != null) {
                    DebuggerPanelsManager.this.mySessionTabs.remove(descriptor.getProcessHandler());
                    Disposer.dispose((Disposable)sessionTab);
                }
            }
        };
        contentManager.addRunContentListener(myContentListener, DefaultDebugExecutor.getDebugExecutorInstance());
        Disposer.register((Disposable)this.myProject, (Disposable)new Disposable(){

            public void dispose() {
                contentManager.removeRunContentListener(myContentListener);
            }
        });
    }

    public void projectClosed() {
    }

    @NotNull
    public String getComponentName() {
        if ("DebuggerPanelsManager" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/debugger/ui/DebuggerPanelsManager.getComponentName must not return null");
        }
        return "DebuggerPanelsManager";
    }

    public void initComponent() {
    }

    public void disposeComponent() {
    }

    public static DebuggerPanelsManager getInstance(Project project) {
        return (DebuggerPanelsManager)project.getComponent(DebuggerPanelsManager.class);
    }

    @Nullable
    public MainWatchPanel getWatchPanel() {
        DebuggerSessionTab sessionTab = this.getSessionTab();
        return sessionTab != null ? sessionTab.getWatchPanel() : null;
    }

    @Nullable
    public DebuggerSessionTab getSessionTab() {
        DebuggerContextImpl context = DebuggerManagerEx.getInstanceEx(this.myProject).getContext();
        return this.getSessionTab(context.getDebuggerSession());
    }

    public void showFramePanel() {
        DebuggerSessionTab sessionTab = this.getSessionTab();
        if (sessionTab != null) {
            sessionTab.showFramePanel();
        }
    }

    public void toFront(DebuggerSession session) {
        DebuggerSessionTab sessionTab = this.getSessionTab(session);
        if (sessionTab != null) {
            sessionTab.toFront();
        }
    }

    private DebuggerSessionTab getSessionTab(ProcessHandler processHandler) {
        return this.mySessionTabs.get(processHandler);
    }

    @Nullable
    private DebuggerSessionTab getSessionTab(DebuggerSession session) {
        return session != null ? this.getSessionTab(session.getProcess().getExecutionResult().getProcessHandler()) : null;
    }
}

