/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.impl;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.impl.DebuggerManagerImpl;
import com.intellij.debugger.impl.GenericDebuggerParametersRunnerConfigurable;
import com.intellij.debugger.impl.GenericDebuggerRunnerSettings;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.debugger.ui.DebuggerPanelsManager;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationInfoProvider;
import com.intellij.execution.configurations.JavaCommandLine;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.ModuleRunProfile;
import com.intellij.execution.configurations.PatchedRunnableState;
import com.intellij.execution.configurations.RemoteConnection;
import com.intellij.execution.configurations.RemoteState;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationWithRunnerSettings;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.JavaPatchableProgramRunner;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryConfiguration;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GenericDebuggerRunner
extends JavaPatchableProgramRunner<GenericDebuggerRunnerSettings> {
    public boolean canRun(@NotNull String executorId, @NotNull RunProfile profile) {
        if (executorId == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/debugger/impl/GenericDebuggerRunner.canRun must not be null");
        }
        if (profile == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/debugger/impl/GenericDebuggerRunner.canRun must not be null");
        }
        return executorId.equals(DefaultDebugExecutor.EXECUTOR_ID) && profile instanceof ModuleRunProfile;
    }

    @NotNull
    public String getRunnerId() {
        if ("Debug" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/debugger/impl/GenericDebuggerRunner.getRunnerId must not return null");
        }
        return "Debug";
    }

    protected RunContentDescriptor doExecute(Project project, Executor executor, RunProfileState state, RunContentDescriptor contentToReuse, ExecutionEnvironment env) throws ExecutionException {
        FileDocumentManager.getInstance().saveAllDocuments();
        if (LocalHistoryConfiguration.getInstance().ADD_LABEL_ON_RUNNING) {
            String name = env.getRunProfile().getName();
            String label = state instanceof RemoteState ? DebuggerBundle.message((String)"debugger.runner.vcs.label.remote.debug", (Object[])new Object[]{name}) : DebuggerBundle.message((String)"debugger.runner.vcs.label.debugging", (Object[])new Object[]{name});
            LocalHistory.putSystemLabel((Project)project, (String)label);
        }
        return this.createContentDescriptor(project, executor, state, contentToReuse, env);
    }

    @Nullable
    protected RunContentDescriptor createContentDescriptor(Project project, Executor executor, RunProfileState state, RunContentDescriptor contentToReuse, ExecutionEnvironment env) throws ExecutionException {
        if (state instanceof JavaCommandLine) {
            JavaParameters parameters = ((JavaCommandLine)state).getJavaParameters();
            GenericDebuggerRunner.runCustomPatchers((JavaParameters)parameters, (RunnerSettings)state.getRunnerSettings(), (Executor)executor);
            RemoteConnection connection = DebuggerManagerImpl.createDebugParameters(parameters, true, DebuggerSettings.getInstance().DEBUGGER_TRANSPORT, "", false);
            return this.attachVirtualMachine(project, executor, state, contentToReuse, env, connection, true);
        }
        if (state instanceof PatchedRunnableState) {
            RemoteConnection connection = GenericDebuggerRunner.doPatch(new JavaParameters(), state.getRunnerSettings());
            return this.attachVirtualMachine(project, executor, state, contentToReuse, env, connection, true);
        }
        if (state instanceof RemoteState) {
            RemoteConnection connection = GenericDebuggerRunner.createRemoteDebugConnection((RemoteState)state, state.getRunnerSettings());
            return this.attachVirtualMachine(project, executor, state, contentToReuse, env, connection, false);
        }
        return null;
    }

    @Nullable
    protected RunContentDescriptor attachVirtualMachine(Project project, Executor executor, RunProfileState state, RunContentDescriptor contentToReuse, ExecutionEnvironment env, RemoteConnection connection, boolean pollConnection) throws ExecutionException {
        DebuggerPanelsManager manager = DebuggerPanelsManager.getInstance(project);
        return manager.attachVirtualMachine(executor, (ProgramRunner)this, env, state, contentToReuse, connection, pollConnection);
    }

    private static RemoteConnection createRemoteDebugConnection(RemoteState connection, RunnerSettings settings) {
        RemoteConnection remoteConnection = connection.getRemoteConnection();
        GenericDebuggerRunnerSettings debuggerRunnerSettings = (GenericDebuggerRunnerSettings)settings.getData();
        if (debuggerRunnerSettings != null) {
            remoteConnection.setUseSockets(debuggerRunnerSettings.getTransport() == 0);
            remoteConnection.setAddress(debuggerRunnerSettings.DEBUG_PORT);
        }
        return remoteConnection;
    }

    public GenericDebuggerRunnerSettings createConfigurationData(ConfigurationInfoProvider settingsProvider) {
        return new GenericDebuggerRunnerSettings();
    }

    public void patch(JavaParameters javaParameters, RunnerSettings settings, boolean beforeExecution) throws ExecutionException {
        GenericDebuggerRunner.doPatch(javaParameters, settings);
        GenericDebuggerRunner.runCustomPatchers((JavaParameters)javaParameters, (RunnerSettings)settings, (Executor)((Executor)Executor.EXECUTOR_EXTENSION_NAME.findExtension(DefaultDebugExecutor.class)));
    }

    private static RemoteConnection doPatch(JavaParameters javaParameters, RunnerSettings settings) throws ExecutionException {
        GenericDebuggerRunnerSettings debuggerSettings = (GenericDebuggerRunnerSettings)settings.getData();
        return DebuggerManagerImpl.createDebugParameters(javaParameters, debuggerSettings, false);
    }

    public SettingsEditor<GenericDebuggerRunnerSettings> getSettingsEditor(Executor executor, RunConfiguration configuration) {
        if (configuration instanceof RunConfigurationWithRunnerSettings && ((RunConfigurationWithRunnerSettings)configuration).isSettingsNeeded()) {
            return new GenericDebuggerParametersRunnerConfigurable(configuration.getProject());
        }
        return null;
    }
}

