/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.impl;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerInvocationUtil;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.ContextUtil;
import com.intellij.debugger.engine.DebugProcessAdapterImpl;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.RequestHint;
import com.intellij.debugger.engine.StackFrameContext;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationListener;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.engine.requests.RequestManagerImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerContextUtil;
import com.intellij.debugger.impl.DebuggerStateManager;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.impl.SimpleStackFrameContext;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.breakpoints.BreakpointWithHighlighter;
import com.intellij.debugger.ui.breakpoints.LineBreakpoint;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ModuleRunProfile;
import com.intellij.execution.configurations.RemoteConnection;
import com.intellij.execution.configurations.RemoteState;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.unscramble.ThreadState;
import com.intellij.xdebugger.AbstractDebuggerSession;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.event.Event;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DebuggerSession
implements AbstractDebuggerSession {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.impl.DebuggerSession");
    private final MyDebuggerStateManager myContextManager;
    public static final int STATE_STOPPED = 0;
    public static final int STATE_RUNNING = 1;
    public static final int STATE_WAITING_ATTACH = 2;
    public static final int STATE_PAUSED = 3;
    public static final int STATE_WAIT_EVALUATION = 5;
    public static final int STATE_DISPOSED = 6;
    public static final int EVENT_ATTACHED = 0;
    public static final int EVENT_DETACHED = 1;
    public static final int EVENT_RESUME = 4;
    public static final int EVENT_STEP = 5;
    public static final int EVENT_PAUSE = 6;
    public static final int EVENT_REFRESH = 7;
    public static final int EVENT_CONTEXT = 8;
    public static final int EVENT_START_WAIT_ATTACH = 9;
    public static final int EVENT_DISPOSE = 10;
    public static final int EVENT_REFRESH_VIEWS_ONLY = 11;
    private volatile boolean myIsEvaluating;
    private volatile int myIgnoreFiltersFrameCountThreshold = 0;
    private DebuggerSessionState myState = null;
    private final String mySessionName;
    private final DebugProcessImpl myDebugProcess;
    @NotNull
    private GlobalSearchScope mySearchScope;
    private final DebuggerContextImpl SESSION_EMPTY_CONTEXT;
    private final Set<ThreadReferenceProxyImpl> mySteppingThroughThreads = new HashSet<ThreadReferenceProxyImpl>();

    public boolean isSteppingThrough(ThreadReferenceProxyImpl threadProxy) {
        return this.mySteppingThroughThreads.contains(threadProxy);
    }

    @NotNull
    public GlobalSearchScope getSearchScope() {
        LOG.assertTrue(this.mySearchScope != null, (Object)"Accessing Session's search scope before its initialization");
        GlobalSearchScope globalSearchScope = this.mySearchScope;
        if (globalSearchScope == null) {
            throw new IllegalStateException("@NotNull method com/intellij/debugger/impl/DebuggerSession.getSearchScope must not return null");
        }
        return globalSearchScope;
    }

    protected DebuggerSession(String sessionName, DebugProcessImpl debugProcess) {
        this.mySessionName = sessionName;
        this.myDebugProcess = debugProcess;
        this.SESSION_EMPTY_CONTEXT = DebuggerContextImpl.createDebuggerContext(this, null, null, null);
        this.myContextManager = new MyDebuggerStateManager();
        this.myState = new DebuggerSessionState(0, null);
        this.myDebugProcess.addDebugProcessListener(new MyDebugProcessListener(debugProcess));
        this.myDebugProcess.addEvaluationListener(new MyEvaluationListener());
    }

    public DebuggerStateManager getContextManager() {
        return this.myContextManager;
    }

    public Project getProject() {
        return this.getProcess().getProject();
    }

    public String getSessionName() {
        return this.mySessionName;
    }

    public DebugProcessImpl getProcess() {
        return this.myDebugProcess;
    }

    public int getState() {
        return this.myState.myState;
    }

    public String getStateDescription() {
        if (this.myState.myDescription != null) {
            return this.myState.myDescription;
        }
        switch (this.myState.myState) {
            case 0: {
                return DebuggerBundle.message((String)"status.debug.stopped", (Object[])new Object[0]);
            }
            case 1: {
                return DebuggerBundle.message((String)"status.app.running", (Object[])new Object[0]);
            }
            case 2: {
                RemoteConnection connection = this.getProcess().getConnection();
                String addressDisplayName = DebuggerBundle.getAddressDisplayName((RemoteConnection)connection);
                String transportName = DebuggerBundle.getTransportName((RemoteConnection)connection);
                return connection.isServerMode() ? DebuggerBundle.message((String)"status.listening", (Object[])new Object[]{addressDisplayName, transportName}) : DebuggerBundle.message((String)"status.connecting", (Object[])new Object[]{addressDisplayName, transportName});
            }
            case 3: {
                return DebuggerBundle.message((String)"status.paused", (Object[])new Object[0]);
            }
            case 5: {
                return DebuggerBundle.message((String)"status.waiting.evaluation.result", (Object[])new Object[0]);
            }
            case 6: {
                return DebuggerBundle.message((String)"status.debug.stopped", (Object[])new Object[0]);
            }
        }
        return this.myState.myDescription;
    }

    private void resumeAction(DebugProcessImpl.ResumeCommand command, int event) {
        this.getContextManager().setState(this.SESSION_EMPTY_CONTEXT, 5, event, null);
        this.myDebugProcess.getManagerThread().schedule(command);
    }

    public void stepOut() {
        SuspendContextImpl suspendContext = this.getSuspendContext();
        this.mySteppingThroughThreads.add(suspendContext.getThread());
        this.resumeAction(this.myDebugProcess.createStepOutCommand(suspendContext), 5);
    }

    public void stepOver(boolean ignoreBreakpoints) {
        SuspendContextImpl suspendContext = this.getSuspendContext();
        this.mySteppingThroughThreads.add(suspendContext.getThread());
        this.resumeAction(this.myDebugProcess.createStepOverCommand(suspendContext, ignoreBreakpoints), 5);
    }

    public void stepInto(boolean ignoreFilters, @Nullable RequestHint.SmartStepFilter smartStepFilter) {
        SuspendContextImpl suspendContext = this.getSuspendContext();
        this.mySteppingThroughThreads.add(suspendContext.getThread());
        this.resumeAction(this.myDebugProcess.createStepIntoCommand(suspendContext, ignoreFilters, smartStepFilter), 5);
    }

    public void runToCursor(Document document, int line, boolean ignoreBreakpoints) {
        try {
            DebugProcessImpl.ResumeCommand runToCursorCommand = this.myDebugProcess.createRunToCursorCommand(this.getSuspendContext(), document, line, ignoreBreakpoints);
            this.mySteppingThroughThreads.add(this.getSuspendContext().getThread());
            this.resumeAction(runToCursorCommand, 5);
        }
        catch (EvaluateException e) {
            Messages.showErrorDialog((String)e.getMessage(), (String)ActionsBundle.actionText((String)"RunToCursor"));
        }
    }

    public void resume() {
        SuspendContextImpl suspendContext = this.getSuspendContext();
        if (suspendContext != null) {
            this.mySteppingThroughThreads.remove(suspendContext.getThread());
            this.resetIgnoreStepFiltersFlag();
            this.resumeAction(this.myDebugProcess.createResumeCommand(suspendContext), 4);
        }
    }

    private void resetIgnoreStepFiltersFlag() {
        this.myIgnoreFiltersFrameCountThreshold = 0;
    }

    public void setIgnoreStepFiltersFlag(int currentStackFrameCount) {
        this.myIgnoreFiltersFrameCountThreshold = currentStackFrameCount;
    }

    public boolean shouldIgnoreSteppingFilters() {
        return this.myIgnoreFiltersFrameCountThreshold > 0;
    }

    public void pause() {
        this.myDebugProcess.getManagerThread().schedule(this.myDebugProcess.createPauseCommand());
    }

    public void showExecutionPoint() {
        this.getContextManager().setState(DebuggerContextUtil.createDebuggerContext(this, this.getSuspendContext()), 3, 7, null);
    }

    public void refresh(boolean refreshViewsOnly) {
        if (this.getState() == 3) {
            DebuggerContextImpl context = this.myContextManager.getContext();
            DebuggerContextImpl newContext = DebuggerContextImpl.createDebuggerContext(this, context.getSuspendContext(), context.getThreadProxy(), context.getFrameProxy());
            this.myContextManager.setState(newContext, 3, refreshViewsOnly ? 11 : 7, null);
        }
    }

    public void dispose() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.getProcess().dispose();
        this.getContextManager().setState(this.SESSION_EMPTY_CONTEXT, 6, 10, null);
    }

    public boolean isStopped() {
        return this.getState() == 0;
    }

    public boolean isAttached() {
        return !this.isStopped() && this.getState() != 2;
    }

    public boolean isPaused() {
        return this.getState() == 3;
    }

    public boolean isConnecting() {
        return this.getState() == 2;
    }

    public boolean isEvaluating() {
        return this.myIsEvaluating;
    }

    public boolean isRunning() {
        return this.getState() == 1 && !this.getProcess().getExecutionResult().getProcessHandler().isProcessTerminated();
    }

    private SuspendContextImpl getSuspendContext() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        return this.getContextManager().getContext().getSuspendContext();
    }

    @Nullable
    protected ExecutionResult attach(@NotNull Executor executor, @NotNull ProgramRunner runner, ModuleRunProfile profile, RunProfileState state, RemoteConnection remoteConnection, boolean pollConnection) throws ExecutionException {
        if (executor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/debugger/impl/DebuggerSession.attach must not be null");
        }
        if (runner == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/debugger/impl/DebuggerSession.attach must not be null");
        }
        String addressDisplayName = DebuggerBundle.getAddressDisplayName((RemoteConnection)remoteConnection);
        String transportName = DebuggerBundle.getTransportName((RemoteConnection)remoteConnection);
        Module[] modules = profile.getModules();
        if (modules.length == 0) {
            this.mySearchScope = GlobalSearchScope.allScope((Project)this.getProject());
        } else {
            GlobalSearchScope scope = GlobalSearchScope.moduleRuntimeScope((Module)modules[0], (boolean)true);
            for (int idx = 1; idx < modules.length; ++idx) {
                Module module = modules[idx];
                scope = scope.uniteWith(GlobalSearchScope.moduleRuntimeScope((Module)module, (boolean)true));
            }
            this.mySearchScope = scope;
        }
        ExecutionResult executionResult = this.myDebugProcess.attachVirtualMachine(executor, runner, this, state, remoteConnection, pollConnection);
        this.getContextManager().setState(this.SESSION_EMPTY_CONTEXT, 2, 9, DebuggerBundle.message((String)"status.waiting.attach", (Object[])new Object[]{addressDisplayName, transportName}));
        return executionResult;
    }

    private class MyEvaluationListener
    implements EvaluationListener {
        private MyEvaluationListener() {
        }

        @Override
        public void evaluationStarted(SuspendContextImpl context) {
            DebuggerSession.this.myIsEvaluating = true;
        }

        @Override
        public void evaluationFinished(final SuspendContextImpl context) {
            DebuggerSession.this.myIsEvaluating = false;
            DebuggerInvocationUtil.invokeLater(DebuggerSession.this.getProject(), new Runnable(){

                @Override
                public void run() {
                    if (context != DebuggerSession.this.getSuspendContext()) {
                        DebuggerSession.this.getContextManager().setState(DebuggerContextUtil.createDebuggerContext(DebuggerSession.this, context), 3, 7, null);
                    }
                }
            });
        }
    }

    private class MyDebugProcessListener
    extends DebugProcessAdapterImpl {
        private final DebugProcessImpl myDebugProcess;

        public MyDebugProcessListener(DebugProcessImpl debugProcess) {
            this.myDebugProcess = debugProcess;
        }

        @Override
        public void connectorIsReady() {
            DebuggerInvocationUtil.invokeLater(DebuggerSession.this.getProject(), new Runnable(){

                @Override
                public void run() {
                    RemoteConnection connection = MyDebugProcessListener.this.myDebugProcess.getConnection();
                    String addressDisplayName = DebuggerBundle.getAddressDisplayName((RemoteConnection)connection);
                    String transportName = DebuggerBundle.getTransportName((RemoteConnection)connection);
                    String connectionStatusMessage = connection.isServerMode() ? DebuggerBundle.message((String)"status.listening", (Object[])new Object[]{addressDisplayName, transportName}) : DebuggerBundle.message((String)"status.connecting", (Object[])new Object[]{addressDisplayName, transportName});
                    DebuggerSession.this.getContextManager().setState(DebuggerSession.this.SESSION_EMPTY_CONTEXT, 2, 9, connectionStatusMessage);
                }
            });
        }

        @Override
        public void paused(SuspendContextImpl suspendContext) {
            SourcePosition position;
            Object positionContext;
            ThreadReferenceProxyImpl currentThread;
            if (LOG.isDebugEnabled()) {
                LOG.debug("paused");
            }
            if ((currentThread = suspendContext.getThread()) == null) {
                LOG.assertTrue(suspendContext.getSuspendPolicy() == 2);
                SuspendContextImpl oldContext = DebuggerSession.this.getProcess().getSuspendManager().getPausedContext();
                if (oldContext != null) {
                    currentThread = oldContext.getThread();
                }
                if (currentThread == null) {
                    Collection<ThreadReferenceProxyImpl> allThreads = DebuggerSession.this.getProcess().getVirtualMachineProxy().allThreads();
                    for (ThreadReferenceProxyImpl thread : allThreads) {
                        if (!ThreadState.isEDT(thread.name())) continue;
                        currentThread = thread;
                        break;
                    }
                    if (currentThread == null) {
                        ThreadReferenceProxyImpl thread;
                        Iterator<ThreadReferenceProxyImpl> i$ = allThreads.iterator();
                        while (i$.hasNext() && (currentThread = (thread = i$.next())).status() != 1) {
                        }
                    }
                }
                StackFrameProxyImpl proxy = null;
                if (currentThread != null) {
                    try {
                        while (!currentThread.isSuspended()) {
                            try {
                                Thread.sleep(10L);
                            }
                            catch (InterruptedException ignored) {}
                        }
                        proxy = currentThread.frameCount() > 0 ? currentThread.frame(0) : null;
                    }
                    catch (ObjectCollectedException e) {
                        proxy = null;
                    }
                    catch (EvaluateException e) {
                        proxy = null;
                        LOG.error((Throwable)e);
                    }
                }
                positionContext = new SimpleStackFrameContext(proxy, this.myDebugProcess);
            } else {
                positionContext = suspendContext;
            }
            if (currentThread != null) {
                try {
                    int frameCount = currentThread.frameCount();
                    if (frameCount == 0 || frameCount < DebuggerSession.this.myIgnoreFiltersFrameCountThreshold) {
                        DebuggerSession.this.resetIgnoreStepFiltersFlag();
                    }
                }
                catch (EvaluateException e) {
                    LOG.info((Throwable)e);
                    DebuggerSession.this.resetIgnoreStepFiltersFlag();
                }
            }
            if ((position = (SourcePosition)PsiDocumentManager.getInstance((Project)DebuggerSession.this.getProject()).commitAndRunReadAction((Computable)new Computable<SourcePosition>((StackFrameContext)positionContext){
                final /* synthetic */ StackFrameContext val$positionContext;
                {
                    this.val$positionContext = stackFrameContext;
                }

                @Nullable
                public SourcePosition compute() {
                    return ContextUtil.getSourcePosition(this.val$positionContext);
                }
            })) != null) {
                List<Pair<Breakpoint, Event>> eventDescriptors = DebuggerUtilsEx.getEventDescriptors(suspendContext);
                RequestManagerImpl requestsManager = suspendContext.getDebugProcess().getRequestsManager();
                PsiFile foundFile = position.getFile();
                boolean sourceMissing = foundFile == null || foundFile instanceof PsiCompiledElement;
                for (Pair<Breakpoint, Event> eventDescriptor : eventDescriptors) {
                    String className;
                    Breakpoint breakpoint = (Breakpoint)eventDescriptor.getFirst();
                    if (!(breakpoint instanceof LineBreakpoint)) continue;
                    SourcePosition breakpointPosition = ((BreakpointWithHighlighter)breakpoint).getSourcePosition();
                    if (breakpointPosition == null || !sourceMissing && breakpointPosition.getLine() != position.getLine()) {
                        requestsManager.deleteRequest(breakpoint);
                        requestsManager.setInvalid(breakpoint, DebuggerBundle.message((String)"error.invalid.breakpoint.source.changed", (Object[])new Object[0]));
                        breakpoint.updateUI();
                        continue;
                    }
                    if (!sourceMissing) continue;
                    position = breakpointPosition;
                    try {
                        className = positionContext.getFrameProxy().location().declaringType().name();
                    }
                    catch (EvaluateException e) {
                        className = "";
                    }
                    requestsManager.setInvalid(breakpoint, DebuggerBundle.message((String)"error.invalid.breakpoint.source.not.found", (Object[])new Object[]{className}));
                    breakpoint.updateUI();
                }
            }
            final DebuggerContextImpl debuggerContext = DebuggerContextImpl.createDebuggerContext(DebuggerSession.this, suspendContext, currentThread, null);
            debuggerContext.setPositionCache(position);
            DebuggerInvocationUtil.invokeLater(DebuggerSession.this.getProject(), new Runnable(){

                @Override
                public void run() {
                    DebuggerSession.this.getContextManager().setState(debuggerContext, 3, 6, null);
                }
            });
        }

        @Override
        public void resumed(SuspendContextImpl suspendContext) {
            final SuspendContextImpl currentContext = DebuggerSession.this.getProcess().getSuspendManager().getPausedContext();
            DebuggerInvocationUtil.invokeLater(DebuggerSession.this.getProject(), new Runnable(){

                @Override
                public void run() {
                    if (currentContext != null) {
                        DebuggerSession.this.getContextManager().setState(DebuggerContextUtil.createDebuggerContext(DebuggerSession.this, currentContext), 3, 8, null);
                    } else {
                        DebuggerSession.this.getContextManager().setState(DebuggerSession.this.SESSION_EMPTY_CONTEXT, 1, 8, null);
                    }
                }
            });
        }

        @Override
        public void processAttached(DebugProcessImpl process) {
            RemoteConnection connection = DebuggerSession.this.getProcess().getConnection();
            String addressDisplayName = DebuggerBundle.getAddressDisplayName((RemoteConnection)connection);
            String transportName = DebuggerBundle.getTransportName((RemoteConnection)connection);
            final String message = DebuggerBundle.message((String)"status.connected", (Object[])new Object[]{addressDisplayName, transportName});
            process.getExecutionResult().getProcessHandler().notifyTextAvailable(message + "\n", ProcessOutputTypes.SYSTEM);
            DebuggerInvocationUtil.invokeLater(DebuggerSession.this.getProject(), new Runnable(){

                @Override
                public void run() {
                    DebuggerSession.this.getContextManager().setState(DebuggerSession.this.SESSION_EMPTY_CONTEXT, 1, 0, message);
                }
            });
        }

        @Override
        public void attachException(final RunProfileState state, final ExecutionException exception, final RemoteConnection remoteConnection) {
            DebuggerInvocationUtil.invokeLater(DebuggerSession.this.getProject(), new Runnable(){

                @Override
                public void run() {
                    String message = "";
                    if (state instanceof RemoteState) {
                        message = DebuggerBundle.message((String)"status.connect.failed", (Object[])new Object[]{DebuggerBundle.getAddressDisplayName((RemoteConnection)remoteConnection), DebuggerBundle.getTransportName((RemoteConnection)remoteConnection)});
                    }
                    message = message + exception.getMessage();
                    DebuggerSession.this.getContextManager().setState(DebuggerSession.this.SESSION_EMPTY_CONTEXT, 0, 1, message);
                }
            });
        }

        @Override
        public void processDetached(DebugProcessImpl debugProcess, boolean closedByUser) {
            ExecutionResult executionResult;
            if (!closedByUser && (executionResult = debugProcess.getExecutionResult()) != null) {
                RemoteConnection connection = DebuggerSession.this.getProcess().getConnection();
                String addressDisplayName = DebuggerBundle.getAddressDisplayName((RemoteConnection)connection);
                String transportName = DebuggerBundle.getTransportName((RemoteConnection)connection);
                executionResult.getProcessHandler().notifyTextAvailable(DebuggerBundle.message((String)"status.disconnected", (Object[])new Object[]{addressDisplayName, transportName}) + "\n", ProcessOutputTypes.SYSTEM);
            }
            DebuggerInvocationUtil.invokeLater(DebuggerSession.this.getProject(), new Runnable(){

                @Override
                public void run() {
                    RemoteConnection connection = DebuggerSession.this.getProcess().getConnection();
                    String addressDisplayName = DebuggerBundle.getAddressDisplayName((RemoteConnection)connection);
                    String transportName = DebuggerBundle.getTransportName((RemoteConnection)connection);
                    DebuggerSession.this.getContextManager().setState(DebuggerSession.this.SESSION_EMPTY_CONTEXT, 0, 1, DebuggerBundle.message((String)"status.disconnected", (Object[])new Object[]{addressDisplayName, transportName}));
                }
            });
            DebuggerSession.this.mySteppingThroughThreads.clear();
        }
    }

    private static class DebuggerSessionState {
        final int myState;
        final String myDescription;

        public DebuggerSessionState(int state, String description) {
            this.myState = state;
            this.myDescription = description;
        }
    }

    private class MyDebuggerStateManager
    extends DebuggerStateManager {
        private DebuggerContextImpl myDebuggerContext;

        MyDebuggerStateManager() {
            this.myDebuggerContext = DebuggerSession.this.SESSION_EMPTY_CONTEXT;
        }

        @Override
        public DebuggerContextImpl getContext() {
            return this.myDebuggerContext;
        }

        @Override
        public void setState(final DebuggerContextImpl context, final int state, final int event, final String description) {
            ApplicationManager.getApplication().assertIsDispatchThread();
            LOG.assertTrue(context.getDebuggerSession() == DebuggerSession.this || context.getDebuggerSession() == null);
            final Runnable setStateRunnable = new Runnable(){

                @Override
                public void run() {
                    LOG.assertTrue(MyDebuggerStateManager.this.myDebuggerContext.isInitialised());
                    MyDebuggerStateManager.this.myDebuggerContext = context;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("DebuggerSession state = " + state + ", event = " + event);
                    }
                    DebuggerSession.this.myIsEvaluating = false;
                    DebuggerSession.this.myState = new DebuggerSessionState(state, description);
                    MyDebuggerStateManager.this.fireStateChanged(context, event);
                }
            };
            if (context.getSuspendContext() == null) {
                setStateRunnable.run();
            } else {
                DebuggerSession.this.getProcess().getManagerThread().schedule(new SuspendContextCommandImpl(context.getSuspendContext()){

                    @Override
                    public void contextAction() throws Exception {
                        context.initCaches();
                        DebuggerInvocationUtil.swingInvokeLater(DebuggerSession.this.getProject(), setStateRunnable);
                    }
                });
            }
        }
    }
}

