/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.evaluation.expression;

import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.expression.AssignmentEvaluator;
import com.intellij.debugger.engine.evaluation.expression.Evaluator;
import com.intellij.debugger.engine.evaluation.expression.Modifier;

public class PostfixOperationEvaluator
implements Evaluator {
    private final Evaluator myOperandEvaluator;
    private final Evaluator myIncrementImpl;
    private Modifier myModifier;

    public PostfixOperationEvaluator(Evaluator operandEvaluator, Evaluator incrementImpl) {
        this.myOperandEvaluator = operandEvaluator;
        this.myIncrementImpl = incrementImpl;
    }

    @Override
    public Object evaluate(EvaluationContextImpl context) throws EvaluateException {
        Object value = this.myOperandEvaluator.evaluate(context);
        this.myModifier = this.myOperandEvaluator.getModifier();
        Object operationResult = this.myIncrementImpl.evaluate(context);
        AssignmentEvaluator.assign(this.myModifier, operationResult, context);
        return value;
    }

    @Override
    public Modifier getModifier() {
        return this.myModifier;
    }
}

