/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.evaluation.expression;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.expression.Evaluator;
import com.intellij.debugger.engine.evaluation.expression.ExpressionEvaluator;
import com.intellij.debugger.engine.evaluation.expression.Modifier;
import com.intellij.openapi.diagnostic.Logger;
import com.sun.jdi.Value;

public class ExpressionEvaluatorImpl
implements ExpressionEvaluator {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.engine.evaluation.expression.ExpressionEvaluator");
    Evaluator myEvaluator;
    Value myValue;

    public ExpressionEvaluatorImpl(Evaluator evaluator) {
        this.myEvaluator = evaluator;
    }

    @Override
    public Value getValue() {
        return this.myValue;
    }

    @Override
    public Modifier getModifier() {
        return this.myEvaluator.getModifier();
    }

    @Override
    public Value evaluate(EvaluationContext context) throws EvaluateException {
        if (!context.getDebugProcess().isAttached()) {
            throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"error.vm.disconnected", (Object[])new Object[0]));
        }
        try {
            if (context.getFrameProxy() == null) {
                throw EvaluateExceptionUtil.NULL_STACK_FRAME;
            }
            Object value = this.myEvaluator.evaluate((EvaluationContextImpl)context);
            if (value != null && !(value instanceof Value)) {
                throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.invalid.expression", (Object[])new Object[]{""}));
            }
            this.myValue = (Value)value;
            return this.myValue;
        }
        catch (Throwable e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(e);
            }
            if (e instanceof EvaluateException) {
                throw (EvaluateException)e;
            }
            throw EvaluateExceptionUtil.createEvaluateException((Throwable)e);
        }
    }
}

