/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.PositionManager;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.CompoundPositionManager;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.JVMNameUtil;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.debugger.requests.ClassPrepareRequestor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtil;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.Location;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.request.ClassPrepareRequest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PositionManagerImpl
implements PositionManager {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.engine.PositionManagerImpl");
    private final DebugProcessImpl myDebugProcess;

    public PositionManagerImpl(DebugProcessImpl debugProcess) {
        this.myDebugProcess = debugProcess;
    }

    public DebugProcess getDebugProcess() {
        return this.myDebugProcess;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public List<Location> locationsOfLine(ReferenceType type, SourcePosition position) {
        List<Location> list;
        block6: {
            List<Location> list2;
            try {
                List<Location> locs;
                int line = position.getLine() + 1;
                List<Location> list3 = locs = this.getDebugProcess().getVirtualMachineProxy().versionHigher("1.4") ? type.locationsOfLine("Java", null, line) : type.locationsOfLine(line);
                if (locs.size() <= 0) break block6;
                list2 = locs;
            }
            catch (AbsentInformationException absentInformationException) {
                // empty catch block
                break block6;
            }
            list = list2;
            if (list2 == null) throw new IllegalStateException("@NotNull method com/intellij/debugger/engine/PositionManagerImpl.locationsOfLine must not return null");
            return list;
        }
        if ((list = Collections.emptyList()) != null) return list;
        throw new IllegalStateException("@NotNull method com/intellij/debugger/engine/PositionManagerImpl.locationsOfLine must not return null");
    }

    public ClassPrepareRequest createPrepareRequest(final ClassPrepareRequestor requestor, final SourcePosition position) {
        final Ref waitPrepareFor = new Ref(null);
        final Ref waitRequestor = new Ref(null);
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                PsiClass psiClass = JVMNameUtil.getClassAt(position);
                if (psiClass == null) {
                    return;
                }
                if (PsiUtil.isLocalOrAnonymousClass((PsiClass)psiClass)) {
                    PsiClass parent = JVMNameUtil.getTopLevelParentClass(psiClass);
                    if (parent == null) {
                        return;
                    }
                    String parentQName = JVMNameUtil.getNonAnonymousClassName(parent);
                    if (parentQName == null) {
                        return;
                    }
                    waitPrepareFor.set((Object)(parentQName + "$*"));
                    waitRequestor.set((Object)new ClassPrepareRequestor(){

                        public void processClassPrepare(DebugProcess debuggerProcess, ReferenceType referenceType) {
                            CompoundPositionManager positionManager = ((DebugProcessImpl)debuggerProcess).getPositionManager();
                            if (positionManager.locationsOfLine(referenceType, position).size() > 0) {
                                requestor.processClassPrepare(debuggerProcess, referenceType);
                            } else {
                                List<ReferenceType> positionClasses = positionManager.getAllClasses(position);
                                if (positionClasses.contains(referenceType)) {
                                    requestor.processClassPrepare(debuggerProcess, referenceType);
                                }
                            }
                        }
                    });
                } else {
                    waitPrepareFor.set((Object)JVMNameUtil.getNonAnonymousClassName(psiClass));
                    waitRequestor.set((Object)requestor);
                }
            }
        });
        if (waitPrepareFor.get() == null) {
            return null;
        }
        return this.myDebugProcess.getRequestsManager().createClassPrepareRequest((ClassPrepareRequestor)waitRequestor.get(), (String)waitPrepareFor.get());
    }

    public SourcePosition getSourcePosition(Location location) {
        int lineNumber;
        DebuggerManagerThreadImpl.assertIsManagerThread();
        if (location == null) {
            return null;
        }
        PsiFile psiFile = this.getPsiFileByLocation(this.getDebugProcess().getProject(), location);
        if (psiFile == null) {
            return null;
        }
        LOG.assertTrue(this.myDebugProcess != null);
        if (location == null) {
            return SourcePosition.createFromLine((PsiFile)psiFile, (int)-1);
        }
        try {
            lineNumber = location.lineNumber() - 1;
        }
        catch (InternalError e) {
            lineNumber = -1;
        }
        if (psiFile instanceof PsiCompiledElement || lineNumber < 0) {
            String methodSignature = location.method().signature();
            if (methodSignature == null) {
                return SourcePosition.createFromLine((PsiFile)psiFile, (int)-1);
            }
            String methodName = location.method().name();
            if (methodName == null) {
                return SourcePosition.createFromLine((PsiFile)psiFile, (int)-1);
            }
            if (location.declaringType() == null) {
                return SourcePosition.createFromLine((PsiFile)psiFile, (int)-1);
            }
            MethodFinder finder = new MethodFinder(location.declaringType().name(), methodSignature);
            psiFile.accept((PsiElementVisitor)finder);
            PsiMethod compiledMethod = finder.getCompiledMethod();
            if (compiledMethod == null) {
                return SourcePosition.createFromLine((PsiFile)psiFile, (int)-1);
            }
            return SourcePosition.createFromElement((PsiElement)compiledMethod);
        }
        return SourcePosition.createFromLine((PsiFile)psiFile, (int)lineNumber);
    }

    @Nullable
    private PsiFile getPsiFileByLocation(Project project, Location location) {
        GlobalSearchScope searchScope;
        if (location == null) {
            return null;
        }
        ReferenceType refType = location.declaringType();
        if (refType == null) {
            return null;
        }
        if (DumbService.getInstance((Project)project).isDumb()) {
            return null;
        }
        String originalQName = refType.name();
        int dollar = originalQName.indexOf(36);
        String qName = dollar >= 0 ? originalQName.substring(0, dollar) : originalQName;
        PsiClass psiClass = DebuggerUtils.findClass((String)qName, (Project)project, (GlobalSearchScope)(searchScope = this.myDebugProcess.getSearchScope()));
        if (psiClass == null && dollar >= 0) {
            psiClass = DebuggerUtils.findClass((String)originalQName, (Project)project, (GlobalSearchScope)searchScope);
        }
        if (psiClass != null) {
            PsiElement element = psiClass.getNavigationElement();
            return element.getContainingFile();
        }
        return null;
    }

    @NotNull
    public List<ReferenceType> getAllClasses(final SourcePosition classPosition) {
        List list = (List)ApplicationManager.getApplication().runReadAction((Computable)new Computable<List<ReferenceType>>(){

            public List<ReferenceType> compute() {
                PsiClass psiClass = JVMNameUtil.getClassAt(classPosition);
                if (psiClass == null) {
                    return Collections.emptyList();
                }
                if (PsiUtil.isLocalOrAnonymousClass((PsiClass)psiClass)) {
                    PsiClass parentNonLocal = JVMNameUtil.getTopLevelParentClass(psiClass);
                    if (parentNonLocal == null) {
                        LOG.error("Local or anonymous class has no non-local parent");
                        return Collections.emptyList();
                    }
                    String parentClassName = JVMNameUtil.getNonAnonymousClassName(parentNonLocal);
                    if (parentClassName == null) {
                        LOG.error("The name of a parent of a local (anonymous) class is null");
                        return Collections.emptyList();
                    }
                    List<ReferenceType> outers = PositionManagerImpl.this.myDebugProcess.getVirtualMachineProxy().classesByName(parentClassName);
                    ArrayList<ReferenceType> result = new ArrayList<ReferenceType>(outers.size());
                    for (ReferenceType outer : outers) {
                        ReferenceType nested = PositionManagerImpl.this.findNested(outer, psiClass, classPosition);
                        if (nested == null) continue;
                        result.add(nested);
                    }
                    return result;
                }
                String className = JVMNameUtil.getNonAnonymousClassName(psiClass);
                if (className == null) {
                    return Collections.emptyList();
                }
                return PositionManagerImpl.this.myDebugProcess.getVirtualMachineProxy().classesByName(className);
            }
        });
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/debugger/engine/PositionManagerImpl.getAllClasses must not return null");
        }
        return list;
    }

    @Nullable
    private ReferenceType findNested(ReferenceType fromClass, PsiClass classToFind, SourcePosition classPosition) {
        VirtualMachineProxyImpl vmProxy = this.myDebugProcess.getVirtualMachineProxy();
        if (fromClass.isPrepared()) {
            List<ReferenceType> nestedTypes = vmProxy.nestedTypes(fromClass);
            for (ReferenceType nested : nestedTypes) {
                ReferenceType found = this.findNested(nested, classToFind, classPosition);
                if (found == null) continue;
                return found;
            }
            try {
                int lineNumber = classPosition.getLine() + 1;
                if (fromClass.locationsOfLine(lineNumber).size() > 0) {
                    return fromClass;
                }
                int rangeBegin = Integer.MAX_VALUE;
                int rangeEnd = Integer.MIN_VALUE;
                for (Location location : fromClass.allLineLocations()) {
                    int locationLine = location.lineNumber() - 1;
                    rangeBegin = Math.min(rangeBegin, locationLine);
                    rangeEnd = Math.max(rangeEnd, locationLine);
                }
                if (classPosition.getLine() >= rangeBegin && classPosition.getLine() <= rangeEnd) {
                    int line = Math.min(rangeBegin + 1, rangeEnd);
                    SourcePosition candidatePosition = SourcePosition.createFromLine((PsiFile)classToFind.getContainingFile(), (int)line);
                    if (classToFind.equals(JVMNameUtil.getClassAt(candidatePosition))) {
                        return fromClass;
                    }
                }
            }
            catch (AbsentInformationException ignored) {
                // empty catch block
            }
        }
        return null;
    }

    private class MethodFinder
    extends JavaRecursiveElementVisitor {
        private final String myClassName;
        private PsiClass myCompiledClass;
        private final String myMethodSignature;
        private PsiMethod myCompiledMethod;

        public MethodFinder(String className, String methodSignature) {
            this.myClassName = className;
            this.myMethodSignature = methodSignature;
        }

        public void visitClass(PsiClass aClass) {
            List<ReferenceType> allClasses = PositionManagerImpl.this.myDebugProcess.getPositionManager().getAllClasses(SourcePosition.createFromElement((PsiElement)aClass));
            for (ReferenceType referenceType : allClasses) {
                if (!referenceType.name().equals(this.myClassName)) continue;
                this.myCompiledClass = aClass;
            }
            aClass.acceptChildren((PsiElementVisitor)this);
        }

        public void visitMethod(PsiMethod method) {
            try {
                String methodName = method.isConstructor() ? "<init>" : method.getName();
                PsiClass containingClass = method.getContainingClass();
                if (containingClass != null && containingClass.equals(this.myCompiledClass) && methodName.equals(methodName) && JVMNameUtil.getJVMSignature(method).getName(PositionManagerImpl.this.myDebugProcess).equals(this.myMethodSignature)) {
                    this.myCompiledMethod = method;
                }
            }
            catch (EvaluateException e) {
                LOG.debug((Throwable)e);
            }
        }

        public PsiClass getCompiledClass() {
            return this.myCompiledClass;
        }

        public PsiMethod getCompiledMethod() {
            return this.myCompiledMethod;
        }
    }
}

