/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cyclicDependencies.actions;

import com.intellij.analysis.AnalysisScope;
import com.intellij.analysis.AnalysisScopeBundle;
import com.intellij.analysis.JavaAnalysisScope;
import com.intellij.cyclicDependencies.actions.CyclicDependenciesHandler;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class CyclicDependenciesAction
extends AnAction {
    private final String myAnalysisVerb = AnalysisScopeBundle.message((String)"action.analyze.verb", (Object[])new Object[0]);
    private final String myAnalysisNoun = AnalysisScopeBundle.message((String)"action.analysis.noun", (Object[])new Object[0]);
    private final String myTitle = AnalysisScopeBundle.message((String)"action.cyclic.dependency.title", (Object[])new Object[0]);

    public void update(AnActionEvent event) {
        Presentation presentation = event.getPresentation();
        presentation.setEnabled(CyclicDependenciesAction.getInspectionScope(event.getDataContext()) != null || event.getData(LangDataKeys.PSI_FILE) != null);
    }

    public void actionPerformed(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        Project project = (Project)PlatformDataKeys.PROJECT.getData(dataContext);
        Module module = (Module)LangDataKeys.MODULE.getData(dataContext);
        if (project != null) {
            PsiFile psiFile = (PsiFile)LangDataKeys.PSI_FILE.getData(dataContext);
            if (psiFile != null && !(psiFile instanceof PsiJavaFile)) {
                return;
            }
            AnalysisScope scope = CyclicDependenciesAction.getInspectionScope(dataContext);
            if (scope == null || scope.getScopeType() != 7) {
                ProjectModuleOrPackageDialog dlg = new ProjectModuleOrPackageDialog(module != null ? ModuleUtil.getModuleNameInReadAction((Module)module) : null);
                dlg.show();
                if (!dlg.isOK()) {
                    return;
                }
                if (dlg.isProjectScopeSelected()) {
                    scope = CyclicDependenciesAction.getProjectScope(dataContext);
                } else if (dlg.isModuleScopeSelected()) {
                    scope = CyclicDependenciesAction.getModuleScope(dataContext);
                }
            }
            FileDocumentManager.getInstance().saveAllDocuments();
            new CyclicDependenciesHandler(project, scope).analyze();
        }
    }

    private static AnalysisScope getInspectionScope(DataContext dataContext) {
        Project project = (Project)PlatformDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return null;
        }
        AnalysisScope scope = CyclicDependenciesAction.getInspectionScopeImpl(dataContext);
        return scope != null && scope.getScopeType() != 6 ? scope : null;
    }

    private static AnalysisScope getInspectionScopeImpl(DataContext dataContext) {
        Project projectContext = (Project)PlatformDataKeys.PROJECT_CONTEXT.getData(dataContext);
        if (projectContext != null) {
            return new AnalysisScope(projectContext);
        }
        Module moduleContext = (Module)LangDataKeys.MODULE_CONTEXT.getData(dataContext);
        if (moduleContext != null) {
            return new AnalysisScope(moduleContext);
        }
        Module[] modulesArray = (Module[])LangDataKeys.MODULE_CONTEXT_ARRAY.getData(dataContext);
        if (modulesArray != null) {
            return new AnalysisScope(modulesArray);
        }
        PsiElement psiTarget = (PsiElement)LangDataKeys.PSI_ELEMENT.getData(dataContext);
        if (psiTarget instanceof PsiDirectory) {
            PsiDirectory psiDirectory = (PsiDirectory)psiTarget;
            if (!psiDirectory.getManager().isInProject((PsiElement)psiDirectory)) {
                return null;
            }
            return new AnalysisScope(psiDirectory);
        }
        if (psiTarget instanceof PsiPackage) {
            PsiPackage pack = (PsiPackage)psiTarget;
            PsiDirectory[] dirs = pack.getDirectories(GlobalSearchScope.projectScope((Project)pack.getProject()));
            if (dirs.length == 0) {
                return null;
            }
            return new JavaAnalysisScope(pack, (Module)LangDataKeys.MODULE.getData(dataContext));
        }
        if (psiTarget != null) {
            return null;
        }
        return CyclicDependenciesAction.getProjectScope(dataContext);
    }

    private static AnalysisScope getProjectScope(DataContext dataContext) {
        Project data = (Project)PlatformDataKeys.PROJECT.getData(dataContext);
        if (data == null) {
            return null;
        }
        return new AnalysisScope(data);
    }

    private static AnalysisScope getModuleScope(DataContext dataContext) {
        Module data = (Module)LangDataKeys.MODULE.getData(dataContext);
        if (data == null) {
            return null;
        }
        return new AnalysisScope(data);
    }

    private class ProjectModuleOrPackageDialog
    extends DialogWrapper {
        private final String myModuleName;
        private JRadioButton myProjectButton;
        private JRadioButton myModuleButton;
        private JPanel myScopePanel;
        private JPanel myWholePanel;

        public ProjectModuleOrPackageDialog(String moduleName) {
            super(true);
            this.myModuleName = moduleName;
            this.$$$setupUI$$$();
            this.init();
            this.setTitle(AnalysisScopeBundle.message((String)"cyclic.dependencies.scope.dialog.title", (Object[])new Object[]{CyclicDependenciesAction.this.myTitle}));
            this.setHorizontalStretch(1.75f);
            if (moduleName == null) {
                this.myModuleButton.setVisible(false);
                this.myProjectButton.setSelected(true);
            } else {
                this.myModuleButton.setSelected(true);
            }
        }

        protected JComponent createCenterPanel() {
            this.myScopePanel.setBorder(IdeBorderFactory.createTitledBorder((String)AnalysisScopeBundle.message((String)"analysis.scope.title", (Object[])new Object[]{CyclicDependenciesAction.this.myAnalysisNoun})));
            this.myProjectButton.setText(AnalysisScopeBundle.message((String)"cyclic.dependencies.scope.dialog.project.button", (Object[])new Object[]{CyclicDependenciesAction.this.myAnalysisVerb}));
            ButtonGroup group = new ButtonGroup();
            group.add(this.myProjectButton);
            if (this.myModuleName != null) {
                this.myModuleButton.setText(AnalysisScopeBundle.message((String)"cyclic.dependencies.scope.dialog.module.button", (Object[])new Object[]{CyclicDependenciesAction.this.myAnalysisVerb, this.myModuleName}));
                group.add(this.myModuleButton);
            }
            return this.myWholePanel;
        }

        public boolean isProjectScopeSelected() {
            return this.myProjectButton.isSelected();
        }

        public boolean isModuleScopeSelected() {
            return this.myModuleButton != null ? this.myModuleButton.isSelected() : false;
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JRadioButton jRadioButton;
            JRadioButton jRadioButton2;
            JPanel jPanel;
            JPanel jPanel2;
            this.myWholePanel = jPanel2 = new JPanel();
            jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
            this.myScopePanel = jPanel = new JPanel();
            jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
            jPanel2.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
            jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), null, 0, 0, null, null));
            this.myProjectButton = jRadioButton2 = new JRadioButton();
            jRadioButton2.setText("###########");
            jPanel.add((Component)jRadioButton2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.myModuleButton = jRadioButton = new JRadioButton();
            jRadioButton.setText("###########");
            jPanel.add((Component)jRadioButton, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            Spacer spacer = new Spacer();
            jPanel2.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myWholePanel;
        }
    }
}

