/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl.javaCompiler.eclipse;

import com.intellij.compiler.OutputParser;
import com.intellij.compiler.impl.javaCompiler.BackendCompiler;
import com.intellij.compiler.impl.javaCompiler.DependencyProcessor;
import com.intellij.compiler.impl.javaCompiler.ModuleChunk;
import com.intellij.compiler.impl.javaCompiler.eclipse.EclipseCompiler;
import com.intellij.compiler.impl.javaCompiler.eclipse.EclipseCompilerConfigurable;
import com.intellij.compiler.impl.javaCompiler.eclipse.EclipseCompilerDriver;
import com.intellij.compiler.impl.javaCompiler.eclipse.EclipseEmbeddedCompilerConfiguration;
import com.intellij.compiler.impl.javaCompiler.javac.JavacSettings;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompilerBundle;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.project.Project;
import com.intellij.util.ArrayUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EclipseEmbeddedCompiler
implements BackendCompiler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.compiler.impl.javaCompiler.eclipse.EclipseEmbeddedCompiler");
    private final Project myProject;
    private final EclipseCompiler myEclipseExternalCompiler;
    private int myExitCode;
    private final EclipseCompilerDriver myEclipseCompilerDriver;
    private static final Set<FileType> COMPILABLE_TYPES = Collections.singleton(StdFileTypes.JAVA);

    public EclipseEmbeddedCompiler(Project project) {
        this.myProject = project;
        this.myEclipseExternalCompiler = new EclipseCompiler(project);
        this.myEclipseCompilerDriver = new EclipseCompilerDriver();
    }

    @Override
    public DependencyProcessor getDependencyProcessor() {
        return null;
    }

    @Override
    public boolean checkCompiler(CompileScope scope) {
        return this.myEclipseCompilerDriver != null && this.myEclipseExternalCompiler.checkCompiler(scope);
    }

    @Override
    @NotNull
    @NonNls
    public String getId() {
        if ("EclipseEmbedded" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/compiler/impl/javaCompiler/eclipse/EclipseEmbeddedCompiler.getId must not return null");
        }
        return "EclipseEmbedded";
    }

    @Override
    @NotNull
    public String getPresentableName() {
        String string = CompilerBundle.message((String)"compiler.eclipse.embedded.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/compiler/impl/javaCompiler/eclipse/EclipseEmbeddedCompiler.getPresentableName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public Configurable createConfigurable() {
        EclipseCompilerConfigurable eclipseCompilerConfigurable = new EclipseCompilerConfigurable(EclipseEmbeddedCompilerConfiguration.getSettings(this.myProject, EclipseEmbeddedCompilerConfiguration.class));
        if (eclipseCompilerConfigurable == null) {
            throw new IllegalStateException("@NotNull method com/intellij/compiler/impl/javaCompiler/eclipse/EclipseEmbeddedCompiler.createConfigurable must not return null");
        }
        return eclipseCompilerConfigurable;
    }

    @Override
    @NotNull
    public Set<FileType> getCompilableFileTypes() {
        Set<FileType> set = COMPILABLE_TYPES;
        if (set == null) {
            throw new IllegalStateException("@NotNull method com/intellij/compiler/impl/javaCompiler/eclipse/EclipseEmbeddedCompiler.getCompilableFileTypes must not return null");
        }
        return set;
    }

    @Override
    @Nullable
    public OutputParser createErrorParser(final @NotNull String outputDir, Process process) {
        if (outputDir == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/compiler/impl/javaCompiler/eclipse/EclipseEmbeddedCompiler.createErrorParser must not be null");
        }
        return new OutputParser(){

            @Override
            public boolean processMessageLine(OutputParser.Callback callback) {
                return EclipseEmbeddedCompiler.this.myEclipseCompilerDriver.processMessageLine(callback, outputDir, EclipseEmbeddedCompiler.this.myProject);
            }
        };
    }

    @Override
    @Nullable
    public OutputParser createOutputParser(@NotNull String outputDir) {
        if (outputDir == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/compiler/impl/javaCompiler/eclipse/EclipseEmbeddedCompiler.createOutputParser must not be null");
        }
        return null;
    }

    @Override
    public void compileFinished() {
    }

    @Override
    @NotNull
    public Process launchProcess(final @NotNull ModuleChunk chunk, final @NotNull String outputDir, final @NotNull CompileContext compileContext) throws IOException {
        if (chunk == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/compiler/impl/javaCompiler/eclipse/EclipseEmbeddedCompiler.launchProcess must not be null");
        }
        if (outputDir == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/compiler/impl/javaCompiler/eclipse/EclipseEmbeddedCompiler.launchProcess must not be null");
        }
        if (compileContext == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/compiler/impl/javaCompiler/eclipse/EclipseEmbeddedCompiler.launchProcess must not be null");
        }
        final ArrayList commandLine = new ArrayList();
        final IOException[] ex = new IOException[]{null};
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                try {
                    JavacSettings settings = EclipseEmbeddedCompilerConfiguration.getSettings(EclipseEmbeddedCompiler.this.myProject, EclipseEmbeddedCompilerConfiguration.class);
                    EclipseEmbeddedCompiler.this.myEclipseExternalCompiler.addCommandLineOptions(commandLine, chunk, outputDir, settings, false, false);
                }
                catch (IOException e) {
                    ex[0] = e;
                }
            }
        });
        if (ex[0] != null) {
            throw ex[0];
        }
        Process process = new Process(){

            @Override
            public OutputStream getOutputStream() {
                throw new UnsupportedOperationException();
            }

            @Override
            public InputStream getInputStream() {
                return null;
            }

            @Override
            public InputStream getErrorStream() {
                return null;
            }

            @Override
            public void destroy() {
            }

            @Override
            public int waitFor() {
                try {
                    commandLine.remove("-verbose");
                    String[] finalCmds = ArrayUtil.toStringArray((Collection)commandLine);
                    EclipseEmbeddedCompiler.this.myEclipseCompilerDriver.parseCommandLineAndCompile(finalCmds, compileContext);
                    EclipseEmbeddedCompiler.this.myExitCode = 0;
                    return EclipseEmbeddedCompiler.this.myExitCode;
                }
                catch (Exception e) {
                    compileContext.addMessage(CompilerMessageCategory.ERROR, e.getMessage(), null, -1, -1);
                    LOG.info((Throwable)e);
                    EclipseEmbeddedCompiler.this.myExitCode = -1;
                    return -1;
                }
            }

            @Override
            public int exitValue() {
                return EclipseEmbeddedCompiler.this.myExitCode;
            }
        };
        if (process == null) {
            throw new IllegalStateException("@NotNull method com/intellij/compiler/impl/javaCompiler/eclipse/EclipseEmbeddedCompiler.launchProcess must not return null");
        }
        return process;
    }
}

