/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl.javaCompiler.eclipse;

import com.intellij.compiler.OutputParser;
import com.intellij.compiler.impl.CompilerUtil;
import com.intellij.compiler.impl.javaCompiler.ExternalCompiler;
import com.intellij.compiler.impl.javaCompiler.ModuleChunk;
import com.intellij.compiler.impl.javaCompiler.eclipse.EclipseCompilerConfigurable;
import com.intellij.compiler.impl.javaCompiler.eclipse.EclipseCompilerConfiguration;
import com.intellij.compiler.impl.javaCompiler.eclipse.EclipseCompilerErrorParser;
import com.intellij.compiler.impl.javaCompiler.eclipse.EclipseCompilerOutputParser;
import com.intellij.compiler.impl.javaCompiler.javac.JavacSettings;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompilerBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.impl.JavaAwareProjectJdkTableImpl;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EclipseCompiler
extends ExternalCompiler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.compiler.impl.javaCompiler.eclipse.EclipseCompiler");
    private final Project myProject;
    private final List<File> myTempFiles = new ArrayList<File>();
    @NonNls
    private static final String PATH_TO_COMPILER_JAR = EclipseCompiler.findJarPah();

    private static String findJarPah() {
        File dir = new File(PathManager.getLibPath());
        File[] jars = dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith("org.eclipse.jdt.core") && name.endsWith(".jar");
            }
        });
        return jars.length == 0 ? dir + "/org.eclipse.jdt.core*.jar" : jars[0].getPath();
    }

    public EclipseCompiler(Project project) {
        this.myProject = project;
    }

    public static boolean isInitialized() {
        File file = new File(PATH_TO_COMPILER_JAR);
        return file.exists();
    }

    @Override
    public boolean checkCompiler(CompileScope scope) {
        if (!EclipseCompiler.isInitialized()) {
            Messages.showMessageDialog((Project)this.myProject, (String)CompilerBundle.message((String)"eclipse.compiler.error.jar.not.found", (Object[])new Object[]{PATH_TO_COMPILER_JAR}), (String)CompilerBundle.message((String)"compiler.eclipse.name", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
            return false;
        }
        return true;
    }

    @NonNls
    public static String getCompilerClass() {
        return "org.eclipse.jdt.internal.compiler.batch.Main";
    }

    @Override
    @NotNull
    public String getId() {
        if ("Eclipse" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/compiler/impl/javaCompiler/eclipse/EclipseCompiler.getId must not return null");
        }
        return "Eclipse";
    }

    @Override
    @NotNull
    public String getPresentableName() {
        String string = CompilerBundle.message((String)"compiler.eclipse.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/compiler/impl/javaCompiler/eclipse/EclipseCompiler.getPresentableName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public Configurable createConfigurable() {
        EclipseCompilerConfigurable eclipseCompilerConfigurable = new EclipseCompilerConfigurable(EclipseCompilerConfiguration.getSettings(this.myProject, EclipseCompilerConfiguration.class));
        if (eclipseCompilerConfigurable == null) {
            throw new IllegalStateException("@NotNull method com/intellij/compiler/impl/javaCompiler/eclipse/EclipseCompiler.createConfigurable must not return null");
        }
        return eclipseCompilerConfigurable;
    }

    @Override
    public OutputParser createErrorParser(@NotNull String outputDir, Process process) {
        if (outputDir == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/compiler/impl/javaCompiler/eclipse/EclipseCompiler.createErrorParser must not be null");
        }
        return new EclipseCompilerErrorParser();
    }

    @Override
    @Nullable
    public OutputParser createOutputParser(@NotNull String outputDir) {
        if (outputDir == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/compiler/impl/javaCompiler/eclipse/EclipseCompiler.createOutputParser must not be null");
        }
        return new EclipseCompilerOutputParser(outputDir);
    }

    @Override
    @NotNull
    public String[] createStartupCommand(final ModuleChunk chunk, CompileContext context, final String outputPath) throws IOException {
        final ArrayList commandLine = new ArrayList();
        final IOException[] ex = new IOException[]{null};
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                try {
                    EclipseCompiler.this.createStartupCommand(chunk, commandLine, outputPath, true);
                }
                catch (IOException e) {
                    ex[0] = e;
                }
            }
        });
        if (ex[0] != null) {
            throw ex[0];
        }
        String[] stringArray = ArrayUtil.toStringArray(commandLine);
        if (stringArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/compiler/impl/javaCompiler/eclipse/EclipseCompiler.createStartupCommand must not return null");
        }
        return stringArray;
    }

    private void createStartupCommand(ModuleChunk chunk, @NonNls ArrayList<String> commandLine, String outputPath, boolean useTempFile) throws IOException {
        JavacSettings compilerSettings = EclipseCompilerConfiguration.getSettings(this.myProject, EclipseCompilerConfiguration.class);
        Sdk projectJdk = JavaAwareProjectJdkTableImpl.getInstanceEx().getInternalJdk();
        String vmExePath = ((JavaSdkType)projectJdk.getSdkType()).getVMExecutablePath(projectJdk);
        commandLine.add(vmExePath);
        commandLine.add("-Xmx" + compilerSettings.MAXIMUM_HEAP_SIZE + "m");
        CompilerUtil.addLocaleOptions(commandLine, false);
        commandLine.add("-classpath");
        commandLine.add(PATH_TO_COMPILER_JAR);
        commandLine.add(EclipseCompiler.getCompilerClass());
        this.addCommandLineOptions(commandLine, chunk, outputPath, compilerSettings, useTempFile, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCommandLineOptions(@NotNull @NonNls List<String> commandLine, @NotNull ModuleChunk chunk, @NotNull String outputPath, @NotNull JavacSettings compilerSettings, boolean useTempFile, boolean quoteBootClasspath) throws IOException {
        if (commandLine == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/compiler/impl/javaCompiler/eclipse/EclipseCompiler.addCommandLineOptions must not be null");
        }
        if (chunk == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/compiler/impl/javaCompiler/eclipse/EclipseCompiler.addCommandLineOptions must not be null");
        }
        if (outputPath == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/compiler/impl/javaCompiler/eclipse/EclipseCompiler.addCommandLineOptions must not be null");
        }
        if (compilerSettings == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/compiler/impl/javaCompiler/eclipse/EclipseCompiler.addCommandLineOptions must not be null");
        }
        Sdk jdk = chunk.getJdk();
        CompilerUtil.addSourceCommandLineSwitch(jdk, chunk.getLanguageLevel(), commandLine);
        String bootCp = chunk.getCompilationBootClasspath();
        String classPath = chunk.getCompilationClasspath();
        commandLine.add("-bootclasspath");
        commandLine.add(quoteBootClasspath ? CompilerUtil.quotePath(bootCp) : bootCp);
        commandLine.add("-classpath");
        commandLine.add(classPath);
        commandLine.add("-d");
        commandLine.add(outputPath.replace('/', File.separatorChar));
        commandLine.add("-verbose");
        StringTokenizer tokenizer = new StringTokenizer(compilerSettings.getOptionsString(this.myProject), " ");
        while (tokenizer.hasMoreTokens()) {
            commandLine.add(tokenizer.nextToken());
        }
        List<VirtualFile> files = chunk.getFilesToCompile();
        if (useTempFile) {
            File sourcesFile = FileUtil.createTempFile((String)"javac", (String)".tmp");
            sourcesFile.deleteOnExit();
            this.myTempFiles.add(sourcesFile);
            PrintWriter writer = new PrintWriter(new BufferedWriter(new FileWriter(sourcesFile)));
            try {
                for (VirtualFile file : files) {
                    String path = file.getPath().replace('/', File.separatorChar);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Adding path for compilation " + path);
                    }
                    writer.println(CompilerUtil.quotePath(path));
                }
            }
            finally {
                writer.close();
            }
            commandLine.add("@" + sourcesFile.getAbsolutePath());
        } else {
            for (VirtualFile file : files) {
                commandLine.add(file.getPath());
            }
        }
    }

    @Override
    public void compileFinished() {
        FileUtil.asyncDelete(this.myTempFiles);
        this.myTempFiles.clear();
    }
}

