/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.FileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;

public class CompilerContentIterator
implements ContentIterator {
    final FileTypeManager fileTypeManager = FileTypeManager.getInstance();
    private final FileType myFileType;
    private final FileIndex myFileIndex;
    private final boolean myInSourceOnly;
    private final Collection<VirtualFile> myFiles;

    public CompilerContentIterator(FileType fileType, FileIndex fileIndex, boolean inSourceOnly, Collection<VirtualFile> files) {
        this.myFileType = fileType;
        this.myFileIndex = fileIndex;
        this.myInSourceOnly = inSourceOnly;
        this.myFiles = files;
    }

    public boolean processFile(VirtualFile fileOrDir) {
        if (fileOrDir.isDirectory()) {
            return true;
        }
        if (!fileOrDir.isInLocalFileSystem()) {
            return true;
        }
        if (this.myInSourceOnly && !this.myFileIndex.isInSourceContent(fileOrDir)) {
            return true;
        }
        if (this.myFileType == null || this.myFileType == this.fileTypeManager.getFileTypeByFile(fileOrDir)) {
            this.myFiles.add(fileOrDir);
        }
        return true;
    }
}

