/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl;

import com.intellij.CommonBundle;
import com.intellij.analysis.AnalysisScope;
import com.intellij.compiler.CompilerConfiguration;
import com.intellij.compiler.CompilerManagerImpl;
import com.intellij.compiler.CompilerMessageImpl;
import com.intellij.compiler.CompilerWorkspaceConfiguration;
import com.intellij.compiler.ModuleCompilerUtil;
import com.intellij.compiler.impl.AdditionalCompileScopeProvider;
import com.intellij.compiler.impl.CompileContextExProxy;
import com.intellij.compiler.impl.CompileContextImpl;
import com.intellij.compiler.impl.CompilerCacheManager;
import com.intellij.compiler.impl.CompilerUtil;
import com.intellij.compiler.impl.CompositeScope;
import com.intellij.compiler.impl.FileProcessingCompilerAdapter;
import com.intellij.compiler.impl.FileProcessingCompilerStateCache;
import com.intellij.compiler.impl.FileSetCompileScope;
import com.intellij.compiler.impl.OutputPathFinder;
import com.intellij.compiler.impl.PackagingCompilerAdapter;
import com.intellij.compiler.impl.ProjectCompileScope;
import com.intellij.compiler.impl.StateCache;
import com.intellij.compiler.impl.TrackDependenciesScope;
import com.intellij.compiler.impl.TranslatingCompilerFilesMonitor;
import com.intellij.compiler.make.CacheCorruptedException;
import com.intellij.compiler.make.CacheUtils;
import com.intellij.compiler.make.DependencyCache;
import com.intellij.compiler.progress.CompilerTask;
import com.intellij.diagnostic.IdeErrorsDialog;
import com.intellij.diagnostic.PluginException;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.compiler.ClassInstrumentingCompiler;
import com.intellij.openapi.compiler.ClassPostProcessingCompiler;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompileStatusNotification;
import com.intellij.openapi.compiler.CompileTask;
import com.intellij.openapi.compiler.Compiler;
import com.intellij.openapi.compiler.CompilerBundle;
import com.intellij.openapi.compiler.CompilerFilter;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.compiler.CompilerMessage;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.compiler.CompilerPaths;
import com.intellij.openapi.compiler.FileProcessingCompiler;
import com.intellij.openapi.compiler.GeneratingCompiler;
import com.intellij.openapi.compiler.IntermediateOutputCompiler;
import com.intellij.openapi.compiler.PackagingCompiler;
import com.intellij.openapi.compiler.SourceGeneratingCompiler;
import com.intellij.openapi.compiler.SourceInstrumentingCompiler;
import com.intellij.openapi.compiler.SourceProcessingCompiler;
import com.intellij.openapi.compiler.TranslatingCompiler;
import com.intellij.openapi.compiler.Validator;
import com.intellij.openapi.compiler.ValidityState;
import com.intellij.openapi.compiler.ex.CompileContextEx;
import com.intellij.openapi.compiler.ex.CompilerPathsEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.LanguageLevelUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.CompilerProjectExtension;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.roots.ui.configuration.CommonContentEntriesEditor;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.packageDependencies.DependenciesBuilder;
import com.intellij.packageDependencies.ForwardDependenciesBuilder;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.Chunk;
import com.intellij.util.LocalTimeCounter;
import com.intellij.util.StringBuilderSpinAllocator;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.OrderedSet;
import gnu.trove.TObjectHashingStrategy;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class CompileDriver {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.compiler.impl.CompileDriver");
    private final Project myProject;
    private final Map<Pair<IntermediateOutputCompiler, Module>, Pair<VirtualFile, VirtualFile>> myGenerationCompilerModuleToOutputDirMap;
    private final String myCachesDirectoryPath;
    private boolean myShouldClearOutputDirectory;
    private final Map<Module, String> myModuleOutputPaths = new com.intellij.util.containers.HashMap();
    private final Map<Module, String> myModuleTestOutputPaths = new com.intellij.util.containers.HashMap();
    private static final String VERSION_FILE_NAME = "version.dat";
    private static final String LOCK_FILE_NAME = "in_progress.dat";
    private static final boolean GENERATE_CLASSPATH_INDEX = "true".equals(System.getProperty("generate.classpath.index"));
    private static final String PROP_PERFORM_INITIAL_REFRESH = "compiler.perform.outputs.refresh.on.start";
    private boolean myInitialRefreshPerformed = false;
    private static final FileProcessingCompilerAdapterFactory FILE_PROCESSING_COMPILER_ADAPTER_FACTORY = new FileProcessingCompilerAdapterFactory(){

        @Override
        public FileProcessingCompilerAdapter create(CompileContext context, FileProcessingCompiler compiler) {
            return new FileProcessingCompilerAdapter(context, compiler);
        }
    };
    private static final FileProcessingCompilerAdapterFactory FILE_PACKAGING_COMPILER_ADAPTER_FACTORY = new FileProcessingCompilerAdapterFactory(){

        @Override
        public FileProcessingCompilerAdapter create(CompileContext context, FileProcessingCompiler compiler) {
            return new PackagingCompilerAdapter(context, (PackagingCompiler)compiler);
        }
    };
    private CompilerFilter myCompilerFilter = CompilerFilter.ALL;
    private static CompilerFilter SOURCE_PROCESSING_ONLY = new CompilerFilter(){

        public boolean acceptCompiler(Compiler compiler) {
            return compiler instanceof SourceProcessingCompiler;
        }
    };
    private static CompilerFilter ALL_EXCEPT_SOURCE_PROCESSING = new CompilerFilter(){

        public boolean acceptCompiler(Compiler compiler) {
            return !SOURCE_PROCESSING_ONLY.acceptCompiler(compiler);
        }
    };
    private OutputPathFinder myOutputFinder;
    private Set<File> myAllOutputDirectories;
    private static final long ONE_MINUTE_MS = 60000L;
    public static final Key<Long> COMPILATION_START_TIMESTAMP = Key.create((String)"COMPILATION_START_TIMESTAMP");

    public CompileDriver(Project project) {
        this.myProject = project;
        this.myCachesDirectoryPath = CompilerPaths.getCacheStoreDirectory((Project)this.myProject).getPath().replace('/', File.separatorChar);
        this.myShouldClearOutputDirectory = CompilerWorkspaceConfiguration.getInstance((Project)this.myProject).CLEAR_OUTPUT_DIRECTORY;
        this.myGenerationCompilerModuleToOutputDirMap = new com.intellij.util.containers.HashMap();
        LocalFileSystem lfs = LocalFileSystem.getInstance();
        IntermediateOutputCompiler[] generatingCompilers = (IntermediateOutputCompiler[])CompilerManager.getInstance((Project)this.myProject).getCompilers(IntermediateOutputCompiler.class, this.myCompilerFilter);
        Module[] allModules = ModuleManager.getInstance((Project)this.myProject).getModules();
        CompilerConfiguration config = CompilerConfiguration.getInstance((Project)project);
        for (Module module : allModules) {
            String path;
            for (IntermediateOutputCompiler compiler : generatingCompilers) {
                VirtualFile productionOutput = CompileDriver.lookupVFile(lfs, CompilerPaths.getGenerationOutputPath((IntermediateOutputCompiler)compiler, (Module)module, (boolean)false));
                VirtualFile testOutput = CompileDriver.lookupVFile(lfs, CompilerPaths.getGenerationOutputPath((IntermediateOutputCompiler)compiler, (Module)module, (boolean)true));
                Pair pair = new Pair((Object)compiler, (Object)module);
                Pair outputs = new Pair((Object)productionOutput, (Object)testOutput);
                this.myGenerationCompilerModuleToOutputDirMap.put((Pair<IntermediateOutputCompiler, Module>)pair, (Pair<VirtualFile, VirtualFile>)outputs);
            }
            if (!config.isAnnotationProcessorsEnabled() || !config.isAnnotationProcessingEnabled(module) || (path = CompilerPaths.getAnnotationProcessorsGenerationPath((Module)module)) == null) continue;
            CompileDriver.lookupVFile(lfs, path);
        }
    }

    public void setCompilerFilter(CompilerFilter compilerFilter) {
        this.myCompilerFilter = compilerFilter == null ? CompilerFilter.ALL : compilerFilter;
    }

    public void rebuild(CompileStatusNotification callback) {
        this.doRebuild(callback, null, true, this.addAdditionalRoots(new ProjectCompileScope(this.myProject), ALL_EXCEPT_SOURCE_PROCESSING));
    }

    public void make(CompileScope scope, CompileStatusNotification callback) {
        if (this.validateCompilerConfiguration(scope = this.addAdditionalRoots(scope, ALL_EXCEPT_SOURCE_PROCESSING), false)) {
            this.startup(scope, false, false, callback, null, true, false);
        }
    }

    public boolean isUpToDate(CompileScope scope) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("isUpToDate operation started");
        }
        scope = this.addAdditionalRoots(scope, ALL_EXCEPT_SOURCE_PROCESSING);
        CompilerTask task = new CompilerTask(this.myProject, true, "", true);
        final CompileContextImpl compileContext = new CompileContextImpl(this.myProject, task, scope, this.createDependencyCache(), true, false);
        this.checkCachesVersion(compileContext);
        if (compileContext.isRebuildRequested()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Rebuild requested, up-to-date=false");
            }
            return false;
        }
        for (Map.Entry<Pair<IntermediateOutputCompiler, Module>, Pair<VirtualFile, VirtualFile>> entry : this.myGenerationCompilerModuleToOutputDirMap.entrySet()) {
            Pair<VirtualFile, VirtualFile> outputs = entry.getValue();
            Module module = (Module)entry.getKey().getSecond();
            compileContext.assignModule((VirtualFile)outputs.getFirst(), module, false);
            compileContext.assignModule((VirtualFile)outputs.getSecond(), module, true);
        }
        final Ref status = new Ref();
        task.start(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    CompileDriver.this.myAllOutputDirectories = CompileDriver.this.getAllOutputDirectories();
                    status.set((Object)CompileDriver.this.doCompile(compileContext, false, false, false, true));
                }
                finally {
                    compileContext.commitZipFiles();
                }
            }
        }, null);
        if (LOG.isDebugEnabled()) {
            LOG.debug("isUpToDate operation finished");
        }
        return ExitStatus.UP_TO_DATE.equals(status.get());
    }

    private DependencyCache createDependencyCache() {
        return new DependencyCache(this.myCachesDirectoryPath + File.separator + ".dependency-info");
    }

    public void compile(CompileScope scope, CompileStatusNotification callback, boolean trackDependencies, boolean clearingOutputDirsPossible) {
        this.myShouldClearOutputDirectory &= clearingOutputDirsPossible;
        if (trackDependencies) {
            scope = new TrackDependenciesScope(scope);
        }
        if (this.validateCompilerConfiguration(scope, false)) {
            this.startup(scope, false, true, callback, null, true, trackDependencies);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompileStatus readStatus() {
        boolean isInProgress = this.getLockFile().exists();
        int version = -1;
        try {
            File versionFile = new File(this.myCachesDirectoryPath, VERSION_FILE_NAME);
            DataInputStream in = new DataInputStream(new FileInputStream(versionFile));
            try {
                version = in.readInt();
            }
            finally {
                in.close();
            }
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
            return null;
        }
        return new CompileStatus(version, isInProgress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeStatus(CompileStatus status, CompileContext context) {
        File statusFile = new File(this.myCachesDirectoryPath, VERSION_FILE_NAME);
        File lockFile = this.getLockFile();
        try {
            FileUtil.createIfDoesntExist((File)statusFile);
            DataOutputStream out = new DataOutputStream(new FileOutputStream(statusFile));
            try {
                out.writeInt(status.CACHE_FORMAT_VERSION);
            }
            finally {
                out.close();
            }
            if (status.COMPILATION_IN_PROGRESS) {
                FileUtil.createIfDoesntExist((File)lockFile);
            } else {
                CompileDriver.deleteFile(lockFile);
            }
        }
        catch (IOException e) {
            context.addMessage(CompilerMessageCategory.ERROR, CompilerBundle.message((String)"compiler.error.exception", (Object[])new Object[]{e.getMessage()}), null, -1, -1);
        }
    }

    private File getLockFile() {
        return new File(CompilerPaths.getCompilerSystemDirectory((Project)this.myProject), LOCK_FILE_NAME);
    }

    private void doRebuild(CompileStatusNotification callback, CompilerMessage message, boolean checkCachesVersion, CompileScope compileScope) {
        if (this.validateCompilerConfiguration(compileScope, true)) {
            this.startup(compileScope, true, false, callback, message, checkCachesVersion, false);
        }
    }

    private CompileScope addAdditionalRoots(CompileScope originalScope, CompilerFilter filter) {
        CompileScope scope = this.attachIntermediateOutputDirectories(originalScope, filter);
        AdditionalCompileScopeProvider[] scopeProviders = (AdditionalCompileScopeProvider[])Extensions.getExtensions(AdditionalCompileScopeProvider.EXTENSION_POINT_NAME);
        CompileScope baseScope = scope;
        for (AdditionalCompileScopeProvider scopeProvider : scopeProviders) {
            CompileScope additionalScope = scopeProvider.getAdditionalScope(baseScope, filter, this.myProject);
            if (additionalScope == null) continue;
            scope = new CompositeScope(scope, additionalScope);
        }
        return scope;
    }

    private CompileScope attachIntermediateOutputDirectories(CompileScope originalScope, CompilerFilter filter) {
        CompileScope scope = originalScope;
        HashSet<Module> affected = new HashSet<Module>(Arrays.asList(originalScope.getAffectedModules()));
        for (Map.Entry<Pair<IntermediateOutputCompiler, Module>, Pair<VirtualFile, VirtualFile>> entry : this.myGenerationCompilerModuleToOutputDirMap.entrySet()) {
            Module module = (Module)entry.getKey().getSecond();
            if (!affected.contains(module) || !filter.acceptCompiler((Compiler)entry.getKey().getFirst())) continue;
            Pair<VirtualFile, VirtualFile> outputs = entry.getValue();
            scope = new CompositeScope(scope, new FileSetCompileScope(Arrays.asList((VirtualFile)outputs.getFirst(), (VirtualFile)outputs.getSecond()), new Module[]{module}));
        }
        return scope;
    }

    private void attachAnnotationProcessorsOutputDirectories(CompileContextEx context) {
        LocalFileSystem lfs = LocalFileSystem.getInstance();
        CompilerConfiguration config = CompilerConfiguration.getInstance((Project)this.myProject);
        HashSet<Module> affected = new HashSet<Module>(Arrays.asList(context.getCompileScope().getAffectedModules()));
        for (Module module : affected) {
            VirtualFile vFile;
            String path;
            if (!config.isAnnotationProcessingEnabled(module) || (path = CompilerPaths.getAnnotationProcessorsGenerationPath((Module)module)) == null || (vFile = lfs.findFileByPath(path)) == null || ModuleRootManager.getInstance((Module)module).getFileIndex().isInSourceContent(vFile)) continue;
            context.addScope(new FileSetCompileScope(Collections.singletonList(vFile), new Module[]{module}));
            context.assignModule(vFile, module, false);
        }
    }

    private void startup(final CompileScope scope, final boolean isRebuild, final boolean forceCompile, final CompileStatusNotification callback, final CompilerMessage message, final boolean checkCachesVersion, final boolean trackDependencies) {
        CompilerTask compileTask = new CompilerTask(this.myProject, CompilerWorkspaceConfiguration.getInstance((Project)this.myProject).COMPILE_IN_BACKGROUND, forceCompile ? CompilerBundle.message((String)"compiler.content.name.compile", (Object[])new Object[0]) : CompilerBundle.message((String)"compiler.content.name.make", (Object[])new Object[0]), false);
        WindowManager windowManager = WindowManager.getInstance();
        if (windowManager != null) {
            windowManager.getStatusBar(this.myProject).setInfo("");
        }
        PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
        FileDocumentManager.getInstance().saveAllDocuments();
        DependencyCache dependencyCache = this.createDependencyCache();
        final CompileContextImpl compileContext = new CompileContextImpl(this.myProject, compileTask, scope, dependencyCache, !isRebuild && !forceCompile, isRebuild);
        compileContext.putUserData(COMPILATION_START_TIMESTAMP, LocalTimeCounter.currentTime());
        for (Map.Entry<Pair<IntermediateOutputCompiler, Module>, Pair<VirtualFile, VirtualFile>> entry : this.myGenerationCompilerModuleToOutputDirMap.entrySet()) {
            Pair<VirtualFile, VirtualFile> outputs = entry.getValue();
            Module module = (Module)entry.getKey().getSecond();
            compileContext.assignModule((VirtualFile)outputs.getFirst(), module, false);
            compileContext.assignModule((VirtualFile)outputs.getSecond(), module, true);
        }
        this.attachAnnotationProcessorsOutputDirectories(compileContext);
        compileTask.start(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                long start = System.currentTimeMillis();
                try {
                    if (CompileDriver.this.myProject.isDisposed()) {
                        return;
                    }
                    LOG.info("COMPILATION STARTED");
                    if (message != null) {
                        compileContext.addMessage(message);
                    }
                    TranslatingCompilerFilesMonitor.getInstance().ensureInitializationCompleted(CompileDriver.this.myProject);
                    CompileDriver.this.doCompile(compileContext, isRebuild, forceCompile, callback, checkCachesVersion, trackDependencies);
                }
                finally {
                    compileContext.commitZipFiles();
                    long finish = System.currentTimeMillis();
                    CompilerUtil.logDuration("\tCOMPILATION FINISHED; Errors: " + compileContext.getMessageCount(CompilerMessageCategory.ERROR) + "; warnings: " + compileContext.getMessageCount(CompilerMessageCategory.WARNING), finish - start);
                }
            }
        }, new Runnable(){

            @Override
            public void run() {
                int rv;
                if (isRebuild && (rv = Messages.showDialog((Project)CompileDriver.this.myProject, (String)"You are about to rebuild the whole project.\nRun 'Make Project' instead?", (String)"Confirm Project Rebuild", (String[])new String[]{"Make", "Rebuild"}, (int)0, (Icon)Messages.getQuestionIcon())) == 0) {
                    CompileDriver.this.startup(scope, false, false, callback, null, checkCachesVersion, trackDependencies);
                    return;
                }
                CompileDriver.this.startup(scope, isRebuild, forceCompile, callback, message, checkCachesVersion, trackDependencies);
            }
        });
    }

    private void doCompile(CompileContextImpl compileContext, boolean isRebuild, boolean forceCompile, CompileStatusNotification callback, boolean checkCachesVersion, boolean trackDependencies) {
        boolean wereExceptions;
        ExitStatus status;
        block17: {
            block16: {
                status = ExitStatus.ERRORS;
                wereExceptions = false;
                if (!checkCachesVersion) break block16;
                this.checkCachesVersion(compileContext);
                if (!compileContext.isRebuildRequested()) break block16;
                CompileDriver.dropDependencyCache(compileContext);
                ExitStatus _status = status;
                if (compileContext.isRebuildRequested()) {
                    ApplicationManager.getApplication().invokeLater(new Runnable(callback, compileContext){
                        final /* synthetic */ CompileStatusNotification val$callback;
                        final /* synthetic */ CompileContextImpl val$compileContext;
                        {
                            this.val$callback = compileStatusNotification;
                            this.val$compileContext = compileContextImpl;
                        }

                        @Override
                        public void run() {
                            CompileDriver.this.doRebuild(this.val$callback, new CompilerMessageImpl(CompileDriver.this.myProject, CompilerMessageCategory.INFORMATION, this.val$compileContext.getRebuildReason(), null, -1, -1, null), false, this.val$compileContext.getCompileScope());
                        }
                    }, ModalityState.NON_MODAL);
                } else {
                    long duration = System.currentTimeMillis() - compileContext.getStartCompilationStamp();
                    this.writeStatus(new CompileStatus(54, wereExceptions), compileContext);
                    ApplicationManager.getApplication().invokeLater(new Runnable(compileContext, _status, duration, callback){
                        final /* synthetic */ CompileContextImpl val$compileContext;
                        final /* synthetic */ ExitStatus val$_status;
                        final /* synthetic */ long val$duration;
                        final /* synthetic */ CompileStatusNotification val$callback;
                        {
                            this.val$compileContext = compileContextImpl;
                            this.val$_status = exitStatus;
                            this.val$duration = l;
                            this.val$callback = compileStatusNotification;
                        }

                        @Override
                        public void run() {
                            int errorCount = this.val$compileContext.getMessageCount(CompilerMessageCategory.ERROR);
                            int warningCount = this.val$compileContext.getMessageCount(CompilerMessageCategory.WARNING);
                            String statusMessage = CompileDriver.createStatusMessage(this.val$_status, warningCount, errorCount);
                            StatusBar statusBar = WindowManager.getInstance().getStatusBar(CompileDriver.this.myProject);
                            if (statusBar != null) {
                                statusBar.setInfo(statusMessage);
                                if (this.val$duration > 60000L) {
                                    MessageType messageType = errorCount > 0 ? MessageType.ERROR : (warningCount > 0 ? MessageType.WARNING : MessageType.INFO);
                                    ToolWindowManager.getInstance((Project)CompileDriver.this.myProject).notifyByBalloon(ToolWindowId.MESSAGES_WINDOW, messageType, statusMessage);
                                }
                            }
                            if (this.val$_status != ExitStatus.UP_TO_DATE && this.val$compileContext.getMessageCount(null) > 0) {
                                this.val$compileContext.addMessage(CompilerMessageCategory.INFORMATION, statusMessage, null, -1, -1);
                            }
                            if (this.val$callback != null) {
                                this.val$callback.finished(this.val$_status == ExitStatus.CANCELLED, errorCount, warningCount, (CompileContext)this.val$compileContext);
                            }
                        }
                    }, ModalityState.NON_MODAL);
                }
                return;
            }
            this.writeStatus(new CompileStatus(54, true), compileContext);
            if (compileContext.getMessageCount(CompilerMessageCategory.ERROR) <= 0) break block17;
            CompileDriver.dropDependencyCache(compileContext);
            ExitStatus _status = status;
            if (compileContext.isRebuildRequested()) {
                ApplicationManager.getApplication().invokeLater(new /* invalid duplicate definition of identical inner class */, ModalityState.NON_MODAL);
            } else {
                long duration = System.currentTimeMillis() - compileContext.getStartCompilationStamp();
                this.writeStatus(new CompileStatus(54, wereExceptions), compileContext);
                ApplicationManager.getApplication().invokeLater(new /* invalid duplicate definition of identical inner class */, ModalityState.NON_MODAL);
            }
            return;
        }
        try {
            this.myAllOutputDirectories = this.getAllOutputDirectories();
            status = this.doCompile(compileContext, isRebuild, forceCompile, trackDependencies, false);
        }
        catch (Throwable ex) {
            try {
                wereExceptions = true;
                PluginId pluginId = IdeErrorsDialog.findPluginId(ex);
                StringBuffer message = new StringBuffer();
                message.append("Internal error");
                if (pluginId != null) {
                    message.append(" (Plugin: ").append(pluginId).append(")");
                }
                message.append(": ").append(ex.getMessage());
                compileContext.addMessage(CompilerMessageCategory.ERROR, message.toString(), null, -1, -1);
                if (pluginId != null) {
                    throw new PluginException(ex, pluginId);
                }
                throw new RuntimeException(ex);
            }
            catch (Throwable throwable) {
                CompileDriver.dropDependencyCache(compileContext);
                ExitStatus _status = status;
                if (compileContext.isRebuildRequested()) {
                    ApplicationManager.getApplication().invokeLater(new /* invalid duplicate definition of identical inner class */, ModalityState.NON_MODAL);
                } else {
                    long duration = System.currentTimeMillis() - compileContext.getStartCompilationStamp();
                    this.writeStatus(new CompileStatus(54, wereExceptions), compileContext);
                    ApplicationManager.getApplication().invokeLater(new /* invalid duplicate definition of identical inner class */, ModalityState.NON_MODAL);
                }
                throw throwable;
            }
        }
        CompileDriver.dropDependencyCache(compileContext);
        ExitStatus _status = status;
        if (compileContext.isRebuildRequested()) {
            ApplicationManager.getApplication().invokeLater(new /* invalid duplicate definition of identical inner class */, ModalityState.NON_MODAL);
        } else {
            long duration = System.currentTimeMillis() - compileContext.getStartCompilationStamp();
            this.writeStatus(new CompileStatus(54, wereExceptions), compileContext);
            ApplicationManager.getApplication().invokeLater(new /* invalid duplicate definition of identical inner class */, ModalityState.NON_MODAL);
        }
    }

    private void checkCachesVersion(CompileContextImpl compileContext) {
        CompileStatus compileStatus = this.readStatus();
        if (compileStatus == null) {
            compileContext.requestRebuildNextTime(CompilerBundle.message((String)"error.compiler.caches.corrupted", (Object[])new Object[0]));
        } else if (compileStatus.CACHE_FORMAT_VERSION != -1 && compileStatus.CACHE_FORMAT_VERSION != 54) {
            compileContext.requestRebuildNextTime(CompilerBundle.message((String)"error.caches.old.format", (Object[])new Object[0]));
        } else if (compileStatus.COMPILATION_IN_PROGRESS) {
            compileContext.requestRebuildNextTime(CompilerBundle.message((String)"error.previous.compilation.failed", (Object[])new Object[0]));
        }
    }

    private static String createStatusMessage(ExitStatus status, int warningCount, int errorCount) {
        if (status == ExitStatus.CANCELLED) {
            return CompilerBundle.message((String)"status.compilation.aborted", (Object[])new Object[0]);
        }
        if (status == ExitStatus.UP_TO_DATE) {
            return CompilerBundle.message((String)"status.all.up.to.date", (Object[])new Object[0]);
        }
        if (status == ExitStatus.SUCCESS) {
            return warningCount > 0 ? CompilerBundle.message((String)"status.compilation.completed.successfully.with.warnings", (Object[])new Object[]{warningCount}) : CompilerBundle.message((String)"status.compilation.completed.successfully", (Object[])new Object[0]);
        }
        return CompilerBundle.message((String)"status.compilation.completed.successfully.with.warnings.and.errors", (Object[])new Object[]{errorCount, warningCount});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ExitStatus doCompile(final CompileContextEx context, boolean isRebuild, boolean forceCompile, boolean trackDependencies, boolean onlyCheckStatus) {
        try {
            if (isRebuild) {
                this.deleteAll(context);
            } else if (forceCompile && this.myShouldClearOutputDirectory) {
                this.clearAffectedOutputPathsIfPossible(context);
            }
            if (context.getMessageCount(CompilerMessageCategory.ERROR) > 0) {
                if (!LOG.isDebugEnabled()) return ExitStatus.ERRORS;
                CompileDriver.logErrorMessages(context);
                return ExitStatus.ERRORS;
            }
            if (!onlyCheckStatus && !this.executeCompileTasks(context, true)) {
                if (!LOG.isDebugEnabled()) return ExitStatus.CANCELLED;
                LOG.debug("Compilation cancelled");
                return ExitStatus.CANCELLED;
            }
            if (context.getMessageCount(CompilerMessageCategory.ERROR) > 0) {
                if (!LOG.isDebugEnabled()) return ExitStatus.ERRORS;
                CompileDriver.logErrorMessages(context);
                return ExitStatus.ERRORS;
            }
            boolean needRecalcOutputDirs = false;
            if (Registry.is((String)PROP_PERFORM_INITIAL_REFRESH) || !this.myInitialRefreshPerformed) {
                this.myInitialRefreshPerformed = true;
                long refreshStart = System.currentTimeMillis();
                VirtualFile[] all = context.getAllOutputDirectories();
                final ProgressIndicator progressIndicator = context.getProgressIndicator();
                final int totalCount = all.length + this.myGenerationCompilerModuleToOutputDirMap.size() * 2;
                final CountDownLatch latch = new CountDownLatch(totalCount);
                Runnable decCount = new Runnable(){

                    @Override
                    public void run() {
                        latch.countDown();
                        progressIndicator.setFraction((double)((long)totalCount - latch.getCount()) / (double)totalCount);
                    }
                };
                progressIndicator.pushState();
                progressIndicator.setText("Inspecting output directories...");
                boolean asyncMode = !ApplicationManager.getApplication().isDispatchThread();
                try {
                    for (VirtualFile output : all) {
                        if (output.isValid()) {
                            CompileDriver.walkChildren(output, context);
                        } else {
                            boolean created;
                            needRecalcOutputDirs = true;
                            File file = new File(output.getPath());
                            if (!file.exists() && !(created = file.mkdirs())) {
                                context.addMessage(CompilerMessageCategory.ERROR, "Failed to create output directory " + file.getPath(), null, 0, 0);
                                ExitStatus exitStatus = ExitStatus.ERRORS;
                                return exitStatus;
                            }
                            output = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file);
                            if (output == null) {
                                context.addMessage(CompilerMessageCategory.ERROR, "Failed to locate output directory " + file.getPath(), null, 0, 0);
                                ExitStatus exitStatus = ExitStatus.ERRORS;
                                return exitStatus;
                            }
                        }
                        output.refresh(asyncMode, true, decCount);
                    }
                    for (Pair<IntermediateOutputCompiler, Module> pair : this.myGenerationCompilerModuleToOutputDirMap.keySet()) {
                        Pair<VirtualFile, VirtualFile> generated = this.myGenerationCompilerModuleToOutputDirMap.get(pair);
                        CompileDriver.walkChildren((VirtualFile)generated.getFirst(), context);
                        ((VirtualFile)generated.getFirst()).refresh(asyncMode, true, decCount);
                        CompileDriver.walkChildren((VirtualFile)generated.getSecond(), context);
                        ((VirtualFile)generated.getSecond()).refresh(asyncMode, true, decCount);
                    }
                    try {
                        while (latch.getCount() > 0L) {
                            latch.await(500L, TimeUnit.MILLISECONDS);
                            if (!progressIndicator.isCanceled()) continue;
                            ExitStatus i$ = ExitStatus.CANCELLED;
                            return i$;
                        }
                    }
                    catch (InterruptedException e) {
                        LOG.info((Throwable)e);
                    }
                }
                finally {
                    progressIndicator.popState();
                }
                long initialRefreshTime = System.currentTimeMillis() - refreshStart;
                CompilerUtil.logDuration("Initial VFS refresh", initialRefreshTime);
            }
            final Semaphore semaphore = new Semaphore();
            semaphore.down();
            DumbService.getInstance((Project)this.myProject).runWhenSmart(new Runnable(){

                @Override
                public void run() {
                    semaphore.up();
                }
            });
            while (!semaphore.waitFor(500L)) {
                if (!context.getProgressIndicator().isCanceled()) continue;
                return ExitStatus.CANCELLED;
            }
            if (needRecalcOutputDirs) {
                context.recalculateOutputDirs();
            }
            boolean didSomething = false;
            CompilerManager compilerManager = CompilerManager.getInstance((Project)this.myProject);
            try {
                didSomething |= this.generateSources(compilerManager, context, forceCompile, onlyCheckStatus);
                didSomething |= this.invokeFileProcessingCompilers(compilerManager, context, SourceInstrumentingCompiler.class, FILE_PROCESSING_COMPILER_ADAPTER_FACTORY, forceCompile, true, onlyCheckStatus);
                didSomething |= this.invokeFileProcessingCompilers(compilerManager, context, SourceProcessingCompiler.class, FILE_PROCESSING_COMPILER_ADAPTER_FACTORY, forceCompile, true, onlyCheckStatus);
                CompileScope intermediateSources = this.attachIntermediateOutputDirectories(new CompositeScope(CompileScope.EMPTY_ARRAY){

                    @Override
                    @NotNull
                    public Module[] getAffectedModules() {
                        Module[] moduleArray = context.getCompileScope().getAffectedModules();
                        if (moduleArray == null) {
                            throw new IllegalStateException("@NotNull method com/intellij/compiler/impl/CompileDriver$12.getAffectedModules must not return null");
                        }
                        return moduleArray;
                    }
                }, SOURCE_PROCESSING_ONLY);
                context.addScope(intermediateSources);
                didSomething |= this.translate(context, compilerManager, forceCompile, isRebuild, trackDependencies, onlyCheckStatus);
                didSomething |= this.invokeFileProcessingCompilers(compilerManager, context, ClassInstrumentingCompiler.class, FILE_PROCESSING_COMPILER_ADAPTER_FACTORY, isRebuild, false, onlyCheckStatus);
                didSomething |= this.invokeFileProcessingCompilers(compilerManager, context, ClassPostProcessingCompiler.class, FILE_PROCESSING_COMPILER_ADAPTER_FACTORY, isRebuild, false, onlyCheckStatus);
                didSomething |= this.invokeFileProcessingCompilers(compilerManager, context, PackagingCompiler.class, FILE_PACKAGING_COMPILER_ADAPTER_FACTORY, isRebuild, false, onlyCheckStatus);
            }
            catch (ExitException e) {
                ExitStatus exitStatus;
                try {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Throwable)e);
                        CompileDriver.logErrorMessages(context);
                    }
                    exitStatus = e.getExitStatus();
                }
                catch (Throwable throwable) {
                    CompileDriver.dropDependencyCache(context);
                    VirtualFile[] allOutputDirs = context.getAllOutputDirectories();
                    if (!didSomething) throw throwable;
                    if (!GENERATE_CLASSPATH_INDEX) throw throwable;
                    CompilerUtil.runInContext(context, "Generating classpath index...", new ThrowableRunnable<RuntimeException>(allOutputDirs, context){
                        final /* synthetic */ VirtualFile[] val$allOutputDirs;
                        final /* synthetic */ CompileContextEx val$context;
                        {
                            this.val$allOutputDirs = virtualFileArray;
                            this.val$context = compileContextEx;
                        }

                        public void run() {
                            int count = 0;
                            for (VirtualFile file : this.val$allOutputDirs) {
                                this.val$context.getProgressIndicator().setFraction((double)(++count) / (double)this.val$allOutputDirs.length);
                                CompileDriver.createClasspathIndex(file);
                            }
                        }
                    });
                    throw throwable;
                }
                CompileDriver.dropDependencyCache(context);
                VirtualFile[] allOutputDirs = context.getAllOutputDirectories();
                if (!didSomething) return exitStatus;
                if (!GENERATE_CLASSPATH_INDEX) return exitStatus;
                CompilerUtil.runInContext(context, "Generating classpath index...", new /* invalid duplicate definition of identical inner class */);
                return exitStatus;
            }
            CompileDriver.dropDependencyCache(context);
            VirtualFile[] allOutputDirs = context.getAllOutputDirectories();
            if ((didSomething |= this.invokeFileProcessingCompilers(compilerManager, context, Validator.class, FILE_PROCESSING_COMPILER_ADAPTER_FACTORY, forceCompile, true, onlyCheckStatus)) && GENERATE_CLASSPATH_INDEX) {
                CompilerUtil.runInContext(context, "Generating classpath index...", new /* invalid duplicate definition of identical inner class */);
            }
            if (!onlyCheckStatus && !this.executeCompileTasks(context, false)) {
                return ExitStatus.CANCELLED;
            }
            if (context.getMessageCount(CompilerMessageCategory.ERROR) > 0) {
                if (!LOG.isDebugEnabled()) return ExitStatus.ERRORS;
                CompileDriver.logErrorMessages(context);
                return ExitStatus.ERRORS;
            }
            if (didSomething) return ExitStatus.SUCCESS;
            return ExitStatus.UP_TO_DATE;
        }
        catch (ProcessCanceledException e) {
            return ExitStatus.CANCELLED;
        }
    }

    private void clearAffectedOutputPathsIfPossible(CompileContextEx context) {
        MultiMap outputToModulesMap = new MultiMap();
        for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
            String outputPathForTestsUrl;
            CompilerModuleExtension compilerModuleExtension = CompilerModuleExtension.getInstance((Module)module);
            if (compilerModuleExtension == null) continue;
            String outputPathUrl = compilerModuleExtension.getCompilerOutputUrl();
            if (outputPathUrl != null) {
                String path = VirtualFileManager.extractPath((String)outputPathUrl);
                outputToModulesMap.putValue((Object)new File(path), (Object)module);
            }
            if ((outputPathForTestsUrl = compilerModuleExtension.getCompilerOutputUrlForTests()) == null) continue;
            String path = VirtualFileManager.extractPath((String)outputPathForTestsUrl);
            outputToModulesMap.putValue((Object)new File(path), (Object)module);
        }
        HashSet<Module> affectedModules = new HashSet<Module>(Arrays.asList(context.getCompileScope().getAffectedModules()));
        final ArrayList<File> scopeOutputs = new ArrayList<File>(affectedModules.size() * 2);
        for (File output : outputToModulesMap.keySet()) {
            Collection modules = outputToModulesMap.get((Object)output);
            boolean shouldInclude = true;
            for (Module module : modules) {
                if (affectedModules.contains(module)) continue;
                shouldInclude = false;
                break;
            }
            if (!shouldInclude) continue;
            scopeOutputs.add(output);
        }
        if (scopeOutputs.size() > 0) {
            CompilerUtil.runInContext(context, CompilerBundle.message((String)"progress.clearing.output", (Object[])new Object[0]), new ThrowableRunnable<RuntimeException>(){

                public void run() {
                    CompileDriver.clearOutputDirectories(scopeOutputs);
                }
            });
        }
    }

    private static void logErrorMessages(CompileContext context) {
        CompilerMessage[] errors = context.getMessages(CompilerMessageCategory.ERROR);
        if (errors.length > 0) {
            LOG.debug("Errors reported: ");
            for (CompilerMessage error : errors) {
                LOG.debug("\t" + error.getMessage());
            }
        }
    }

    private static void walkChildren(VirtualFile from, CompileContext context) {
        VirtualFile[] files = from.getChildren();
        if (files != null && files.length > 0) {
            context.getProgressIndicator().checkCanceled();
            context.getProgressIndicator().setText2(from.getPresentableUrl());
            for (VirtualFile file : files) {
                CompileDriver.walkChildren(file, context);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createClasspathIndex(VirtualFile file) {
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(new File(VfsUtil.virtualToIoFile((VirtualFile)file), "classpath.index")));
            try {
                CompileDriver.writeIndex(writer, file, file);
            }
            finally {
                writer.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void writeIndex(BufferedWriter writer, VirtualFile root, VirtualFile file) throws IOException {
        writer.write(VfsUtil.getRelativePath((VirtualFile)file, (VirtualFile)root, (char)'/'));
        writer.write(10);
        for (VirtualFile child : file.getChildren()) {
            CompileDriver.writeIndex(writer, root, child);
        }
    }

    private static void dropDependencyCache(final CompileContextEx context) {
        CompilerUtil.runInContext(context, CompilerBundle.message((String)"progress.saving.caches", (Object[])new Object[0]), new ThrowableRunnable<RuntimeException>(){

            public void run() {
                context.getDependencyCache().resetState();
            }
        });
    }

    private boolean generateSources(CompilerManager compilerManager, CompileContextEx context, boolean forceCompile, boolean onlyCheckStatus) throws ExitException {
        SourceGeneratingCompiler[] sourceGenerators;
        boolean didSomething = false;
        for (SourceGeneratingCompiler sourceGenerator : sourceGenerators = (SourceGeneratingCompiler[])compilerManager.getCompilers(SourceGeneratingCompiler.class, this.myCompilerFilter)) {
            if (context.getProgressIndicator().isCanceled()) {
                throw new ExitException(ExitStatus.CANCELLED);
            }
            boolean generatedSomething = this.generateOutput(context, (GeneratingCompiler)sourceGenerator, forceCompile, onlyCheckStatus);
            if (context.getMessageCount(CompilerMessageCategory.ERROR) > 0) {
                throw new ExitException(ExitStatus.ERRORS);
            }
            didSomething |= generatedSomething;
        }
        return didSomething;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean translate(final CompileContextEx context, CompilerManager compilerManager, boolean forceCompile, boolean isRebuild, boolean trackDependencies, boolean onlyCheckStatus) throws ExitException {
        boolean didSomething = false;
        TranslatingCompiler[] translators = (TranslatingCompiler[])compilerManager.getCompilers(TranslatingCompiler.class, this.myCompilerFilter);
        List<Chunk> sortedChunks = Collections.unmodifiableList((List)ApplicationManager.getApplication().runReadAction((Computable)new Computable<List<Chunk<Module>>>(){

            public List<Chunk<Module>> compute() {
                ModuleManager moduleManager = ModuleManager.getInstance((Project)CompileDriver.this.myProject);
                return ModuleCompilerUtil.getSortedModuleChunks((Project)CompileDriver.this.myProject, Arrays.asList(moduleManager.getModules()));
            }
        }));
        try {
            VirtualFile[] snapshot = null;
            com.intellij.util.containers.HashMap chunkMap = new com.intellij.util.containers.HashMap();
            int total = 0;
            int processed = 0;
            for (Chunk currentChunk : sortedChunks) {
                TranslatorsOutputSink sink = new TranslatorsOutputSink(context, translators);
                HashSet generatedTypes = new HashSet();
                Collection chunkFiles = (Collection)chunkMap.get(currentChunk);
                try {
                    int translatorsLength = translators.length;
                    for (int currentCompiler = 0; currentCompiler < translatorsLength; ++currentCompiler) {
                        CompileContextEx _context;
                        sink.setCurrentCompilerIndex(currentCompiler);
                        TranslatingCompiler compiler = translators[currentCompiler];
                        if (context.getProgressIndicator().isCanceled()) {
                            throw new ExitException(ExitStatus.CANCELLED);
                        }
                        DumbService.getInstance((Project)this.myProject).waitForSmartMode();
                        if (snapshot == null || ContainerUtil.intersects(generatedTypes, (Collection)compilerManager.getRegisteredInputTypes(compiler))) {
                            snapshot = (VirtualFile[])ApplicationManager.getApplication().runReadAction((Computable)new Computable<VirtualFile[]>(){

                                public VirtualFile[] compute() {
                                    return context.getCompileScope().getFiles(null, true);
                                }
                            });
                            Map<Module, List<VirtualFile>> moduleToFilesMap = CompilerUtil.buildModuleToFilesMap((CompileContext)context, snapshot);
                            for (Chunk moduleChunk : sortedChunks) {
                                List files = Collections.emptyList();
                                for (Module module : moduleChunk.getNodes()) {
                                    List<VirtualFile> moduleFiles = moduleToFilesMap.get(module);
                                    if (moduleFiles == null) continue;
                                    files = ContainerUtil.concat(files, moduleFiles);
                                }
                                chunkMap.put(moduleChunk, files);
                            }
                            total = snapshot.length * translatorsLength;
                            chunkFiles = (Collection)chunkMap.get(currentChunk);
                        }
                        if (compiler instanceof IntermediateOutputCompiler) {
                            final IntermediateOutputCompiler _compiler = (IntermediateOutputCompiler)compiler;
                            _context = new CompileContextExProxy(context){

                                @Override
                                public VirtualFile getModuleOutputDirectory(Module module) {
                                    return CompileDriver.this.getGenerationOutputDir(_compiler, module, false);
                                }

                                @Override
                                public VirtualFile getModuleOutputDirectoryForTests(Module module) {
                                    return CompileDriver.this.getGenerationOutputDir(_compiler, module, true);
                                }
                            };
                        } else {
                            _context = context;
                        }
                        boolean compiledSomething = this.compileSources(_context, (Chunk<Module>)currentChunk, compiler, chunkFiles, forceCompile, isRebuild, trackDependencies, onlyCheckStatus, sink);
                        _context.getProgressIndicator().setFraction((double)(processed += chunkFiles.size()) / (double)total);
                        if (compiledSomething) {
                            generatedTypes.addAll(compilerManager.getRegisteredOutputTypes(compiler));
                        }
                        if (_context.getMessageCount(CompilerMessageCategory.ERROR) > 0) {
                            throw new ExitException(ExitStatus.ERRORS);
                        }
                        didSomething |= compiledSomething;
                    }
                }
                finally {
                    if (context.getMessageCount(CompilerMessageCategory.ERROR) != 0) continue;
                    sink.flushPostponedItems();
                }
            }
        }
        catch (ProcessCanceledException e) {
            ProgressManager.getInstance().executeNonCancelableSection(new Runnable(){

                @Override
                public void run() {
                    try {
                        Collection<VirtualFile> deps = CacheUtils.findDependentFiles(context, Collections.<VirtualFile>emptySet(), null, null);
                        if (deps.size() > 0) {
                            TranslatingCompilerFilesMonitor.getInstance().update(context, null, Collections.<TranslatingCompiler.OutputItem>emptyList(), VfsUtil.toVirtualFileArray(deps));
                        }
                    }
                    catch (IOException ignored) {
                        LOG.info((Throwable)ignored);
                    }
                    catch (CacheCorruptedException ignored) {
                        LOG.info((Throwable)ignored);
                    }
                }
            });
            throw e;
        }
        finally {
            CompileDriver.dropDependencyCache(context);
            if (didSomething) {
                TranslatingCompilerFilesMonitor.getInstance().updateOutputRootsLayout(this.myProject);
            }
        }
        return didSomething;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean invokeFileProcessingCompilers(CompilerManager compilerManager, CompileContextEx context, Class<? extends FileProcessingCompiler> fileProcessingCompilerClass, FileProcessingCompilerAdapterFactory factory, boolean forceCompile, boolean checkScope, boolean onlyCheckStatus) throws ExitException {
        boolean didSomething = false;
        FileProcessingCompiler[] compilers = (FileProcessingCompiler[])compilerManager.getCompilers(fileProcessingCompilerClass, this.myCompilerFilter);
        if (compilers.length > 0) {
            try {
                CacheDeferredUpdater cacheUpdater = new CacheDeferredUpdater();
                try {
                    for (FileProcessingCompiler compiler : compilers) {
                        if (context.getProgressIndicator().isCanceled()) {
                            throw new ExitException(ExitStatus.CANCELLED);
                        }
                        CompileContextEx _context = context;
                        if (compiler instanceof IntermediateOutputCompiler) {
                            final IntermediateOutputCompiler _compiler = (IntermediateOutputCompiler)compiler;
                            _context = new CompileContextExProxy(context){

                                @Override
                                public VirtualFile getModuleOutputDirectory(Module module) {
                                    return CompileDriver.this.getGenerationOutputDir(_compiler, module, false);
                                }

                                @Override
                                public VirtualFile getModuleOutputDirectoryForTests(Module module) {
                                    return CompileDriver.this.getGenerationOutputDir(_compiler, module, true);
                                }
                            };
                        }
                        boolean processedSomething = this.processFiles(factory.create(_context, compiler), forceCompile, checkScope, onlyCheckStatus, cacheUpdater);
                        if (context.getMessageCount(CompilerMessageCategory.ERROR) > 0) {
                            throw new ExitException(ExitStatus.ERRORS);
                        }
                        didSomething |= processedSomething;
                    }
                }
                finally {
                    cacheUpdater.doUpdate();
                }
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
                context.requestRebuildNextTime(e.getMessage());
                throw new ExitException(ExitStatus.ERRORS);
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (ExitException e) {
                throw e;
            }
            catch (Exception e) {
                context.addMessage(CompilerMessageCategory.ERROR, CompilerBundle.message((String)"compiler.error.exception", (Object[])new Object[]{e.getMessage()}), null, -1, -1);
                LOG.error((Throwable)e);
            }
        }
        return didSomething;
    }

    private static Map<Module, Set<GeneratingCompiler.GenerationItem>> buildModuleToGenerationItemMap(GeneratingCompiler.GenerationItem[] items) {
        com.intellij.util.containers.HashMap map = new com.intellij.util.containers.HashMap();
        for (GeneratingCompiler.GenerationItem item : items) {
            Module module = item.getModule();
            LOG.assertTrue(module != null);
            HashSet<GeneratingCompiler.GenerationItem> itemSet = (HashSet<GeneratingCompiler.GenerationItem>)map.get(module);
            if (itemSet == null) {
                itemSet = new HashSet<GeneratingCompiler.GenerationItem>();
                map.put(module, itemSet);
            }
            itemSet.add(item);
        }
        return map;
    }

    private void deleteAll(final CompileContextEx context) {
        CompilerUtil.runInContext(context, CompilerBundle.message((String)"progress.clearing.output", (Object[])new Object[0]), new ThrowableRunnable<RuntimeException>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                boolean isTestMode = ApplicationManager.getApplication().isUnitTestMode();
                final VirtualFile[] allSources = context.getProjectCompileScope().getFiles(null, true);
                if (CompileDriver.this.myShouldClearOutputDirectory) {
                    CompileDriver.clearOutputDirectories(CompileDriver.this.myAllOutputDirectories);
                } else {
                    try {
                        for (final Compiler compiler : CompilerManager.getInstance((Project)CompileDriver.this.myProject).getCompilers(Compiler.class)) {
                            try {
                                if (compiler instanceof GeneratingCompiler) {
                                    StateCache cache = CompileDriver.this.getGeneratingCompilerCache((GeneratingCompiler)compiler);
                                    Iterator<String> urlIterator = cache.getUrlsIterator();
                                    while (urlIterator.hasNext()) {
                                        context.getProgressIndicator().checkCanceled();
                                        CompileDriver.deleteFile(new File(VirtualFileManager.extractPath((String)urlIterator.next())));
                                    }
                                    continue;
                                }
                                if (!(compiler instanceof TranslatingCompiler)) continue;
                                final ArrayList toDelete = new ArrayList();
                                ApplicationManager.getApplication().runReadAction(new Runnable(){

                                    @Override
                                    public void run() {
                                        TranslatingCompilerFilesMonitor.getInstance().collectFiles(context, (TranslatingCompiler)compiler, Arrays.asList(allSources).iterator(), true, false, new ArrayList<VirtualFile>(), toDelete);
                                    }
                                });
                                for (Trinity trinity : toDelete) {
                                    context.getProgressIndicator().checkCanceled();
                                    File file = (File)trinity.getFirst();
                                    CompileDriver.deleteFile(file);
                                    if (!isTestMode) continue;
                                    CompilerManagerImpl.addDeletedPath(file.getPath());
                                }
                            }
                            catch (IOException e) {
                                LOG.info((Throwable)e);
                            }
                        }
                        CompileDriver.pruneEmptyDirectories(context.getProgressIndicator(), CompileDriver.this.myAllOutputDirectories);
                    }
                    finally {
                        CompilerUtil.refreshIODirectories(CompileDriver.this.myAllOutputDirectories);
                    }
                }
                CompileDriver.this.dropScopesCaches();
                CompileDriver.this.clearCompilerSystemDirectory(context);
            }
        });
    }

    private void dropScopesCaches() {
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                ((ProjectRootManagerEx)ProjectRootManager.getInstance((Project)CompileDriver.this.myProject)).clearScopesCachesForModules();
            }
        });
    }

    private static void pruneEmptyDirectories(ProgressIndicator progress, Set<File> directories) {
        for (File directory : directories) {
            CompileDriver.doPrune(progress, directory, directories);
        }
    }

    private static boolean doPrune(ProgressIndicator progress, File directory, Set<File> outPutDirectories) {
        progress.checkCanceled();
        File[] files = directory.listFiles();
        boolean isEmpty = true;
        if (files != null) {
            for (File file : files) {
                if (!outPutDirectories.contains(file)) {
                    if (CompileDriver.doPrune(progress, file, outPutDirectories)) {
                        CompileDriver.deleteFile(file);
                        continue;
                    }
                    isEmpty = false;
                    continue;
                }
                isEmpty = false;
            }
        } else {
            isEmpty = false;
        }
        return isEmpty;
    }

    private Set<File> getAllOutputDirectories() {
        OrderedSet outputDirs = new OrderedSet(TObjectHashingStrategy.CANONICAL);
        Module[] modules = ModuleManager.getInstance((Project)this.myProject).getModules();
        for (String path : CompilerPathsEx.getOutputPaths((Module[])modules)) {
            outputDirs.add(new File(path));
        }
        for (Pair<IntermediateOutputCompiler, Module> pair : this.myGenerationCompilerModuleToOutputDirMap.keySet()) {
            outputDirs.add(new File(CompilerPaths.getGenerationOutputPath((IntermediateOutputCompiler)((IntermediateOutputCompiler)pair.getFirst()), (Module)((Module)pair.getSecond()), (boolean)false)));
            outputDirs.add(new File(CompilerPaths.getGenerationOutputPath((IntermediateOutputCompiler)((IntermediateOutputCompiler)pair.getFirst()), (Module)((Module)pair.getSecond()), (boolean)true)));
        }
        CompilerConfiguration config = CompilerConfiguration.getInstance((Project)this.myProject);
        if (config.isAnnotationProcessorsEnabled()) {
            for (Module module : modules) {
                String path;
                if (!config.isAnnotationProcessingEnabled(module) || (path = CompilerPaths.getAnnotationProcessorsGenerationPath((Module)module)) == null) continue;
                outputDirs.add(new File(path));
            }
        }
        return outputDirs;
    }

    private static void clearOutputDirectories(Collection<File> outputDirectories) {
        long start = System.currentTimeMillis();
        ArrayList<File> filesToDelete = new ArrayList<File>(outputDirectories.size() * 2);
        for (File outputDirectory : outputDirectories) {
            File[] files = outputDirectory.listFiles();
            if (files == null) continue;
            filesToDelete.addAll(Arrays.asList(files));
        }
        if (filesToDelete.size() > 0) {
            FileUtil.asyncDelete(filesToDelete);
            for (File file : outputDirectories) {
                file.mkdirs();
            }
            long clearStop = System.currentTimeMillis();
            CompilerUtil.refreshIODirectories(outputDirectories);
            long refreshStop = System.currentTimeMillis();
            CompilerUtil.logDuration("Clearing output dirs", clearStop - start);
            CompilerUtil.logDuration("Refreshing output directories", refreshStop - clearStop);
        }
    }

    private void clearCompilerSystemDirectory(CompileContextEx context) {
        CompilerCacheManager.getInstance(this.myProject).clearCaches(context);
        FileUtil.delete((File)CompilerPathsEx.getZipStoreDirectory((Project)this.myProject));
        CompileDriver.dropDependencyCache(context);
        for (Pair<IntermediateOutputCompiler, Module> pair : this.myGenerationCompilerModuleToOutputDirMap.keySet()) {
            File[] outputs;
            for (File output : outputs = new File[]{new File(CompilerPaths.getGenerationOutputPath((IntermediateOutputCompiler)((IntermediateOutputCompiler)pair.getFirst()), (Module)((Module)pair.getSecond()), (boolean)false)), new File(CompilerPaths.getGenerationOutputPath((IntermediateOutputCompiler)((IntermediateOutputCompiler)pair.getFirst()), (Module)((Module)pair.getSecond()), (boolean)true))}) {
                File[] files = output.listFiles();
                if (files == null) continue;
                for (File file : files) {
                    boolean deleteOk = CompileDriver.deleteFile(file);
                    if (deleteOk) continue;
                    context.addMessage(CompilerMessageCategory.ERROR, CompilerBundle.message((String)"compiler.error.failed.to.delete", (Object[])new Object[]{file.getPath()}), null, -1, -1);
                }
            }
        }
    }

    private static boolean deleteFile(File file) {
        File[] files = file.listFiles();
        if (files != null) {
            for (File file1 : files) {
                CompileDriver.deleteFile(file1);
            }
        }
        for (int i = 0; i < 10; ++i) {
            if (file.delete()) {
                return true;
            }
            if (!file.exists()) {
                return false;
            }
            try {
                Thread.sleep(50L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return false;
    }

    private VirtualFile getGenerationOutputDir(IntermediateOutputCompiler compiler, Module module, boolean forTestSources) {
        Pair<VirtualFile, VirtualFile> outputs = this.myGenerationCompilerModuleToOutputDirMap.get(new Pair((Object)compiler, (Object)module));
        return forTestSources ? (VirtualFile)outputs.getSecond() : (VirtualFile)outputs.getFirst();
    }

    /*
     * Unable to fully structure code
     */
    private boolean generateOutput(final CompileContextEx context, final GeneratingCompiler compiler, boolean forceGenerate, boolean onlyCheckStatus) throws ExitException {
        block18: {
            allItems = compiler.getGenerationItems((CompileContext)context);
            toGenerate = new ArrayList<E>();
            filesToRefresh = new ArrayList<File>();
            generatedFiles = new ArrayList<E>();
            affectedModules = new ArrayList<E>();
            cache = this.getGeneratingCompilerCache(compiler);
            pathsToRemove = new HashSet<String>(cache.getUrls());
            itemToOutputPathMap = new com.intellij.util.containers.HashMap();
            ex = new IOException[]{null};
            ApplicationManager.getApplication().runReadAction(new Runnable((Map)itemToOutputPathMap, cache, forceGenerate, context, toGenerate, pathsToRemove, ex){
                final /* synthetic */ Map val$itemToOutputPathMap;
                final /* synthetic */ StateCache val$cache;
                final /* synthetic */ boolean val$forceGenerate;
                final /* synthetic */ CompileContextEx val$context;
                final /* synthetic */ List val$toGenerate;
                final /* synthetic */ Set val$pathsToRemove;
                final /* synthetic */ IOException[] val$ex;
                {
                    this.val$itemToOutputPathMap = map;
                    this.val$cache = stateCache;
                    this.val$forceGenerate = bl;
                    this.val$context = compileContextEx;
                    this.val$toGenerate = list;
                    this.val$pathsToRemove = set;
                    this.val$ex = iOExceptionArray;
                }

                @Override
                public void run() {
                    for (GeneratingCompiler.GenerationItem item : allItems) {
                        Module itemModule = item.getModule();
                        String outputDirPath = CompilerPaths.getGenerationOutputPath((IntermediateOutputCompiler)compiler, (Module)itemModule, (boolean)item.isTestSource());
                        String outputPath = outputDirPath + "/" + item.getPath();
                        this.val$itemToOutputPathMap.put(item, outputPath);
                        try {
                            ValidityState savedState = (ValidityState)this.val$cache.getState(outputPath);
                            if (this.val$forceGenerate || savedState == null || !savedState.equalsTo(item.getValidityState())) {
                                String outputPathUrl = VirtualFileManager.constructUrl((String)"file", (String)outputPath);
                                if (this.val$context.getCompileScope().belongs(outputPathUrl)) {
                                    this.val$toGenerate.add(item);
                                    continue;
                                }
                                this.val$pathsToRemove.remove(outputPath);
                                continue;
                            }
                            this.val$pathsToRemove.remove(outputPath);
                        }
                        catch (IOException e) {
                            this.val$ex[0] = e;
                        }
                    }
                }
            });
            if (ex[0] != null) {
                throw ex[0];
            }
            if (!onlyCheckStatus) ** GOTO lbl33
            if (!toGenerate.isEmpty() || !pathsToRemove.isEmpty()) break block18;
            var14_15 = false;
            CompilerUtil.refreshIOFiles(filesToRefresh);
            if (!generatedFiles.isEmpty()) {
                DumbService.getInstance((Project)this.myProject).waitForSmartMode();
                vFiles = (List)ApplicationManager.getApplication().runReadAction((Computable)new Computable<List<VirtualFile>>(generatedFiles){
                    final /* synthetic */ List val$generatedFiles;
                    {
                        this.val$generatedFiles = list;
                    }

                    public List<VirtualFile> compute() {
                        ArrayList<VirtualFile> vFiles = new ArrayList<VirtualFile>(this.val$generatedFiles.size());
                        for (File generatedFile : this.val$generatedFiles) {
                            VirtualFile vFile = LocalFileSystem.getInstance().findFileByIoFile(generatedFile);
                            if (vFile == null) continue;
                            vFiles.add(vFile);
                        }
                        return vFiles;
                    }
                });
                if (forceGenerate) {
                    context.addScope(new FileSetCompileScope(vFiles, affectedModules.toArray(new Module[affectedModules.size()])));
                }
                context.markGenerated(vFiles);
            }
            return var14_15;
        }
        try {
            if (CompileDriver.LOG.isDebugEnabled()) {
                if (!toGenerate.isEmpty()) {
                    CompileDriver.LOG.debug("Found items to generate, compiler " + compiler.getDescription());
                }
                if (!pathsToRemove.isEmpty()) {
                    CompileDriver.LOG.debug("Found paths to remove, compiler " + compiler.getDescription());
                }
            }
            throw new ExitException(ExitStatus.CANCELLED);
lbl33:
            // 1 sources

            if (!pathsToRemove.isEmpty()) {
                CompilerUtil.runInContext(context, CompilerBundle.message((String)"progress.synchronizing.output.directory", (Object[])new Object[0]), new ThrowableRunnable<IOException>(){

                    public void run() throws IOException {
                        for (String path : pathsToRemove) {
                            File file = new File(path);
                            boolean deleted = CompileDriver.deleteFile(file);
                            if (!deleted) continue;
                            cache.remove(path);
                            filesToRefresh.add(file);
                        }
                    }
                });
            }
            moduleToItemMap = CompileDriver.buildModuleToGenerationItemMap(toGenerate.toArray(new GeneratingCompiler.GenerationItem[toGenerate.size()]));
            modules = new ArrayList<Module>(moduleToItemMap.size());
            for (final Module module : moduleToItemMap.keySet()) {
                modules.add(module);
            }
            ModuleCompilerUtil.sortModules((Project)this.myProject, modules);
            for (final Module module : modules) {
                CompilerUtil.runInContext(context, "Generating output from " + compiler.getDescription(), new ThrowableRunnable<IOException>((Map)itemToOutputPathMap, cache, filesToRefresh, generatedFiles){
                    final /* synthetic */ Map val$itemToOutputPathMap;
                    final /* synthetic */ StateCache val$cache;
                    final /* synthetic */ List val$filesToRefresh;
                    final /* synthetic */ List val$generatedFiles;
                    {
                        this.val$itemToOutputPathMap = map2;
                        this.val$cache = stateCache;
                        this.val$filesToRefresh = list2;
                        this.val$generatedFiles = list3;
                    }

                    public void run() throws IOException {
                        Set items = (Set)moduleToItemMap.get(module);
                        if (items != null && !items.isEmpty()) {
                            GeneratingCompiler.GenerationItem[][] productionAndTestItems;
                            for (GeneratingCompiler.GenerationItem[] _items : productionAndTestItems = CompileDriver.splitGenerationItems(items)) {
                                if (_items.length == 0) continue;
                                VirtualFile outputDir = CompileDriver.this.getGenerationOutputDir((IntermediateOutputCompiler)compiler, module, _items[0].isTestSource());
                                final GeneratingCompiler.GenerationItem[] successfullyGenerated = compiler.generate((CompileContext)context, _items, outputDir);
                                CompilerUtil.runInContext(context, CompilerBundle.message((String)"progress.updating.caches", (Object[])new Object[0]), new ThrowableRunnable<IOException>(){

                                    public void run() throws IOException {
                                        if (successfullyGenerated.length > 0) {
                                            affectedModules.add(module);
                                        }
                                        for (GeneratingCompiler.GenerationItem item : successfullyGenerated) {
                                            String fullOutputPath = (String)val$itemToOutputPathMap.get(item);
                                            val$cache.update(fullOutputPath, item.getValidityState());
                                            File file = new File(fullOutputPath);
                                            val$filesToRefresh.add(file);
                                            val$generatedFiles.add(file);
                                            context.getProgressIndicator().setText2(file.getPath());
                                        }
                                    }
                                });
                            }
                        }
                    }
                });
            }
        }
        catch (IOException e) {
            try {
                CompileDriver.LOG.info((Throwable)e);
                context.requestRebuildNextTime(e.getMessage());
                throw new ExitException(ExitStatus.ERRORS);
            }
            catch (Throwable var18_21) {
                CompilerUtil.refreshIOFiles(filesToRefresh);
                if (!generatedFiles.isEmpty()) {
                    DumbService.getInstance((Project)this.myProject).waitForSmartMode();
                    vFiles = (List)ApplicationManager.getApplication().runReadAction((Computable)new /* invalid duplicate definition of identical inner class */);
                    if (forceGenerate) {
                        context.addScope(new FileSetCompileScope(vFiles, affectedModules.toArray(new Module[affectedModules.size()])));
                    }
                    context.markGenerated(vFiles);
                }
                throw var18_21;
            }
        }
        CompilerUtil.refreshIOFiles(filesToRefresh);
        if (!generatedFiles.isEmpty()) {
            DumbService.getInstance((Project)this.myProject).waitForSmartMode();
            vFiles = (List)ApplicationManager.getApplication().runReadAction((Computable)new /* invalid duplicate definition of identical inner class */);
            if (forceGenerate) {
                context.addScope(new FileSetCompileScope(vFiles, affectedModules.toArray(new Module[affectedModules.size()])));
            }
            context.markGenerated(vFiles);
        }
        return toGenerate.isEmpty() == false || filesToRefresh.isEmpty() == false;
    }

    private static GeneratingCompiler.GenerationItem[][] splitGenerationItems(Set<GeneratingCompiler.GenerationItem> items) {
        ArrayList<GeneratingCompiler.GenerationItem> production = new ArrayList<GeneratingCompiler.GenerationItem>();
        ArrayList<GeneratingCompiler.GenerationItem> tests = new ArrayList<GeneratingCompiler.GenerationItem>();
        for (GeneratingCompiler.GenerationItem item : items) {
            if (item.isTestSource()) {
                tests.add(item);
                continue;
            }
            production.add(item);
        }
        return new GeneratingCompiler.GenerationItem[][]{production.toArray(new GeneratingCompiler.GenerationItem[production.size()]), tests.toArray(new GeneratingCompiler.GenerationItem[tests.size()])};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean compileSources(final CompileContextEx context, Chunk<Module> moduleChunk, final TranslatingCompiler compiler, final Collection<VirtualFile> srcSnapshot, final boolean forceCompile, final boolean isRebuild, final boolean trackDependencies, boolean onlyCheckStatus, TranslatingCompiler.OutputSink sink) throws ExitException {
        final HashSet toCompile = new HashSet();
        final ArrayList<Trinity<File, String, Boolean>> toDelete = new ArrayList<Trinity<File, String, Boolean>>();
        context.getProgressIndicator().pushState();
        boolean[] wereFilesDeleted = new boolean[]{false};
        boolean traverseRootsProcessed = false;
        try {
            ApplicationManager.getApplication().runReadAction(new Runnable(){

                @Override
                public void run() {
                    TranslatingCompilerFilesMonitor.getInstance().collectFiles(context, compiler, srcSnapshot.iterator(), forceCompile, isRebuild, toCompile, toDelete);
                    if (trackDependencies && !toCompile.isEmpty()) {
                        FileTypeManager fileTypeManager = FileTypeManager.getInstance();
                        PsiManager psiManager = PsiManager.getInstance((Project)CompileDriver.this.myProject);
                        for (VirtualFile file : VfsUtil.toVirtualFileArray((Collection)toCompile)) {
                            PsiFile psiFile;
                            if (fileTypeManager.getFileTypeByFile(file) != StdFileTypes.JAVA || (psiFile = psiManager.findFile(file)) == null) continue;
                            CompileDriver.this.addDependentFiles(psiFile, toCompile, compiler, context);
                        }
                    }
                }
            });
            if (onlyCheckStatus) {
                if (toDelete.isEmpty() && toCompile.isEmpty()) {
                    boolean bl = false;
                    return bl;
                }
                if (LOG.isDebugEnabled()) {
                    if (!toDelete.isEmpty()) {
                        LOG.debug("Found items to delete, compiler " + compiler.getDescription());
                    }
                    if (!toCompile.isEmpty()) {
                        LOG.debug("Found items to compile, compiler " + compiler.getDescription());
                    }
                }
                throw new ExitException(ExitStatus.CANCELLED);
            }
            if (!toDelete.isEmpty()) {
                try {
                    wereFilesDeleted[0] = CompileDriver.syncOutputDir(context, toDelete);
                }
                catch (CacheCorruptedException e) {
                    LOG.info((Throwable)e);
                    context.requestRebuildNextTime(e.getMessage());
                }
            }
            boolean hadUnprocessedTraverseRoots = context.getDependencyCache().hasUnprocessedTraverseRoots();
            if ((wereFilesDeleted[0] || hadUnprocessedTraverseRoots || !toCompile.isEmpty()) && context.getMessageCount(CompilerMessageCategory.ERROR) == 0) {
                compiler.compile((CompileContext)context, moduleChunk, VfsUtil.toVirtualFileArray(toCompile), sink);
                traverseRootsProcessed = hadUnprocessedTraverseRoots != context.getDependencyCache().hasUnprocessedTraverseRoots();
            }
        }
        finally {
            context.getProgressIndicator().popState();
        }
        return !toCompile.isEmpty() || traverseRootsProcessed || wereFilesDeleted[0];
    }

    private static boolean syncOutputDir(final CompileContextEx context, final Collection<Trinity<File, String, Boolean>> toDelete) throws CacheCorruptedException {
        final DependencyCache dependencyCache = context.getDependencyCache();
        final boolean isTestMode = ApplicationManager.getApplication().isUnitTestMode();
        final ArrayList filesToRefresh = new ArrayList();
        final boolean[] wereFilesDeleted = new boolean[]{false};
        CompilerUtil.runInContext(context, CompilerBundle.message((String)"progress.synchronizing.output.directory", (Object[])new Object[0]), new ThrowableRunnable<CacheCorruptedException>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() throws CacheCorruptedException {
                long start = System.currentTimeMillis();
                try {
                    for (Trinity trinity : toDelete) {
                        File outputPath = (File)trinity.getFirst();
                        context.getProgressIndicator().checkCanceled();
                        context.getProgressIndicator().setText2(outputPath.getPath());
                        filesToRefresh.add(outputPath);
                        if (isTestMode) {
                            LOG.assertTrue(outputPath.exists());
                        }
                        if (!CompileDriver.deleteFile(outputPath)) {
                            if (!isTestMode || !outputPath.exists()) continue;
                            LOG.error("Was not able to delete output file: " + outputPath.getPath());
                            continue;
                        }
                        wereFilesDeleted[0] = true;
                        String className = (String)trinity.getSecond();
                        if (className != null) {
                            int id = dependencyCache.getSymbolTable().getId(className);
                            dependencyCache.addTraverseRoot(id);
                            boolean sourcePresent = (Boolean)trinity.getThird();
                            if (!sourcePresent) {
                                dependencyCache.markSourceRemoved(id);
                            }
                        }
                        if (!isTestMode) continue;
                        CompilerManagerImpl.addDeletedPath(outputPath.getPath());
                    }
                }
                finally {
                    CompilerUtil.logDuration("Sync output directory", System.currentTimeMillis() - start);
                    CompilerUtil.refreshIOFiles(filesToRefresh);
                }
            }
        });
        return wereFilesDeleted[0];
    }

    private void addDependentFiles(PsiFile psiFile, Set<VirtualFile> toCompile, TranslatingCompiler compiler, CompileContext context) {
        ForwardDependenciesBuilder builder = new ForwardDependenciesBuilder(this.myProject, new AnalysisScope(psiFile));
        ((DependenciesBuilder)builder).analyze();
        Map<PsiFile, Set<PsiFile>> dependencies = builder.getDependencies();
        Set<PsiFile> dependentFiles = dependencies.get(psiFile);
        if (dependentFiles != null && !dependentFiles.isEmpty()) {
            TranslatingCompilerFilesMonitor monitor = TranslatingCompilerFilesMonitor.getInstance();
            for (PsiFile dependentFile : dependentFiles) {
                VirtualFile vFile;
                if (dependentFile instanceof PsiCompiledElement || (vFile = dependentFile.getVirtualFile()) == null || toCompile.contains(vFile) || !compiler.isCompilableFile(vFile, context) || !monitor.isMarkedForCompilation(this.myProject, vFile)) continue;
                toCompile.add(vFile);
                this.addDependentFiles(dependentFile, toCompile, compiler, context);
            }
        }
    }

    private String getModuleOutputPath(Module module, boolean inTestSourceContent) {
        Map<Module, String> map = inTestSourceContent ? this.myModuleTestOutputPaths : this.myModuleOutputPaths;
        String path = map.get(module);
        if (path == null) {
            path = CompilerPaths.getModuleOutputPath((Module)module, (boolean)inTestSourceContent);
            map.put(module, path);
        }
        return path;
    }

    private boolean processFiles(final FileProcessingCompilerAdapter adapter, final boolean forceCompile, final boolean checkScope, final boolean onlyCheckStatus, final CacheDeferredUpdater cacheUpdater) throws ExitException, IOException {
        final CompileContextEx context = (CompileContextEx)adapter.getCompileContext();
        final FileProcessingCompilerStateCache cache = this.getFileProcessingCompilerCache(adapter.getCompiler());
        final FileProcessingCompiler.ProcessingItem[] items = adapter.getProcessingItems();
        if (context.getMessageCount(CompilerMessageCategory.ERROR) > 0) {
            return false;
        }
        if (LOG.isDebugEnabled() && items.length > 0) {
            LOG.debug("Start processing files by " + adapter.getCompiler().getDescription());
        }
        final CompileScope scope = context.getCompileScope();
        final ArrayList toProcess = new ArrayList();
        final HashSet allUrls = new HashSet();
        final IOException[] ex = new IOException[]{null};
        DumbService.getInstance((Project)this.myProject).waitForSmartMode();
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                try {
                    for (FileProcessingCompiler.ProcessingItem item : items) {
                        VirtualFile file = item.getFile();
                        if (file == null) {
                            LOG.error("FileProcessingCompiler.ProcessingItem.getFile() must not return null: compiler " + adapter.getCompiler().getDescription());
                            continue;
                        }
                        String url = file.getUrl();
                        allUrls.add(url);
                        if (!forceCompile && cache.getTimestamp(url) == file.getTimeStamp()) {
                            ValidityState state = cache.getExtState(url);
                            ValidityState itemState = item.getValidityState();
                            if (state == null ? itemState == null : state.equalsTo(itemState)) continue;
                        }
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Adding item to process: " + url + "; saved ts= " + cache.getTimestamp(url) + "; VFS ts=" + file.getTimeStamp());
                        }
                        toProcess.add(item);
                    }
                }
                catch (IOException e) {
                    ex[0] = e;
                }
            }
        });
        if (ex[0] != null) {
            throw ex[0];
        }
        final Collection<String> urls = cache.getUrls();
        final ArrayList urlsToRemove = new ArrayList();
        if (!urls.isEmpty()) {
            CompilerUtil.runInContext(context, CompilerBundle.message((String)"progress.processing.outdated.files", (Object[])new Object[0]), new ThrowableRunnable<IOException>(){

                public void run() throws IOException {
                    ApplicationManager.getApplication().runReadAction(new Runnable(){

                        @Override
                        public void run() {
                            for (String url : urls) {
                                if (allUrls.contains(url) || checkScope && !scope.belongs(url)) continue;
                                urlsToRemove.add(url);
                            }
                        }
                    });
                    if (!onlyCheckStatus && !urlsToRemove.isEmpty()) {
                        for (String url : urlsToRemove) {
                            adapter.processOutdatedItem(context, url, cache.getExtState(url));
                            cache.remove(url);
                        }
                    }
                }
            });
        }
        if (onlyCheckStatus) {
            if (urlsToRemove.isEmpty() && toProcess.isEmpty()) {
                return false;
            }
            if (LOG.isDebugEnabled()) {
                if (!urlsToRemove.isEmpty()) {
                    LOG.debug("Found urls to remove, compiler " + adapter.getCompiler().getDescription());
                    for (String url : urlsToRemove) {
                        LOG.debug("\t" + url);
                    }
                }
                if (!toProcess.isEmpty()) {
                    LOG.debug("Found items to compile, compiler " + adapter.getCompiler().getDescription());
                    for (FileProcessingCompiler.ProcessingItem item : toProcess) {
                        LOG.debug("\t" + item.getFile().getPresentableUrl());
                    }
                }
            }
            throw new ExitException(ExitStatus.CANCELLED);
        }
        if (toProcess.isEmpty()) {
            return false;
        }
        final FileProcessingCompiler.ProcessingItem[] processed = adapter.process(toProcess.toArray(new FileProcessingCompiler.ProcessingItem[toProcess.size()]));
        if (processed.length == 0) {
            return true;
        }
        CompilerUtil.runInContext(context, CompilerBundle.message((String)"progress.updating.caches", (Object[])new Object[0]), new ThrowableRunnable<IOException>(){

            public void run() throws IOException {
                ArrayList<VirtualFile> vFiles = new ArrayList<VirtualFile>(processed.length);
                for (FileProcessingCompiler.ProcessingItem aProcessed : processed) {
                    VirtualFile file = aProcessed.getFile();
                    vFiles.add(file);
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug("\tFile processed " + file.getPresentableUrl() + "; ts=" + file.getTimeStamp());
                }
                LocalFileSystem.getInstance().refreshFiles(vFiles);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Files after VFS refresh:");
                    for (VirtualFile file : vFiles) {
                        LOG.debug("\t" + file.getPresentableUrl() + "; ts=" + file.getTimeStamp());
                    }
                }
                for (FileProcessingCompiler.ProcessingItem item : processed) {
                    cacheUpdater.addFileForUpdate(item, cache);
                }
            }
        });
        return true;
    }

    private FileProcessingCompilerStateCache getFileProcessingCompilerCache(FileProcessingCompiler compiler) throws IOException {
        return CompilerCacheManager.getInstance(this.myProject).getFileProcessingCompilerCache(compiler);
    }

    private StateCache<ValidityState> getGeneratingCompilerCache(GeneratingCompiler compiler) throws IOException {
        return CompilerCacheManager.getInstance(this.myProject).getGeneratingCompilerCache(compiler);
    }

    public void executeCompileTask(final CompileTask task, CompileScope scope, String contentName, final Runnable onTaskFinished) {
        CompilerTask progressManagerTask = new CompilerTask(this.myProject, CompilerWorkspaceConfiguration.getInstance((Project)this.myProject).COMPILE_IN_BACKGROUND, contentName, false);
        final CompileContextImpl compileContext = new CompileContextImpl(this.myProject, progressManagerTask, scope, null, false, false);
        FileDocumentManager.getInstance().saveAllDocuments();
        progressManagerTask.start(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    task.execute((CompileContext)compileContext);
                }
                catch (ProcessCanceledException processCanceledException) {
                }
                finally {
                    compileContext.commitZipFiles();
                    if (onTaskFinished != null) {
                        onTaskFinished.run();
                    }
                }
            }
        }, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executeCompileTasks(CompileContext context, boolean beforeTasks) {
        ProgressIndicator progressIndicator;
        block7: {
            boolean bl;
            CompilerManager manager = CompilerManager.getInstance((Project)this.myProject);
            progressIndicator = context.getProgressIndicator();
            progressIndicator.pushState();
            try {
                CompileTask[] tasks;
                CompileTask[] compileTaskArray = tasks = beforeTasks ? manager.getBeforeTasks() : manager.getAfterTasks();
                if (tasks.length <= 0) break block7;
                progressIndicator.setText(beforeTasks ? CompilerBundle.message((String)"progress.executing.precompile.tasks", (Object[])new Object[0]) : CompilerBundle.message((String)"progress.executing.postcompile.tasks", (Object[])new Object[0]));
                for (CompileTask task : tasks) {
                    if (task.execute(context)) break block8;
                    bl = false;
                }
            }
            catch (Throwable throwable) {
                progressIndicator.popState();
                WindowManager.getInstance().getStatusBar(this.myProject).setInfo("");
                if (progressIndicator instanceof CompilerTask) {
                    ApplicationManager.getApplication().invokeLater(new Runnable(progressIndicator){
                        final /* synthetic */ ProgressIndicator val$progressIndicator;
                        {
                            this.val$progressIndicator = progressIndicator;
                        }

                        @Override
                        public void run() {
                            ((CompilerTask)this.val$progressIndicator).showCompilerContent();
                        }
                    });
                }
                throw throwable;
            }
            {
                block8: {
                    progressIndicator.popState();
                    WindowManager.getInstance().getStatusBar(this.myProject).setInfo("");
                    if (progressIndicator instanceof CompilerTask) {
                        ApplicationManager.getApplication().invokeLater(new /* invalid duplicate definition of identical inner class */);
                    }
                    return bl;
                }
                continue;
            }
        }
        progressIndicator.popState();
        WindowManager.getInstance().getStatusBar(this.myProject).setInfo("");
        if (progressIndicator instanceof CompilerTask) {
            ApplicationManager.getApplication().invokeLater(new /* invalid duplicate definition of identical inner class */);
        }
        return true;
    }

    private boolean validateCompilerConfiguration(CompileScope scope, boolean checkOutputAndSourceIntersection) {
        Compiler[] allCompilers;
        Module[] scopeModules = scope.getAffectedModules();
        ArrayList<String> modulesWithoutOutputPathSpecified = new ArrayList<String>();
        boolean isProjectCompilePathSpecified = true;
        ArrayList<String> modulesWithoutJdkAssigned = new ArrayList<String>();
        final HashSet<File> nonExistingOutputPaths = new HashSet<File>();
        CompilerConfiguration config = CompilerConfiguration.getInstance((Project)this.myProject);
        for (Module module : scopeModules) {
            boolean hasSources = CompileDriver.hasSources(module, false);
            boolean hasTestSources = CompileDriver.hasSources(module, true);
            if (!hasSources && !hasTestSources) continue;
            Sdk jdk = ModuleRootManager.getInstance((Module)module).getSdk();
            if (jdk == null) {
                modulesWithoutJdkAssigned.add(module.getName());
            }
            String outputPath = this.getModuleOutputPath(module, false);
            String testsOutputPath = this.getModuleOutputPath(module, true);
            if (outputPath == null && testsOutputPath == null) {
                modulesWithoutOutputPathSpecified.add(module.getName());
                continue;
            }
            if (outputPath != null) {
                File file = new File(outputPath.replace('/', File.separatorChar));
                if (!file.exists()) {
                    nonExistingOutputPaths.add(file);
                }
            } else if (hasSources) {
                modulesWithoutOutputPathSpecified.add(module.getName());
            }
            if (testsOutputPath != null) {
                File f = new File(testsOutputPath.replace('/', File.separatorChar));
                if (!f.exists()) {
                    nonExistingOutputPaths.add(f);
                }
            } else if (hasTestSources) {
                modulesWithoutOutputPathSpecified.add(module.getName());
            }
            if (!config.isAnnotationProcessorsEnabled() || !config.isAnnotationProcessingEnabled(module)) continue;
            String path = CompilerPaths.getAnnotationProcessorsGenerationPath((Module)module);
            if (path == null) {
                CompilerProjectExtension extension = CompilerProjectExtension.getInstance((Project)module.getProject());
                if (extension == null || extension.getCompilerOutputUrl() == null) {
                    isProjectCompilePathSpecified = false;
                    continue;
                }
                modulesWithoutOutputPathSpecified.add(module.getName());
                continue;
            }
            File file = new File(path);
            if (file.exists()) continue;
            nonExistingOutputPaths.add(file);
        }
        if (!modulesWithoutJdkAssigned.isEmpty()) {
            this.showNotSpecifiedError("error.jdk.not.specified", modulesWithoutJdkAssigned, ProjectBundle.message((String)"modules.classpath.title", (Object[])new Object[0]));
            return false;
        }
        if (!isProjectCompilePathSpecified) {
            String message = CompilerBundle.message((String)"error.project.output.not.specified", (Object[])new Object[0]);
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                LOG.error(message);
            }
            Messages.showMessageDialog((Project)this.myProject, (String)message, (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
            ProjectSettingsService.getInstance(this.myProject).openProjectSettings();
            return false;
        }
        if (!modulesWithoutOutputPathSpecified.isEmpty()) {
            this.showNotSpecifiedError("error.output.not.specified", modulesWithoutOutputPathSpecified, CommonContentEntriesEditor.NAME);
            return false;
        }
        if (!nonExistingOutputPaths.isEmpty()) {
            for (File file : nonExistingOutputPaths) {
                boolean succeeded = file.mkdirs();
                if (succeeded || file.exists()) continue;
                Messages.showMessageDialog((Project)this.myProject, (String)CompilerBundle.message((String)"error.failed.to.create.directory", (Object[])new Object[]{file.getPath()}), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
                return false;
            }
            Boolean refreshSuccess = (Boolean)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<Boolean>(){

                public Boolean compute() {
                    LocalFileSystem.getInstance().refreshIoFiles((Iterable)nonExistingOutputPaths);
                    for (File file : nonExistingOutputPaths) {
                        if (LocalFileSystem.getInstance().findFileByIoFile(file) != null) continue;
                        return Boolean.FALSE;
                    }
                    return Boolean.TRUE;
                }
            });
            if (!refreshSuccess.booleanValue()) {
                return false;
            }
            this.dropScopesCaches();
        }
        if (checkOutputAndSourceIntersection && this.myShouldClearOutputDirectory && !this.validateOutputAndSourcePathsIntersection()) {
            return false;
        }
        List chunks = ModuleCompilerUtil.getSortedModuleChunks((Project)this.myProject, Arrays.asList(scopeModules));
        for (Chunk chunk : chunks) {
            Set chunkModules = chunk.getNodes();
            if (chunkModules.size() <= 1) continue;
            if (config.isAnnotationProcessorsEnabled()) {
                for (Module chunkModule : chunkModules) {
                    if (!config.isAnnotationProcessingEnabled(chunkModule)) continue;
                    this.showCyclesNotSupportedForAnnotationProcessors(chunkModules.toArray(new Module[chunkModules.size()]));
                    return false;
                }
            }
            Sdk jdk = null;
            LanguageLevel languageLevel = null;
            for (Module module : chunkModules) {
                Sdk moduleJdk = ModuleRootManager.getInstance((Module)module).getSdk();
                if (jdk == null) {
                    jdk = moduleJdk;
                } else if (!jdk.equals(moduleJdk)) {
                    this.showCyclicModulesHaveDifferentJdksError(chunkModules.toArray(new Module[chunkModules.size()]));
                    return false;
                }
                LanguageLevel moduleLanguageLevel = LanguageLevelUtil.getEffectiveLanguageLevel((Module)module);
                if (languageLevel == null) {
                    languageLevel = moduleLanguageLevel;
                    continue;
                }
                if (languageLevel.equals((Object)moduleLanguageLevel)) continue;
                this.showCyclicModulesHaveDifferentLanguageLevel(chunkModules.toArray(new Module[chunkModules.size()]));
                return false;
            }
        }
        for (Compiler compiler : allCompilers = CompilerManager.getInstance((Project)this.myProject).getCompilers(Compiler.class)) {
            if (compiler.validateConfiguration(scope)) continue;
            return false;
        }
        return true;
    }

    private void showCyclicModulesHaveDifferentLanguageLevel(Module[] modulesInChunk) {
        LOG.assertTrue(modulesInChunk.length > 0);
        String moduleNameToSelect = modulesInChunk[0].getName();
        String moduleNames = CompileDriver.getModulesString(modulesInChunk);
        Messages.showMessageDialog((Project)this.myProject, (String)CompilerBundle.message((String)"error.chunk.modules.must.have.same.language.level", (Object[])new Object[]{moduleNames}), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
        this.showConfigurationDialog(moduleNameToSelect, null);
    }

    private void showCyclicModulesHaveDifferentJdksError(Module[] modulesInChunk) {
        LOG.assertTrue(modulesInChunk.length > 0);
        String moduleNameToSelect = modulesInChunk[0].getName();
        String moduleNames = CompileDriver.getModulesString(modulesInChunk);
        Messages.showMessageDialog((Project)this.myProject, (String)CompilerBundle.message((String)"error.chunk.modules.must.have.same.jdk", (Object[])new Object[]{moduleNames}), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
        this.showConfigurationDialog(moduleNameToSelect, null);
    }

    private void showCyclesNotSupportedForAnnotationProcessors(Module[] modulesInChunk) {
        LOG.assertTrue(modulesInChunk.length > 0);
        String moduleNameToSelect = modulesInChunk[0].getName();
        String moduleNames = CompileDriver.getModulesString(modulesInChunk);
        Messages.showMessageDialog((Project)this.myProject, (String)CompilerBundle.message((String)"error.annotation.processing.not.supported.for.module.cycles", (Object[])new Object[]{moduleNames}), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
        this.showConfigurationDialog(moduleNameToSelect, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getModulesString(Module[] modulesInChunk) {
        StringBuilder moduleNames = StringBuilderSpinAllocator.alloc();
        try {
            for (Module module : modulesInChunk) {
                if (moduleNames.length() > 0) {
                    moduleNames.append("\n");
                }
                moduleNames.append("\"").append(module.getName()).append("\"");
            }
            String string = moduleNames.toString();
            return string;
        }
        finally {
            StringBuilderSpinAllocator.dispose((StringBuilder)moduleNames);
        }
    }

    private static boolean hasSources(Module module, boolean checkTestSources) {
        ContentEntry[] contentEntries;
        for (ContentEntry contentEntry : contentEntries = ModuleRootManager.getInstance((Module)module).getContentEntries()) {
            SourceFolder[] sourceFolders;
            for (SourceFolder sourceFolder : sourceFolders = contentEntry.getSourceFolders()) {
                if (sourceFolder.getFile() == null || !(checkTestSources ? sourceFolder.isTestSource() : !sourceFolder.isTestSource())) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showNotSpecifiedError(@NonNls String resourceId, List<String> modules, String tabNameToSelect) {
        String message;
        String nameToSelect = null;
        StringBuilder names = StringBuilderSpinAllocator.alloc();
        try {
            int maxModulesToShow = 10;
            for (String name : modules.size() > 10 ? modules.subList(0, 10) : modules) {
                if (nameToSelect == null) {
                    nameToSelect = name;
                }
                if (names.length() > 0) {
                    names.append(",\n");
                }
                names.append("\"");
                names.append(name);
                names.append("\"");
            }
            if (modules.size() > 10) {
                names.append(",\n...");
            }
            message = CompilerBundle.message((String)resourceId, (Object[])new Object[]{modules.size(), names.toString()});
        }
        finally {
            StringBuilderSpinAllocator.dispose((StringBuilder)names);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            LOG.error(message);
        }
        Messages.showMessageDialog((Project)this.myProject, (String)message, (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
        this.showConfigurationDialog(nameToSelect, tabNameToSelect);
    }

    private boolean validateOutputAndSourcePathsIntersection() {
        Module[] allModules = ModuleManager.getInstance((Project)this.myProject).getModules();
        VirtualFile[] outputPaths = CompilerPathsEx.getOutputDirectories((Module[])allModules);
        HashSet<VirtualFile> affectedOutputPaths = new HashSet<VirtualFile>();
        for (Module allModule : allModules) {
            ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)allModule);
            VirtualFile[] sourceRoots = rootManager.getSourceRoots();
            for (VirtualFile outputPath : outputPaths) {
                for (VirtualFile sourceRoot : sourceRoots) {
                    if (!VfsUtil.isAncestor((VirtualFile)outputPath, (VirtualFile)sourceRoot, (boolean)true) && !VfsUtil.isAncestor((VirtualFile)sourceRoot, (VirtualFile)outputPath, (boolean)false)) continue;
                    affectedOutputPaths.add(outputPath);
                }
            }
        }
        if (!affectedOutputPaths.isEmpty()) {
            StringBuilder paths = new StringBuilder();
            for (VirtualFile affectedOutputPath : affectedOutputPaths) {
                if (paths.length() < 0) {
                    paths.append("\n");
                }
                paths.append(affectedOutputPath.getPath().replace('/', File.separatorChar));
            }
            int answer = Messages.showOkCancelDialog((Project)this.myProject, (String)CompilerBundle.message((String)"warning.sources.under.output.paths", (Object[])new Object[]{paths.toString()}), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getWarningIcon());
            if (answer == 0) {
                this.myShouldClearOutputDirectory = false;
                return true;
            }
            return false;
        }
        return true;
    }

    private void showConfigurationDialog(String moduleNameToSelect, String tabNameToSelect) {
        ProjectSettingsService.getInstance(this.myProject).showModuleConfigurationDialog(moduleNameToSelect, tabNameToSelect, false);
    }

    private static VirtualFile lookupVFile(LocalFileSystem lfs, String path) {
        File file = new File(path);
        VirtualFile vFile = lfs.findFileByIoFile(file);
        if (vFile != null) {
            return vFile;
        }
        boolean justCreated = file.mkdirs();
        vFile = lfs.refreshAndFindFileByIoFile(file);
        assert (vFile != null) : "Virtual file not found for " + file.getPath() + "; mkdirs() exit code is " + justCreated;
        return vFile;
    }

    private static class TranslatorsOutputSink
    implements TranslatingCompiler.OutputSink {
        final Map<String, Collection<TranslatingCompiler.OutputItem>> myPostponedItems = new com.intellij.util.containers.HashMap();
        private final CompileContextEx myContext;
        private final TranslatingCompiler[] myCompilers;
        private int myCurrentCompilerIdx;

        private TranslatorsOutputSink(CompileContextEx context, TranslatingCompiler[] compilers) {
            this.myContext = context;
            this.myCompilers = compilers;
        }

        public void setCurrentCompilerIndex(int index) {
            this.myCurrentCompilerIdx = index;
        }

        public void add(String outputRoot, Collection<TranslatingCompiler.OutputItem> items, VirtualFile[] filesToRecompile) {
            TranslatingCompiler compiler = this.myCompilers[this.myCurrentCompilerIdx];
            if (compiler instanceof IntermediateOutputCompiler) {
                LocalFileSystem lfs = LocalFileSystem.getInstance();
                ArrayList<VirtualFile> outputs = new ArrayList<VirtualFile>();
                for (TranslatingCompiler.OutputItem outputItem : items) {
                    VirtualFile vFile = lfs.findFileByPath(outputItem.getOutputPath());
                    if (vFile == null) continue;
                    outputs.add(vFile);
                }
                this.myContext.markGenerated(outputs);
            }
            int nextCompilerIdx = this.myCurrentCompilerIdx + 1;
            try {
                if (nextCompilerIdx < this.myCompilers.length) {
                    HashMap<String, Collection<TranslatingCompiler.OutputItem>> updateNow = new HashMap<String, Collection<TranslatingCompiler.OutputItem>>();
                    for (Map.Entry entry : this.myPostponedItems.entrySet()) {
                        String outputDir = (String)entry.getKey();
                        Collection postponed = (Collection)entry.getValue();
                        Iterator it = postponed.iterator();
                        while (it.hasNext()) {
                            TranslatingCompiler.OutputItem item = (TranslatingCompiler.OutputItem)it.next();
                            boolean shouldPostpone = false;
                            for (int idx = nextCompilerIdx; idx < this.myCompilers.length && !(shouldPostpone = this.myCompilers[idx].isCompilableFile(item.getSourceFile(), (CompileContext)this.myContext)); ++idx) {
                            }
                            if (shouldPostpone) continue;
                            it.remove();
                            this.addItemToMap(updateNow, outputDir, item);
                        }
                    }
                    for (TranslatingCompiler.OutputItem outputItem : items) {
                        boolean shouldPostpone = false;
                        for (int idx = nextCompilerIdx; idx < this.myCompilers.length && !(shouldPostpone = this.myCompilers[idx].isCompilableFile(outputItem.getSourceFile(), (CompileContext)this.myContext)); ++idx) {
                        }
                        if (shouldPostpone) {
                            this.addItemToMap(this.myPostponedItems, outputRoot, outputItem);
                            continue;
                        }
                        this.addItemToMap(updateNow, outputRoot, outputItem);
                    }
                    if (updateNow.size() == 1) {
                        Map.Entry entry = updateNow.entrySet().iterator().next();
                        String string = (String)entry.getKey();
                        Collection itemsToUpdate = (Collection)entry.getValue();
                        TranslatingCompilerFilesMonitor.getInstance().update(this.myContext, string, itemsToUpdate, filesToRecompile);
                    } else {
                        for (Map.Entry entry : updateNow.entrySet()) {
                            String outputDir = (String)entry.getKey();
                            Collection itemsToUpdate = (Collection)entry.getValue();
                            TranslatingCompilerFilesMonitor.getInstance().update(this.myContext, outputDir, itemsToUpdate, VirtualFile.EMPTY_ARRAY);
                        }
                        if (filesToRecompile.length > 0) {
                            TranslatingCompilerFilesMonitor.getInstance().update(this.myContext, null, Collections.<TranslatingCompiler.OutputItem>emptyList(), filesToRecompile);
                        }
                    }
                } else {
                    TranslatingCompilerFilesMonitor.getInstance().update(this.myContext, outputRoot, items, filesToRecompile);
                }
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
                this.myContext.requestRebuildNextTime(e.getMessage());
            }
        }

        private void addItemToMap(Map<String, Collection<TranslatingCompiler.OutputItem>> map, String outputDir, TranslatingCompiler.OutputItem item) {
            Collection<TranslatingCompiler.OutputItem> collection = map.get(outputDir);
            if (collection == null) {
                collection = new ArrayList<TranslatingCompiler.OutputItem>();
                map.put(outputDir, collection);
            }
            collection.add(item);
        }

        public void flushPostponedItems() {
            TranslatingCompilerFilesMonitor filesMonitor = TranslatingCompilerFilesMonitor.getInstance();
            try {
                for (Map.Entry<String, Collection<TranslatingCompiler.OutputItem>> entry : this.myPostponedItems.entrySet()) {
                    String outputDir = entry.getKey();
                    Collection<TranslatingCompiler.OutputItem> items = entry.getValue();
                    filesMonitor.update(this.myContext, outputDir, items, VirtualFile.EMPTY_ARRAY);
                }
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
                this.myContext.requestRebuildNextTime(e.getMessage());
            }
        }
    }

    private static class CacheDeferredUpdater {
        private final Map<VirtualFile, List<Pair<FileProcessingCompilerStateCache, FileProcessingCompiler.ProcessingItem>>> myData = new HashMap<VirtualFile, List<Pair<FileProcessingCompilerStateCache, FileProcessingCompiler.ProcessingItem>>>();

        private CacheDeferredUpdater() {
        }

        public void addFileForUpdate(FileProcessingCompiler.ProcessingItem item, FileProcessingCompilerStateCache cache) {
            VirtualFile file = item.getFile();
            List<Pair<FileProcessingCompilerStateCache, FileProcessingCompiler.ProcessingItem>> list = this.myData.get(file);
            if (list == null) {
                list = new ArrayList<Pair<FileProcessingCompilerStateCache, FileProcessingCompiler.ProcessingItem>>();
                this.myData.put(file, list);
            }
            list.add((Pair<FileProcessingCompilerStateCache, FileProcessingCompiler.ProcessingItem>)new Pair((Object)cache, (Object)item));
        }

        public void doUpdate() throws IOException {
            final IOException[] ex = new IOException[]{null};
            ApplicationManager.getApplication().runReadAction(new Runnable(){

                @Override
                public void run() {
                    try {
                        for (Map.Entry entry : CacheDeferredUpdater.this.myData.entrySet()) {
                            for (Pair pair : (List)entry.getValue()) {
                                FileProcessingCompiler.ProcessingItem item = (FileProcessingCompiler.ProcessingItem)pair.getSecond();
                                ((FileProcessingCompilerStateCache)pair.getFirst()).update((VirtualFile)entry.getKey(), item.getValidityState());
                            }
                        }
                    }
                    catch (IOException e) {
                        ex[0] = e;
                    }
                }
            });
            if (ex[0] != null) {
                throw ex[0];
            }
        }
    }

    private static interface FileProcessingCompilerAdapterFactory {
        public FileProcessingCompilerAdapter create(CompileContext var1, FileProcessingCompiler var2);
    }

    private static class ExitException
    extends Exception {
        private final ExitStatus myStatus;

        private ExitException(ExitStatus status) {
            this.myStatus = status;
        }

        public ExitStatus getExitStatus() {
            return this.myStatus;
        }
    }

    private static class ExitStatus {
        private final String myName;
        public static final ExitStatus CANCELLED = new ExitStatus("CANCELLED");
        public static final ExitStatus ERRORS = new ExitStatus("ERRORS");
        public static final ExitStatus SUCCESS = new ExitStatus("SUCCESS");
        public static final ExitStatus UP_TO_DATE = new ExitStatus("UP_TO_DATE");

        private ExitStatus(@NonNls String name) {
            this.myName = name;
        }

        public String toString() {
            return this.myName;
        }
    }

    private static class CompileStatus {
        final int CACHE_FORMAT_VERSION;
        final boolean COMPILATION_IN_PROGRESS;

        private CompileStatus(int cacheVersion, boolean isCompilationInProgress) {
            this.CACHE_FORMAT_VERSION = cacheVersion;
            this.COMPILATION_IN_PROGRESS = isCompilationInProgress;
        }
    }
}

