/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.unusedLibraries;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.ex.DescriptorProviderInspection;
import com.intellij.codeInspection.ex.JobDescriptor;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefModule;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.impl.ProgressManagerImpl;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryUtil;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packageDependencies.BackwardDependenciesBuilder;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.PackageSetFactory;
import com.intellij.psi.search.scope.packageSet.ParsingException;
import com.intellij.util.Function;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class UnusedLibrariesInspection
extends DescriptorProviderInspection {
    private static final Logger LOG = Logger.getInstance((String)("#" + UnusedLibrariesInspection.class.getName()));
    private static final JobDescriptor BACKWARD_ANALYSIS = new JobDescriptor(InspectionsBundle.message((String)"unused.library.backward.analysis.job.description", (Object[])new Object[0]));

    @Override
    public void runInspection(AnalysisScope scope, InspectionManager manager) {
        GlobalSearchScope searchScope;
        final Project project = this.getContext().getProject();
        ArrayList<VirtualFile> libraryRoots = new ArrayList<VirtualFile>();
        if (scope.getScopeType() == 1) {
            libraryRoots.addAll(Arrays.asList(LibraryUtil.getLibraryRoots((Project)project, (boolean)false, (boolean)false)));
        } else {
            final HashSet modules = new HashSet();
            scope.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(){

                public void visitFile(PsiFile file) {
                    Module module;
                    VirtualFile virtualFile;
                    if (!(file instanceof PsiCompiledElement) && (virtualFile = file.getVirtualFile()) != null && (module = ModuleUtil.findModuleForFile((VirtualFile)virtualFile, (Project)project)) != null) {
                        modules.add(module);
                    }
                }
            });
            libraryRoots.addAll(Arrays.asList(LibraryUtil.getLibraryRoots((Module[])modules.toArray(new Module[modules.size()]), (boolean)false, (boolean)false)));
        }
        try {
            String libsName = "libs";
            searchScope = GlobalSearchScope.filterScope((Project)project, (NamedScope)new NamedScope("libs", PackageSetFactory.getInstance().compile("lib:*..*")));
        }
        catch (ParsingException e) {
            LOG.error((Throwable)e);
            return;
        }
        AnalysisScope analysisScope = new AnalysisScope((SearchScope)searchScope, project);
        analysisScope.setSearchInLibraries(true);
        final BackwardDependenciesBuilder builder = new BackwardDependenciesBuilder(project, analysisScope);
        final ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
        BACKWARD_ANALYSIS.setTotalAmount(builder.getTotalFileCount());
        ((ProgressManagerImpl)ProgressManager.getInstance()).executeProcessUnderProgress(new Runnable(){

            @Override
            public void run() {
                builder.analyze();
            }
        }, new ProgressIndicatorBase(){

            @Override
            public void setFraction(double fraction) {
                super.setFraction(fraction);
                BACKWARD_ANALYSIS.setDoneAmount((int)fraction * BACKWARD_ANALYSIS.getTotalAmount());
                UnusedLibrariesInspection.this.getContext().incrementJobDoneAmount(BACKWARD_ANALYSIS, this.getText2());
            }

            @Override
            public boolean isCanceled() {
                return progressIndicator != null && progressIndicator.isCanceled() || super.isCanceled();
            }
        });
        Map<PsiFile, Set<PsiFile>> dependencies = builder.getDependencies();
        for (PsiFile file : dependencies.keySet()) {
            VirtualFile virtualFile = file.getVirtualFile();
            LOG.assertTrue(virtualFile != null);
            Iterator i = libraryRoots.iterator();
            while (i.hasNext()) {
                if (!VfsUtil.isAncestor((VirtualFile)((VirtualFile)i.next()), (VirtualFile)virtualFile, (boolean)false)) continue;
                i.remove();
            }
        }
        if (libraryRoots.size() > 0) {
            ProjectFileIndex projectIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
            HashMap<OrderEntry, HashSet<VirtualFile>> unusedLibs = new HashMap<OrderEntry, HashSet<VirtualFile>>();
            for (VirtualFile libraryRoot : libraryRoots) {
                List orderEntries = projectIndex.getOrderEntriesForFile(libraryRoot);
                for (OrderEntry orderEntry : orderEntries) {
                    HashSet<VirtualFile> files = (HashSet<VirtualFile>)unusedLibs.get(orderEntry);
                    if (files == null) {
                        files = new HashSet<VirtualFile>();
                        unusedLibs.put(orderEntry, files);
                    }
                    files.add(libraryRoot);
                }
            }
            RefManager refManager = this.getRefManager();
            for (OrderEntry orderEntry : unusedLibs.keySet()) {
                if (!(orderEntry instanceof LibraryOrderEntry)) continue;
                RefModule refModule = refManager.getRefModule(orderEntry.getOwnerModule());
                Set files = (Set)unusedLibs.get(orderEntry);
                if (files.size() < orderEntry.getFiles(OrderRootType.CLASSES).length) {
                    String unusedLibraryRoots = StringUtil.join((Collection)files, (Function)new Function<VirtualFile, String>(){

                        public String fun(VirtualFile file) {
                            return file.getPresentableName();
                        }
                    }, (String)",");
                    this.addProblemElement((RefEntity)refModule, manager.createProblemDescriptor(InspectionsBundle.message((String)"unused.library.roots.problem.descriptor", (Object[])new Object[]{unusedLibraryRoots, orderEntry.getPresentableName()}), new QuickFix[]{new RemoveUnusedLibrary(refModule, orderEntry, files)}));
                    continue;
                }
                this.addProblemElement((RefEntity)refModule, manager.createProblemDescriptor(InspectionsBundle.message((String)"unused.library.problem.descriptor", (Object[])new Object[]{orderEntry.getPresentableName()}), new QuickFix[]{new RemoveUnusedLibrary(refModule, orderEntry, null)}));
            }
        }
    }

    @Override
    public boolean isGraphNeeded() {
        return false;
    }

    @Override
    @NotNull
    public JobDescriptor[] getJobDescriptors() {
        JobDescriptor[] jobDescriptorArray = new JobDescriptor[]{BACKWARD_ANALYSIS};
        if (jobDescriptorArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/unusedLibraries/UnusedLibrariesInspection.getJobDescriptors must not return null");
        }
        return jobDescriptorArray;
    }

    @Override
    public boolean isEnabledByDefault() {
        return false;
    }

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.DECLARATION_REDUNDANCY;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/unusedLibraries/UnusedLibrariesInspection.getGroupDisplayName must not return null");
        }
        return string;
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionsBundle.message((String)"unused.library.display.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/unusedLibraries/UnusedLibrariesInspection.getDisplayName must not return null");
        }
        return string;
    }

    @NonNls
    @NotNull
    public String getShortName() {
        if ("UnusedLibrary" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/unusedLibraries/UnusedLibrariesInspection.getShortName must not return null");
        }
        return "UnusedLibrary";
    }

    private static class RemoveUnusedLibrary
    implements QuickFix {
        private final RefModule myRefModule;
        private final OrderEntry myOrderEntry;
        private final Set<VirtualFile> myFiles;

        public RemoveUnusedLibrary(RefModule refModule, OrderEntry orderEntry, Set<VirtualFile> files) {
            this.myRefModule = refModule;
            this.myOrderEntry = orderEntry;
            this.myFiles = files;
        }

        @NotNull
        public String getName() {
            String string = this.myFiles == null ? InspectionsBundle.message((String)"detach.library.quickfix.name", (Object[])new Object[0]) : InspectionsBundle.message((String)"detach.library.roots.quickfix.name", (Object[])new Object[0]);
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/intellij/codeInspection/unusedLibraries/UnusedLibrariesInspection$RemoveUnusedLibrary.getName must not return null");
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/intellij/codeInspection/unusedLibraries/UnusedLibrariesInspection$RemoveUnusedLibrary.getFamilyName must not return null");
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull CommonProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/unusedLibraries/UnusedLibrariesInspection$RemoveUnusedLibrary.applyFix must not be null");
            }
            if (descriptor == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInspection/unusedLibraries/UnusedLibrariesInspection$RemoveUnusedLibrary.applyFix must not be null");
            }
            final Module module = this.myRefModule.getModule();
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    ModifiableRootModel model = ModuleRootManager.getInstance((Module)module).getModifiableModel();
                    for (OrderEntry entry : model.getOrderEntries()) {
                        if (!(entry instanceof LibraryOrderEntry) || !Comparing.strEqual((String)entry.getPresentableName(), (String)RemoveUnusedLibrary.this.myOrderEntry.getPresentableName())) continue;
                        if (RemoveUnusedLibrary.this.myFiles == null) {
                            model.removeOrderEntry(entry);
                            continue;
                        }
                        Library library = ((LibraryOrderEntry)entry).getLibrary();
                        if (library == null) continue;
                        Library.ModifiableModel modifiableModel = library.getModifiableModel();
                        for (VirtualFile file : RemoveUnusedLibrary.this.myFiles) {
                            modifiableModel.removeRoot(file.getUrl(), OrderRootType.CLASSES);
                        }
                        modifiableModel.commit();
                    }
                    model.commit();
                }
            });
        }
    }
}

