/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui.actions;

import com.intellij.CommonBundle;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ModifiableModel;
import com.intellij.codeInspection.actions.RunInspectionIntention;
import com.intellij.codeInspection.ex.DisableInspectionToolAction;
import com.intellij.codeInspection.ex.InspectionManagerEx;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionTool;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.ui.InspectionResultsView;
import com.intellij.codeInspection.ui.InspectionTree;
import com.intellij.codeInspection.ui.actions.SuppressActionWrapper;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.IconLoader;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class InspectionsOptionsToolbarAction
extends AnAction {
    private static final Logger LOG = Logger.getInstance((String)"com.intellij.codeInspection.ui.actions.SuppressInspectionToolbarAction");
    private final InspectionResultsView myView;

    public InspectionsOptionsToolbarAction(InspectionResultsView view) {
        super(InspectionsOptionsToolbarAction.getToolOptions(null), InspectionsOptionsToolbarAction.getToolOptions(null), IconLoader.getIcon((String)"/general/inspectionsOff.png"));
        this.myView = view;
    }

    public void actionPerformed(AnActionEvent e) {
        DefaultActionGroup options = new DefaultActionGroup();
        List<AnAction> actions = this.createActions();
        for (AnAction action : actions) {
            options.add(action);
        }
        DataContext dataContext = e.getDataContext();
        ListPopup popup = JBPopupFactory.getInstance().createActionGroupPopup(this.getSelectedTool().getDisplayName(), (ActionGroup)options, dataContext, JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, false);
        InspectionResultsView.showPopup(e, (JBPopup)popup);
    }

    @Nullable
    private InspectionTool getSelectedTool() {
        return this.myView.getTree().getSelectedTool();
    }

    public void update(AnActionEvent e) {
        if (!this.myView.isSingleToolInSelection()) {
            e.getPresentation().setEnabled(false);
            return;
        }
        InspectionTool selectedTool = this.getSelectedTool();
        assert (selectedTool != null);
        HighlightDisplayKey key = HighlightDisplayKey.find((String)selectedTool.getShortName());
        if (key == null) {
            e.getPresentation().setEnabled(false);
        }
        e.getPresentation().setEnabled(true);
        String text = InspectionsOptionsToolbarAction.getToolOptions(selectedTool);
        e.getPresentation().setText(text);
        e.getPresentation().setDescription(text);
    }

    private static String getToolOptions(@Nullable InspectionTool selectedTool) {
        return InspectionsBundle.message((String)"inspections.view.options.title", (Object[])new Object[]{selectedTool != null ? selectedTool.getDisplayName() : ""});
    }

    public List<AnAction> createActions() {
        ArrayList<AnAction> result = new ArrayList<AnAction>();
        final InspectionTree tree = this.myView.getTree();
        final InspectionTool tool = tree.getSelectedTool();
        if (tool == null) {
            return result;
        }
        HighlightDisplayKey key = HighlightDisplayKey.find((String)tool.getShortName());
        if (key == null) {
            return result;
        }
        result.add(new DisableInspectionAction(key));
        result.add(new AnAction(InspectionsBundle.message((String)"run.inspection.on.file.intention.text", (Object[])new Object[0])){

            public void actionPerformed(AnActionEvent e) {
                RefEntity[] selectedElements = tree.getSelectedElements();
                PsiElement psiElement = selectedElements.length > 0 && selectedElements[0] instanceof RefElement ? ((RefElement)selectedElements[0]).getElement() : null;
                RunInspectionIntention.rerunInspection(tool, (InspectionManagerEx)InspectionManagerEx.getInstance((Project)InspectionsOptionsToolbarAction.this.myView.getProject()), InspectionsOptionsToolbarAction.this.myView.getScope(), psiElement);
            }
        });
        result.add((AnAction)new SuppressActionWrapper(this.myView.getProject(), tool, tree.getSelectionPaths()));
        return result;
    }

    private class DisableInspectionAction
    extends AnAction {
        private final HighlightDisplayKey myKey;

        public DisableInspectionAction(HighlightDisplayKey key) {
            super(DisableInspectionToolAction.NAME);
            this.myKey = key;
        }

        public void actionPerformed(AnActionEvent e) {
            try {
                if (InspectionsOptionsToolbarAction.this.myView.isProfileDefined()) {
                    ModifiableModel model = InspectionsOptionsToolbarAction.this.myView.getCurrentProfile().getModifiableModel();
                    model.disableTool(this.myKey.toString());
                    model.commit();
                    InspectionsOptionsToolbarAction.this.myView.updateCurrentProfile();
                } else {
                    RefEntity[] selectedElements = InspectionsOptionsToolbarAction.this.myView.getTree().getSelectedElements();
                    HashSet<PsiElement> files = new HashSet<PsiElement>();
                    Project project = InspectionsOptionsToolbarAction.this.myView.getProject();
                    InspectionProjectProfileManager profileManager = InspectionProjectProfileManager.getInstance(project);
                    for (RefEntity selectedElement : selectedElements) {
                        if (!(selectedElement instanceof RefElement)) continue;
                        PsiElement element = ((RefElement)selectedElement).getElement();
                        files.add(element);
                    }
                    ModifiableModel model = ((InspectionProfileImpl)profileManager.getProjectProfileImpl()).getModifiableModel();
                    for (PsiElement element : files) {
                        model.disableTool(this.myKey.toString(), element);
                    }
                    model.commit();
                    DaemonCodeAnalyzer.getInstance((Project)project).restart();
                }
            }
            catch (IOException e1) {
                Messages.showErrorDialog((Project)InspectionsOptionsToolbarAction.this.myView.getProject(), (String)e1.getMessage(), (String)CommonBundle.getErrorTitle());
            }
        }
    }
}

