/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.reference;

import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefEntityImpl;
import com.intellij.codeInspection.reference.RefJavaManager;
import com.intellij.codeInspection.reference.RefJavaVisitor;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefPackage;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.util.Icons;
import javax.swing.Icon;

public class RefPackageImpl
extends RefEntityImpl
implements RefPackage {
    private final String myQualifiedName;

    public RefPackageImpl(String name, RefManager refManager) {
        super(RefPackageImpl.getPackageSuffix(name), refManager);
        this.myQualifiedName = name;
    }

    @Override
    public String getQualifiedName() {
        return this.myQualifiedName;
    }

    private static String getPackageSuffix(String fullName) {
        int dotIndex = fullName.lastIndexOf(46);
        return dotIndex >= 0 ? fullName.substring(dotIndex + 1) : fullName;
    }

    @Override
    public void accept(final RefVisitor visitor) {
        if (visitor instanceof RefJavaVisitor) {
            ApplicationManager.getApplication().runReadAction(new Runnable(){

                @Override
                public void run() {
                    ((RefJavaVisitor)visitor).visitPackage((RefPackage)RefPackageImpl.this);
                }
            });
        } else {
            super.accept(visitor);
        }
    }

    @Override
    public String getExternalName() {
        return this.getQualifiedName();
    }

    public static RefEntity packageFromFQName(RefManager manager, String name) {
        return ((RefJavaManager)manager.getExtension(RefJavaManager.MANAGER)).getPackage(name);
    }

    public boolean isValid() {
        return true;
    }

    public Icon getIcon(boolean expanded) {
        return expanded ? Icons.PACKAGE_OPEN_ICON : Icons.PACKAGE_ICON;
    }
}

