/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.analysis.AnalysisScope;
import com.intellij.analysis.AnalysisUIOptions;
import com.intellij.analysis.PerformAnalysisInBackgroundOption;
import com.intellij.codeInsight.daemon.impl.LocalInspectionsPass;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ex.GlobalInspectionToolWrapper;
import com.intellij.codeInspection.ex.InspectionManagerEx;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionRVContentProviderImpl;
import com.intellij.codeInspection.ex.InspectionTool;
import com.intellij.codeInspection.ex.JobDescriptor;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.codeInspection.ex.ScopeToolState;
import com.intellij.codeInspection.ex.Tools;
import com.intellij.codeInspection.ex.ToolsImpl;
import com.intellij.codeInspection.lang.GlobalInspectionContextExtension;
import com.intellij.codeInspection.lang.InspectionExtensionsFactory;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefElementImpl;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefManagerImpl;
import com.intellij.codeInspection.ui.InspectionResultsView;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.ProgressManagerImpl;
import com.intellij.openapi.progress.util.ProgressWrapper;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.profile.Profile;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerAdapter;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.util.containers.HashMap;
import gnu.trove.THashMap;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class GlobalInspectionContextImpl
implements GlobalInspectionContext {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.ex.GlobalInspectionContextImpl");
    private RefManager myRefManager;
    private final NotNullLazyValue<ContentManager> myContentManager;
    private AnalysisScope myCurrentScope;
    private final Project myProject;
    private List<JobDescriptor> myJobDescriptors;
    private InspectionResultsView myView = null;
    private Content myContent = null;
    private ProgressIndicator myProgressIndicator;
    public static final JobDescriptor BUILD_GRAPH = new JobDescriptor(InspectionsBundle.message((String)"inspection.processing.job.descriptor", (Object[])new Object[0]));
    public static final JobDescriptor FIND_EXTERNAL_USAGES = new JobDescriptor(InspectionsBundle.message((String)"inspection.processing.job.descriptor1", (Object[])new Object[0]));
    private static final JobDescriptor LOCAL_ANALYSIS = new JobDescriptor(InspectionsBundle.message((String)"inspection.processing.job.descriptor2", (Object[])new Object[0]));
    private InspectionProfile myExternalProfile = null;
    private final Map<Key, GlobalInspectionContextExtension> myExtensions = new HashMap();
    private boolean RUN_GLOBAL_TOOLS_ONLY = false;
    private final Map<String, Tools> myTools = new THashMap();
    private final AnalysisUIOptions myUIOptions;

    public GlobalInspectionContextImpl(Project project, NotNullLazyValue<ContentManager> contentManager) {
        this.myProject = project;
        this.myUIOptions = AnalysisUIOptions.getInstance(this.myProject).copy();
        this.myRefManager = null;
        this.myCurrentScope = null;
        this.myContentManager = contentManager;
        for (InspectionExtensionsFactory factory : (InspectionExtensionsFactory[])Extensions.getExtensions((ExtensionPointName)InspectionExtensionsFactory.EP_NAME)) {
            GlobalInspectionContextExtension extension = factory.createGlobalInspectionContextExtension();
            this.myExtensions.put(extension.getID(), extension);
        }
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/ex/GlobalInspectionContextImpl.getProject must not return null");
        }
        return project;
    }

    public <T> T getExtension(Key<T> key) {
        return (T)this.myExtensions.get(key);
    }

    public ContentManager getContentManager() {
        return (ContentManager)this.myContentManager.getValue();
    }

    public InspectionProfile getCurrentProfile() {
        if (this.myExternalProfile != null) {
            return this.myExternalProfile;
        }
        InspectionManagerEx managerEx = (InspectionManagerEx)InspectionManager.getInstance((Project)this.myProject);
        InspectionProjectProfileManager inspectionProfileManager = InspectionProjectProfileManager.getInstance(this.myProject);
        Profile profile = inspectionProfileManager.getProfile(managerEx.getCurrentProfile(), false);
        if (profile == null) {
            profile = InspectionProfileManager.getInstance().getProfile(managerEx.getCurrentProfile());
            if (profile != null) {
                return (InspectionProfile)profile;
            }
            String[] avaliableProfileNames = inspectionProfileManager.getAvailableProfileNames();
            if (avaliableProfileNames == null || avaliableProfileNames.length == 0) {
                return null;
            }
            profile = inspectionProfileManager.getProfile(avaliableProfileNames[0]);
        }
        return (InspectionProfile)profile;
    }

    public boolean isSuppressed(RefEntity entity, String id) {
        return entity instanceof RefElementImpl && ((RefElementImpl)entity).isSuppressed(id);
    }

    public boolean shouldCheck(RefEntity entity, GlobalInspectionTool tool) {
        if (entity instanceof RefElementImpl) {
            RefElementImpl refElement = (RefElementImpl)entity;
            if (refElement.isSuppressed(tool.getShortName())) {
                return false;
            }
            PsiFile file = refElement.getContainingFile();
            if (file == null) {
                return false;
            }
            Tools tools = this.myTools.get(tool.getShortName());
            for (ScopeToolState state : tools.getTools()) {
                NamedScope namedScope = state.getScope();
                if (namedScope != null && !namedScope.getValue().contains(file, this.getCurrentProfile().getProfileManager().getScopesManager())) continue;
                return state.isEnabled() && ((GlobalInspectionToolWrapper)state.getTool()).getTool() == tool;
            }
            return false;
        }
        return true;
    }

    public boolean isSuppressed(PsiElement element, String id) {
        RefManagerImpl refManager = (RefManagerImpl)this.getRefManager();
        if (refManager.isDeclarationsFound()) {
            RefElement refElement = refManager.getReference(element);
            return refElement instanceof RefElementImpl && ((RefElementImpl)refElement).isSuppressed(id);
        }
        return InspectionManagerEx.isSuppressed(element, id);
    }

    public void addView(InspectionResultsView view, String title) {
        ((ContentManager)this.myContentManager.getValue()).addContentManagerListener((ContentManagerListener)new ContentManagerAdapter(){

            public void contentRemoved(ContentManagerEvent event) {
                if (event.getContent() == GlobalInspectionContextImpl.this.myContent) {
                    if (GlobalInspectionContextImpl.this.myView != null) {
                        GlobalInspectionContextImpl.this.close(false);
                    }
                    GlobalInspectionContextImpl.this.myContent = null;
                }
            }
        });
        this.myView = view;
        ContentManager contentManager = this.getContentManager();
        this.myContent = ContentFactory.SERVICE.getInstance().createContent((JComponent)view, title, false);
        this.myContent.setDisposer((Disposable)this.myView);
        contentManager.addContent(this.myContent);
        contentManager.setSelectedContent(this.myContent);
        ToolWindowManager.getInstance((Project)this.myProject).getToolWindow(ToolWindowId.INSPECTION).activate(null);
    }

    private void addView(InspectionResultsView view) {
        this.addView(view, view.getCurrentProfileName() == null ? InspectionsBundle.message((String)"inspection.results.title", (Object[])new Object[0]) : InspectionsBundle.message((String)"inspection.results.for.profile.toolwindow.title", (Object[])new Object[]{view.getCurrentProfileName()}));
    }

    private void cleanup() {
        this.myProgressIndicator = null;
        for (GlobalInspectionContextExtension extension : this.myExtensions.values()) {
            extension.cleanup();
        }
        for (Tools tools : this.myTools.values()) {
            for (ScopeToolState state : tools.getTools()) {
                ((InspectionTool)state.getTool()).cleanup();
            }
        }
        this.myTools.clear();
        if (this.myRefManager != null) {
            ((RefManagerImpl)this.myRefManager).cleanup();
            this.myRefManager = null;
            if (this.myCurrentScope != null) {
                this.myCurrentScope.invalidate();
                this.myCurrentScope = null;
            }
        }
    }

    public void setCurrentScope(AnalysisScope currentScope) {
        this.myCurrentScope = currentScope;
    }

    public void doInspections(final AnalysisScope scope, final InspectionManager manager) {
        if (!InspectionManagerEx.canRunInspections(this.myProject, true)) {
            return;
        }
        this.cleanup();
        if (this.myContent != null) {
            this.getContentManager().removeContent(this.myContent, true);
        }
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                GlobalInspectionContextImpl.this.myCurrentScope = scope;
                GlobalInspectionContextImpl.this.launchInspections(scope, manager);
            }
        });
    }

    @NotNull
    public RefManager getRefManager() {
        if (this.myRefManager == null) {
            this.myRefManager = (RefManager)ApplicationManager.getApplication().runReadAction((Computable)new Computable<RefManagerImpl>(){

                public RefManagerImpl compute() {
                    return new RefManagerImpl(GlobalInspectionContextImpl.this.myProject, GlobalInspectionContextImpl.this.myCurrentScope, GlobalInspectionContextImpl.this);
                }
            });
        }
        RefManager refManager = this.myRefManager;
        if (refManager == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/ex/GlobalInspectionContextImpl.getRefManager must not return null");
        }
        return refManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void launchInspectionsOffline(final AnalysisScope scope, final String outputPath, boolean runWithEditorSettings, boolean runGlobalToolsOnly, final InspectionManager manager) {
        this.cleanup();
        this.myCurrentScope = scope;
        InspectionTool.setOutputPath(outputPath);
        boolean oldToolsSettings = this.RUN_GLOBAL_TOOLS_ONLY;
        this.RUN_GLOBAL_TOOLS_ONLY = runGlobalToolsOnly;
        try {
            ApplicationManager.getApplication().runReadAction(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    GlobalInspectionContextImpl.this.performInspectionsWithProgress(scope, manager);
                    String ext = ".xml";
                    for (Map.Entry stringSetEntry : GlobalInspectionContextImpl.this.myTools.entrySet()) {
                        Element root = new Element(InspectionsBundle.message((String)"inspection.problems", (Object[])new Object[0]));
                        org.jdom.Document doc = new org.jdom.Document(root);
                        Tools sameTools = (Tools)stringSetEntry.getValue();
                        boolean hasProblems = false;
                        boolean isLocalTool = false;
                        String toolName = (String)stringSetEntry.getKey();
                        if (sameTools != null) {
                            for (ScopeToolState toolDescr : sameTools.getTools()) {
                                InspectionTool tool = (InspectionTool)toolDescr.getTool();
                                if (tool instanceof LocalInspectionToolWrapper) {
                                    hasProblems = new File(outputPath, toolName + ".xml").exists();
                                    isLocalTool = true;
                                    continue;
                                }
                                tool.updateContent();
                                if (!tool.hasReportedProblems()) continue;
                                hasProblems = true;
                                tool.exportResults(root);
                            }
                        }
                        if (!hasProblems) continue;
                        String isLocalToolAttribute = "is_local_tool";
                        root.setAttribute("is_local_tool", String.valueOf(isLocalTool));
                        OutputStream outStream = null;
                        try {
                            new File(outputPath).mkdirs();
                            File file = new File(outputPath, toolName + ".xml");
                            if (isLocalTool) {
                                outStream = new BufferedOutputStream(new FileOutputStream(file, true));
                                outStream.write(("</" + InspectionsBundle.message((String)"inspection.problems", (Object[])new Object[0]) + ">").getBytes());
                                continue;
                            }
                            PathMacroManager.getInstance((ComponentManager)GlobalInspectionContextImpl.this.getProject()).collapsePaths(doc.getRootElement());
                            outStream = new BufferedOutputStream(new FileOutputStream(file));
                            JDOMUtil.writeDocument((org.jdom.Document)doc, (OutputStream)outStream, (String)"\n");
                        }
                        catch (IOException e) {
                            LOG.error((Throwable)e);
                        }
                        finally {
                            if (outStream == null) continue;
                            try {
                                outStream.close();
                            }
                            catch (IOException e) {
                                LOG.error((Throwable)e);
                            }
                        }
                    }
                }
            });
        }
        finally {
            InspectionTool.setOutputPath(null);
            this.RUN_GLOBAL_TOOLS_ONLY = oldToolsSettings;
        }
    }

    public boolean isToCheckMember(@NotNull RefElement owner, InspectionTool tool) {
        if (owner == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/ex/GlobalInspectionContextImpl.isToCheckMember must not be null");
        }
        PsiElement element = owner.getElement();
        return this.isToCheckMember(element, tool) && !((RefElementImpl)owner).isSuppressed(tool.getShortName());
    }

    public boolean isToCheckMember(PsiElement element, InspectionTool tool) {
        Tools tools = this.myTools.get(tool.getShortName());
        for (ScopeToolState state : tools.getTools()) {
            NamedScope namedScope = state.getScope();
            if (namedScope != null && !namedScope.getValue().contains(element.getContainingFile(), this.getCurrentProfile().getProfileManager().getScopesManager())) continue;
            return state.isEnabled() && state.getTool() == tool;
        }
        return false;
    }

    public void ignoreElement(InspectionTool tool, PsiElement element) {
        RefElement refElement = this.getRefManager().getReference(element);
        Tools tools = this.myTools.get(tool.getShortName());
        if (tools != null) {
            for (ScopeToolState state : tools.getTools()) {
                GlobalInspectionContextImpl.ignoreElementRecursively((InspectionTool)state.getTool(), (RefEntity)refElement);
            }
        }
    }

    private static void ignoreElementRecursively(InspectionTool tool, RefEntity refElement) {
        if (refElement != null) {
            tool.ignoreCurrentElement(refElement);
            List children = refElement.getChildren();
            if (children != null) {
                for (RefEntity child : children) {
                    GlobalInspectionContextImpl.ignoreElementRecursively(tool, child);
                }
            }
        }
    }

    public AnalysisUIOptions getUIOptions() {
        return this.myUIOptions;
    }

    public void setSplitterProportion(float proportion) {
        this.myUIOptions.SPLITTER_PROPORTION = proportion;
    }

    public ToggleAction createToggleAutoscrollAction() {
        return this.myUIOptions.getAutoScrollToSourceHandler().createToggleAction();
    }

    private void launchInspections(final AnalysisScope scope, final InspectionManager manager) {
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                PsiDocumentManager.getInstance((Project)GlobalInspectionContextImpl.this.myProject).commitAllDocuments();
            }
        });
        LOG.info("Code inspection started");
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(this.getProject(), InspectionsBundle.message((String)"inspection.progress.title", (Object[])new Object[0]), true, new PerformAnalysisInBackgroundOption(this.myProject)){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/ex/GlobalInspectionContextImpl$6.run must not be null");
                }
                GlobalInspectionContextImpl.this.performInspectionsWithProgress(scope, manager);
            }

            public void onSuccess() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        LOG.info("Code inspection finished");
                        InspectionResultsView view = new InspectionResultsView(myProject, GlobalInspectionContextImpl.this.getCurrentProfile(), scope, GlobalInspectionContextImpl.this, new InspectionRVContentProviderImpl(myProject));
                        if (!view.update() && !GlobalInspectionContextImpl.this.getUIOptions().SHOW_ONLY_DIFF) {
                            Messages.showMessageDialog((Project)myProject, (String)InspectionsBundle.message((String)"inspection.no.problems.message", (Object[])new Object[0]), (String)InspectionsBundle.message((String)"inspection.no.problems.dialog.title", (Object[])new Object[0]), (Icon)Messages.getInformationIcon());
                            GlobalInspectionContextImpl.this.close(true);
                        } else {
                            GlobalInspectionContextImpl.this.addView(view);
                        }
                    }
                });
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performInspectionsWithProgress(final AnalysisScope scope, final InspectionManager manager) {
        PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
        this.myProgressIndicator = ProgressManager.getInstance().getProgressIndicator();
        RefManagerImpl refManager = (RefManagerImpl)this.getRefManager();
        try {
            psiManager.startBatchFilesProcessingMode();
            refManager.inspectionReadActionStarted();
            BUILD_GRAPH.setTotalAmount(scope.getFileCount());
            LOCAL_ANALYSIS.setTotalAmount(scope.getFileCount());
            final ArrayList needRepeatSearchRequest = new ArrayList();
            ((ProgressManagerImpl)ProgressManager.getInstance()).executeProcessUnderProgress(new Runnable(){

                @Override
                public void run() {
                    GlobalInspectionContextImpl.this.runTools(needRepeatSearchRequest, scope, manager);
                }
            }, ProgressWrapper.wrap(this.myProgressIndicator));
        }
        catch (ProcessCanceledException e) {
            this.cleanup((InspectionManagerEx)manager);
            throw e;
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
        finally {
            refManager.inspectionReadActionFinished();
            psiManager.finishBatchFilesProcessingMode();
        }
    }

    private void runTools(List<InspectionProfileEntry> needRepeatSearchRequest, AnalysisScope scope, final InspectionManager manager) {
        ArrayList<Tools> globalTools = new ArrayList<Tools>();
        final ArrayList<Tools> localTools = new ArrayList<Tools>();
        this.initializeTools(globalTools, localTools);
        ((RefManagerImpl)this.getRefManager()).initializeAnnotators();
        for (Tools tools : globalTools) {
            for (ScopeToolState state : tools.getTools()) {
                InspectionTool tool = (InspectionTool)state.getTool();
                try {
                    if (tool.isGraphNeeded()) {
                        ((RefManagerImpl)tool.getRefManager()).findAllDeclarations();
                    }
                    tool.runInspection(scope, manager);
                    if (!tool.queryExternalUsagesRequests(manager)) continue;
                    needRepeatSearchRequest.add(tool);
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (Exception e) {
                    LOG.error((Throwable)e);
                }
            }
        }
        for (GlobalInspectionContextExtension extension : this.myExtensions.values()) {
            try {
                extension.performPostRunActivities(needRepeatSearchRequest, (GlobalInspectionContext)this);
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
        if (this.RUN_GLOBAL_TOOLS_ONLY) {
            return;
        }
        final PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
        scope.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(){

            public void visitFile(PsiFile file) {
                FileViewProvider viewProvider;
                Document document;
                VirtualFile virtualFile = file.getVirtualFile();
                if (virtualFile != null) {
                    GlobalInspectionContextImpl.this.incrementJobDoneAmount(LOCAL_ANALYSIS, ProjectUtil.calcRelativeToProjectPath((VirtualFile)virtualFile, (Project)GlobalInspectionContextImpl.this.myProject));
                    if (SingleRootFileViewProvider.isTooLarge(virtualFile)) {
                        return;
                    }
                }
                Document document2 = document = (viewProvider = psiManager.findViewProvider(virtualFile)) == null ? null : viewProvider.getDocument();
                if (document == null || virtualFile.getFileType().isBinary()) {
                    return;
                }
                LocalInspectionsPass pass = new LocalInspectionsPass(file, document, 0, file.getTextLength());
                try {
                    ArrayList<InspectionProfileEntry> lTools = new ArrayList<InspectionProfileEntry>();
                    for (Tools tool : localTools) {
                        InspectionTool enabledTool = (InspectionTool)tool.getEnabledTool((PsiElement)file);
                        if (enabledTool == null) continue;
                        lTools.add(enabledTool);
                    }
                    pass.doInspectInBatch((InspectionManagerEx)manager, lTools, true);
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (Exception e) {
                    LOG.error((Throwable)e);
                }
            }
        });
    }

    public void initializeTools(List<Tools> globalTools, List<Tools> localTools) {
        this.myJobDescriptors = new ArrayList<JobDescriptor>();
        InspectionProfileImpl profile = new InspectionProfileImpl((InspectionProfileImpl)this.getCurrentProfile());
        List<ToolsImpl> usedTools = profile.getAllEnabledInspectionTools();
        for (ToolsImpl currentTools : usedTools) {
            String shortName = currentTools.getShortName();
            this.myTools.put(shortName, currentTools);
            InspectionTool tool = (InspectionTool)currentTools.getTool();
            if (tool instanceof LocalInspectionToolWrapper) {
                localTools.add(currentTools);
                this.appendJobDescriptor(LOCAL_ANALYSIS);
            } else {
                JobDescriptor[] jobDescriptors;
                globalTools.add(currentTools);
                for (JobDescriptor jobDescriptor : jobDescriptors = tool.getJobDescriptors()) {
                    this.appendJobDescriptor(jobDescriptor);
                }
            }
            for (ScopeToolState state : currentTools.getTools()) {
                ((InspectionTool)state.getTool()).initialize(this);
            }
        }
        for (GlobalInspectionContextExtension extension : this.myExtensions.values()) {
            extension.performPreRunActivities(globalTools, localTools, (GlobalInspectionContext)this);
        }
    }

    public Map<String, Tools> getTools() {
        return this.myTools;
    }

    private void appendJobDescriptor(JobDescriptor job) {
        if (!this.myJobDescriptors.contains(job)) {
            this.myJobDescriptors.add(job);
            job.setDoneAmount(0);
        }
    }

    public void close(boolean noSuspisiousCodeFound) {
        ContentManager contentManager;
        if (!noSuspisiousCodeFound && (this.myView == null || this.myView.isRerun())) {
            return;
        }
        InspectionManagerEx managerEx = (InspectionManagerEx)InspectionManager.getInstance((Project)this.myProject);
        this.cleanup(managerEx);
        AnalysisUIOptions.getInstance(this.myProject).save(this.myUIOptions);
        if (this.myContent != null && (contentManager = this.getContentManager()) != null) {
            contentManager.removeContent(this.myContent, true);
        }
        this.myView = null;
    }

    public void cleanup(InspectionManagerEx managerEx) {
        managerEx.closeRunningContext(this);
        for (Tools tools : this.myTools.values()) {
            for (ScopeToolState state : tools.getTools()) {
                ((InspectionTool)state.getTool()).finalCleanup();
            }
        }
        this.cleanup();
    }

    public void refreshViews() {
        if (this.myView != null) {
            this.myView.updateView(false);
        }
    }

    public void incrementJobDoneAmount(JobDescriptor job, String message) {
        if (this.myProgressIndicator == null) {
            return;
        }
        ProgressManager.checkCanceled();
        int old = job.getDoneAmount();
        job.setDoneAmount(old + 1);
        int jobCount = this.myJobDescriptors.size();
        float totalProgress = 0.0f;
        for (JobDescriptor jobDescriptor : this.myJobDescriptors) {
            totalProgress += jobDescriptor.getProgress();
        }
        this.myProgressIndicator.setFraction((double)(totalProgress /= (float)jobCount));
        this.myProgressIndicator.setText(job.getDisplayName() + " " + message);
    }

    public void setExternalProfile(InspectionProfile profile) {
        this.myExternalProfile = profile;
    }
}

