/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.DataFlowRunner;
import com.intellij.codeInspection.dataFlow.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.DfaVariableState;
import com.intellij.codeInspection.dataFlow.RunnerResult;
import com.intellij.codeInspection.dataFlow.StandardInstructionVisitor;
import com.intellij.codeInspection.dataFlow.ValuableDataFlowRunner;
import com.intellij.codeInspection.dataFlow.instructions.AssignInstruction;
import com.intellij.codeInspection.dataFlow.instructions.Instruction;
import com.intellij.codeInspection.dataFlow.instructions.PushInstruction;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.MultiValuesMap;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DfaUtil {
    private static final Key<CachedValue<MultiValuesMap<PsiVariable, PsiExpression>>> DFA_VARIABLE_INFO_KEY = Key.create((String)"DFA_VARIABLE_INFO_KEY");
    private static final MultiValuesMap<PsiVariable, PsiExpression> TOO_COMPLEX = new MultiValuesMap();

    private DfaUtil() {
    }

    @Nullable(value="null means DFA analysis has failed (too complex to analyze)")
    public static Collection<PsiExpression> getCachedVariableValues(@Nullable PsiVariable variable, final @Nullable PsiElement context) {
        MultiValuesMap value;
        if (variable == null || context == null) {
            return Collections.emptyList();
        }
        CachedValue cachedValue = (CachedValue)context.getUserData(DFA_VARIABLE_INFO_KEY);
        if (cachedValue == null) {
            final PsiElement codeBlock = DfaUtil.getEnclosingCodeBlock(variable, context);
            cachedValue = CachedValuesManager.getManager((Project)context.getProject()).createCachedValue((CachedValueProvider)new CachedValueProvider<MultiValuesMap<PsiVariable, PsiExpression>>(){

                public CachedValueProvider.Result<MultiValuesMap<PsiVariable, PsiExpression>> compute() {
                    ValuableInstructionVisitor visitor;
                    MultiValuesMap<PsiVariable, PsiExpression> result = codeBlock == null ? null : (new ValuableDataFlowRunner().analyzeMethod(codeBlock, visitor = new ValuableInstructionVisitor(context)) == RunnerResult.OK ? visitor.myValues : TOO_COMPLEX);
                    return new CachedValueProvider.Result(result, new Object[]{codeBlock});
                }
            }, false);
            context.putUserData(DFA_VARIABLE_INFO_KEY, (Object)cachedValue);
        }
        if ((value = (MultiValuesMap)cachedValue.getValue()) == TOO_COMPLEX) {
            return null;
        }
        Collection expressions = value == null ? null : value.get((Object)variable);
        return expressions == null ? Collections.emptyList() : expressions;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static Nullness checkNullness(@Nullable PsiVariable variable, @Nullable PsiElement context) {
        Nullness nullness;
        if (variable == null || context == null) {
            nullness = Nullness.UNKNOWN;
            if (nullness == null) throw new IllegalStateException("@NotNull method com/intellij/codeInspection/dataFlow/DfaUtil.checkNullness must not return null");
            return nullness;
        }
        PsiElement codeBlock = DfaUtil.getEnclosingCodeBlock(variable, context);
        if (codeBlock == null) {
            nullness = Nullness.UNKNOWN;
            if (nullness == null) throw new IllegalStateException("@NotNull method com/intellij/codeInspection/dataFlow/DfaUtil.checkNullness must not return null");
            return nullness;
        }
        ValuableInstructionVisitor visitor = new ValuableInstructionVisitor(context);
        RunnerResult result = new ValuableDataFlowRunner().analyzeMethod(codeBlock, visitor);
        if (result != RunnerResult.OK) {
            nullness = Nullness.UNKNOWN;
            if (nullness == null) throw new IllegalStateException("@NotNull method com/intellij/codeInspection/dataFlow/DfaUtil.checkNullness must not return null");
            return nullness;
        }
        if (visitor.myNulls.contains(variable) && !visitor.myNotNulls.contains(variable)) {
            nullness = Nullness.NULL;
            if (nullness == null) throw new IllegalStateException("@NotNull method com/intellij/codeInspection/dataFlow/DfaUtil.checkNullness must not return null");
            return nullness;
        }
        if (visitor.myNotNulls.contains(variable) && !visitor.myNulls.contains(variable)) {
            nullness = Nullness.NOT_NULL;
            if (nullness == null) throw new IllegalStateException("@NotNull method com/intellij/codeInspection/dataFlow/DfaUtil.checkNullness must not return null");
            return nullness;
        }
        nullness = Nullness.UNKNOWN;
        if (nullness != null) return nullness;
        throw new IllegalStateException("@NotNull method com/intellij/codeInspection/dataFlow/DfaUtil.checkNullness must not return null");
    }

    @Nullable
    public static PsiCodeBlock getTopmostBlockInSameClass(@NotNull PsiElement position) {
        if (position == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/dataFlow/DfaUtil.getTopmostBlockInSameClass must not be null");
        }
        PsiCodeBlock block = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)position, PsiCodeBlock.class, (boolean)false, (Class[])new Class[]{PsiMember.class, PsiFile.class});
        if (block == null) {
            return null;
        }
        PsiCodeBlock lastBlock = block;
        while ((block = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)block, PsiCodeBlock.class, (boolean)true, (Class[])new Class[]{PsiMember.class, PsiFile.class})) != null) {
            lastBlock = block;
        }
        return lastBlock;
    }

    private static PsiElement getEnclosingCodeBlock(PsiVariable variable, PsiElement context) {
        PsiAnonymousClass anon;
        PsiElement codeBlock;
        if (variable instanceof PsiParameter) {
            codeBlock = ((PsiParameter)variable).getDeclarationScope();
            if (codeBlock instanceof PsiMethod) {
                codeBlock = ((PsiMethod)codeBlock).getBody();
            }
        } else {
            codeBlock = variable instanceof PsiLocalVariable ? PsiTreeUtil.getParentOfType((PsiElement)variable, PsiCodeBlock.class) : PsiTreeUtil.getParentOfType((PsiElement)context, PsiCodeBlock.class);
        }
        while (codeBlock != null && (anon = (PsiAnonymousClass)PsiTreeUtil.getParentOfType((PsiElement)codeBlock, PsiAnonymousClass.class)) != null) {
            codeBlock = PsiTreeUtil.getParentOfType((PsiElement)anon, PsiCodeBlock.class);
        }
        return codeBlock;
    }

    public static Collection<? extends PsiElement> getPossibleInitializationElements(PsiElement qualifierExpression) {
        if (qualifierExpression instanceof PsiMethodCallExpression) {
            return Collections.singletonList(qualifierExpression);
        }
        if (qualifierExpression instanceof PsiReferenceExpression) {
            PsiElement targetElement = ((PsiReferenceExpression)qualifierExpression).resolve();
            if (targetElement instanceof PsiVariable) {
                Collection<PsiExpression> variableValues = DfaUtil.getCachedVariableValues((PsiVariable)targetElement, qualifierExpression);
                if (variableValues == null || variableValues.isEmpty()) {
                    return DfaUtil.getVariableAssignmentsInFile((PsiVariable)targetElement, false);
                }
                return variableValues;
            }
        } else if (qualifierExpression instanceof PsiLiteralExpression) {
            return Collections.singletonList(qualifierExpression);
        }
        return Collections.emptyList();
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static Collection<PsiExpression> getVariableAssignmentsInFile(PsiVariable psiVariable, final boolean literalsOnly) {
        List list;
        final Ref modificationRef = Ref.create((Object)Boolean.FALSE);
        List list2 = ContainerUtil.mapNotNull((Iterable)ReferencesSearch.search((PsiElement)psiVariable, (SearchScope)new LocalSearchScope(new PsiElement[]{psiVariable.getContainingFile()}, null, true)).findAll(), (Function)new NullableFunction<PsiReference, PsiExpression>(){

            public PsiExpression fun(PsiReference psiReference) {
                if (((Boolean)modificationRef.get()).booleanValue()) {
                    return null;
                }
                PsiElement parent = psiReference.getElement().getParent();
                if (parent instanceof PsiAssignmentExpression) {
                    PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)parent;
                    IElementType operation = assignmentExpression.getOperationTokenType();
                    if (assignmentExpression.getLExpression() == psiReference) {
                        if (JavaTokenType.EQ.equals(operation)) {
                            if (!literalsOnly || DfaUtil.allOperandsAreLiterals(assignmentExpression.getRExpression())) {
                                return assignmentExpression.getRExpression();
                            }
                            modificationRef.set((Object)Boolean.TRUE);
                        } else if (JavaTokenType.PLUSEQ.equals(operation)) {
                            modificationRef.set((Object)Boolean.TRUE);
                        }
                    }
                }
                return null;
            }
        });
        if (((Boolean)modificationRef.get()).booleanValue()) {
            list = Collections.emptyList();
            if (list == null) throw new IllegalStateException("@NotNull method com/intellij/codeInspection/dataFlow/DfaUtil.getVariableAssignmentsInFile must not return null");
            return list;
        }
        if (!literalsOnly || DfaUtil.allOperandsAreLiterals(psiVariable.getInitializer())) {
            ContainerUtil.addIfNotNull((Object)psiVariable.getInitializer(), (Collection)list2);
        }
        if ((list = list2) != null) return list;
        throw new IllegalStateException("@NotNull method com/intellij/codeInspection/dataFlow/DfaUtil.getVariableAssignmentsInFile must not return null");
    }

    public static boolean allOperandsAreLiterals(@Nullable PsiExpression expression) {
        if (expression == null) {
            return false;
        }
        if (expression instanceof PsiLiteralExpression) {
            return true;
        }
        if (expression instanceof PsiBinaryExpression) {
            LinkedList<PsiExpression> stack = new LinkedList<PsiExpression>();
            stack.add(expression);
            while (!stack.isEmpty()) {
                PsiExpression psiExpression = (PsiExpression)stack.removeFirst();
                if (psiExpression instanceof PsiBinaryExpression) {
                    PsiBinaryExpression binaryExpression = (PsiBinaryExpression)psiExpression;
                    stack.addLast(binaryExpression.getLOperand());
                    PsiExpression right = binaryExpression.getROperand();
                    if (right == null) continue;
                    stack.addLast(right);
                    continue;
                }
                if (psiExpression instanceof PsiLiteralExpression) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static class ValuableInstructionVisitor
    extends StandardInstructionVisitor {
        final MultiValuesMap<PsiVariable, PsiExpression> myValues = new MultiValuesMap(true);
        final Set<PsiVariable> myNulls = new THashSet();
        final Set<PsiVariable> myNotNulls = new THashSet();
        private final PsiElement myContext;

        public ValuableInstructionVisitor(PsiElement context) {
            this.myContext = context;
        }

        @Override
        public DfaInstructionState[] visitPush(PushInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
            if (this.myContext == instruction.getPlace()) {
                Map<DfaVariableValue, DfaVariableState> map = ((ValuableDataFlowRunner.MyDfaMemoryState)memState).getVariableStates();
                for (Map.Entry<DfaVariableValue, DfaVariableState> entry : map.entrySet()) {
                    ValuableDataFlowRunner.ValuableDfaVariableState state = (ValuableDataFlowRunner.ValuableDfaVariableState)entry.getValue();
                    DfaVariableValue variableValue = entry.getKey();
                    PsiExpression psiExpression = state.myExpression;
                    if (psiExpression == null) continue;
                    this.myValues.put((Object)variableValue.getPsiVariable(), (Object)psiExpression);
                }
                DfaValue value = instruction.getValue();
                if (value instanceof DfaVariableValue) {
                    if (memState.isNotNull((DfaVariableValue)value)) {
                        this.myNotNulls.add(((DfaVariableValue)value).getPsiVariable());
                    }
                    if (memState.isNull(value)) {
                        this.myNulls.add(((DfaVariableValue)value).getPsiVariable());
                    }
                }
            }
            return super.visitPush(instruction, runner, memState);
        }

        @Override
        public DfaInstructionState[] visitAssign(AssignInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
            Instruction nextInstruction = runner.getInstruction(instruction.getIndex() + 1);
            DfaValue dfaSource = memState.pop();
            DfaValue dfaDest = memState.pop();
            if (dfaDest instanceof DfaVariableValue) {
                PsiExpression nextValue;
                DfaVariableValue var = (DfaVariableValue)dfaDest;
                PsiExpression rightValue = instruction.getRExpression();
                PsiElement parent = rightValue == null ? null : rightValue.getParent();
                IElementType type = parent instanceof PsiAssignmentExpression ? ((PsiAssignmentExpression)parent).getOperationTokenType() : JavaTokenType.EQ;
                PsiExpression prevValue = ((ValuableDataFlowRunner.ValuableDfaVariableState)((ValuableDataFlowRunner.MyDfaMemoryState)memState).getVariableState((DfaVariableValue)var)).myExpression;
                memState.setVarValue(var, dfaSource);
                ValuableDataFlowRunner.ValuableDfaVariableState curState = (ValuableDataFlowRunner.ValuableDfaVariableState)((ValuableDataFlowRunner.MyDfaMemoryState)memState).getVariableState(var);
                PsiExpression curValue = curState.myExpression;
                if (type == JavaTokenType.PLUSEQ && prevValue != null) {
                    PsiExpression tmpExpression;
                    try {
                        tmpExpression = JavaPsiFacade.getElementFactory((Project)this.myContext.getProject()).createExpressionFromText(prevValue.getText() + "+" + rightValue.getText(), (PsiElement)rightValue);
                    }
                    catch (Exception e) {
                        tmpExpression = curValue == null ? rightValue : curValue;
                    }
                    nextValue = tmpExpression;
                } else {
                    nextValue = curValue == null ? rightValue : curValue;
                }
                curState.myExpression = nextValue;
            }
            memState.push(dfaDest);
            return new DfaInstructionState[]{new DfaInstructionState(nextInstruction, memState)};
        }
    }

    public static enum Nullness {
        NOT_NULL,
        NULL,
        UNKNOWN;

    }
}

