/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzerSettings;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.actions.AddNoInspectionJavaCommentFix;
import com.intellij.codeInsight.daemon.impl.actions.AddSuppressInspectionAllForClassFix;
import com.intellij.codeInsight.daemon.impl.actions.AddSuppressInspectionFix;
import com.intellij.codeInsight.daemon.impl.actions.AddSuppressInspectionForClassFix;
import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.codeInspection.SuppressManager;
import com.intellij.codeInspection.SuppressionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.PsiVariableEx;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SuppressManagerImpl
extends SuppressManager {
    public SuppressIntentionAction[] createSuppressActions(HighlightDisplayKey displayKey) {
        return new SuppressIntentionAction[]{new AddNoInspectionJavaCommentFix(displayKey), new AddSuppressInspectionFix(displayKey), new AddSuppressInspectionForClassFix(displayKey), new AddSuppressInspectionAllForClassFix()};
    }

    public boolean isSuppressedFor(PsiElement element, String toolId) {
        return this.getElementToolSuppressedIn(element, toolId) != null;
    }

    @Nullable
    public PsiElement getElementMemberSuppressedIn(PsiDocCommentOwner owner, String inspectionToolID) {
        PsiElement element = this.getDocCommentToolSuppressedIn(owner, inspectionToolID);
        if (element != null) {
            return element;
        }
        element = this.getAnnotationMemberSuppressedIn((PsiModifierListOwner)owner, inspectionToolID);
        if (element != null) {
            return element;
        }
        PsiDocCommentOwner classContainer = (PsiDocCommentOwner)PsiTreeUtil.getParentOfType((PsiElement)owner, PsiDocCommentOwner.class);
        while (classContainer != null) {
            element = this.getDocCommentToolSuppressedIn(classContainer, inspectionToolID);
            if (element != null) {
                return element;
            }
            element = this.getAnnotationMemberSuppressedIn((PsiModifierListOwner)classContainer, inspectionToolID);
            if (element != null) {
                return element;
            }
            classContainer = (PsiDocCommentOwner)PsiTreeUtil.getParentOfType((PsiElement)classContainer, PsiDocCommentOwner.class);
        }
        return null;
    }

    @Nullable
    public PsiElement getAnnotationMemberSuppressedIn(PsiModifierListOwner owner, String inspectionToolID) {
        PsiModifierList modifierList = owner.getModifierList();
        Collection<String> suppressedIds = SuppressManagerImpl.getInspectionIdsSuppressedInAnnotation(modifierList);
        for (String ids : suppressedIds) {
            if (!SuppressionUtil.isInspectionToolIdMentioned(ids, inspectionToolID)) continue;
            return modifierList != null ? modifierList.findAnnotation("java.lang.SuppressWarnings") : null;
        }
        return null;
    }

    @Nullable
    public PsiElement getDocCommentToolSuppressedIn(PsiDocCommentOwner owner, String inspectionToolID) {
        PsiDocTag inspectionTag;
        PsiElement el;
        PsiDocComment docComment = owner.getDocComment();
        if (docComment == null && owner.getParent() instanceof PsiDeclarationStatement && (el = PsiTreeUtil.skipSiblingsBackward((PsiElement)owner.getParent(), (Class[])new Class[]{PsiWhiteSpace.class})) instanceof PsiDocComment) {
            docComment = (PsiDocComment)el;
        }
        if (docComment != null && (inspectionTag = docComment.findTagByName("noinspection")) != null) {
            PsiElement[] dataElements;
            for (PsiElement dataElement : dataElements = inspectionTag.getDataElements()) {
                String valueText = dataElement.getText();
                if (!SuppressionUtil.isInspectionToolIdMentioned(valueText, inspectionToolID)) continue;
                return docComment;
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public Collection<String> getInspectionIdsSuppressedInAnnotation(PsiModifierListOwner owner) {
        Collection<String> collection;
        if (!PsiUtil.isLanguageLevel5OrHigher((PsiElement)owner)) {
            collection = Collections.emptyList();
            if (collection == null) throw new IllegalStateException("@NotNull method com/intellij/codeInspection/SuppressManagerImpl.getInspectionIdsSuppressedInAnnotation must not return null");
            return collection;
        }
        PsiModifierList modifierList = owner.getModifierList();
        collection = SuppressManagerImpl.getInspectionIdsSuppressedInAnnotation(modifierList);
        if (collection != null) return collection;
        throw new IllegalStateException("@NotNull method com/intellij/codeInspection/SuppressManagerImpl.getInspectionIdsSuppressedInAnnotation must not return null");
    }

    @Nullable
    public String getSuppressedInspectionIdsIn(PsiElement element) {
        PsiDocTag inspectionTag;
        PsiDocComment docComment;
        String text;
        Matcher matcher;
        if (element instanceof PsiComment && (matcher = SuppressionUtil.SUPPRESS_IN_LINE_COMMENT_PATTERN.matcher(text = element.getText())).matches()) {
            return matcher.group(1).trim();
        }
        if (element instanceof PsiDocCommentOwner && (docComment = ((PsiDocCommentOwner)element).getDocComment()) != null && (inspectionTag = docComment.findTagByName("noinspection")) != null) {
            String valueText = "";
            for (PsiElement dataElement : inspectionTag.getDataElements()) {
                valueText = valueText + dataElement.getText();
            }
            return valueText;
        }
        if (element instanceof PsiModifierListOwner) {
            Collection<String> suppressedIds = this.getInspectionIdsSuppressedInAnnotation((PsiModifierListOwner)element);
            return suppressedIds.isEmpty() ? null : StringUtil.join(suppressedIds, (String)",");
        }
        return null;
    }

    @Nullable
    public PsiElement getElementToolSuppressedIn(final PsiElement place, final String toolId) {
        if (place == null) {
            return null;
        }
        return (PsiElement)ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiElement>(){

            @Nullable
            public PsiElement compute() {
                PsiElement element;
                PsiElement element2;
                PsiElement statement = SuppressionUtil.getStatementToolSuppressedIn(place, toolId, PsiStatement.class);
                if (statement != null) {
                    return statement;
                }
                PsiLocalVariable local = (PsiLocalVariable)PsiTreeUtil.getParentOfType((PsiElement)place, PsiLocalVariable.class);
                if (local != null && SuppressManagerImpl.this.getAnnotationMemberSuppressedIn((PsiModifierListOwner)local, toolId) != null) {
                    PsiModifierList modifierList = local.getModifierList();
                    return modifierList != null ? modifierList.findAnnotation("java.lang.SuppressWarnings") : null;
                }
                PsiDocCommentOwner container = (PsiDocCommentOwner)PsiTreeUtil.getNonStrictParentOfType((PsiElement)place, (Class[])new Class[]{PsiDocCommentOwner.class});
                while (container instanceof PsiTypeParameter) {
                    container = (PsiDocCommentOwner)PsiTreeUtil.getParentOfType((PsiElement)container, PsiDocCommentOwner.class);
                }
                if (container != null && (element2 = SuppressManagerImpl.this.getElementMemberSuppressedIn(container, toolId)) != null) {
                    return element2;
                }
                PsiDocCommentOwner classContainer = (PsiDocCommentOwner)PsiTreeUtil.getParentOfType((PsiElement)container, PsiDocCommentOwner.class, (boolean)true);
                if (classContainer != null && (element = SuppressManagerImpl.this.getElementMemberSuppressedIn(classContainer, toolId)) != null) {
                    return element;
                }
                return null;
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static Collection<String> getInspectionIdsSuppressedInAnnotation(PsiModifierList modifierList) {
        List<String> list;
        if (modifierList == null) {
            list = Collections.emptyList();
            if (list == null) throw new IllegalStateException("@NotNull method com/intellij/codeInspection/SuppressManagerImpl.getInspectionIdsSuppressedInAnnotation must not return null");
            return list;
        }
        PsiAnnotation annotation = modifierList.findAnnotation("java.lang.SuppressWarnings");
        if (annotation == null) {
            list = Collections.emptyList();
            if (list == null) throw new IllegalStateException("@NotNull method com/intellij/codeInspection/SuppressManagerImpl.getInspectionIdsSuppressedInAnnotation must not return null");
            return list;
        }
        PsiNameValuePair[] attributes = annotation.getParameterList().getAttributes();
        if (attributes.length == 0) {
            list = Collections.emptyList();
            if (list == null) throw new IllegalStateException("@NotNull method com/intellij/codeInspection/SuppressManagerImpl.getInspectionIdsSuppressedInAnnotation must not return null");
            return list;
        }
        PsiAnnotationMemberValue attributeValue = attributes[0].getValue();
        ArrayList<String> result = new ArrayList<String>();
        if (attributeValue instanceof PsiArrayInitializerMemberValue) {
            PsiAnnotationMemberValue[] initializers;
            for (PsiAnnotationMemberValue annotationMemberValue : initializers = ((PsiArrayInitializerMemberValue)attributeValue).getInitializers()) {
                String id = SuppressManagerImpl.getInspectionIdSuppressedInAnnotationAttribute((PsiElement)annotationMemberValue);
                if (id == null) continue;
                result.add(id);
            }
        } else {
            String id = SuppressManagerImpl.getInspectionIdSuppressedInAnnotationAttribute((PsiElement)attributeValue);
            if (id != null) {
                result.add(id);
            }
        }
        if ((list = result) != null) return list;
        throw new IllegalStateException("@NotNull method com/intellij/codeInspection/SuppressManagerImpl.getInspectionIdsSuppressedInAnnotation must not return null");
    }

    @Nullable
    public static String getInspectionIdSuppressedInAnnotationAttribute(PsiElement element) {
        Object val;
        PsiElement psiElement;
        if (element instanceof PsiLiteralExpression) {
            Object value = ((PsiLiteralExpression)element).getValue();
            if (value instanceof String) {
                return (String)value;
            }
        } else if (element instanceof PsiReferenceExpression && (psiElement = ((PsiReferenceExpression)element).resolve()) instanceof PsiVariableEx && (val = ((PsiVariableEx)psiElement).computeConstantValue(new HashSet<PsiVariable>())) instanceof String) {
            return (String)val;
        }
        return null;
    }

    public boolean canHave15Suppressions(PsiElement file) {
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)file);
        if (module == null) {
            return false;
        }
        Sdk jdk = ModuleRootManager.getInstance((Module)module).getSdk();
        if (jdk == null) {
            return false;
        }
        String jdkVersion = jdk.getVersionString();
        if (jdkVersion == null) {
            return false;
        }
        boolean is_1_5 = JavaSdk.getInstance().compareTo(jdkVersion, "1.5") >= 0;
        return DaemonCodeAnalyzerSettings.getInstance().SUPPRESS_WARNINGS && is_1_5 && PsiUtil.isLanguageLevel5OrHigher((PsiElement)file);
    }

    public boolean alreadyHas14Suppressions(PsiDocCommentOwner commentOwner) {
        PsiDocComment docComment = commentOwner.getDocComment();
        return docComment != null && docComment.findTagByName("noinspection") != null;
    }
}

