/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.macro;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.openapi.util.text.StringUtil;
import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import groovy.lang.Script;
import java.io.File;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NotNull;

public class GroovyScriptMacro
implements Macro {
    public String getName() {
        return "groovyScript";
    }

    public String getDescription() {
        return CodeInsightBundle.message((String)"macro.groovy.script", (Object[])new Object[0]);
    }

    public String getDefaultValue() {
        return "";
    }

    public Result calculateResult(@NotNull Expression[] params, ExpressionContext context) {
        if (params == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/template/macro/GroovyScriptMacro.calculateResult must not be null");
        }
        if (params.length == 0) {
            return null;
        }
        Object o = GroovyScriptMacro.runIt(params, context);
        if (o != null) {
            return new TextResult(o.toString());
        }
        return null;
    }

    private static Object runIt(Expression[] params, ExpressionContext context) {
        try {
            Result result = params[0].calculateResult(context);
            if (result == null) {
                return result;
            }
            String text = result.toString();
            GroovyShell shell = new GroovyShell();
            File possibleFile = new File(text);
            Script script = possibleFile.exists() ? shell.parse(possibleFile) : shell.parse(text);
            Binding binding = new Binding();
            for (int i = 1; i < params.length; ++i) {
                Result paramResult = params[i].calculateResult(context);
                binding.setVariable("_" + i, (Object)(paramResult != null ? paramResult.toString() : null));
            }
            binding.setVariable("_editor", (Object)context.getEditor());
            script.setBinding(binding);
            Object o = script.run();
            return o != null ? StringUtil.convertLineSeparators((String)o.toString()) : null;
        }
        catch (Exception e) {
            return new TextResult(StringUtil.convertLineSeparators((String)e.getLocalizedMessage()));
        }
    }

    public Result calculateQuickResult(@NotNull Expression[] params, ExpressionContext context) {
        if (params == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/template/macro/GroovyScriptMacro.calculateQuickResult must not be null");
        }
        return this.calculateResult(params, context);
    }

    public LookupElement[] calculateLookupItems(@NotNull Expression[] params, ExpressionContext context) {
        if (params == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/template/macro/GroovyScriptMacro.calculateLookupItems must not be null");
        }
        Object o = GroovyScriptMacro.runIt(params, context);
        if (o != null) {
            LinkedHashSet<LookupElementBuilder> set = new LinkedHashSet<LookupElementBuilder>();
            set.add(LookupElementBuilder.create((String)o.toString()));
            return set.toArray(new LookupElement[set.size()]);
        }
        return LookupElement.EMPTY_ARRAY;
    }
}

