/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.macro;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.TextResult;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class FirstWordMacro
implements Macro {
    @NonNls
    public String getName() {
        return "firstWord";
    }

    public String getDescription() {
        return CodeInsightBundle.message((String)"macro.firstWord.string", (Object[])new Object[0]);
    }

    @NonNls
    public String getDefaultValue() {
        return "a";
    }

    public Result calculateResult(@NotNull Expression[] params, ExpressionContext context) {
        if (params == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/template/macro/FirstWordMacro.calculateResult must not be null");
        }
        if (params.length != 1) {
            return null;
        }
        Result result = params[0].calculateResult(context);
        return this.execute(result);
    }

    private Result execute(Result result) {
        String resultString = result.toString();
        int index = resultString.indexOf(32);
        return index >= 0 ? new TextResult(resultString.substring(0, index)) : result;
    }

    public Result calculateQuickResult(@NotNull Expression[] params, ExpressionContext context) {
        if (params == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/template/macro/FirstWordMacro.calculateQuickResult must not be null");
        }
        if (params.length != 1) {
            return null;
        }
        Result result = params[0].calculateResult(context);
        return this.execute(result);
    }

    public LookupElement[] calculateLookupItems(@NotNull Expression[] params, ExpressionContext context) {
        if (params == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/template/macro/FirstWordMacro.calculateLookupItems must not be null");
        }
        return LookupElement.EMPTY_ARRAY;
    }
}

