/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.impl.editorActions;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;

public class EscapeHandler
extends EditorActionHandler {
    private final EditorActionHandler myOriginalHandler;

    public EscapeHandler(EditorActionHandler originalHandler) {
        this.myOriginalHandler = originalHandler;
    }

    public void execute(Editor editor, DataContext dataContext) {
        TemplateState templateState;
        if (!editor.getSelectionModel().hasSelection() && (templateState = TemplateManagerImpl.getTemplateState(editor)) != null && !templateState.isFinished()) {
            CommandProcessor.getInstance().setCurrentCommandName(CodeInsightBundle.message((String)"finish.template.command", (Object[])new Object[0]));
            templateState.gotoEnd(true);
            return;
        }
        this.myOriginalHandler.execute(editor, dataContext);
    }

    public boolean isEnabled(Editor editor, DataContext dataContext) {
        TemplateState templateState = TemplateManagerImpl.getTemplateState(editor);
        if (templateState != null && !templateState.isFinished()) {
            return true;
        }
        return this.myOriginalHandler.isEnabled(editor, dataContext);
    }
}

