/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.ide.highlighter.JavaFileHighlighter;
import com.intellij.lang.Language;
import com.intellij.lang.StdLanguages;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilBase;
import org.jetbrains.annotations.NotNull;

public class JavaCodeContextType
extends TemplateContextType {
    public JavaCodeContextType() {
        super("JAVA_CODE", CodeInsightBundle.message((String)"dialog.edit.template.checkbox.java.code", (Object[])new Object[0]));
    }

    @Override
    public boolean isInContext(@NotNull PsiFile file, int offset) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/template/JavaCodeContextType.isInContext must not be null");
        }
        FileType fileType = file.getFileType();
        if (fileType == StdFileTypes.JAVA) {
            PsiElement element = file.findElementAt(offset);
            if (element instanceof PsiWhiteSpace && offset > 0) {
                element = file.findElementAt(offset - 1);
            }
            return element != null && PsiTreeUtil.getParentOfType((PsiElement)element, PsiComment.class, (boolean)false) == null && (!(element instanceof PsiJavaToken) || ((PsiJavaToken)element).getTokenType() != JavaTokenType.STRING_LITERAL);
        }
        if (fileType == StdFileTypes.JSP || fileType == StdFileTypes.JSPX) {
            Language language = PsiUtilBase.getLanguageAtOffset((PsiFile)file, (int)offset);
            return language.equals(StdLanguages.JAVA);
        }
        return false;
    }

    @Override
    public boolean isInContext(@NotNull FileType fileType) {
        if (fileType == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/template/JavaCodeContextType.isInContext must not be null");
        }
        return fileType == StdFileTypes.JAVA || fileType == StdFileTypes.JSP || fileType == StdFileTypes.JSPX;
    }

    @Override
    @NotNull
    public SyntaxHighlighter createHighlighter() {
        JavaFileHighlighter javaFileHighlighter = new JavaFileHighlighter();
        if (javaFileHighlighter == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/template/JavaCodeContextType.createHighlighter must not return null");
        }
        return javaFileHighlighter;
    }
}

