/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ConcatenationToMessageFormatAction
implements IntentionAction {
    @NotNull
    public String getFamilyName() {
        String string = CodeInsightBundle.message((String)"intention.replace.concatenation.with.formatted.output.family", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/intention/impl/ConcatenationToMessageFormatAction.getFamilyName must not return null");
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = CodeInsightBundle.message((String)"intention.replace.concatenation.with.formatted.output.text", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/intention/impl/ConcatenationToMessageFormatAction.getText must not return null");
        }
        return string;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/intention/impl/ConcatenationToMessageFormatAction.invoke must not be null");
        }
        if (!CodeInsightUtilBase.prepareFileForWrite(file)) {
            return;
        }
        PsiBinaryExpression concatenation = ConcatenationToMessageFormatAction.getEnclosingLiteralConcatenation(file, editor);
        PsiManager manager = concatenation.getManager();
        StringBuffer formatString = new StringBuffer();
        ArrayList<PsiExpression> args = new ArrayList<PsiExpression>();
        ArrayList<PsiExpression> argsToCombine = new ArrayList<PsiExpression>();
        ConcatenationToMessageFormatAction.calculateFormatAndArguments((PsiExpression)concatenation, formatString, args, argsToCombine, false);
        ConcatenationToMessageFormatAction.appendArgument(args, argsToCombine, formatString);
        PsiMethodCallExpression call = (PsiMethodCallExpression)JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory().createExpressionFromText("java.text.MessageFormat.format()", (PsiElement)concatenation);
        PsiExpressionList argumentList = call.getArgumentList();
        String format = ConcatenationToMessageFormatAction.prepareString(formatString.toString());
        PsiExpression formatArgument = JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory().createExpressionFromText("\"" + format + "\"", null);
        argumentList.add((PsiElement)formatArgument);
        if (PsiUtil.isLanguageLevel5OrHigher((PsiElement)file)) {
            for (PsiExpression arg : args) {
                argumentList.add((PsiElement)arg);
            }
        } else {
            PsiNewExpression arrayArg = (PsiNewExpression)JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory().createExpressionFromText("new java.lang.Object[]{}", null);
            PsiArrayInitializerExpression arrayInitializer = arrayArg.getArrayInitializer();
            assert (arrayInitializer != null);
            for (PsiExpression arg : args) {
                arrayInitializer.add((PsiElement)arg);
            }
            argumentList.add((PsiElement)arrayArg);
        }
        call = (PsiMethodCallExpression)JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)call);
        call = (PsiMethodCallExpression)manager.getCodeStyleManager().reformat((PsiElement)call);
        concatenation.replace((PsiElement)call);
    }

    public static String prepareString(String s) {
        return ConcatenationToMessageFormatAction.repeatSingleQuotes(StringUtil.escapeStringCharacters((String)s));
    }

    private static String repeatSingleQuotes(String s) {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\'') {
                buffer.append(c);
                buffer.append(c);
                continue;
            }
            buffer.append(c);
        }
        return buffer.toString();
    }

    public static boolean calculateFormatAndArguments(PsiExpression expression, StringBuffer formatString, List<PsiExpression> args, List<PsiExpression> argsToCombine, boolean wasLiteral) throws IncorrectOperationException {
        if (expression == null) {
            return wasLiteral;
        }
        if (expression instanceof PsiBinaryExpression) {
            PsiType type = expression.getType();
            if (type != null && type.equalsToText("java.lang.String") && ((PsiBinaryExpression)expression).getOperationSign().getTokenType() == JavaTokenType.PLUS) {
                wasLiteral = ConcatenationToMessageFormatAction.calculateFormatAndArguments(((PsiBinaryExpression)expression).getLOperand(), formatString, args, argsToCombine, wasLiteral);
                wasLiteral = ConcatenationToMessageFormatAction.calculateFormatAndArguments(((PsiBinaryExpression)expression).getROperand(), formatString, args, argsToCombine, wasLiteral);
            } else {
                if (expression instanceof PsiLiteralExpression && ((PsiLiteralExpression)expression).getValue() instanceof String) {
                    ConcatenationToMessageFormatAction.appendArgument(args, argsToCombine, formatString);
                    argsToCombine.clear();
                    formatString.append(((PsiLiteralExpression)expression).getValue());
                    return true;
                }
                if (wasLiteral) {
                    ConcatenationToMessageFormatAction.appendArgument(args, Collections.singletonList(expression), formatString);
                } else {
                    argsToCombine.add(expression);
                }
            }
        } else {
            if (expression instanceof PsiLiteralExpression && ((PsiLiteralExpression)expression).getValue() instanceof String) {
                ConcatenationToMessageFormatAction.appendArgument(args, argsToCombine, formatString);
                argsToCombine.clear();
                formatString.append(((PsiLiteralExpression)expression).getValue());
                return true;
            }
            if (wasLiteral) {
                ConcatenationToMessageFormatAction.appendArgument(args, Collections.singletonList(expression), formatString);
            } else {
                argsToCombine.add(expression);
            }
        }
        return wasLiteral;
    }

    private static void appendArgument(List<PsiExpression> args, List<PsiExpression> argsToCombine, StringBuffer formatString) throws IncorrectOperationException {
        if (argsToCombine.isEmpty()) {
            return;
        }
        PsiExpression argument = argsToCombine.get(0);
        PsiManager manager = argument.getManager();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory();
        for (int i = 1; i < argsToCombine.size(); ++i) {
            PsiBinaryExpression newArg = (PsiBinaryExpression)factory.createExpressionFromText("a+b", null);
            newArg.getLOperand().replace((PsiElement)argument);
            PsiExpression rOperand = newArg.getROperand();
            assert (rOperand != null);
            rOperand.replace((PsiElement)argsToCombine.get(i));
            argument = newArg;
        }
        formatString.append("{").append(args.size()).append("}");
        args.add(ConcatenationToMessageFormatAction.getBoxedArgument(argument));
    }

    private static PsiExpression getBoxedArgument(PsiExpression arg) throws IncorrectOperationException {
        PsiPrimitiveType primitiveType;
        String boxedQName;
        PsiType type;
        arg = PsiUtil.deparenthesizeExpression((PsiExpression)arg);
        assert (arg != null);
        PsiManager manager = arg.getManager();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory();
        if (!PsiUtil.isLanguageLevel5OrHigher((PsiElement)arg) && (type = arg.getType()) instanceof PsiPrimitiveType && !type.equals(PsiType.NULL) && (boxedQName = (primitiveType = (PsiPrimitiveType)type).getBoxedTypeName()) != null) {
            GlobalSearchScope resolveScope = arg.getResolveScope();
            PsiJavaCodeReferenceElement ref = factory.createReferenceElementByFQClassName(boxedQName, resolveScope);
            PsiNewExpression newExpr = (PsiNewExpression)factory.createExpressionFromText("new A(b)", null);
            PsiJavaCodeReferenceElement classRef = newExpr.getClassReference();
            assert (classRef != null);
            classRef.replace((PsiElement)ref);
            PsiExpressionList argumentList = newExpr.getArgumentList();
            assert (argumentList != null);
            argumentList.getExpressions()[0].replace((PsiElement)arg);
            return newExpr;
        }
        return arg;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/intention/impl/ConcatenationToMessageFormatAction.isAvailable must not be null");
        }
        return PsiUtil.getLanguageLevel((PsiElement)file).compareTo((Enum)LanguageLevel.JDK_1_4) >= 0 && ConcatenationToMessageFormatAction.getEnclosingLiteralConcatenation(file, editor) != null;
    }

    public static PsiBinaryExpression getEnclosingLiteralConcatenation(@NotNull PsiFile file, @NotNull Editor editor) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/intention/impl/ConcatenationToMessageFormatAction.getEnclosingLiteralConcatenation must not be null");
        }
        if (editor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/intention/impl/ConcatenationToMessageFormatAction.getEnclosingLiteralConcatenation must not be null");
        }
        PsiElement elementAt = file.findElementAt(editor.getCaretModel().getOffset());
        return ConcatenationToMessageFormatAction.getEnclosingLiteralConcatenation(elementAt);
    }

    public static PsiBinaryExpression getEnclosingLiteralConcatenation(PsiElement psiElement) {
        PsiBinaryExpression element = (PsiBinaryExpression)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiBinaryExpression.class, (boolean)false, (Class[])new Class[]{PsiMember.class});
        if (element == null) {
            return null;
        }
        PsiBinaryExpression concatenation = null;
        boolean stringLiteralOccured = false;
        while (true) {
            PsiElement parent;
            PsiExpression lOperand = element.getLOperand();
            PsiExpression rOperand = element.getROperand();
            if (element.getOperationSign().getTokenType() != JavaTokenType.PLUS) {
                return concatenation;
            }
            if (stringLiteralOccured |= lOperand instanceof PsiLiteralExpression && ((PsiLiteralExpression)lOperand).getValue() instanceof String || rOperand instanceof PsiLiteralExpression && ((PsiLiteralExpression)rOperand).getValue() instanceof String) {
                concatenation = element;
            }
            if (!((parent = element.getParent()) instanceof PsiBinaryExpression)) {
                return concatenation;
            }
            element = (PsiBinaryExpression)parent;
        }
    }

    public boolean startInWriteAction() {
        return true;
    }

    public static PsiLiteralExpression getContainingLiteral(PsiBinaryExpression concatenation) {
        PsiExpression operand = concatenation.getLOperand();
        PsiLiteralExpression literalExpression = null;
        if (operand instanceof PsiLiteralExpression) {
            literalExpression = (PsiLiteralExpression)operand;
        } else {
            operand = concatenation.getROperand();
            if (operand instanceof PsiLiteralExpression) {
                literalExpression = (PsiLiteralExpression)operand;
            }
        }
        return literalExpression;
    }
}

