/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.MethodImplementor;
import com.intellij.codeInsight.generation.ClassMember;
import com.intellij.codeInsight.generation.GenerateMembersUtil;
import com.intellij.codeInsight.generation.ImplementMethodsHandler;
import com.intellij.codeInsight.generation.OverrideImplementsAnnotationsHandler;
import com.intellij.codeInsight.generation.OverrideMethodsHandler;
import com.intellij.codeInsight.generation.PsiGenerationInfo;
import com.intellij.codeInsight.generation.PsiMethodMember;
import com.intellij.codeInsight.intention.AddAnnotationFix;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.FileTemplateUtil;
import com.intellij.ide.fileTemplates.JavaTemplateUtil;
import com.intellij.ide.util.MemberChooser;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationMethod;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.impl.source.jsp.jspJava.JspClass;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OverrideImplementUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.generation.OverrideImplementUtil");
    @NonNls
    private static final String PROP_COMBINED_OVERRIDE_IMPLEMENT = "OverrideImplement.combined";

    private OverrideImplementUtil() {
    }

    @NotNull
    public static Collection<CandidateInfo> getMethodsToOverrideImplement(PsiClass aClass, boolean toImplement) {
        Collection<CandidateInfo> collection = OverrideImplementUtil.getMapToOverrideImplement(aClass, toImplement).values();
        if (collection == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/generation/OverrideImplementUtil.getMethodsToOverrideImplement must not return null");
        }
        return collection;
    }

    @NotNull
    public static Collection<MethodSignature> getMethodSignaturesToImplement(@NotNull PsiClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/generation/OverrideImplementUtil.getMethodSignaturesToImplement must not be null");
        }
        Set<MethodSignature> set = OverrideImplementUtil.getMapToOverrideImplement(aClass, true).keySet();
        if (set == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/generation/OverrideImplementUtil.getMethodSignaturesToImplement must not return null");
        }
        return set;
    }

    @NotNull
    public static Collection<MethodSignature> getMethodSignaturesToOverride(@NotNull PsiClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/generation/OverrideImplementUtil.getMethodSignaturesToOverride must not be null");
        }
        Set<MethodSignature> set = OverrideImplementUtil.getMapToOverrideImplement(aClass, false).keySet();
        if (set == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/generation/OverrideImplementUtil.getMethodSignaturesToOverride must not return null");
        }
        return set;
    }

    @NotNull
    private static Map<MethodSignature, CandidateInfo> getMapToOverrideImplement(PsiClass aClass, boolean toImplement) {
        MethodSignature signature;
        LinkedHashMap<HierarchicalMethodSignature, PsiMethod> abstracts = new LinkedHashMap<HierarchicalMethodSignature, PsiMethod>();
        LinkedHashMap<HierarchicalMethodSignature, PsiMethod> finals = new LinkedHashMap<HierarchicalMethodSignature, PsiMethod>();
        LinkedHashMap concretes = new LinkedHashMap();
        Collection allMethodSigs = aClass.getVisibleSignatures();
        PsiResolveHelper resolveHelper = JavaPsiFacade.getInstance((Project)aClass.getProject()).getResolveHelper();
        for (HierarchicalMethodSignature signature2 : allMethodSigs) {
            PsiClass hisClass;
            PsiMethod method = signature2.getMethod();
            if (method.hasModifierProperty("static") || !resolveHelper.isAccessible((PsiMember)method, (PsiElement)aClass, aClass) || (hisClass = method.getContainingClass()) == null || method.isConstructor() && (!aClass.isInheritor(hisClass, false) || aClass instanceof PsiAnonymousClass || aClass.isEnum()) || MethodSignatureUtil.findMethodBySignature((PsiClass)aClass, (MethodSignature)signature2, (boolean)false) != null) continue;
            if (method.hasModifierProperty("final")) {
                finals.put(signature2, method);
                continue;
            }
            LinkedHashMap<Object, Object> map = hisClass.isInterface() || method.hasModifierProperty("abstract") ? abstracts : concretes;
            PsiMethod other = (PsiMethod)map.get(signature2);
            if (other != null && !OverrideImplementUtil.preferLeftForImplement(method, other)) continue;
            map.put(signature2, method);
        }
        TreeMap<MethodSignature, CandidateInfo> result = new TreeMap<MethodSignature, CandidateInfo>(new Comparator<MethodSignature>(){

            @Override
            public int compare(MethodSignature o1, MethodSignature o2) {
                if (o1 instanceof MethodSignatureBackedByPsiMethod && o2 instanceof MethodSignatureBackedByPsiMethod) {
                    PsiMethod m1 = ((MethodSignatureBackedByPsiMethod)o1).getMethod();
                    PsiMethod m2 = ((MethodSignatureBackedByPsiMethod)o2).getMethod();
                    PsiElement p1 = m1.getParent();
                    PsiElement p2 = m2.getParent();
                    if (p1 instanceof PsiClass && p2 instanceof PsiClass) {
                        PsiClass c1 = (PsiClass)p1;
                        PsiClass c2 = (PsiClass)p2;
                        if (c1 == c2) {
                            List<PsiMethod> methods = Arrays.asList(c1.getMethods());
                            return methods.indexOf(m1) - methods.indexOf(m2);
                        }
                        if (c1.isInheritor(c2, true)) {
                            return -1;
                        }
                        if (c2.isInheritor(c1, true)) {
                            return 1;
                        }
                        return StringUtil.notNullize((String)c1.getName()).compareTo(StringUtil.notNullize((String)c2.getName()));
                    }
                    return m1.getTextOffset() - m2.getTextOffset();
                }
                return 0;
            }
        });
        if (toImplement || aClass.isInterface()) {
            for (Map.Entry entry : abstracts.entrySet()) {
                signature = (MethodSignature)entry.getKey();
                PsiMethod abstractOne = (PsiMethod)entry.getValue();
                PsiMethod concrete = (PsiMethod)concretes.get(signature);
                if (concrete != null && PsiUtil.getAccessLevel((PsiModifierList)concrete.getModifierList()) >= PsiUtil.getAccessLevel((PsiModifierList)abstractOne.getModifierList()) && (abstractOne.getContainingClass().isInterface() || !abstractOne.getContainingClass().isInheritor(concrete.getContainingClass(), true)) || finals.get(signature) != null) continue;
                PsiSubstitutor subst = GenerateMembersUtil.correctSubstitutor(abstractOne, signature.getSubstitutor());
                CandidateInfo info = new CandidateInfo((PsiElement)abstractOne, subst);
                result.put(signature, info);
            }
            for (MethodImplementor implementor : OverrideImplementUtil.getImplementors()) {
                for (PsiMethod method : implementor.getMethodsToImplement(aClass)) {
                    MethodSignature signature3 = MethodSignatureUtil.createMethodSignature((String)method.getName(), (PsiParameterList)method.getParameterList(), (PsiTypeParameterList)method.getTypeParameterList(), (PsiSubstitutor)PsiSubstitutor.EMPTY);
                    CandidateInfo info = new CandidateInfo((PsiElement)method, PsiSubstitutor.EMPTY);
                    result.put(signature3, info);
                }
            }
        } else {
            for (Map.Entry entry : concretes.entrySet()) {
                PsiMethod abstractOne;
                signature = (MethodSignature)entry.getKey();
                PsiMethod concrete = (PsiMethod)entry.getValue();
                if (finals.get(signature) != null || (abstractOne = (PsiMethod)abstracts.get(signature)) != null && abstractOne.getContainingClass().isInheritor(concrete.getContainingClass(), true) && !"java.lang.Object".equals(concrete.getContainingClass().getQualifiedName())) continue;
                PsiSubstitutor subst = GenerateMembersUtil.correctSubstitutor(concrete, signature.getSubstitutor());
                CandidateInfo info = new CandidateInfo((PsiElement)concrete, subst);
                result.put(signature, info);
            }
        }
        TreeMap<MethodSignature, CandidateInfo> treeMap = result;
        if (treeMap == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/generation/OverrideImplementUtil.getMapToOverrideImplement must not return null");
        }
        return treeMap;
    }

    private static boolean preferLeftForImplement(PsiMethod left, PsiMethod right) {
        PsiAnnotation[] rightAnnotations;
        if (PsiUtil.getAccessLevel((PsiModifierList)left.getModifierList()) > PsiUtil.getAccessLevel((PsiModifierList)right.getModifierList())) {
            return true;
        }
        if (!left.getContainingClass().isInterface()) {
            return true;
        }
        if (!right.getContainingClass().isInterface()) {
            return false;
        }
        PsiAnnotation[] leftAnnotations = left.getModifierList().getAnnotations();
        return leftAnnotations.length > (rightAnnotations = right.getModifierList().getAnnotations()).length;
    }

    private static MethodImplementor[] getImplementors() {
        return (MethodImplementor[])Extensions.getExtensions((ExtensionPointName)MethodImplementor.EXTENSION_POINT_NAME);
    }

    @NotNull
    public static Collection<PsiMethod> overrideOrImplementMethod(PsiClass aClass, PsiMethod method, boolean toCopyJavaDoc) throws IncorrectOperationException {
        PsiClass containingClass = method.getContainingClass();
        PsiSubstitutor substitutor = aClass.isInheritor(containingClass, true) ? TypeConversionUtil.getSuperClassSubstitutor((PsiClass)containingClass, (PsiClass)aClass, (PsiSubstitutor)PsiSubstitutor.EMPTY) : PsiSubstitutor.EMPTY;
        Collection<PsiMethod> collection = OverrideImplementUtil.overrideOrImplementMethod(aClass, method, substitutor, toCopyJavaDoc, true);
        if (collection == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/generation/OverrideImplementUtil.overrideOrImplementMethod must not return null");
        }
        return collection;
    }

    public static boolean isInsertOverride(PsiMethod superMethod, PsiClass targetClass) {
        if (!CodeStyleSettingsManager.getSettings((Project)targetClass.getProject()).INSERT_OVERRIDE_ANNOTATION || !PsiUtil.isLanguageLevel5OrHigher((PsiElement)targetClass)) {
            return false;
        }
        if (PsiUtil.isLanguageLevel6OrHigher((PsiElement)targetClass)) {
            return true;
        }
        if (targetClass.isInterface()) {
            return true;
        }
        PsiClass superClass = superMethod.getContainingClass();
        return !superClass.isInterface();
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private static Collection<PsiMethod> overrideOrImplementMethod(PsiClass aClass, PsiMethod method, PsiSubstitutor substitutor, boolean toCopyJavaDoc, boolean insertAtOverrideIfPossible) throws IncorrectOperationException {
        List<PsiMethod> list;
        if (!method.isValid() || !substitutor.isValid()) {
            list = Collections.emptyList();
            if (list == null) throw new IllegalStateException("@NotNull method com/intellij/codeInsight/generation/OverrideImplementUtil.overrideOrImplementMethod must not return null");
            return list;
        }
        ArrayList<PsiMethod> results = new ArrayList<PsiMethod>();
        for (MethodImplementor implementor : OverrideImplementUtil.getImplementors()) {
            results.addAll(Arrays.asList(implementor.createImplementationPrototypes(aClass, method)));
        }
        if (results.isEmpty()) {
            PsiAnnotationMemberValue defaultValue;
            PsiMethod method1 = GenerateMembersUtil.substituteGenericMethod(method, substitutor);
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)method.getProject()).getElementFactory();
            PsiMethod result = (PsiMethod)factory.createClass("Dummy").add((PsiElement)method1);
            if (result instanceof PsiAnnotationMethod && (defaultValue = ((PsiAnnotationMethod)result).getDefaultValue()) != null) {
                PsiAnnotationMemberValue defaultKeyword;
                for (defaultKeyword = defaultValue; !(defaultKeyword instanceof PsiKeyword) && defaultKeyword != null; defaultKeyword = defaultKeyword.getPrevSibling()) {
                }
                if (defaultKeyword == null) {
                    defaultKeyword = defaultValue;
                }
                defaultValue.getParent().deleteChildRange((PsiElement)defaultKeyword, (PsiElement)defaultValue);
            }
            results.add(result);
        }
        Iterator iterator = results.iterator();
        while (true) {
            int len$;
            OverrideImplementsAnnotationsHandler[] arr$;
            PsiMethod result;
            if (iterator.hasNext()) {
                PsiDocComment comment;
                result = (PsiMethod)iterator.next();
                PsiUtil.setModifierProperty((PsiModifierListOwner)result, (String)"abstract", (boolean)aClass.isInterface());
                PsiUtil.setModifierProperty((PsiModifierListOwner)result, (String)"native", (boolean)false);
                if (!toCopyJavaDoc && (comment = result.getDocComment()) != null) {
                    comment.delete();
                }
                if (insertAtOverrideIfPossible && OverrideImplementUtil.isInsertOverride(method, aClass) && !method.isConstructor()) {
                    OverrideImplementUtil.annotate(result, "java.lang.Override", new String[0]);
                }
                arr$ = (OverrideImplementsAnnotationsHandler[])Extensions.getExtensions(OverrideImplementsAnnotationsHandler.EP_NAME);
                len$ = arr$.length;
            } else {
                list = results;
                if (list != null) return list;
                throw new IllegalStateException("@NotNull method com/intellij/codeInsight/generation/OverrideImplementUtil.overrideOrImplementMethod must not return null");
            }
            for (int i$ = 0; i$ < len$; ++i$) {
                OverrideImplementsAnnotationsHandler annotationsHandler = arr$[i$];
                for (String annotationFQName : annotationsHandler.getAnnotations()) {
                    if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)method, (String)annotationFQName, (boolean)false)) continue;
                    OverrideImplementUtil.annotate(result, annotationFQName, annotationsHandler.annotationsToRemove(annotationFQName));
                }
            }
            PsiCodeBlock body = JavaPsiFacade.getInstance((Project)method.getProject()).getElementFactory().createCodeBlockFromText("{}", null);
            PsiCodeBlock oldbody = result.getBody();
            if (oldbody != null) {
                oldbody.replace((PsiElement)body);
            } else {
                result.add((PsiElement)body);
            }
            OverrideImplementUtil.setupMethodBody(result, method, aClass);
            Project project = method.getProject();
            CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project);
            CodeStyleSettings settings = CodeStyleSettingsManager.getSettings((Project)project);
            boolean keepBreaks = settings.KEEP_LINE_BREAKS;
            settings.KEEP_LINE_BREAKS = false;
            result = (PsiMethod)JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)result);
            result = (PsiMethod)codeStyleManager.reformat((PsiElement)result);
            settings.KEEP_LINE_BREAKS = keepBreaks;
            if (aClass.findMethodBySignature(result, false) == null) continue;
            iterator.remove();
        }
    }

    private static void annotate(PsiMethod result, String fqn, String ... annosToRemove) throws IncorrectOperationException {
        AddAnnotationFix fix = new AddAnnotationFix(fqn, (PsiModifierListOwner)result, annosToRemove);
        Project project = result.getProject();
        if (fix.isAvailable(project, null, result.getContainingFile())) {
            fix.invoke(project, null, result.getContainingFile());
        }
    }

    public static boolean isOverridable(PsiMethod method) {
        return !method.isConstructor() && !method.hasModifierProperty("static") && !method.hasModifierProperty("final") && !method.hasModifierProperty("private");
    }

    @NotNull
    public static List<PsiGenerationInfo<PsiMethod>> overrideOrImplementMethods(PsiClass aClass, Collection<PsiMethodMember> candidates, boolean toCopyJavaDoc, boolean toInsertAtOverride) throws IncorrectOperationException {
        List candidateInfos = ContainerUtil.map2List(candidates, (Function)new Function<PsiMethodMember, CandidateInfo>(){

            public CandidateInfo fun(PsiMethodMember s) {
                return new CandidateInfo(s.getElement(), s.getSubstitutor());
            }
        });
        List<PsiMethod> methods = OverrideImplementUtil.overrideOrImplementMethodCandidates(aClass, candidateInfos, toCopyJavaDoc, toInsertAtOverride);
        List<PsiGenerationInfo<PsiMethod>> list = OverrideImplementUtil.convert2GenerationInfos(methods);
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/generation/OverrideImplementUtil.overrideOrImplementMethods must not return null");
        }
        return list;
    }

    @NotNull
    public static List<PsiMethod> overrideOrImplementMethodCandidates(PsiClass aClass, Collection<CandidateInfo> candidates, boolean toCopyJavaDoc, boolean insertOverrideWherePossible) throws IncorrectOperationException {
        ArrayList<PsiMethod> result = new ArrayList<PsiMethod>();
        for (CandidateInfo candidateInfo : candidates) {
            result.addAll(OverrideImplementUtil.overrideOrImplementMethod(aClass, (PsiMethod)candidateInfo.getElement(), candidateInfo.getSubstitutor(), toCopyJavaDoc, insertOverrideWherePossible));
        }
        ArrayList<PsiMethod> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/generation/OverrideImplementUtil.overrideOrImplementMethodCandidates must not return null");
        }
        return arrayList;
    }

    public static List<PsiGenerationInfo<PsiMethod>> convert2GenerationInfos(Collection<PsiMethod> methods) {
        return ContainerUtil.map2List(methods, (Function)new Function<PsiMethod, PsiGenerationInfo<PsiMethod>>(){

            public PsiGenerationInfo<PsiMethod> fun(PsiMethod s) {
                return new PsiGenerationInfo<PsiMethod>(s);
            }
        });
    }

    @NotNull
    private static String callSuper(PsiMethod superMethod, PsiMethod overriding) {
        StringBuilder buffer = new StringBuilder();
        if (!superMethod.isConstructor() && superMethod.getReturnType() != PsiType.VOID) {
            buffer.append("return ");
        }
        buffer.append("super");
        PsiParameter[] parms = overriding.getParameterList().getParameters();
        if (!superMethod.isConstructor()) {
            buffer.append(".");
            buffer.append(superMethod.getName());
        }
        buffer.append("(");
        for (int i = 0; i < parms.length; ++i) {
            String name = parms[i].getName();
            if (i > 0) {
                buffer.append(",");
            }
            buffer.append(name);
        }
        buffer.append(")");
        String string = buffer.toString();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/generation/OverrideImplementUtil.callSuper must not return null");
        }
        return string;
    }

    public static void setupMethodBody(PsiMethod result, PsiMethod originalMethod, PsiClass targetClass) throws IncorrectOperationException {
        String templName = originalMethod.hasModifierProperty("abstract") ? "Implemented Method Body.java" : "Overridden Method Body.java";
        FileTemplate template = FileTemplateManager.getInstance().getCodeTemplate(templName);
        OverrideImplementUtil.setupMethodBody(result, originalMethod, targetClass, template);
    }

    public static void setupMethodBody(PsiMethod result, PsiMethod originalMethod, PsiClass targetClass, FileTemplate template) throws IncorrectOperationException {
        String methodText;
        PsiCodeBlock body;
        if (targetClass.isInterface() && (body = result.getBody()) != null) {
            body.delete();
        }
        FileType fileType = FileTypeManager.getInstance().getFileTypeByExtension(template.getExtension());
        PsiType returnType = result.getReturnType();
        if (returnType == null) {
            returnType = PsiType.VOID;
        }
        Properties properties = new Properties();
        properties.setProperty("RETURN_TYPE", returnType.getPresentableText());
        properties.setProperty("DEFAULT_RETURN_VALUE", PsiTypesUtil.getDefaultValueOfType((PsiType)returnType));
        properties.setProperty("CALL_SUPER", OverrideImplementUtil.callSuper(originalMethod, result));
        JavaTemplateUtil.setClassAndMethodNameProperties(properties, targetClass, result);
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)originalMethod.getProject()).getElementFactory();
        try {
            String bodyText = template.getText(properties);
            if (!"".equals(bodyText)) {
                bodyText = bodyText + "\n";
            }
            methodText = "void foo () {\n" + bodyText + "}";
            methodText = FileTemplateUtil.indent(methodText, result.getProject(), fileType);
        }
        catch (Exception e) {
            throw new IncorrectOperationException("Failed to parse file template", e);
        }
        if (methodText != null) {
            PsiMethod m;
            try {
                m = factory.createMethodFromText(methodText, (PsiElement)originalMethod);
            }
            catch (IncorrectOperationException e) {
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Messages.showErrorDialog((String)CodeInsightBundle.message((String)"override.implement.broken.file.template.message", (Object[])new Object[0]), (String)CodeInsightBundle.message((String)"override.implement.broken.file.template.title", (Object[])new Object[0]));
                    }
                });
                return;
            }
            PsiCodeBlock oldBody = result.getBody();
            if (oldBody != null) {
                oldBody.replace((PsiElement)m.getBody());
            }
        }
    }

    public static void chooseAndOverrideMethods(Project project, Editor editor, PsiClass aClass) {
        FeatureUsageTracker.getInstance().triggerFeatureUsed("codeassists.overrideimplement");
        OverrideImplementUtil.chooseAndOverrideOrImplementMethods(project, editor, aClass, false);
    }

    public static void chooseAndImplementMethods(Project project, Editor editor, PsiClass aClass) {
        FeatureUsageTracker.getInstance().triggerFeatureUsed("codeassists.overrideimplement");
        OverrideImplementUtil.chooseAndOverrideOrImplementMethods(project, editor, aClass, true);
    }

    private static void chooseAndOverrideOrImplementMethods(Project project, final Editor editor, final PsiClass aClass, final boolean toImplement) {
        List<CandidateInfo> secondary;
        LOG.assertTrue(aClass.isValid());
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Collection<CandidateInfo> candidates = OverrideImplementUtil.getMethodsToOverrideImplement(aClass, toImplement);
        Collection<CandidateInfo> collection = secondary = toImplement ? Collections.emptyList() : OverrideImplementUtil.getMethodsToOverrideImplement(aClass, true);
        if (candidates.isEmpty() && secondary.isEmpty()) {
            return;
        }
        Object[] onlyPrimary = OverrideImplementUtil.convertToMethodMembers(candidates);
        final PsiMethodMember[] all = (PsiMethodMember[])ArrayUtil.mergeArrays((Object[])onlyPrimary, (Object[])OverrideImplementUtil.convertToMethodMembers(secondary), PsiMethodMember.class);
        String toMerge = PropertiesComponent.getInstance((Project)project).getValue(PROP_COMBINED_OVERRIDE_IMPLEMENT);
        final Ref merge = Ref.create((Object)(!"false".equals(toMerge) ? 1 : 0));
        boolean isAll = (Boolean)merge.get();
        final MemberChooser<PsiMethodMember> chooser = new MemberChooser<PsiMethodMember>((PsiMethodMember[])(isAll ? all : onlyPrimary), false, true, project, PsiUtil.isLanguageLevel5OrHigher((PsiElement)aClass), (PsiMethodMember[])onlyPrimary){
            final /* synthetic */ PsiMethodMember[] val$onlyPrimary;
            {
                this.val$onlyPrimary = psiMethodMemberArray2;
                super((ClassMember[])x0, x1, x2, x3, x4);
            }

            @Override
            protected void fillToolbarActions(DefaultActionGroup group) {
                super.fillToolbarActions(group);
                if (toImplement) {
                    return;
                }
                ToggleAction mergeAction = new ToggleAction("Show methods to implement", "Show methods to implement", IconLoader.getIcon((String)"/general/show_to_implement.png")){

                    public boolean isSelected(AnActionEvent e) {
                        return (Boolean)merge.get();
                    }

                    public void setSelected(AnActionEvent e, boolean state) {
                        merge.set((Object)state);
                        this.resetElements(state ? all : val$onlyPrimary);
                        this.setTitle(OverrideImplementUtil.getChooserTitle(false, (Ref<Boolean>)merge));
                    }
                };
                mergeAction.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(73, 8)), (JComponent)this.myTree);
                group.add((AnAction)mergeAction);
            }
        };
        chooser.setTitle(OverrideImplementUtil.getChooserTitle(toImplement, (Ref<Boolean>)merge));
        OverrideImplementUtil.registerHandlerForComplementaryAction(project, editor, aClass, toImplement, chooser);
        chooser.setCopyJavadocVisible(true);
        if (toImplement) {
            chooser.selectElements((ClassMember[])(isAll ? all : onlyPrimary));
        }
        chooser.show();
        if (chooser.getExitCode() != 0) {
            return;
        }
        PropertiesComponent.getInstance((Project)project).setValue(PROP_COMBINED_OVERRIDE_IMPLEMENT, ((Boolean)merge.get()).toString());
        final List selectedElements = chooser.getSelectedElements();
        if (selectedElements == null || selectedElements.isEmpty()) {
            return;
        }
        new WriteCommandAction(project, new PsiFile[]{aClass.getContainingFile()}){

            protected void run(Result result) throws Throwable {
                OverrideImplementUtil.overrideOrImplementMethodsInRightPlace(editor, aClass, selectedElements, chooser.isCopyJavadoc(), chooser.isInsertOverrideAnnotation());
            }
        }.execute();
    }

    private static String getChooserTitle(boolean toImplement, Ref<Boolean> merge) {
        return toImplement ? CodeInsightBundle.message((String)"methods.to.implement.chooser.title", (Object[])new Object[0]) : ((Boolean)merge.get() != false ? CodeInsightBundle.message((String)"methods.to.override.implement.chooser.title", (Object[])new Object[0]) : CodeInsightBundle.message((String)"methods.to.override.chooser.title", (Object[])new Object[0]));
    }

    private static PsiMethodMember[] convertToMethodMembers(Collection<CandidateInfo> candidates) {
        return (PsiMethodMember[])ContainerUtil.map2Array(candidates, PsiMethodMember.class, (Function)new Function<CandidateInfo, PsiMethodMember>(){

            public PsiMethodMember fun(CandidateInfo s) {
                return new PsiMethodMember(s);
            }
        });
    }

    private static void registerHandlerForComplementaryAction(final Project project, final Editor editor, final PsiClass aClass, final boolean toImplement, final MemberChooser<PsiMethodMember> chooser) {
        String s;
        JComponent preferredFocusedComponent = chooser.getPreferredFocusedComponent();
        Keymap keymap = KeymapManager.getInstance().getActiveKeymap();
        Shortcut[] shortcuts = keymap.getShortcuts(s = toImplement ? "OverrideMethods" : "ImplementMethods");
        if (shortcuts.length > 0 && shortcuts[0] instanceof KeyboardShortcut) {
            preferredFocusedComponent.getInputMap().put(((KeyboardShortcut)shortcuts[0]).getFirstKeyStroke(), s);
            preferredFocusedComponent.getActionMap().put(s, new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    chooser.close(1);
                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Object handler = toImplement ? new OverrideMethodsHandler() : new ImplementMethodsHandler();
                            handler.invoke(project, editor, aClass.getContainingFile());
                        }
                    });
                }
            });
        }
    }

    public static void overrideOrImplementMethodsInRightPlace(Editor editor, PsiClass aClass, Collection<PsiMethodMember> candidates, boolean copyJavadoc, boolean insertOverrideWherePossible) {
        try {
            List<Object> resultMembers;
            int lbraceOffset;
            int offset = editor.getCaretModel().getOffset();
            if (aClass.getLBrace() == null) {
                PsiClass psiClass = JavaPsiFacade.getInstance((Project)aClass.getProject()).getElementFactory().createClass("X");
                aClass.addRangeAfter((PsiElement)psiClass.getLBrace(), (PsiElement)psiClass.getRBrace(), aClass.getLastChild());
            }
            if (offset <= (lbraceOffset = aClass.getLBrace().getTextOffset()) || aClass.isEnum()) {
                resultMembers = new ArrayList();
                for (PsiMethodMember candidate : candidates) {
                    Collection<PsiMethod> prototypes = OverrideImplementUtil.overrideOrImplementMethod(aClass, (PsiMethod)candidate.getElement(), candidate.getSubstitutor(), copyJavadoc, insertOverrideWherePossible);
                    for (PsiMethod prototype : prototypes) {
                        PsiElement anchor = OverrideImplementUtil.getDefaultAnchorToOverrideOrImplement(aClass, (PsiMethod)candidate.getElement(), candidate.getSubstitutor());
                        PsiElement result = GenerateMembersUtil.insert(aClass, (PsiMember)prototype, anchor, true);
                        resultMembers.add(new PsiGenerationInfo<PsiMethod>((PsiMethod)result));
                    }
                }
            } else {
                List<PsiGenerationInfo<PsiMethod>> prototypes = OverrideImplementUtil.overrideOrImplementMethods(aClass, candidates, copyJavadoc, insertOverrideWherePossible);
                resultMembers = GenerateMembersUtil.insertMembersAtOffset(aClass.getContainingFile(), offset, prototypes);
            }
            if (!resultMembers.isEmpty()) {
                GenerateMembersUtil.positionCaret(editor, ((PsiGenerationInfo)resultMembers.get(0)).getPsiMember(), true);
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    @Nullable
    public static PsiElement getDefaultAnchorToOverrideOrImplement(PsiClass aClass, PsiMethod baseMethod, PsiSubstitutor substitutor) {
        PsiMethod prevBaseMethod = (PsiMethod)PsiTreeUtil.getPrevSiblingOfType((PsiElement)baseMethod, PsiMethod.class);
        while (prevBaseMethod != null) {
            MethodSignature signature;
            PsiMethod prevMethod;
            String name;
            String string = name = prevBaseMethod.isConstructor() ? aClass.getName() : prevBaseMethod.getName();
            if (name != null && (prevMethod = MethodSignatureUtil.findMethodBySignature((PsiClass)aClass, (MethodSignature)(signature = MethodSignatureUtil.createMethodSignature((String)name, (PsiParameterList)prevBaseMethod.getParameterList(), (PsiTypeParameterList)prevBaseMethod.getTypeParameterList(), (PsiSubstitutor)substitutor)), (boolean)false)) != null) {
                return prevMethod.getNextSibling();
            }
            prevBaseMethod = (PsiMethod)PsiTreeUtil.getPrevSiblingOfType((PsiElement)prevBaseMethod, PsiMethod.class);
        }
        PsiMethod nextBaseMethod = (PsiMethod)PsiTreeUtil.getNextSiblingOfType((PsiElement)baseMethod, PsiMethod.class);
        while (nextBaseMethod != null) {
            MethodSignature signature;
            PsiMethod nextMethod;
            String name;
            String string = name = nextBaseMethod.isConstructor() ? aClass.getName() : nextBaseMethod.getName();
            if (name != null && (nextMethod = MethodSignatureUtil.findMethodBySignature((PsiClass)aClass, (MethodSignature)(signature = MethodSignatureUtil.createMethodSignature((String)name, (PsiParameterList)nextBaseMethod.getParameterList(), (PsiTypeParameterList)nextBaseMethod.getTypeParameterList(), (PsiSubstitutor)substitutor)), (boolean)false)) != null) {
                return nextMethod;
            }
            nextBaseMethod = (PsiMethod)PsiTreeUtil.getNextSiblingOfType((PsiElement)nextBaseMethod, PsiMethod.class);
        }
        return null;
    }

    public static void overrideOrImplement(PsiClass psiClass, @NotNull PsiMethod baseMethod) throws IncorrectOperationException {
        if (baseMethod == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/generation/OverrideImplementUtil.overrideOrImplement must not be null");
        }
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)baseMethod.getProject());
        List<PsiGenerationInfo<PsiMethod>> prototypes = OverrideImplementUtil.convert2GenerationInfos(OverrideImplementUtil.overrideOrImplementMethod(psiClass, baseMethod, false));
        if (prototypes.isEmpty()) {
            return;
        }
        PsiSubstitutor substitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)baseMethod.getContainingClass(), (PsiClass)psiClass, (PsiSubstitutor)PsiSubstitutor.EMPTY);
        PsiElement anchor = OverrideImplementUtil.getDefaultAnchorToOverrideOrImplement(psiClass, baseMethod, substitutor);
        List<PsiGenerationInfo<PsiMethod>> results = GenerateMembersUtil.insertMembersBeforeAnchor(psiClass, anchor, prototypes);
        PsiFile psiFile = psiClass.getContainingFile();
        Editor editor = fileEditorManager.openTextEditor(new OpenFileDescriptor(psiFile.getProject(), psiFile.getVirtualFile()), false);
        if (editor == null) {
            return;
        }
        GenerateMembersUtil.positionCaret(editor, (PsiElement)results.get(0).getPsiMember(), true);
        editor.getScrollingModel().scrollToCaret(ScrollType.CENTER);
    }

    public static PsiClass getContextClass(Project project, Editor editor, PsiFile file, boolean allowInterface) {
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        int offset = editor.getCaretModel().getOffset();
        PsiElement element = file.findElementAt(offset);
        while ((element = PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class)) instanceof PsiTypeParameter) {
        }
        PsiClass aClass = (PsiClass)element;
        if (aClass instanceof JspClass) {
            return null;
        }
        return aClass == null || !allowInterface && aClass.isInterface() ? null : aClass;
    }

    private static PsiSubstitutor getContextSubstitutor(PsiClass aClass) {
        if (aClass instanceof PsiAnonymousClass) {
            return ((PsiAnonymousClass)aClass).getBaseClassType().resolveGenerics().getSubstitutor();
        }
        return PsiSubstitutor.EMPTY;
    }

    public static void overrideOrImplementMethodsInRightPlace(Editor editor1, PsiClass aClass, Collection<PsiMethodMember> members, boolean copyJavadoc) {
        boolean insert = CodeStyleSettingsManager.getSettings((Project)aClass.getProject()).INSERT_OVERRIDE_ANNOTATION;
        OverrideImplementUtil.overrideOrImplementMethodsInRightPlace(editor1, aClass, members, copyJavadoc, insert);
    }

    public static List<PsiMethod> overrideOrImplementMethodCandidates(PsiClass aClass, Collection<CandidateInfo> candidatesToImplement, boolean copyJavadoc) throws IncorrectOperationException {
        boolean insert = CodeStyleSettingsManager.getSettings((Project)aClass.getProject()).INSERT_OVERRIDE_ANNOTATION;
        return OverrideImplementUtil.overrideOrImplementMethodCandidates(aClass, candidatesToImplement, copyJavadoc, insert);
    }
}

