/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.generation.ClassMember;
import com.intellij.codeInsight.generation.GenerateMembersUtil;
import com.intellij.codeInsight.generation.GenerationInfo;
import com.intellij.codeInsight.generation.OverrideImplementUtil;
import com.intellij.codeInsight.generation.TemplateGenerationInfo;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateEditingAdapter;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.ide.util.MemberChooser;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.actions.EnterAction;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GenerateMembersHandlerBase
implements CodeInsightActionHandler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.generation.GenerateMembersHandlerBase");
    private final String myChooserTitle;
    protected boolean myToCopyJavaDoc = false;

    public GenerateMembersHandlerBase(String chooserTitle) {
        this.myChooserTitle = chooserTitle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void invoke(final @NotNull Project project, final @NotNull Editor editor, @NotNull PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/generation/GenerateMembersHandlerBase.invoke must not be null");
        }
        if (editor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/generation/GenerateMembersHandlerBase.invoke must not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/codeInsight/generation/GenerateMembersHandlerBase.invoke must not be null");
        }
        if (!FileDocumentManager.getInstance().requestWriting(editor.getDocument(), project)) {
            return;
        }
        final PsiClass aClass = OverrideImplementUtil.getContextClass(project, editor, file, false);
        if (aClass == null || aClass.isInterface()) {
            return;
        }
        LOG.assertTrue(aClass.isValid());
        LOG.assertTrue(aClass.getContainingFile() != null);
        try {
            final ClassMember[] members = this.chooseOriginalMembers(aClass, project);
            if (members == null) {
                return;
            }
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    GenerateMembersHandlerBase.this.doGenerate(project, editor, aClass, members);
                }
            });
        }
        finally {
            this.cleanup();
        }
    }

    protected void cleanup() {
    }

    private void doGenerate(Project project, Editor editor, PsiClass aClass, ClassMember[] members) {
        List<? extends GenerationInfo> newMembers;
        int offset = editor.getCaretModel().getOffset();
        int col = editor.getCaretModel().getLogicalPosition().column;
        int line = editor.getCaretModel().getLogicalPosition().line;
        Document document = editor.getDocument();
        int lineStartOffset = document.getLineStartOffset(line);
        CharSequence docText = document.getCharsSequence();
        String textBeforeCaret = ((Object)docText.subSequence(lineStartOffset, offset)).toString();
        String afterCaret = ((Object)docText.subSequence(offset, document.getLineEndOffset(line))).toString();
        if (textBeforeCaret.trim().length() > 0 && StringUtil.isEmptyOrSpaces((String)afterCaret) && !editor.getSelectionModel().hasSelection()) {
            EnterAction.insertNewLineAtCaret(editor);
            PsiDocumentManager.getInstance((Project)project).commitDocument(document);
            offset = editor.getCaretModel().getOffset();
            col = editor.getCaretModel().getLogicalPosition().column;
            line = editor.getCaretModel().getLogicalPosition().line;
        }
        editor.getCaretModel().moveToLogicalPosition(new LogicalPosition(0, 0));
        try {
            List<? extends GenerationInfo> prototypes = this.generateMemberPrototypes(aClass, members);
            newMembers = GenerateMembersUtil.insertMembersAtOffset(aClass.getContainingFile(), offset, prototypes);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
            return;
        }
        if (newMembers.isEmpty()) {
            return;
        }
        editor.getCaretModel().moveToLogicalPosition(new LogicalPosition(line, col));
        ArrayList<TemplateGenerationInfo> templates = new ArrayList<TemplateGenerationInfo>();
        for (GenerationInfo generationInfo : newMembers) {
            if (!(generationInfo instanceof TemplateGenerationInfo)) continue;
            templates.add((TemplateGenerationInfo)generationInfo);
        }
        if (!templates.isEmpty()) {
            PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(document);
            GenerateMembersHandlerBase.runTemplates(project, editor, templates, 0);
        } else if (!newMembers.isEmpty()) {
            GenerateMembersUtil.positionCaret(editor, (PsiElement)newMembers.get(0).getPsiMember(), false);
        }
    }

    private static void runTemplates(final Project myProject, final Editor editor, final List<TemplateGenerationInfo> templates, final int index) {
        TemplateGenerationInfo info = templates.get(index);
        Template template = info.getTemplate();
        PsiMethod element = info.getPsiMember();
        TextRange range = element.getTextRange();
        editor.getDocument().deleteString(range.getStartOffset(), range.getEndOffset());
        int offset = range.getStartOffset();
        editor.getCaretModel().moveToOffset(offset);
        editor.getScrollingModel().scrollToCaret(ScrollType.CENTER);
        TemplateManager.getInstance(myProject).startTemplate(editor, template, new TemplateEditingAdapter(){

            @Override
            public void templateFinished(Template template, boolean brokenOff) {
                if (index + 1 < templates.size()) {
                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            new WriteCommandAction(myProject, new PsiFile[0]){

                                protected void run(Result result) throws Throwable {
                                    GenerateMembersHandlerBase.runTemplates(myProject, editor, templates, index + 1);
                                }
                            }.execute();
                        }
                    });
                }
            }
        });
    }

    @Nullable
    protected ClassMember[] chooseOriginalMembers(PsiClass aClass, Project project) {
        ClassMember[] allMembers = this.getAllOriginalMembers(aClass);
        return this.chooseMembers(allMembers, false, false, project);
    }

    @Nullable
    protected final ClassMember[] chooseMembers(ClassMember[] members, boolean allowEmptySelection, boolean copyJavadocCheckbox, Project project) {
        MemberChooser chooser = new MemberChooser(members, allowEmptySelection, true, project);
        chooser.setTitle(this.myChooserTitle);
        chooser.setCopyJavadocVisible(copyJavadocCheckbox);
        chooser.show();
        this.myToCopyJavaDoc = chooser.isCopyJavadoc();
        List<ClassMember> list = chooser.getSelectedElements();
        return list == null ? null : list.toArray(new ClassMember[list.size()]);
    }

    @NotNull
    protected List<? extends GenerationInfo> generateMemberPrototypes(PsiClass aClass, ClassMember[] members) throws IncorrectOperationException {
        ArrayList<GenerationInfo> array = new ArrayList<GenerationInfo>();
        for (ClassMember member : members) {
            GenerationInfo[] prototypes = this.generateMemberPrototypes(aClass, member);
            if (prototypes == null) continue;
            array.addAll(Arrays.asList(prototypes));
        }
        ArrayList<GenerationInfo> arrayList = array;
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/generation/GenerateMembersHandlerBase.generateMemberPrototypes must not return null");
        }
        return arrayList;
    }

    protected abstract ClassMember[] getAllOriginalMembers(PsiClass var1);

    protected abstract GenerationInfo[] generateMemberPrototypes(PsiClass var1, ClassMember var2) throws IncorrectOperationException;

    public boolean startInWriteAction() {
        return false;
    }
}

