/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.wordSelection;

import com.intellij.codeInsight.editorActions.wordSelection.WordSelectioner;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIdentifier;
import java.util.List;

public class FieldSelectioner
extends WordSelectioner {
    @Override
    public boolean canSelect(PsiElement e) {
        return e instanceof PsiField;
    }

    private static void addRangeElem(List<TextRange> result, CharSequence editorText, PsiElement first, int end) {
        if (first != null) {
            result.addAll(FieldSelectioner.expandToWholeLine(editorText, new TextRange(first.getTextRange().getStartOffset(), end)));
        }
    }

    @Override
    public List<TextRange> select(PsiElement e, CharSequence editorText, int cursorOffset, Editor editor) {
        List<TextRange> result = super.select(e, editorText, cursorOffset, editor);
        PsiField field = (PsiField)e;
        TextRange range = field.getTextRange();
        PsiIdentifier first = field.getNameIdentifier();
        TextRange firstRange = first.getTextRange();
        PsiExpression last = field.getInitializer();
        int end = last == null ? firstRange.getEndOffset() : last.getTextRange().getEndOffset();
        FieldSelectioner.addRangeElem(result, editorText, (PsiElement)first, end);
        FieldSelectioner.addRangeElem(result, editorText, (PsiElement)field.getModifierList(), range.getEndOffset());
        result.addAll(FieldSelectioner.expandToWholeLine(editorText, range));
        return result;
    }
}

