/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.enter;

import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.lang.ASTNode;
import com.intellij.lang.CodeDocumentationAwareCommenter;
import com.intellij.lang.Commenter;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageCommenters;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.text.CharArrayUtil;

public class EnterInLineCommentHandler
implements EnterHandlerDelegate {
    @Override
    public EnterHandlerDelegate.Result preprocessEnter(PsiFile file, Editor editor, Ref<Integer> caretOffsetRef, Ref<Integer> caretAdvance, DataContext dataContext, EditorActionHandler originalHandler) {
        int caretOffset = (Integer)caretOffsetRef.get();
        PsiElement psiAtOffset = file.findElementAt(caretOffset);
        if (psiAtOffset != null && psiAtOffset.getTextOffset() < caretOffset) {
            int offset;
            CodeDocumentationAwareCommenter commenter;
            ASTNode token = psiAtOffset.getNode();
            Document document = editor.getDocument();
            String text = document.getText();
            Language language = psiAtOffset.getLanguage();
            Commenter languageCommenter = (Commenter)LanguageCommenters.INSTANCE.forLanguage(language);
            CodeDocumentationAwareCommenter codeDocumentationAwareCommenter = commenter = languageCommenter instanceof CodeDocumentationAwareCommenter ? (CodeDocumentationAwareCommenter)languageCommenter : null;
            if (commenter != null && token.getElementType() == commenter.getLineCommentTokenType() && (offset = CharArrayUtil.shiftForward((CharSequence)text, (int)caretOffset, (String)" \t")) < document.getTextLength() && text.charAt(offset) != '\n') {
                assert (commenter.getLineCommentPrefix() != null) : "Line Comment type is set but Line Comment Prefix is null!";
                document.insertString(caretOffset, (CharSequence)(commenter.getLineCommentPrefix() + " "));
                return EnterHandlerDelegate.Result.Default;
            }
        }
        return EnterHandlerDelegate.Result.Continue;
    }
}

