/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.editorActions.ExtendWordSelectionHandler;
import com.intellij.codeInsight.editorActions.SelectWordUtil;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.DataManager;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.ASTNode;
import com.intellij.lang.CompositeLanguage;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import java.awt.Component;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SelectWordHandler
extends EditorActionHandler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.editorActions.SelectWordHandler");
    private final EditorActionHandler myOriginalHandler;

    public SelectWordHandler(EditorActionHandler originalHandler) {
        this.myOriginalHandler = originalHandler;
    }

    public void execute(Editor editor, DataContext dataContext) {
        Project project;
        if (LOG.isDebugEnabled()) {
            LOG.debug("enter: execute(editor='" + editor + "')");
        }
        if (editor instanceof EditorWindow && editor.getSelectionModel().hasSelection() && InjectedLanguageUtil.isSelectionIsAboutToOverflowInjectedFragment((EditorWindow)editor)) {
            editor = ((EditorWindow)editor).getDelegate();
        }
        if ((project = (Project)PlatformDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)editor.getComponent()))) == null) {
            if (this.myOriginalHandler != null) {
                this.myOriginalHandler.execute(editor, dataContext);
            }
            return;
        }
        Document document = editor.getDocument();
        PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
        if (file == null) {
            if (this.myOriginalHandler != null) {
                this.myOriginalHandler.execute(editor, dataContext);
            }
            return;
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        SelectWordHandler.doAction(editor, file);
    }

    private static void doAction(Editor editor, PsiFile file) {
        PsiElement anotherElement;
        PsiElement element;
        CharSequence text = editor.getDocument().getCharsSequence();
        if (file instanceof PsiCompiledElement) {
            file = (PsiFile)((PsiCompiledElement)file).getMirror();
        }
        FeatureUsageTracker.getInstance().triggerFeatureUsed("editing.select.word");
        int caretOffset = editor.getCaretModel().getOffset();
        if (caretOffset > 0 && caretOffset < editor.getDocument().getTextLength() && !Character.isJavaIdentifierPart(text.charAt(caretOffset)) && Character.isJavaIdentifierPart(text.charAt(caretOffset - 1))) {
            --caretOffset;
        }
        if ((element = SelectWordHandler.findElementAt(file, caretOffset)) instanceof PsiWhiteSpace && caretOffset > 0 && !((anotherElement = SelectWordHandler.findElementAt(file, caretOffset - 1)) instanceof PsiWhiteSpace)) {
            element = anotherElement;
        }
        while (element instanceof PsiWhiteSpace || element != null && StringUtil.isEmpty((String)element.getText().trim())) {
            while (element.getNextSibling() == null) {
                if (element instanceof PsiFile) {
                    return;
                }
                PsiElement parent = element.getParent();
                PsiElement[] children = parent.getChildren();
                if (children.length > 0 && children[children.length - 1] == element) {
                    element = parent;
                    continue;
                }
                element = parent;
                break;
            }
            if ((element = element.getNextSibling()) == null) {
                return;
            }
            caretOffset = element.getTextRange().getStartOffset();
        }
        TextRange selectionRange = new TextRange(editor.getSelectionModel().getSelectionStart(), editor.getSelectionModel().getSelectionEnd());
        TextRange newRange = null;
        int textLength = editor.getDocument().getTextLength();
        while (element != null && !(element instanceof PsiFile) && ((newRange = SelectWordHandler.advance(selectionRange, element, text, caretOffset, editor)) == null || newRange.isEmpty())) {
            element = SelectWordHandler.getUpperElement(element);
        }
        if (newRange == null) {
            newRange = new TextRange(0, textLength);
        }
        if (!editor.getSelectionModel().hasSelection() || newRange.contains(selectionRange)) {
            selectionRange = newRange;
        }
        editor.getSelectionModel().setSelection(selectionRange.getStartOffset(), selectionRange.getEndOffset());
    }

    @Nullable
    private static PsiElement findElementAt(PsiFile file, int caretOffset) {
        PsiElement elementAt = file.findElementAt(caretOffset);
        if (elementAt != null && SelectWordHandler.isLanguageExtension(file, elementAt)) {
            return file.getViewProvider().findElementAt(caretOffset, file.getLanguage());
        }
        return elementAt;
    }

    private static boolean isLanguageExtension(@NotNull PsiFile file, @NotNull PsiElement elementAt) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/editorActions/SelectWordHandler.isLanguageExtension must not be null");
        }
        if (elementAt == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/editorActions/SelectWordHandler.isLanguageExtension must not be null");
        }
        Language elementLanguage = elementAt.getLanguage();
        if (file.getLanguage() instanceof CompositeLanguage) {
            Language[] extensions;
            CompositeLanguage compositeLanguage = (CompositeLanguage)file.getLanguage();
            for (Language extension : extensions = compositeLanguage.getLanguageExtensionsForFile(file)) {
                if (extension != elementLanguage) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private static PsiElement getUpperElement(PsiElement e) {
        PsiElement psiElement;
        PsiFile baseRoot;
        PsiFile file;
        FileViewProvider viewProvider;
        PsiElement parent = e.getParent();
        if (!(e instanceof PsiErrorElement) && (viewProvider = (file = e.getContainingFile()).getViewProvider()).getBaseLanguage() != e.getLanguage() && (baseRoot = viewProvider.getPsi(viewProvider.getBaseLanguage())) != file && parent.getTextLength() == baseRoot.getTextLength()) {
            ASTNode leafElementAt;
            ASTNode node = baseRoot.getNode();
            if (!(node == null ? (psiElement = parent) != null : (psiElement = (leafElementAt = node.findLeafElementAt(e.getTextRange().getStartOffset())) != null ? leafElementAt.getPsi() : parent) != null)) throw new IllegalStateException("@NotNull method com/intellij/codeInsight/editorActions/SelectWordHandler.getUpperElement must not return null");
            return psiElement;
        }
        psiElement = parent;
        if (psiElement != null) return psiElement;
        throw new IllegalStateException("@NotNull method com/intellij/codeInsight/editorActions/SelectWordHandler.getUpperElement must not return null");
    }

    @Nullable
    private static TextRange advance(TextRange selectionRange, PsiElement element, CharSequence text, int cursorOffset, Editor editor) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("enter: advance(selectionRange='" + selectionRange + "', element='" + element + "')");
        }
        TextRange minimumRange = null;
        for (ExtendWordSelectionHandler selectioner : SelectWordUtil.getExtendWordSelectionHandlers()) {
            List ranges;
            if (!selectioner.canSelect(element) || (ranges = selectioner.select(element, text, cursorOffset, editor)) == null) continue;
            for (TextRange range : ranges) {
                if (range == null || !range.contains(selectionRange) || range.equals((Object)selectionRange) || minimumRange != null && !minimumRange.contains(range)) continue;
                minimumRange = range;
            }
        }
        if (minimumRange != null) {
            LOG.assertTrue(minimumRange.getEndOffset() <= text.length());
        }
        return minimumRange;
    }
}

