/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VariableArrayTypeFix
implements IntentionAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.quickfix.VariableArrayTypeFix");
    private final PsiVariable myVariable;
    @Nullable
    private final PsiNewExpression myNewExpression;
    @NotNull
    private final PsiArrayInitializerExpression myInitializer;
    @NotNull
    private final PsiArrayType myTargetType;

    public VariableArrayTypeFix(@NotNull PsiArrayInitializerExpression initializer, @NotNull PsiType componentType) {
        if (initializer == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/VariableArrayTypeFix.<init> must not be null");
        }
        if (componentType == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/VariableArrayTypeFix.<init> must not be null");
        }
        PsiArrayType arrayType = new PsiArrayType(componentType);
        PsiArrayInitializerExpression arrayInitializer = initializer;
        while (arrayInitializer.getParent() instanceof PsiArrayInitializerExpression) {
            arrayInitializer = (PsiArrayInitializerExpression)arrayInitializer.getParent();
            arrayType = new PsiArrayType((PsiType)arrayType);
        }
        this.myInitializer = arrayInitializer;
        this.myTargetType = arrayType;
        PsiNewExpression newExpressionLocal = null;
        PsiVariable variableLocal = null;
        PsiElement parent = this.myInitializer.getParent();
        if (parent instanceof PsiVariable) {
            variableLocal = (PsiVariable)parent;
        } else if (parent instanceof PsiNewExpression) {
            newExpressionLocal = (PsiNewExpression)parent;
            PsiElement newParent = newExpressionLocal.getParent();
            if (newParent instanceof PsiAssignmentExpression) {
                variableLocal = VariableArrayTypeFix.getFromAssignment((PsiAssignmentExpression)newParent);
            } else if (newParent instanceof PsiVariable) {
                variableLocal = (PsiVariable)newParent;
            }
        } else if (parent instanceof PsiAssignmentExpression) {
            variableLocal = VariableArrayTypeFix.getFromAssignment((PsiAssignmentExpression)parent);
        }
        this.myNewExpression = newExpressionLocal;
        this.myVariable = variableLocal;
    }

    @Nullable
    private static PsiVariable getFromAssignment(PsiAssignmentExpression assignment) {
        PsiExpression reference = assignment.getLExpression();
        PsiElement referencedElement = reference instanceof PsiReferenceExpression ? ((PsiReferenceExpression)reference).resolve() : null;
        return referencedElement != null && referencedElement instanceof PsiVariable ? (PsiVariable)referencedElement : null;
    }

    private String getNewText() {
        String newText = this.myNewExpression.getText();
        int initializerIdx = newText.indexOf(this.myInitializer.getText());
        if (initializerIdx != -1) {
            return newText.substring(0, initializerIdx).trim();
        }
        return newText;
    }

    @NotNull
    public String getText() {
        String string = this.myTargetType.equals((Object)this.myVariable.getType()) && this.myNewExpression != null ? QuickFixBundle.message("change.new.operator.type.text", this.getNewText(), this.myTargetType.getCanonicalText(), "") : QuickFixBundle.message("fix.variable.type.text", this.myVariable.getName(), this.myTargetType.getCanonicalText());
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/VariableArrayTypeFix.getText must not return null");
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.myTargetType.equals((Object)this.myVariable.getType()) && this.myNewExpression != null ? QuickFixBundle.message("change.new.operator.type.family", new Object[0]) : QuickFixBundle.message("fix.variable.type.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/VariableArrayTypeFix.getFamilyName must not return null");
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/VariableArrayTypeFix.isAvailable must not be null");
        }
        return this.myVariable != null && this.myVariable.isValid() && this.myVariable.getManager().isInProject((PsiElement)this.myVariable) && this.myTargetType.isValid() && this.myInitializer.isValid();
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/VariableArrayTypeFix.invoke must not be null");
        }
        if (!CodeInsightUtilBase.prepareFileForWrite(this.myVariable.getContainingFile())) {
            return;
        }
        try {
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)file.getProject()).getElementFactory();
            if (!this.myTargetType.equals((Object)this.myVariable.getType())) {
                this.myVariable.normalizeDeclaration();
                this.myVariable.getTypeElement().replace((PsiElement)factory.createTypeElement((PsiType)this.myTargetType));
                JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)this.myVariable);
                if (!this.myVariable.getContainingFile().equals(file)) {
                    UndoUtil.markPsiFileForUndo((PsiFile)this.myVariable.getContainingFile());
                }
            }
            if (this.myNewExpression != null) {
                if (!CodeInsightUtilBase.prepareFileForWrite(file)) {
                    return;
                }
                String text = "new " + this.myTargetType.getCanonicalText() + "{}";
                PsiNewExpression newExpression = (PsiNewExpression)factory.createExpressionFromText(text, this.myNewExpression.getParent());
                PsiElement[] children = newExpression.getChildren();
                children[children.length - 1].replace((PsiElement)this.myInitializer);
                this.myNewExpression.replace((PsiElement)newExpression);
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    public boolean startInWriteAction() {
        return true;
    }
}

