/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.ArgumentFixerActionFactory;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public abstract class MethodArgumentFix
implements IntentionAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.quickfix.MethodArgumentFix");
    protected final PsiExpressionList myArgList;
    protected final int myIndex;
    private final ArgumentFixerActionFactory myArgumentFixerActionFactory;
    protected final PsiType myToType;

    protected MethodArgumentFix(PsiExpressionList list, int i, PsiType toType, ArgumentFixerActionFactory fixerActionFactory) {
        this.myArgList = list;
        this.myIndex = i;
        this.myArgumentFixerActionFactory = fixerActionFactory;
        this.myToType = toType instanceof PsiEllipsisType ? ((PsiEllipsisType)toType).toArrayType() : toType;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/MethodArgumentFix.isAvailable must not be null");
        }
        return this.myToType != null && this.myToType.isValid() && this.myArgList != null && this.myArgList.getExpressions().length > this.myIndex && this.myArgList.getExpressions()[this.myIndex] != null && this.myArgList.getExpressions()[this.myIndex].isValid();
    }

    public boolean startInWriteAction() {
        return true;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/MethodArgumentFix.invoke must not be null");
        }
        if (!CodeInsightUtilBase.prepareFileForWrite(file)) {
            return;
        }
        PsiExpression expression = this.myArgList.getExpressions()[this.myIndex];
        try {
            PsiExpression modified = this.myArgumentFixerActionFactory.getModifiedArgument(expression, this.myToType);
            LOG.assertTrue(modified != null);
            expression.replace((PsiElement)modified);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("fix.argument.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/MethodArgumentFix.getFamilyName must not return null");
        }
        return string;
    }
}

