/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiParameter;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class MakeVarargParameterLastFix
implements IntentionAction {
    private final PsiParameter myParameter;

    public MakeVarargParameterLastFix(PsiParameter parameter) {
        this.myParameter = parameter;
    }

    @NotNull
    public String getText() {
        String string = QuickFixBundle.message("make.vararg.parameter.last.text", this.myParameter.getName());
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/MakeVarargParameterLastFix.getText must not return null");
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("make.vararg.parameter.last.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/MakeVarargParameterLastFix.getFamilyName must not return null");
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/MakeVarargParameterLastFix.isAvailable must not be null");
        }
        return this.myParameter.isValid() && this.myParameter.getManager().isInProject((PsiElement)this.myParameter);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/MakeVarargParameterLastFix.invoke must not be null");
        }
        if (!CodeInsightUtilBase.preparePsiElementForWrite((PsiElement)this.myParameter)) {
            return;
        }
        this.myParameter.getParent().add((PsiElement)this.myParameter);
        this.myParameter.delete();
    }

    public boolean startInWriteAction() {
        return true;
    }
}

