/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.find.FindManager;
import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.findUsages.FindUsagesManager;
import com.intellij.find.findUsages.FindUsagesOptions;
import com.intellij.find.impl.FindManagerImpl;
import com.intellij.ide.DataManager;
import com.intellij.ide.util.SuperMethodWarningUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.changeSignature.ChangeSignatureDialog;
import com.intellij.refactoring.changeSignature.ChangeSignatureProcessor;
import com.intellij.refactoring.changeSignature.ParameterInfoImpl;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ChangeMethodSignatureFromUsageFix
implements IntentionAction {
    private final PsiMethod myTargetMethod;
    private final PsiExpression[] myExpressions;
    private final PsiSubstitutor mySubstitutor;
    private final PsiElement myContext;
    private final boolean myChangeAllUsages;
    private final int myMinUsagesNumberToShowDialog;
    private ParameterInfoImpl[] myNewParametersInfo;

    ChangeMethodSignatureFromUsageFix(@NotNull PsiMethod targetMethod, @NotNull PsiExpression[] expressions, @NotNull PsiSubstitutor substitutor, @NotNull PsiElement context, boolean changeAllUsages, int minUsagesNumberToShowDialog) {
        if (targetMethod == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/ChangeMethodSignatureFromUsageFix.<init> must not be null");
        }
        if (expressions == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/ChangeMethodSignatureFromUsageFix.<init> must not be null");
        }
        if (substitutor == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/ChangeMethodSignatureFromUsageFix.<init> must not be null");
        }
        if (context == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/ChangeMethodSignatureFromUsageFix.<init> must not be null");
        }
        this.myTargetMethod = targetMethod;
        this.myExpressions = expressions;
        this.mySubstitutor = substitutor;
        this.myContext = context;
        this.myChangeAllUsages = changeAllUsages;
        this.myMinUsagesNumberToShowDialog = minUsagesNumberToShowDialog;
    }

    @NotNull
    public String getText() {
        String string = QuickFixBundle.message("change.method.signature.from.usage.text", HighlightUtil.formatMethod(this.myTargetMethod), this.myTargetMethod.getName(), ChangeMethodSignatureFromUsageFix.formatTypesList(this.myNewParametersInfo, this.myContext));
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/ChangeMethodSignatureFromUsageFix.getText must not return null");
        }
        return string;
    }

    private static String formatTypesList(ParameterInfoImpl[] infos, PsiElement context) {
        String result = "";
        try {
            for (ParameterInfoImpl info : infos) {
                PsiType type = info.getTypeWrapper().getType(context, context.getManager());
                if (result.length() != 0) {
                    result = result + ", ";
                }
                result = result + type.getPresentableText();
            }
        }
        catch (IncorrectOperationException e) {
            return null;
        }
        return result;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("change.method.signature.from.usage.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/ChangeMethodSignatureFromUsageFix.getFamilyName must not return null");
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/ChangeMethodSignatureFromUsageFix.isAvailable must not be null");
        }
        if (!this.myTargetMethod.isValid()) {
            return false;
        }
        for (PsiExpression expression : this.myExpressions) {
            if (expression.isValid()) continue;
            return false;
        }
        this.myNewParametersInfo = ChangeMethodSignatureFromUsageFix.getNewParametersInfo(this.myExpressions, this.myTargetMethod, this.mySubstitutor);
        if (this.myNewParametersInfo == null || ChangeMethodSignatureFromUsageFix.formatTypesList(this.myNewParametersInfo, this.myContext) == null) {
            return false;
        }
        return !this.isMethodSignatureExists();
    }

    private boolean isMethodSignatureExists() {
        PsiMethod[] methods;
        PsiClass target = this.myTargetMethod.getContainingClass();
        for (PsiMethod method : methods = target.findMethodsByName(this.myTargetMethod.getName(), false)) {
            if (!PsiUtil.isApplicable((PsiMethod)method, (PsiSubstitutor)PsiSubstitutor.EMPTY, (PsiExpression[])this.myExpressions)) continue;
            return true;
        }
        return false;
    }

    public void invoke(@NotNull Project project, Editor editor, final PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/ChangeMethodSignatureFromUsageFix.invoke must not be null");
        }
        if (!CodeInsightUtilBase.prepareFileForWrite(file)) {
            return;
        }
        final PsiMethod method = SuperMethodWarningUtil.checkSuperMethod(this.myTargetMethod, RefactoringBundle.message((String)"to.refactor"));
        if (method == null) {
            return;
        }
        if (!CodeInsightUtilBase.prepareFileForWrite(method.getContainingFile())) {
            return;
        }
        FindUsagesManager findUsagesManager = ((FindManagerImpl)FindManager.getInstance((Project)project)).getFindUsagesManager();
        final FindUsagesHandler handler = findUsagesManager.getFindUsagesHandler((PsiElement)method, false);
        if (handler == null) {
            return;
        }
        final FindUsagesOptions options = new FindUsagesOptions(project, editor == null ? null : DataManager.getInstance().getDataContext((Component)editor.getComponent()));
        options.isImplementingMethods = true;
        options.isMethodsUsages = true;
        options.isOverridingMethods = true;
        options.isUsages = true;
        options.isSearchForTextOccurences = false;
        final int[] usagesFound = new int[1];
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Processor<UsageInfo> processor = new Processor<UsageInfo>(){

                    public boolean process(UsageInfo t) {
                        usagesFound[0] = usagesFound[0] + 1;
                        return usagesFound[0] < ChangeMethodSignatureFromUsageFix.this.myMinUsagesNumberToShowDialog;
                    }
                };
                handler.processElementUsages((PsiElement)method, processor, options);
            }
        };
        String progressTitle = QuickFixBundle.message("searching.for.usages.progress.title", new Object[0]);
        if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(runnable, progressTitle, true, project)) {
            return;
        }
        this.myNewParametersInfo = ChangeMethodSignatureFromUsageFix.getNewParametersInfo(this.myExpressions, this.myTargetMethod, this.mySubstitutor);
        if (ApplicationManager.getApplication().isUnitTestMode() || usagesFound[0] < this.myMinUsagesNumberToShowDialog) {
            ChangeSignatureProcessor processor = new ChangeSignatureProcessor(project, method, false, null, method.getName(), method.getReturnType(), this.myNewParametersInfo){

                @Override
                @NotNull
                protected UsageInfo[] findUsages() {
                    UsageInfo[] usageInfoArray = ChangeMethodSignatureFromUsageFix.this.myChangeAllUsages ? super.findUsages() : UsageInfo.EMPTY_ARRAY;
                    if (usageInfoArray == null) {
                        throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/ChangeMethodSignatureFromUsageFix$2.findUsages must not return null");
                    }
                    return usageInfoArray;
                }
            };
            processor.run();
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    UndoUtil.markPsiFileForUndo((PsiFile)file);
                }
            });
        } else {
            ArrayList<ParameterInfoImpl> parameterInfos = new ArrayList<ParameterInfoImpl>(Arrays.asList(this.myNewParametersInfo));
            PsiReferenceExpression refExpr = TargetElementUtil.findReferenceExpression(editor);
            ChangeSignatureDialog dialog = new ChangeSignatureDialog(project, method, false, refExpr);
            dialog.setParameterInfos(parameterInfos);
            dialog.show();
            this.myNewParametersInfo = dialog.getParameters();
        }
    }

    public String getNewParameterNameByOldIndex(int oldIndex) {
        if (this.myNewParametersInfo == null) {
            return null;
        }
        for (ParameterInfoImpl info : this.myNewParametersInfo) {
            if (info.oldParameterIndex != oldIndex) continue;
            return info.getName();
        }
        return null;
    }

    private static ParameterInfoImpl[] getNewParametersInfo(PsiExpression[] expressions, PsiMethod targetMethod, PsiSubstitutor substitutor) {
        PsiParameter[] parameters = targetMethod.getParameterList().getParameters();
        ArrayList<ParameterInfoImpl> result = new ArrayList<ParameterInfoImpl>();
        if (expressions.length < parameters.length) {
            int ei = 0;
            int pi = 0;
            while (ei < expressions.length && pi < parameters.length) {
                PsiExpression expression = expressions[ei];
                PsiParameter parameter = parameters[pi];
                PsiType paramType = substitutor.substitute(parameter.getType());
                if (TypeConversionUtil.areTypesAssignmentCompatible((PsiType)paramType, (PsiExpression)expression)) {
                    result.add(new ParameterInfoImpl(pi, parameter.getName(), PsiUtil.convertAnonymousToBaseType((PsiType)paramType)));
                    ++pi;
                    ++ei;
                    continue;
                }
                ++pi;
            }
            if (result.size() != expressions.length) {
                return null;
            }
        } else if (expressions.length > parameters.length) {
            HashSet<String> existingNames = new HashSet<String>();
            for (PsiParameter parameter : parameters) {
                existingNames.add(parameter.getName());
            }
            int ei = 0;
            int pi = 0;
            while (ei < expressions.length || pi < parameters.length) {
                boolean parameterAssignable;
                PsiParameter parameter;
                PsiExpression expression = ei < expressions.length ? expressions[ei] : null;
                parameter = pi < parameters.length ? parameters[pi] : null;
                PsiType paramType = parameter == null ? null : substitutor.substitute(parameter.getType());
                boolean bl = parameterAssignable = paramType != null && (expression == null || TypeConversionUtil.areTypesAssignmentCompatible((PsiType)paramType, (PsiExpression)expression));
                if (parameterAssignable) {
                    result.add(new ParameterInfoImpl(pi, parameter.getName(), parameter.getType()));
                    ++pi;
                    ++ei;
                    continue;
                }
                if (expression == null) continue;
                PsiType exprType = RefactoringUtil.getTypeByExpression(expression);
                if (exprType == null) {
                    return null;
                }
                JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)expression.getProject());
                String name = ChangeMethodSignatureFromUsageFix.suggestUniqueParameterName(codeStyleManager, expression, exprType, existingNames);
                result.add(new ParameterInfoImpl(-1, name, exprType, expression.getText().replace('\n', ' ')));
                ++ei;
            }
            if (result.size() != expressions.length) {
                return null;
            }
        } else {
            PsiType paramType;
            for (int i = 0; i < parameters.length; ++i) {
                PsiParameter parameter = parameters[i];
                PsiExpression expression = expressions[i];
                paramType = substitutor.substitute(parameter.getType());
                if (TypeConversionUtil.areTypesAssignmentCompatible((PsiType)paramType, (PsiExpression)expression)) {
                    result.add(new ParameterInfoImpl(i, parameter.getName(), paramType));
                    continue;
                }
                PsiType exprType = RefactoringUtil.getTypeByExpression(expression);
                if (exprType == null) {
                    return null;
                }
                result.add(new ParameterInfoImpl(i, parameter.getName(), exprType));
            }
            boolean isSilly = true;
            for (int i = 0; i < result.size(); ++i) {
                ParameterInfoImpl parameterInfo;
                String typeText;
                PsiParameter parameter = parameters[i];
                paramType = substitutor.substitute(parameter.getType());
                if (paramType.equalsToText(typeText = (parameterInfo = (ParameterInfoImpl)result.get(i)).getTypeText())) continue;
                isSilly = false;
                break;
            }
            if (isSilly) {
                return null;
            }
        }
        return result.toArray(new ParameterInfoImpl[result.size()]);
    }

    private static String suggestUniqueParameterName(JavaCodeStyleManager codeStyleManager, PsiExpression expression, PsiType exprType, Set<String> existingNames) {
        SuggestedNameInfo nameInfo = codeStyleManager.suggestVariableName(VariableKind.PARAMETER, null, expression, exprType);
        String[] names = nameInfo.names;
        if (names.length == 0) {
            names = new String[]{"param"};
        }
        int suffix = 0;
        while (true) {
            for (String name : names) {
                String suggested = name + (suffix == 0 ? "" : String.valueOf(suffix));
                if (!existingNames.add(suggested)) continue;
                return suggested;
            }
            ++suffix;
        }
    }

    public static void registerIntentions(@NotNull JavaResolveResult[] candidates, @NotNull PsiExpressionList list, @NotNull HighlightInfo highlightInfo, TextRange fixRange) {
        if (candidates == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/ChangeMethodSignatureFromUsageFix.registerIntentions must not be null");
        }
        if (list == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/ChangeMethodSignatureFromUsageFix.registerIntentions must not be null");
        }
        if (highlightInfo == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/ChangeMethodSignatureFromUsageFix.registerIntentions must not be null");
        }
        if (candidates.length == 0) {
            return;
        }
        PsiExpression[] expressions = list.getExpressions();
        for (JavaResolveResult candidate : candidates) {
            ChangeMethodSignatureFromUsageFix.registerIntention(expressions, highlightInfo, fixRange, candidate, (PsiElement)list);
        }
    }

    private static void registerIntention(@NotNull PsiExpression[] expressions, @NotNull HighlightInfo highlightInfo, TextRange fixRange, @NotNull JavaResolveResult candidate, @NotNull PsiElement context) {
        if (expressions == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/ChangeMethodSignatureFromUsageFix.registerIntention must not be null");
        }
        if (highlightInfo == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/ChangeMethodSignatureFromUsageFix.registerIntention must not be null");
        }
        if (candidate == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/ChangeMethodSignatureFromUsageFix.registerIntention must not be null");
        }
        if (context == null) {
            throw new IllegalArgumentException("Argument 4 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/ChangeMethodSignatureFromUsageFix.registerIntention must not be null");
        }
        if (!candidate.isStaticsScopeCorrect()) {
            return;
        }
        PsiMethod method = (PsiMethod)candidate.getElement();
        PsiSubstitutor substitutor = candidate.getSubstitutor();
        if (method != null && context.getManager().isInProject((PsiElement)method)) {
            ChangeMethodSignatureFromUsageFix fix = new ChangeMethodSignatureFromUsageFix(method, expressions, substitutor, context, false, 2);
            QuickFixAction.registerQuickFixAction(highlightInfo, fixRange, fix, null);
        }
    }

    public boolean startInWriteAction() {
        return false;
    }
}

