/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.LanguageLevelModuleExtension;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import java.util.EnumMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IncreaseLanguageLevelFix
implements IntentionAction {
    private static final Logger LOG = Logger.getInstance((String)("#" + IncreaseLanguageLevelFix.class.getName()));
    private final LanguageLevel myLevel;
    private static final Map<LanguageLevel, String[]> acceptableJDKVersions = new EnumMap<LanguageLevel, String[]>(LanguageLevel.class);

    public IncreaseLanguageLevelFix(LanguageLevel targetLevel) {
        this.myLevel = targetLevel;
    }

    @NotNull
    public String getText() {
        String string = CodeInsightBundle.message((String)"set.language.level.to.0", (Object[])new Object[]{this.myLevel.getPresentableText()});
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/analysis/IncreaseLanguageLevelFix.getText must not return null");
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = CodeInsightBundle.message((String)"set.language.level", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/analysis/IncreaseLanguageLevelFix.getFamilyName must not return null");
        }
        return string;
    }

    private static boolean isJdkSupportsLevel(@Nullable Sdk jdk, LanguageLevel level) {
        String[] acceptableVersionNumbers;
        if (jdk == null) {
            return true;
        }
        JavaSdk sdk = JavaSdk.getInstance();
        String versionString = jdk.getVersionString();
        if (versionString == null) {
            return false;
        }
        for (String number : acceptableVersionNumbers = acceptableJDKVersions.get(level)) {
            if (sdk.compareTo(versionString, number) < 0) continue;
            return true;
        }
        return false;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/analysis/IncreaseLanguageLevelFix.isAvailable must not be null");
        }
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        Module module = ModuleUtil.findModuleForFile((VirtualFile)virtualFile, (Project)project);
        return IncreaseLanguageLevelFix.isLanguageLevelAcceptable(project, module, this.myLevel);
    }

    public static boolean isLanguageLevelAcceptable(Project project, Module module, LanguageLevel level) {
        return IncreaseLanguageLevelFix.isJdkSupportsLevel(IncreaseLanguageLevelFix.getRelevantJdk(project, module), level);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        LanguageLevel moduleLevel;
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/analysis/IncreaseLanguageLevelFix.invoke must not be null");
        }
        VirtualFile virtualFile = file.getVirtualFile();
        LOG.assertTrue(virtualFile != null);
        Module module = ModuleUtil.findModuleForFile((VirtualFile)virtualFile, (Project)project);
        LanguageLevel languageLevel = moduleLevel = module == null ? null : LanguageLevelModuleExtension.getInstance((Module)module).getLanguageLevel();
        if (moduleLevel != null && IncreaseLanguageLevelFix.isLanguageLevelAcceptable(project, module, this.myLevel)) {
            final ModifiableRootModel rootModel = ModuleRootManager.getInstance((Module)module).getModifiableModel();
            ((LanguageLevelModuleExtension)rootModel.getModuleExtension(LanguageLevelModuleExtension.class)).setLanguageLevel(this.myLevel);
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    rootModel.commit();
                }
            });
        } else {
            LanguageLevelProjectExtension.getInstance((Project)project).setLanguageLevel(this.myLevel);
        }
    }

    @Nullable
    private static Sdk getRelevantJdk(Project project, @Nullable Module module) {
        Sdk projectJdk = ProjectRootManager.getInstance((Project)project).getProjectJdk();
        Sdk moduleJdk = module == null ? null : ModuleRootManager.getInstance((Module)module).getSdk();
        return moduleJdk == null ? projectJdk : moduleJdk;
    }

    public boolean startInWriteAction() {
        return false;
    }

    static {
        acceptableJDKVersions.put(LanguageLevel.JDK_1_3, new String[]{"1.3"});
        acceptableJDKVersions.put(LanguageLevel.JDK_1_4, new String[]{"1.4"});
        acceptableJDKVersions.put(LanguageLevel.JDK_1_5, new String[]{"1.5", "5.0"});
        acceptableJDKVersions.put(LanguageLevel.JDK_1_6, new String[]{"1.6", "6.0"});
        acceptableJDKVersions.put(LanguageLevel.JDK_1_7, new String[]{"1.7", "7.0"});
    }
}

