/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.daemon.impl.analysis.XmlNSRenderer;
import com.intellij.codeInsight.hint.QuestionAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.XmlExtension;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImportNSAction
implements QuestionAction {
    private final Set<String> myNamespaces;
    private final XmlFile myFile;
    @Nullable
    private final PsiElement myElement;
    private final Editor myEditor;
    private final String myTitle;

    public ImportNSAction(Set<String> namespaces, XmlFile file, @NotNull PsiElement element, Editor editor, String title) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/analysis/ImportNSAction.<init> must not be null");
        }
        this.myNamespaces = namespaces;
        this.myFile = file;
        this.myElement = element;
        this.myEditor = editor;
        this.myTitle = title;
    }

    public boolean execute() {
        Object[] objects = this.myNamespaces.toArray();
        Arrays.sort(objects);
        final JList<Object> list = new JList<Object>(objects);
        list.setCellRenderer((ListCellRenderer<Object>)((Object)XmlNSRenderer.INSTANCE));
        list.setSelectedIndex(0);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                final String namespace = (String)list.getSelectedValue();
                if (namespace != null) {
                    Project project = ImportNSAction.this.myFile.getProject();
                    new WriteCommandAction.Simple(project, new PsiFile[]{ImportNSAction.this.myFile}){

                        protected void run() throws Throwable {
                            final XmlExtension extension = XmlExtension.getExtension((PsiFile)ImportNSAction.this.myFile);
                            String prefix = extension.getNamespacePrefix(ImportNSAction.this.myElement);
                            extension.insertNamespaceDeclaration(ImportNSAction.this.myFile, ImportNSAction.this.myEditor, Collections.singleton(namespace), prefix, new XmlExtension.Runner<String, IncorrectOperationException>(){

                                @Override
                                public void run(String s) throws IncorrectOperationException {
                                    PsiDocumentManager.getInstance((Project)ImportNSAction.this.myFile.getProject()).doPostponedOperationsAndUnblockDocument(ImportNSAction.this.myEditor.getDocument());
                                    extension.qualifyWithPrefix(s, ImportNSAction.this.myElement, ImportNSAction.this.myEditor.getDocument());
                                }
                            });
                        }
                    }.execute();
                }
            }
        };
        if (list.getModel().getSize() == 1) {
            runnable.run();
        } else {
            new PopupChooserBuilder(list).setTitle(this.myTitle).setItemChoosenCallback(runnable).createPopup().showInBestPositionFor(this.myEditor);
        }
        return true;
    }
}

