/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.daemon.impl.analysis.FileHighlighingSetting;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.util.containers.WeakHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;

@State(name="HighlightingSettingsPerFile", storages={@Storage(id="other", file="$WORKSPACE_FILE$")})
public class HighlightingSettingsPerFile
implements PersistentStateComponent<Element> {
    @NonNls
    private static final String SETTING_TAG = "setting";
    @NonNls
    private static final String ROOT_ATT_PREFIX = "root";
    @NonNls
    private static final String FILE_ATT = "file";
    private final Map<VirtualFile, FileHighlighingSetting[]> myHighlightSettings = new HashMap<VirtualFile, FileHighlighingSetting[]>();
    private final Map<PsiFile, InspectionProfile> myProfileSettings = new WeakHashMap();

    public static HighlightingSettingsPerFile getInstance(Project progect) {
        return (HighlightingSettingsPerFile)ServiceManager.getService((Project)progect, HighlightingSettingsPerFile.class);
    }

    public FileHighlighingSetting getHighlightingSettingForRoot(PsiElement root) {
        PsiFile containingFile = root.getContainingFile();
        VirtualFile virtualFile = containingFile.getVirtualFile();
        FileHighlighingSetting[] fileHighlighingSettings = this.myHighlightSettings.get(virtualFile);
        int index = PsiUtilBase.getRootIndex((PsiElement)root);
        if (fileHighlighingSettings == null || fileHighlighingSettings.length <= index) {
            return FileHighlighingSetting.FORCE_HIGHLIGHTING;
        }
        return fileHighlighingSettings[index];
    }

    public static FileHighlighingSetting[] getDefaults(PsiFile file) {
        int rootsCount = file.getViewProvider().getLanguages().size();
        FileHighlighingSetting[] fileHighlighingSettings = new FileHighlighingSetting[rootsCount];
        for (int i = 0; i < fileHighlighingSettings.length; ++i) {
            fileHighlighingSettings[i] = FileHighlighingSetting.FORCE_HIGHLIGHTING;
        }
        return fileHighlighingSettings;
    }

    public void setHighlightingSettingForRoot(PsiElement root, FileHighlighingSetting setting) {
        PsiFile containingFile = root.getContainingFile();
        VirtualFile virtualFile = containingFile.getVirtualFile();
        if (virtualFile == null) {
            return;
        }
        FileHighlighingSetting[] defaults = this.myHighlightSettings.get(virtualFile);
        int rootIndex = PsiUtilBase.getRootIndex((PsiElement)root);
        if (defaults != null && rootIndex >= defaults.length) {
            defaults = null;
        }
        if (defaults == null) {
            defaults = HighlightingSettingsPerFile.getDefaults(containingFile);
        }
        defaults[rootIndex] = setting;
        boolean toRemove = true;
        for (FileHighlighingSetting aDefault : defaults) {
            if (aDefault == FileHighlighingSetting.NONE) continue;
            toRemove = false;
        }
        if (!toRemove) {
            this.myHighlightSettings.put(virtualFile, defaults);
        } else {
            this.myHighlightSettings.remove(virtualFile);
        }
    }

    public void loadState(Element element) {
        List children = element.getChildren(SETTING_TAG);
        for (Object aChildren : children) {
            VirtualFile fileByUrl;
            Element child = (Element)aChildren;
            String url = child.getAttributeValue(FILE_ATT);
            if (url == null || (fileByUrl = VirtualFileManager.getInstance().findFileByUrl(url)) == null) continue;
            ArrayList<FileHighlighingSetting> settings = new ArrayList<FileHighlighingSetting>();
            int index = 0;
            while (child.getAttributeValue(ROOT_ATT_PREFIX + index) != null) {
                String attributeValue = child.getAttributeValue(ROOT_ATT_PREFIX + index++);
                settings.add(Enum.valueOf(FileHighlighingSetting.class, attributeValue));
            }
            this.myHighlightSettings.put(fileByUrl, settings.toArray(new FileHighlighingSetting[settings.size()]));
        }
    }

    public Element getState() {
        Element element = new Element("state");
        for (Map.Entry<VirtualFile, FileHighlighingSetting[]> entry : this.myHighlightSettings.entrySet()) {
            Element child = new Element(SETTING_TAG);
            VirtualFile vFile = entry.getKey();
            if (!vFile.isValid()) continue;
            child.setAttribute(FILE_ATT, vFile.getUrl());
            for (int i = 0; i < entry.getValue().length; ++i) {
                FileHighlighingSetting fileHighlighingSetting = entry.getValue()[i];
                child.setAttribute(ROOT_ATT_PREFIX + i, fileHighlighingSetting.toString());
            }
            element.addContent(child);
        }
        return element;
    }

    public synchronized void cleanProfileSettings() {
        this.myProfileSettings.clear();
    }

    public synchronized InspectionProfile getInspectionProfile(PsiFile file) {
        return this.myProfileSettings.get(file);
    }
}

