/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.daemon.JavaErrorMessages;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightMethodUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightNamesUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.AddReturnFix;
import com.intellij.codeInsight.daemon.impl.quickfix.AddVariableInitializerFix;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateConstructorParameterFromFieldFix;
import com.intellij.codeInsight.daemon.impl.quickfix.DeferFinalAssignmentFix;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.daemon.impl.quickfix.VariableAccessFromInnerClassFix;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ImplicitVariable;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.JspPsiUtil;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowFactory;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.controlFlow.LocalsOrMyInstanceFieldsControlFlowPolicy;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiMatcherImpl;
import com.intellij.psi.util.PsiMatchers;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class HighlightControlFlowUtil {
    private static final QuickFixFactory QUICK_FIX_FACTORY = QuickFixFactory.getInstance();

    @Nullable
    public static HighlightInfo checkMissingReturnStatement(PsiMethod method) {
        PsiCodeBlock body = method.getBody();
        if (body == null || method.getReturnType() == null || PsiType.VOID.equals(method.getReturnType())) {
            return null;
        }
        try {
            ControlFlow controlFlow = HighlightControlFlowUtil.getControlFlowNoConstantEvaluate((PsiElement)body);
            if (!ControlFlowUtil.returnPresent(controlFlow)) {
                PsiJavaToken rBrace = body.getRBrace();
                PsiJavaToken context = rBrace == null ? body.getLastChild() : rBrace;
                HighlightInfo highlightInfo = HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, (PsiElement)context, JavaErrorMessages.message("missing.return.statement", new Object[0]));
                QuickFixAction.registerQuickFixAction(highlightInfo, new AddReturnFix(method));
                IntentionAction fix = QUICK_FIX_FACTORY.createMethodReturnFix(method, PsiType.VOID, true);
                QuickFixAction.registerQuickFixAction(highlightInfo, fix);
                return highlightInfo;
            }
        }
        catch (AnalysisCanceledException analysisCanceledException) {
            // empty catch block
        }
        return null;
    }

    public static ControlFlow getControlFlowNoConstantEvaluate(PsiElement body) throws AnalysisCanceledException {
        return ControlFlowFactory.getInstance(body.getProject()).getControlFlow(body, LocalsOrMyInstanceFieldsControlFlowPolicy.getInstance(), false);
    }

    private static ControlFlow getControlFlow(PsiElement context) throws AnalysisCanceledException {
        return ControlFlowFactory.getInstance(context.getProject()).getControlFlow(context, LocalsOrMyInstanceFieldsControlFlowPolicy.getInstance());
    }

    public static HighlightInfo checkUnreachableStatement(PsiCodeBlock codeBlock) {
        if (codeBlock == null) {
            return null;
        }
        try {
            ControlFlow controlFlow = HighlightControlFlowUtil.getControlFlowNoConstantEvaluate((PsiElement)codeBlock);
            PsiElement unreachableStatement = ControlFlowUtil.getUnreachableStatement(controlFlow);
            if (unreachableStatement != null) {
                return HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, unreachableStatement, JavaErrorMessages.message("unreachable.statement", new Object[0]));
            }
        }
        catch (AnalysisCanceledException analysisCanceledException) {
            // empty catch block
        }
        return null;
    }

    private static boolean isFinalFieldInitialized(PsiField field) {
        if (field.hasInitializer()) {
            return true;
        }
        boolean isFieldStatic = field.hasModifierProperty("static");
        PsiClass aClass = field.getContainingClass();
        if (aClass != null && HighlightControlFlowUtil.isFieldInitializedInOtherFieldInitializer(aClass, field, isFieldStatic)) {
            return true;
        }
        if (aClass == null) {
            return false;
        }
        PsiClassInitializer[] initializers = aClass.getInitializers();
        for (PsiClassInitializer initializer : initializers) {
            if (initializer.hasModifierProperty("static") != isFieldStatic || !HighlightControlFlowUtil.variableDefinitelyAssignedIn((PsiVariable)field, (PsiElement)initializer.getBody())) continue;
            return true;
        }
        if (isFieldStatic) {
            return false;
        }
        PsiMethod[] constructors = aClass.getConstructors();
        if (constructors.length == 0) {
            return false;
        }
        block1: for (PsiMethod constructor : constructors) {
            PsiCodeBlock ctrBody = constructor.getBody();
            if (ctrBody == null) {
                return false;
            }
            List<PsiMethod> redirectedConstructors = HighlightControlFlowUtil.getChainedConstructors(constructor);
            for (int j = 0; redirectedConstructors != null && j < redirectedConstructors.size(); ++j) {
                PsiMethod redirectedConstructor = redirectedConstructors.get(j);
                PsiCodeBlock body = redirectedConstructor.getBody();
                if (body != null && HighlightControlFlowUtil.variableDefinitelyAssignedIn((PsiVariable)field, (PsiElement)body)) continue block1;
            }
            if (!ctrBody.isValid() || HighlightControlFlowUtil.variableDefinitelyAssignedIn((PsiVariable)field, (PsiElement)ctrBody)) continue;
            return false;
        }
        return true;
    }

    private static boolean isFieldInitializedInOtherFieldInitializer(PsiClass aClass, PsiField field, boolean fieldStatic) {
        PsiField[] fields;
        for (PsiField psiField : fields = aClass.getFields()) {
            if (psiField == field || psiField.hasModifierProperty("static") != fieldStatic || !HighlightControlFlowUtil.variableDefinitelyAssignedIn((PsiVariable)field, (PsiElement)psiField)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static List<PsiMethod> getChainedConstructors(PsiMethod constructor) {
        ConstructorVisitorInfo info = new ConstructorVisitorInfo();
        HighlightControlFlowUtil.visitConstructorChain(constructor, info);
        if (info.visitedConstructors != null) {
            info.visitedConstructors.remove(constructor);
        }
        return info.visitedConstructors;
    }

    public static boolean isRecursivelyCalledConstructor(PsiMethod constructor) {
        ConstructorVisitorInfo info = new ConstructorVisitorInfo();
        HighlightControlFlowUtil.visitConstructorChain(constructor, info);
        if (info.recursivelyCalledConstructor == null) {
            return false;
        }
        return info.visitedConstructors.indexOf(info.recursivelyCalledConstructor) <= info.visitedConstructors.indexOf(constructor);
    }

    private static void visitConstructorChain(PsiMethod constructor, ConstructorVisitorInfo info) {
        while (constructor != null) {
            PsiCodeBlock body = constructor.getBody();
            if (body == null) {
                return;
            }
            PsiStatement[] statements = body.getStatements();
            if (statements.length == 0) {
                return;
            }
            PsiStatement statement = statements[0];
            PsiElement element = new PsiMatcherImpl((PsiElement)statement).dot(PsiMatchers.hasClass(PsiExpressionStatement.class)).firstChild(PsiMatchers.hasClass(PsiMethodCallExpression.class)).firstChild(PsiMatchers.hasClass(PsiReferenceExpression.class)).firstChild(PsiMatchers.hasClass(PsiKeyword.class)).dot(PsiMatchers.hasText((String)"this")).parent(null).parent(null).getElement();
            if (element == null) {
                return;
            }
            PsiMethodCallExpression methodCall = (PsiMethodCallExpression)element;
            PsiMethod method = methodCall.resolveMethod();
            if (method == null) {
                return;
            }
            if (info.visitedConstructors != null && info.visitedConstructors.contains(method)) {
                info.recursivelyCalledConstructor = method;
                return;
            }
            if (info.visitedConstructors == null) {
                info.visitedConstructors = new ArrayList<PsiMethod>(5);
            }
            info.visitedConstructors.add(method);
            constructor = method;
        }
        return;
    }

    private static boolean variableDefinitelyAssignedIn(PsiVariable variable, PsiElement context) {
        try {
            ControlFlow controlFlow = HighlightControlFlowUtil.getControlFlow(context);
            return ControlFlowUtil.isVariableDefinitelyAssigned(variable, controlFlow);
        }
        catch (AnalysisCanceledException e) {
            return false;
        }
    }

    private static boolean variableDefinitelyNotAssignedIn(PsiVariable variable, PsiElement context) {
        try {
            ControlFlow controlFlow = HighlightControlFlowUtil.getControlFlow(context);
            return ControlFlowUtil.isVariableDefinitelyNotAssigned(variable, controlFlow);
        }
        catch (AnalysisCanceledException e) {
            return false;
        }
    }

    @Nullable
    public static HighlightInfo checkFinalFieldInitialized(PsiField field) {
        if (!field.hasModifierProperty("final")) {
            return null;
        }
        if (HighlightControlFlowUtil.isFinalFieldInitialized(field)) {
            return null;
        }
        String description = JavaErrorMessages.message("variable.not.initialized", field.getName());
        TextRange range = HighlightNamesUtil.getFieldDeclarationTextRange(field);
        HighlightInfo highlightInfo = HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, range.getStartOffset(), range.getEndOffset(), description);
        QuickFixAction.registerQuickFixAction(highlightInfo, HighlightMethodUtil.getFixRange((PsiElement)field), new CreateConstructorParameterFromFieldFix(field), null);
        PsiClass containingClass = field.getContainingClass();
        if (containingClass != null && !containingClass.isInterface()) {
            IntentionAction fix = QUICK_FIX_FACTORY.createModifierListFix((PsiModifierListOwner)field, "final", false, false);
            QuickFixAction.registerQuickFixAction(highlightInfo, fix);
        }
        QuickFixAction.registerQuickFixAction(highlightInfo, new AddVariableInitializerFix((PsiVariable)field));
        return highlightInfo;
    }

    @Nullable
    public static HighlightInfo checkVariableInitializedBeforeUsage(PsiReferenceExpression expression, PsiVariable variable, Map<PsiElement, Collection<PsiReferenceExpression>> uninitializedVarProblems) {
        PsiElement topBlock;
        if (variable instanceof ImplicitVariable) {
            return null;
        }
        if (!PsiUtil.isAccessedForReading((PsiExpression)expression)) {
            return null;
        }
        int startOffset = expression.getTextRange().getStartOffset();
        if (variable.hasInitializer()) {
            topBlock = PsiUtil.getVariableCodeBlock((PsiVariable)variable, (PsiElement)variable);
            if (topBlock == null) {
                return null;
            }
        } else {
            PsiFile scope;
            Object object = variable instanceof PsiField ? variable.getContainingFile() : (scope = variable.getParent() != null ? variable.getParent().getParent() : null);
            if (scope instanceof PsiCodeBlock && scope.getParent() instanceof PsiSwitchStatement) {
                scope = PsiTreeUtil.getParentOfType((PsiElement)scope, PsiCodeBlock.class);
            }
            Object object2 = topBlock = JspPsiUtil.isInJspFile((PsiElement)scope) && scope instanceof PsiFile ? scope : PsiUtil.getTopLevelEnclosingCodeBlock((PsiElement)expression, (PsiElement)scope);
            if (variable instanceof PsiField) {
                PsiClass aClass;
                PsiCodeBlock block;
                if (!variable.hasModifierProperty("final")) {
                    return null;
                }
                if (PsiUtil.findEnclosingConstructorOrInitializer((PsiElement)expression) == null && HighlightUtil.findEnclosingFieldInitializer((PsiElement)expression) == null) {
                    return null;
                }
                if (HighlightControlFlowUtil.inInnerClass((PsiElement)expression, ((PsiField)variable).getContainingClass())) {
                    return null;
                }
                if (topBlock == null) {
                    return null;
                }
                PsiElement parent = topBlock.getParent();
                if (parent instanceof PsiMethod) {
                    PsiMethod constructor = (PsiMethod)parent;
                    if (!parent.getManager().areElementsEquivalent((PsiElement)constructor.getContainingClass(), (PsiElement)((PsiField)variable).getContainingClass())) {
                        return null;
                    }
                    if (variable.hasModifierProperty("static")) {
                        return null;
                    }
                    List<PsiMethod> redirectedConstructors = HighlightControlFlowUtil.getChainedConstructors(constructor);
                    for (int j = 0; redirectedConstructors != null && j < redirectedConstructors.size(); ++j) {
                        PsiMethod redirectedConstructor = redirectedConstructors.get(j);
                        if (redirectedConstructor.getBody() == null || !HighlightControlFlowUtil.variableDefinitelyAssignedIn(variable, (PsiElement)redirectedConstructor.getBody())) continue;
                        return null;
                    }
                    block = constructor.getBody();
                    aClass = constructor.getContainingClass();
                } else if (parent instanceof PsiClassInitializer) {
                    PsiClassInitializer classInitializer = (PsiClassInitializer)parent;
                    if (!parent.getManager().areElementsEquivalent((PsiElement)classInitializer.getContainingClass(), (PsiElement)((PsiField)variable).getContainingClass())) {
                        return null;
                    }
                    block = classInitializer.getBody();
                    aClass = classInitializer.getContainingClass();
                } else {
                    PsiMethod[] constructors;
                    PsiField field = (PsiField)variable;
                    aClass = field.getContainingClass();
                    if (aClass == null || HighlightControlFlowUtil.isFieldInitializedInOtherFieldInitializer(aClass, field, field.hasModifierProperty("static"))) {
                        return null;
                    }
                    block = null;
                    for (PsiMethod constructor : constructors = aClass.getConstructors()) {
                        if (startOffset < constructor.getTextRange().getStartOffset()) continue;
                        if (constructor.getBody() != null && HighlightControlFlowUtil.variableDefinitelyAssignedIn(variable, (PsiElement)constructor.getBody())) {
                            return null;
                        }
                        List<PsiMethod> redirectedConstructors = HighlightControlFlowUtil.getChainedConstructors(constructor);
                        for (int j = 0; redirectedConstructors != null && j < redirectedConstructors.size(); ++j) {
                            PsiMethod redirectedConstructor = redirectedConstructors.get(j);
                            if (startOffset < redirectedConstructor.getTextRange().getStartOffset() || redirectedConstructor.getBody() == null || !HighlightControlFlowUtil.variableDefinitelyAssignedIn(variable, (PsiElement)redirectedConstructor.getBody())) continue;
                            return null;
                        }
                    }
                }
                if (aClass != null) {
                    PsiClassInitializer initializer;
                    PsiCodeBlock body;
                    PsiClassInitializer[] initializers;
                    PsiClassInitializer[] arr$ = initializers = aClass.getInitializers();
                    int len$ = arr$.length;
                    for (int i$ = 0; i$ < len$ && (body = (initializer = arr$[i$]).getBody()) != block; ++i$) {
                        boolean shouldCheckInitializerOrder;
                        boolean bl = shouldCheckInitializerOrder = block == null || block.getParent() instanceof PsiClassInitializer;
                        if (shouldCheckInitializerOrder && startOffset < initializer.getTextRange().getStartOffset() || initializer.hasModifierProperty("static") != variable.hasModifierProperty("static") || !HighlightControlFlowUtil.variableDefinitelyAssignedIn(variable, (PsiElement)body)) continue;
                        return null;
                    }
                }
            }
        }
        if (topBlock == null) {
            return null;
        }
        Collection<PsiReferenceExpression> codeBlockProblems = uninitializedVarProblems.get(topBlock);
        if (codeBlockProblems == null) {
            try {
                ControlFlow controlFlow = HighlightControlFlowUtil.getControlFlow(topBlock);
                codeBlockProblems = ControlFlowUtil.getReadBeforeWrite(controlFlow);
            }
            catch (AnalysisCanceledException e) {
                codeBlockProblems = Collections.emptyList();
            }
            uninitializedVarProblems.put(topBlock, codeBlockProblems);
        }
        if (codeBlockProblems.contains(expression)) {
            String name = expression.getElement().getText();
            String description = JavaErrorMessages.message("variable.not.initialized", name);
            HighlightInfo highlightInfo = HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, (PsiElement)expression, description);
            QuickFixAction.registerQuickFixAction(highlightInfo, new AddVariableInitializerFix(variable));
            return highlightInfo;
        }
        return null;
    }

    private static boolean inInnerClass(PsiElement element, PsiClass containingClass) {
        while (element != null) {
            if (element instanceof PsiClass) {
                return !element.getManager().areElementsEquivalent(element, (PsiElement)containingClass);
            }
            element = element.getParent();
        }
        return false;
    }

    public static boolean isReassigned(PsiVariable variable, Map<PsiElement, Collection<ControlFlowUtil.VariableInfo>> finalVarProblems, Map<PsiParameter, Boolean> parameterIsReassigned) {
        if (variable instanceof PsiLocalVariable) {
            PsiElement parent = variable.getParent();
            if (parent == null) {
                return false;
            }
            PsiElement declarationScope = parent.getParent();
            Collection<ControlFlowUtil.VariableInfo> codeBlockProblems = HighlightControlFlowUtil.getFinalVariableProblemsInBlock(finalVarProblems, declarationScope);
            return codeBlockProblems.contains(new ControlFlowUtil.VariableInfo(variable, null));
        }
        if (variable instanceof PsiParameter) {
            PsiParameter parameter = (PsiParameter)variable;
            Boolean isReassigned = parameterIsReassigned.get(parameter);
            if (isReassigned != null) {
                return isReassigned;
            }
            boolean isAssigned = PsiUtil.isAssigned((PsiParameter)parameter);
            parameterIsReassigned.put(parameter, isAssigned);
            return isAssigned;
        }
        return false;
    }

    public static HighlightInfo checkFinalVariableMightAlreadyHaveBeenAssignedTo(PsiVariable variable, PsiReferenceExpression expression, Map<PsiElement, Collection<ControlFlowUtil.VariableInfo>> finalVarProblems) {
        if (!PsiUtil.isAccessedForWriting((PsiExpression)expression)) {
            return null;
        }
        Object scope = variable instanceof PsiField ? variable.getParent() : (variable.getParent() == null ? null : variable.getParent().getParent());
        PsiElement codeBlock = PsiUtil.getTopLevelEnclosingCodeBlock((PsiElement)expression, (PsiElement)scope);
        if (codeBlock == null) {
            return null;
        }
        Collection<ControlFlowUtil.VariableInfo> codeBlockProblems = HighlightControlFlowUtil.getFinalVariableProblemsInBlock(finalVarProblems, codeBlock);
        boolean alreadyAssigned = false;
        for (ControlFlowUtil.VariableInfo variableInfo : codeBlockProblems) {
            if (variableInfo.expression != expression) continue;
            alreadyAssigned = true;
            break;
        }
        if (!alreadyAssigned) {
            if (!(variable instanceof PsiField)) {
                return null;
            }
            PsiField field = (PsiField)variable;
            PsiClass aClass = field.getContainingClass();
            if (aClass == null) {
                return null;
            }
            PsiField[] fields = aClass.getFields();
            boolean isFieldStatic = field.hasModifierProperty("static");
            for (PsiField psiField : fields) {
                PsiExpression initializer = psiField.getInitializer();
                if (psiField == field || psiField.hasModifierProperty("static") != isFieldStatic || initializer == null || initializer == codeBlock || HighlightControlFlowUtil.variableDefinitelyNotAssignedIn((PsiVariable)field, (PsiElement)initializer)) continue;
                alreadyAssigned = true;
                break;
            }
            if (!alreadyAssigned) {
                PsiClassInitializer[] initializers;
                PsiMember enclosingConstructorOrInitializer = PsiUtil.findEnclosingConstructorOrInitializer((PsiElement)expression);
                if (enclosingConstructorOrInitializer == null || !aClass.getManager().areElementsEquivalent((PsiElement)enclosingConstructorOrInitializer.getContainingClass(), (PsiElement)aClass)) {
                    return null;
                }
                for (PsiClassInitializer initializer : initializers = aClass.getInitializers()) {
                    if (initializer.hasModifierProperty("static") != field.hasModifierProperty("static")) continue;
                    PsiCodeBlock body = initializer.getBody();
                    if (body == codeBlock) {
                        return null;
                    }
                    try {
                        ControlFlow controlFlow = HighlightControlFlowUtil.getControlFlow((PsiElement)body);
                        if (ControlFlowUtil.isVariableDefinitelyNotAssigned((PsiVariable)field, controlFlow)) continue;
                        alreadyAssigned = true;
                        break;
                    }
                    catch (AnalysisCanceledException e) {
                        return null;
                    }
                }
            }
            if (!alreadyAssigned && !field.hasModifierProperty("static")) {
                PsiMethod ctr = codeBlock.getParent() instanceof PsiMethod ? (PsiMethod)codeBlock.getParent() : null;
                List<PsiMethod> redirectedConstructors = ctr != null && ctr.isConstructor() ? HighlightControlFlowUtil.getChainedConstructors(ctr) : null;
                for (int j = 0; redirectedConstructors != null && j < redirectedConstructors.size(); ++j) {
                    PsiMethod redirectedConstructor = redirectedConstructors.get(j);
                    if (redirectedConstructor.getBody() == null || !HighlightControlFlowUtil.variableDefinitelyAssignedIn(variable, (PsiElement)redirectedConstructor.getBody())) continue;
                    alreadyAssigned = true;
                    break;
                }
            }
        }
        if (alreadyAssigned) {
            String description = JavaErrorMessages.message("variable.already.assigned", variable.getName());
            HighlightInfo highlightInfo = HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, (PsiElement)expression, description);
            IntentionAction fix = QUICK_FIX_FACTORY.createModifierListFix((PsiModifierListOwner)variable, "final", false, false);
            QuickFixAction.registerQuickFixAction(highlightInfo, fix);
            QuickFixAction.registerQuickFixAction(highlightInfo, new DeferFinalAssignmentFix(variable, expression));
            return highlightInfo;
        }
        return null;
    }

    private static Collection<ControlFlowUtil.VariableInfo> getFinalVariableProblemsInBlock(Map<PsiElement, Collection<ControlFlowUtil.VariableInfo>> finalVarProblems, PsiElement codeBlock) {
        Collection<ControlFlowUtil.VariableInfo> codeBlockProblems = finalVarProblems.get(codeBlock);
        if (codeBlockProblems == null) {
            try {
                ControlFlow controlFlow = HighlightControlFlowUtil.getControlFlow(codeBlock);
                codeBlockProblems = ControlFlowUtil.getInitializedTwice(controlFlow);
            }
            catch (AnalysisCanceledException e) {
                codeBlockProblems = Collections.emptyList();
            }
            finalVarProblems.put(codeBlock, codeBlockProblems);
        }
        return codeBlockProblems;
    }

    public static HighlightInfo checkFinalVariableInitalizedInLoop(PsiReferenceExpression expression, PsiElement resolved) {
        if (ControlFlowUtil.isVariableAssignedInLoop(expression, resolved)) {
            String description = JavaErrorMessages.message("variable.assigned.in.loop", ((PsiVariable)resolved).getName());
            HighlightInfo highlightInfo = HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, (PsiElement)expression, description);
            IntentionAction fix = QUICK_FIX_FACTORY.createModifierListFix((PsiModifierListOwner)((PsiVariable)resolved), "final", false, false);
            QuickFixAction.registerQuickFixAction(highlightInfo, fix);
            return highlightInfo;
        }
        return null;
    }

    public static HighlightInfo checkCannotWriteToFinal(PsiExpression expression) {
        PsiVariable variable;
        IElementType sign;
        PsiExpression operand;
        PsiReferenceExpression reference = null;
        if (expression instanceof PsiAssignmentExpression) {
            PsiExpression left = ((PsiAssignmentExpression)expression).getLExpression();
            if (left instanceof PsiReferenceExpression) {
                reference = (PsiReferenceExpression)left;
            }
        } else if (expression instanceof PsiPostfixExpression) {
            operand = ((PsiPostfixExpression)expression).getOperand();
            sign = ((PsiPostfixExpression)expression).getOperationSign().getTokenType();
            if (operand instanceof PsiReferenceExpression && (sign == JavaTokenType.PLUSPLUS || sign == JavaTokenType.MINUSMINUS)) {
                reference = (PsiReferenceExpression)operand;
            }
        } else if (expression instanceof PsiPrefixExpression) {
            operand = ((PsiPrefixExpression)expression).getOperand();
            sign = ((PsiPrefixExpression)expression).getOperationSign().getTokenType();
            if (operand instanceof PsiReferenceExpression && (sign == JavaTokenType.PLUSPLUS || sign == JavaTokenType.MINUSMINUS)) {
                reference = (PsiReferenceExpression)operand;
            }
        }
        PsiElement resolved = reference == null ? null : reference.resolve();
        PsiVariable psiVariable = variable = resolved instanceof PsiVariable ? (PsiVariable)resolved : null;
        if (variable == null || !variable.hasModifierProperty("final")) {
            return null;
        }
        if (!HighlightControlFlowUtil.canWriteToFinal(variable, expression, reference)) {
            String name = variable.getName();
            String description = JavaErrorMessages.message("assignment.to.final.variable", name);
            HighlightInfo highlightInfo = HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, (PsiElement)expression, description);
            PsiClass innerClass = HighlightControlFlowUtil.getInnerClassVariableReferencedFrom(variable, (PsiElement)expression);
            if (innerClass == null || variable instanceof PsiField) {
                IntentionAction fix = QUICK_FIX_FACTORY.createModifierListFix((PsiModifierListOwner)variable, "final", false, false);
                QuickFixAction.registerQuickFixAction(highlightInfo, fix);
            } else {
                QuickFixAction.registerQuickFixAction(highlightInfo, new VariableAccessFromInnerClassFix(variable, innerClass));
            }
            return highlightInfo;
        }
        return null;
    }

    private static boolean canWriteToFinal(PsiVariable variable, PsiExpression expression, PsiReferenceExpression reference) {
        if (variable.hasInitializer()) {
            return false;
        }
        if (variable instanceof PsiParameter) {
            return false;
        }
        PsiClass innerClass = HighlightControlFlowUtil.getInnerClassVariableReferencedFrom(variable, (PsiElement)expression);
        if (variable instanceof PsiField) {
            if (HighlightUtil.findEnclosingFieldInitializer((PsiElement)expression) != null) {
                return true;
            }
            PsiField field = (PsiField)variable;
            if (innerClass != null && !innerClass.getManager().areElementsEquivalent((PsiElement)innerClass, (PsiElement)field.getContainingClass())) {
                return false;
            }
            PsiMember enclosingCtrOrInitializer = PsiUtil.findEnclosingConstructorOrInitializer((PsiElement)expression);
            return enclosingCtrOrInitializer != null && HighlightControlFlowUtil.isSameField(variable, enclosingCtrOrInitializer, field, reference);
        }
        if (variable instanceof PsiLocalVariable) {
            boolean isAccessedFromOtherClass;
            boolean bl = isAccessedFromOtherClass = innerClass != null;
            if (isAccessedFromOtherClass) {
                return false;
            }
        }
        return true;
    }

    private static boolean isSameField(PsiVariable variable, PsiMember enclosingCtrOrInitializer, PsiField field, PsiReferenceExpression reference) {
        if (!variable.getManager().areElementsEquivalent((PsiElement)enclosingCtrOrInitializer.getContainingClass(), (PsiElement)field.getContainingClass())) {
            return false;
        }
        PsiExpression qualifierExpression = reference.getQualifierExpression();
        return qualifierExpression == null || qualifierExpression instanceof PsiThisExpression;
    }

    static HighlightInfo checkVariableMustBeFinal(PsiVariable variable, PsiJavaCodeReferenceElement context) {
        if (variable.hasModifierProperty("final")) {
            return null;
        }
        PsiClass innerClass = HighlightControlFlowUtil.getInnerClassVariableReferencedFrom(variable, (PsiElement)context);
        if (innerClass != null) {
            String description = JavaErrorMessages.message("variable.must.be.final", context.getText());
            HighlightInfo highlightInfo = HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, (PsiElement)context, description);
            QuickFixAction.registerQuickFixAction(highlightInfo, new VariableAccessFromInnerClassFix(variable, innerClass));
            return highlightInfo;
        }
        return null;
    }

    public static PsiClass getInnerClassVariableReferencedFrom(PsiVariable variable, PsiElement context) {
        PsiElement scope = variable instanceof PsiLocalVariable ? variable.getParent().getParent() : (variable instanceof PsiParameter ? ((PsiParameter)variable).getDeclarationScope() : variable.getParent());
        if (scope.getContainingFile() != context.getContainingFile()) {
            return null;
        }
        PsiElement prevParent = context;
        for (PsiElement parent = context.getParent(); parent != null && !parent.equals(scope); parent = parent.getParent()) {
            if (!(!(parent instanceof PsiClass) || prevParent instanceof PsiExpressionList && parent instanceof PsiAnonymousClass)) {
                return (PsiClass)parent;
            }
            prevParent = parent;
        }
        return null;
    }

    public static HighlightInfo checkInitializerCompleteNormally(PsiClassInitializer initializer) {
        PsiCodeBlock body = initializer.getBody();
        try {
            ControlFlow controlFlow = HighlightControlFlowUtil.getControlFlowNoConstantEvaluate((PsiElement)body);
            int completionReasons = ControlFlowUtil.getCompletionReasons(controlFlow, 0, controlFlow.getSize());
            if ((completionReasons & 1) == 0) {
                return HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, (PsiElement)body, JavaErrorMessages.message("initializer.must.be.able.to.complete.normally", new Object[0]));
            }
        }
        catch (AnalysisCanceledException analysisCanceledException) {
            // empty catch block
        }
        return null;
    }

    private static class ConstructorVisitorInfo {
        List<PsiMethod> visitedConstructors;
        PsiMethod recursivelyCalledConstructor;

        private ConstructorVisitorInfo() {
        }
    }
}

