/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProvider;
import com.intellij.codeInsight.daemon.impl.CollectHighlightsUtil;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerImpl;
import com.intellij.codeInsight.daemon.impl.LineMarkersPass;
import com.intellij.codeInsight.daemon.impl.LineMarkersProcessor;
import com.intellij.codeInsight.daemon.impl.UpdateHighlightersUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightLevelUtil;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class SlowLineMarkersPass
extends TextEditorHighlightingPass
implements LineMarkersProcessor,
DumbAware {
    private final PsiFile myFile;
    private final int myStartOffset;
    private final int myEndOffset;
    private volatile Collection<LineMarkerInfo> myMarkers;

    public SlowLineMarkersPass(@NotNull Project project, @NotNull PsiFile file, @NotNull Document document, int startOffset, int endOffset) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/SlowLineMarkersPass.<init> must not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/SlowLineMarkersPass.<init> must not be null");
        }
        if (document == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/SlowLineMarkersPass.<init> must not be null");
        }
        super(project, document, false);
        this.myMarkers = Collections.emptyList();
        this.myFile = file;
        this.myStartOffset = startOffset;
        this.myEndOffset = endOffset;
    }

    @Override
    public void doCollectInformation(ProgressIndicator progress) {
        FileViewProvider viewProvider = this.myFile.getViewProvider();
        Set relevantLanguages = viewProvider.getLanguages();
        SmartList markers = new SmartList();
        for (Language language : relevantLanguages) {
            PsiFile psiRoot = viewProvider.getPsi(language);
            if (psiRoot == null || !HighlightLevelUtil.shouldHighlight((PsiElement)psiRoot)) continue;
            List<PsiElement> elements = CollectHighlightsUtil.getElementsInRange((PsiElement)psiRoot, this.myStartOffset, this.myEndOffset);
            List<LineMarkerProvider> providers = LineMarkersPass.getMarkerProviders(language, this.myProject);
            this.addLineMarkers(elements, providers, (List<LineMarkerInfo>)markers, progress);
            LineMarkersPass.collectLineMarkersForInjected((List<LineMarkerInfo>)markers, elements, this, this.myFile, progress);
        }
        this.myMarkers = markers;
    }

    @Override
    public void addLineMarkers(@NotNull List<PsiElement> elements, @NotNull List<LineMarkerProvider> providers, @NotNull List<LineMarkerInfo> result, @NotNull ProgressIndicator progress) throws ProcessCanceledException {
        if (elements == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/SlowLineMarkersPass.addLineMarkers must not be null");
        }
        if (providers == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/SlowLineMarkersPass.addLineMarkers must not be null");
        }
        if (result == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/SlowLineMarkersPass.addLineMarkers must not be null");
        }
        if (progress == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/SlowLineMarkersPass.addLineMarkers must not be null");
        }
        for (LineMarkerProvider provider : providers) {
            provider.collectSlowLineMarkers(elements, result);
        }
    }

    @Override
    public void doApplyInformationToEditor() {
        UpdateHighlightersUtil.setLineMarkersToEditor(this.myProject, this.myDocument, this.myStartOffset, this.myEndOffset, this.myMarkers, this.getId());
        DaemonCodeAnalyzer daemonCodeAnalyzer = DaemonCodeAnalyzer.getInstance((Project)this.myProject);
        ((DaemonCodeAnalyzerImpl)daemonCodeAnalyzer).getFileStatusMap().markFileUpToDate(this.myDocument, this.myFile, this.getId());
    }
}

