/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.ui.awt.RelativePoint;
import java.awt.event.MouseEvent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class PsiElementListNavigator {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.PsiElementListNavigator");

    private PsiElementListNavigator() {
    }

    public static void openTargets(MouseEvent e, NavigatablePsiElement[] targets, String title, ListCellRenderer listRenderer) {
        if (targets.length == 0) {
            return;
        }
        if (targets.length == 1) {
            targets[0].navigate(true);
        } else {
            final JList<NavigatablePsiElement> list = new JList<NavigatablePsiElement>(targets);
            list.setCellRenderer(listRenderer);
            PopupChooserBuilder builder = new PopupChooserBuilder(list);
            if (listRenderer instanceof PsiElementListCellRenderer) {
                ((PsiElementListCellRenderer)listRenderer).installSpeedSearch(builder);
            }
            builder.setTitle(title).setMovable(true).setItemChoosenCallback(new Runnable(){

                @Override
                public void run() {
                    Object[] selectedElements;
                    int[] ids = list.getSelectedIndices();
                    if (ids == null || ids.length == 0) {
                        return;
                    }
                    for (Object element : selectedElements = list.getSelectedValues()) {
                        PsiElement selected = (PsiElement)element;
                        LOG.assertTrue(selected.isValid());
                        ((NavigatablePsiElement)selected).navigate(true);
                    }
                }
            }).createPopup().show(new RelativePoint(e));
        }
    }
}

