/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.controlflow.impl;

import com.intellij.codeInsight.controlflow.ControlFlowBuilder;
import com.intellij.codeInsight.controlflow.Instruction;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.Nullable;

public class InstructionImpl
implements Instruction {
    final ArrayList<Instruction> myPred = new ArrayList();
    final ArrayList<Instruction> mySucc = new ArrayList();
    protected final PsiElement myElement;
    private final int myNumber;

    @Override
    @Nullable
    public final PsiElement getElement() {
        return this.myElement;
    }

    public InstructionImpl(ControlFlowBuilder builder, PsiElement element) {
        this.myElement = element;
        this.myNumber = builder.instructionCount++;
    }

    @Override
    public final Collection<Instruction> allSucc() {
        return this.mySucc;
    }

    @Override
    public final Collection<Instruction> allPred() {
        return this.myPred;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.myNumber);
        builder.append("(");
        for (int i = 0; i < this.mySucc.size(); ++i) {
            if (i > 0) {
                builder.append(',');
            }
            builder.append(this.mySucc.get(i).num());
        }
        builder.append(") ").append(this.getElementPresentation());
        return builder.toString();
    }

    @Override
    public String getElementPresentation() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("element: ").append(this.myElement);
        return buffer.toString();
    }

    @Override
    public final int num() {
        return this.myNumber;
    }
}

