/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.completion.AbstractExpectedTypeSkipper;
import com.intellij.codeInsight.completion.CompletionLocation;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.CompletionWeigher;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.completion.JavaSmartCompletionContributor;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.util.NullableLazyKey;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.NullableFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PreferDefaultTypeWeigher
extends CompletionWeigher {
    private static final NullableLazyKey<PsiTypeParameter, CompletionLocation> TYPE_PARAMETER = NullableLazyKey.create((String)"expectedTypes", (NullableFunction)new NullableFunction<CompletionLocation, PsiTypeParameter>(){

        @Nullable
        public PsiTypeParameter fun(CompletionLocation location) {
            Pair<PsiClass, Integer> pair = JavaSmartCompletionContributor.getTypeParameterInfo(location.getCompletionParameters().getPosition());
            if (pair == null) {
                return null;
            }
            return ((PsiClass)pair.first).getTypeParameters()[(Integer)pair.second];
        }
    });

    public MyResult weigh(@NotNull LookupElement item, CompletionLocation location) {
        PsiTypeParameter parameter;
        if (item == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/completion/PreferDefaultTypeWeigher.weigh must not be null");
        }
        Object object = item.getObject();
        if (location.getCompletionType() != CompletionType.SMART) {
            return MyResult.normal;
        }
        if (object instanceof PsiClass && (parameter = (PsiTypeParameter)TYPE_PARAMETER.getValue((UserDataHolder)location)) != null && object.equals(PsiUtil.resolveClassInType((PsiType)TypeConversionUtil.typeParameterErasure((PsiTypeParameter)parameter)))) {
            return MyResult.exactlyExpected;
        }
        ExpectedTypeInfo[] expectedInfos = (ExpectedTypeInfo[])JavaCompletionUtil.EXPECTED_TYPES.getValue((UserDataHolder)location);
        if (expectedInfos == null) {
            return MyResult.normal;
        }
        PsiType itemType = JavaCompletionUtil.getLookupElementType(item);
        if (itemType == null || !itemType.isValid()) {
            return MyResult.normal;
        }
        if (object instanceof PsiClass) {
            for (ExpectedTypeInfo info : expectedInfos) {
                if (!TypeConversionUtil.erasure((PsiType)info.getType().getDeepComponentType()).equals(TypeConversionUtil.erasure((PsiType)itemType))) continue;
                return AbstractExpectedTypeSkipper.skips(item, location) ? MyResult.expectedNoSelect : MyResult.exactlyExpected;
            }
        }
        for (ExpectedTypeInfo expectedInfo : expectedInfos) {
            PsiType defaultType = expectedInfo.getDefaultType();
            PsiType expectedType = expectedInfo.getType();
            if (!expectedType.isValid()) {
                return MyResult.normal;
            }
            if (defaultType != expectedType) {
                if (defaultType.equals(itemType)) {
                    return MyResult.exactlyDefault;
                }
                if (defaultType.isAssignableFrom(itemType)) {
                    return MyResult.ofDefaultType;
                }
            }
            if (!PsiType.VOID.equals(itemType) || !PsiType.VOID.equals(expectedType)) continue;
            return MyResult.exactlyExpected;
        }
        return MyResult.normal;
    }

    private static enum MyResult {
        normal,
        exactlyExpected,
        ofDefaultType,
        exactlyDefault,
        expectedNoSelect;

    }
}

