/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.completion.CompletionLocation;
import com.intellij.codeInsight.completion.CompletionStatistician;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupItem;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.statistics.JavaStatisticsManager;
import com.intellij.psi.statistics.StatisticsInfo;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NonNls;

public class JavaCompletionStatistician
extends CompletionStatistician {
    @NonNls
    public static final String CLASS_NAME_COMPLETION_PREFIX = "classNameCompletion#";

    public StatisticsInfo serialize(LookupElement element, CompletionLocation location) {
        boolean primitivesOnly;
        Object o = element.getObject();
        if (o instanceof PsiLocalVariable || o instanceof PsiParameter || o instanceof PsiThisExpression) {
            return StatisticsInfo.EMPTY;
        }
        Object[] infos = (ExpectedTypeInfo[])JavaCompletionUtil.EXPECTED_TYPES.getValue((UserDataHolder)location);
        if (infos != null && infos.length > 0 && (primitivesOnly = ContainerUtil.and((Object[])infos, (Condition)new Condition<ExpectedTypeInfo>(){

            public boolean value(ExpectedTypeInfo info) {
                return info.getType() instanceof PsiPrimitiveType;
            }
        }))) {
            return StatisticsInfo.EMPTY;
        }
        LookupItem item = LookupItem.from(element);
        if (item == null) {
            return null;
        }
        PsiType qualifierType = JavaCompletionUtil.getQualifierType(item);
        if (qualifierType == null && infos != null && infos.length > 0) {
            qualifierType = infos[0].getDefaultType();
        }
        CompletionType type = location.getCompletionType();
        if (o instanceof PsiMember) {
            String qualifiedName;
            boolean isClass = o instanceof PsiClass;
            if (qualifierType != null) {
                if (type == CompletionType.SMART) {
                    String context = isClass ? JavaStatisticsManager.getAfterNewKey((PsiType)qualifierType) : JavaStatisticsManager.getMemberUseKey1((PsiType)qualifierType);
                    return new StatisticsInfo(context, JavaStatisticsManager.getMemberUseKey2((PsiMember)((PsiMember)o)));
                }
                if (!isClass && type == CompletionType.BASIC) {
                    return JavaStatisticsManager.createInfo((PsiType)qualifierType, (PsiMember)((PsiMember)o));
                }
                return StatisticsInfo.EMPTY;
            }
            if (type == CompletionType.CLASS_NAME && isClass && (qualifiedName = ((PsiClass)o).getQualifiedName()) != null) {
                String prefixCapitals = StringUtil.capitalsOnly((String)element.getPrefixMatcher().getPrefix());
                return new StatisticsInfo(CLASS_NAME_COMPLETION_PREFIX + prefixCapitals, qualifiedName);
            }
        }
        if (qualifierType != null) {
            return StatisticsInfo.EMPTY;
        }
        return null;
    }
}

