/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.TailTypes;
import com.intellij.codeInsight.completion.CompletionBundle;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.CompletionVariant;
import com.intellij.codeInsight.completion.DefaultInsertHandler;
import com.intellij.codeInsight.completion.DummyIdentifierPatcher;
import com.intellij.codeInsight.completion.FileCopyPatcher;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.Java15CompletionData;
import com.intellij.codeInsight.completion.JavaAwareCompletionData;
import com.intellij.codeInsight.completion.JavaCompletionData;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.completion.JavaSmartCompletionContributor;
import com.intellij.codeInsight.completion.LegacyCompletionContributor;
import com.intellij.codeInsight.daemon.impl.quickfix.ImportClassFix;
import com.intellij.codeInsight.hint.ShowParameterInfoHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupItem;
import com.intellij.codeInsight.lookup.LookupItemUtil;
import com.intellij.codeInsight.lookup.TailTypeDecorator;
import com.intellij.lang.LangBundle;
import com.intellij.lang.StdLanguages;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.PsiNameValuePairPattern;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMethod;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiJavaCodeReferenceCodeFragment;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaReference;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.filters.AndFilter;
import com.intellij.psi.filters.ClassFilter;
import com.intellij.psi.filters.ElementExtractorFilter;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.filters.NotFilter;
import com.intellij.psi.filters.OrFilter;
import com.intellij.psi.filters.TrueFilter;
import com.intellij.psi.filters.classes.AssignableFromContextFilter;
import com.intellij.psi.filters.classes.ThisOrAnyInnerFilter;
import com.intellij.psi.filters.element.ExcludeDeclaredFilter;
import com.intellij.psi.filters.element.ModifierFilter;
import com.intellij.psi.filters.getters.ExpectedTypesGetter;
import com.intellij.psi.filters.types.AssignableFromFilter;
import com.intellij.psi.scope.ElementClassFilter;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.PairConsumer;
import com.intellij.util.ProcessingContext;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaCompletionContributor
extends CompletionContributor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.completion.JavaCompletionContributor");
    private static final Java15CompletionData ourJava15CompletionData = new Java15CompletionData();
    private static final JavaCompletionData ourJavaCompletionData = new JavaCompletionData();
    private static final PsiNameValuePairPattern NAME_VALUE_PAIR = (PsiNameValuePairPattern)PsiJavaPatterns.psiNameValuePair().withSuperParent(2, (ElementPattern)PsiJavaPatterns.psiElement(PsiAnnotation.class));
    private static final ElementPattern<PsiElement> ANNOTATION_ATTRIBUTE_NAME = PsiJavaPatterns.or((ElementPattern[])new ElementPattern[]{PsiJavaPatterns.psiElement(PsiIdentifier.class).withParent((ElementPattern)NAME_VALUE_PAIR), ((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().afterLeaf(new String[]{"("})).withParent((ElementPattern)PsiJavaPatterns.psiReferenceExpression().withParent((ElementPattern)NAME_VALUE_PAIR))});
    public static final ElementPattern SWITCH_LABEL = PsiJavaPatterns.psiElement().withSuperParent(2, (ElementPattern)PsiJavaPatterns.psiElement(PsiSwitchLabelStatement.class).withSuperParent(2, (ElementPattern)PsiJavaPatterns.psiElement(PsiSwitchStatement.class).with((PatternCondition)new PatternCondition<PsiSwitchStatement>("enumExpressionType"){

        public boolean accepts(@NotNull PsiSwitchStatement psiSwitchStatement, ProcessingContext context) {
            if (psiSwitchStatement == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/completion/JavaCompletionContributor$1.accepts must not be null");
            }
            PsiExpression expression = psiSwitchStatement.getExpression();
            if (expression == null) {
                return false;
            }
            PsiType type = expression.getType();
            return type instanceof PsiClassType;
        }
    })));

    @Nullable
    private static ElementFilter getReferenceFilter(PsiElement position) {
        PsiClass containingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)position, PsiClass.class, (boolean)false, (Class[])new Class[]{PsiCodeBlock.class, PsiMethod.class, PsiExpressionList.class});
        if (containingClass != null && ((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().afterLeaf(new String[]{"extends", "implements", ",", "&"})).accepts((Object)position)) {
            return new AndFilter((ElementFilter)ElementClassFilter.CLASS, (ElementFilter)new NotFilter(new AssignableFromContextFilter()));
        }
        if (JavaCompletionData.DECLARATION_START.isAcceptable(position, position)) {
            return new OrFilter(ElementClassFilter.CLASS, ElementClassFilter.PACKAGE_FILTER);
        }
        if (JavaCompletionData.INSIDE_PARAMETER_LIST.accepts((Object)position)) {
            return ElementClassFilter.CLASS;
        }
        if (((PsiJavaElementPattern.Capture)((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().afterLeaf(new String[]{"throws", ","})).inside((ElementPattern)PsiJavaPatterns.psiElement(PsiReferenceList.class).withParent(PsiMethod.class))).accepts((Object)position)) {
            return new OrFilter(new ThisOrAnyInnerFilter((ElementFilter)new AssignableFromFilter("java.lang.Throwable")), ElementClassFilter.PACKAGE_FILTER);
        }
        if (((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().afterLeaf(new String[]{"instanceof"})).accepts((Object)position)) {
            return new ElementExtractorFilter(ElementClassFilter.CLASS);
        }
        if (JavaCompletionData.AFTER_FINAL.accepts((Object)position)) {
            return ElementClassFilter.CLASS;
        }
        if (JavaCompletionData.AFTER_TRY_BLOCK.isAcceptable(position, position) || JavaCompletionData.START_SWITCH.isAcceptable(position, position) || JavaCompletionData.INSTANCEOF_PLACE.isAcceptable(position, position)) {
            return null;
        }
        if (((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().afterLeaf((ElementPattern)((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withText("(")).withParent(PsiTryStatement.class))).accepts((Object)position)) {
            return new OrFilter(new ThisOrAnyInnerFilter((ElementFilter)new AssignableFromFilter("java.lang.Throwable")), ElementClassFilter.PACKAGE_FILTER);
        }
        if (JavaSmartCompletionContributor.AFTER_THROW_NEW.accepts((Object)position)) {
            return new ThisOrAnyInnerFilter((ElementFilter)new AssignableFromFilter("java.lang.Throwable"));
        }
        if (JavaSmartCompletionContributor.AFTER_NEW.accepts((Object)position)) {
            return ElementClassFilter.CLASS;
        }
        if (((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().inside(PsiReferenceParameterList.class)).accepts((Object)position)) {
            return ElementClassFilter.CLASS;
        }
        if (((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().inside(PsiAnnotationParameterList.class)).accepts((Object)position)) {
            return new OrFilter(new ClassFilter(PsiAnnotationMethod.class), ElementClassFilter.CLASS, ElementClassFilter.PACKAGE_FILTER, new AndFilter((ElementFilter)new ClassFilter(PsiField.class), (ElementFilter)new ModifierFilter("static", "final")));
        }
        if (((PsiJavaElementPattern.Capture)((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().afterLeaf(new String[]{"="})).inside(PsiVariable.class)).accepts((Object)position)) {
            return new OrFilter(new ClassFilter(PsiVariable.class, false), new ExcludeDeclaredFilter(new ClassFilter(PsiVariable.class)));
        }
        if (SWITCH_LABEL.accepts((Object)position)) {
            return new ClassFilter(PsiField.class){

                @Override
                public boolean isAcceptable(Object element, PsiElement context) {
                    return element instanceof PsiEnumConstant;
                }
            };
        }
        return TrueFilter.INSTANCE;
    }

    public void fillCompletionVariants(final CompletionParameters parameters, final CompletionResultSet _result) {
        if (parameters.getCompletionType() != CompletionType.BASIC) {
            return;
        }
        final PsiElement insertedElement = parameters.getPosition();
        if (!insertedElement.getContainingFile().getLanguage().isKindOf(StdLanguages.JAVA)) {
            return;
        }
        final PsiFile file = parameters.getOriginalFile();
        int startOffset = parameters.getOffset();
        final PsiElement lastElement = file.findElementAt(startOffset - 1);
        final JavaAwareCompletionData completionData = (JavaAwareCompletionData)ApplicationManager.getApplication().runReadAction((Computable)new Computable<JavaAwareCompletionData>(){

            public JavaAwareCompletionData compute() {
                return JavaCompletionContributor.getCompletionDataByElementInner(lastElement);
            }
        });
        if (ANNOTATION_ATTRIBUTE_NAME.accepts((Object)insertedElement)) {
            ApplicationManager.getApplication().runReadAction(new Runnable(){

                @Override
                public void run() {
                    JavaCompletionContributor.completeAnnotationAttributeName(_result, file, insertedElement, parameters);
                }
            });
            _result.stopHere();
            return;
        }
        final boolean checkAccess = parameters.getInvocationCount() == 1;
        LegacyCompletionContributor.processReferences(parameters, _result, completionData, new PairConsumer<PsiReference, CompletionResultSet>(){

            public void consume(final PsiReference reference, final CompletionResultSet result) {
                ApplicationManager.getApplication().runReadAction(new Runnable(){

                    @Override
                    public void run() {
                        if (reference instanceof PsiJavaReference) {
                            ElementFilter filter = JavaCompletionContributor.getReferenceFilter(insertedElement);
                            if (filter != null) {
                                boolean isSwitchLabel = SWITCH_LABEL.accepts((Object)insertedElement);
                                for (LookupElement element : JavaCompletionUtil.processJavaReference(insertedElement, (PsiJavaReference)reference, new ElementExtractorFilter(filter), checkAccess, result.getPrefixMatcher(), parameters)) {
                                    if (isSwitchLabel) {
                                        result.addElement(TailTypeDecorator.withTail(element, TailType.createSimpleTailType((char)':')));
                                        continue;
                                    }
                                    LookupItem item = (LookupItem)element.as(LookupItem.class);
                                    if (file instanceof PsiJavaCodeReferenceCodeFragment && !((PsiJavaCodeReferenceCodeFragment)file).isClassesAccepted() && item != null) {
                                        item.setTailType(TailType.NONE);
                                    }
                                    result.addElement(element);
                                }
                            }
                            return;
                        }
                        Object[] variants = reference.getVariants();
                        if (variants == null) {
                            LOG.error("Reference=" + reference);
                        }
                        for (Object completion : variants) {
                            if (completion == null) {
                                LOG.error("Position=" + insertedElement + "\n;Reference=" + reference + "\n;variants=" + Arrays.toString(variants));
                            }
                            if (completion instanceof LookupElement) {
                                result.addElement((LookupElement)completion);
                                continue;
                            }
                            result.addElement(LookupItemUtil.objectToLookupItem(completion));
                        }
                    }
                });
            }
        });
        LinkedHashSet<LookupElement> lookupSet = new LinkedHashSet<LookupElement>();
        HashSet<CompletionVariant> keywordVariants = new HashSet<CompletionVariant>();
        completionData.addKeywordVariants(keywordVariants, insertedElement, parameters.getOriginalFile());
        final CompletionResultSet result = _result.withPrefixMatcher(completionData.findPrefix(insertedElement, startOffset));
        completionData.completeKeywordsBySet(lookupSet, keywordVariants, insertedElement, result.getPrefixMatcher(), parameters.getOriginalFile());
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                completionData.fillCompletions(parameters, result);
            }
        });
        for (LookupElement item : lookupSet) {
            if (item instanceof LookupItem && ((LookupItem)item).getInsertHandler() == null) {
                ((LookupItem)item).setInsertHandler(new InsertHandler(){

                    public void handleInsert(InsertionContext context, LookupElement item) {
                        JavaCompletionContributor.analyzeItem((LookupItem)item, item.getObject(), parameters.getPosition());
                        new DefaultInsertHandler().handleInsert(context, item);
                    }
                });
            }
            result.addElement(item);
        }
        result.stopHere();
    }

    private static void completeAnnotationAttributeName(CompletionResultSet result, PsiFile file, PsiElement insertedElement, CompletionParameters parameters) {
        PsiElement element;
        PsiNameValuePair pair = (PsiNameValuePair)PsiTreeUtil.getParentOfType((PsiElement)insertedElement, PsiNameValuePair.class);
        PsiAnnotationParameterList parameterList = (PsiAnnotationParameterList)pair.getParent();
        PsiAnnotation anno = (PsiAnnotation)parameterList.getParent();
        boolean showClasses = ((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().afterLeaf(new String[]{"("})).accepts((Object)insertedElement);
        PsiClass annoClass = null;
        PsiJavaCodeReferenceElement referenceElement = anno.getNameReferenceElement();
        if (referenceElement != null && (element = referenceElement.resolve()) instanceof PsiClass && (annoClass = (PsiClass)element).findMethodsByName("value", false).length == 0) {
            showClasses = false;
        }
        if (showClasses && insertedElement.getParent() instanceof PsiReferenceExpression) {
            Set<LookupElement> set = JavaCompletionUtil.processJavaReference(insertedElement, (PsiJavaReference)insertedElement.getParent(), TrueFilter.INSTANCE, true, result.getPrefixMatcher(), parameters);
            for (LookupElement element2 : set) {
                result.addElement(element2);
            }
        }
        if (annoClass != null) {
            PsiNameValuePair[] existingPairs = parameterList.getAttributes();
            block1: for (PsiMethod method : annoClass.getMethods()) {
                String attrName = method.getName();
                for (PsiNameValuePair apair : existingPairs) {
                    if (Comparing.equal((String)apair.getName(), (String)attrName)) continue block1;
                }
                result.addElement((LookupElement)new LookupItem<PsiMethod>(method, attrName).setInsertHandler((InsertHandler)new InsertHandler<LookupElement>(){

                    public void handleInsert(InsertionContext context, LookupElement item) {
                        Editor editor = context.getEditor();
                        TailType.EQ.processTail(editor, editor.getCaretModel().getOffset());
                        context.setAddCompletionChar(false);
                    }
                }));
            }
        }
    }

    private static JavaAwareCompletionData getCompletionDataByElementInner(PsiElement element) {
        return element != null && PsiUtil.isLanguageLevel5OrHigher((PsiElement)element) ? ourJava15CompletionData : ourJavaCompletionData;
    }

    public String advertise(@NotNull CompletionParameters parameters) {
        PsiType[] psiTypes;
        String shortcut;
        if (parameters == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/completion/JavaCompletionContributor.advertise must not be null");
        }
        if (!(parameters.getOriginalFile() instanceof PsiJavaFile)) {
            return null;
        }
        if (parameters.getCompletionType() != CompletionType.SMART && JavaCompletionContributor.shouldSuggestSmartCompletion(parameters.getPosition()) && CompletionUtil.shouldShowFeature(parameters, "editing.completion.smarttype.general") && (shortcut = JavaCompletionContributor.getActionShortcut((String)"SmartTypeCompletion")) != null) {
            return CompletionBundle.message("completion.smart.hint", shortcut);
        }
        if (parameters.getCompletionType() != CompletionType.CLASS_NAME && JavaCompletionContributor.shouldSuggestClassNameCompletion(parameters.getPosition()) && CompletionUtil.shouldShowFeature(parameters, "editing.completion.classname") && (shortcut = JavaCompletionContributor.getActionShortcut((String)"ClassNameCompletion")) != null) {
            return CompletionBundle.message("completion.class.name.hint", shortcut);
        }
        if (parameters.getCompletionType() == CompletionType.SMART && parameters.getInvocationCount() == 1 && (psiTypes = ExpectedTypesGetter.getExpectedTypes(parameters.getPosition(), true)).length > 0) {
            String shortcut2;
            if (CompletionUtil.shouldShowFeature(parameters, "editing.completion.second.smarttype.toar") && (shortcut2 = JavaCompletionContributor.getActionShortcut((String)"SmartTypeCompletion")) != null) {
                for (PsiType psiType : psiTypes) {
                    PsiType type = PsiUtil.extractIterableTypeParameter((PsiType)psiType, (boolean)false);
                    if (type == null) continue;
                    return CompletionBundle.message("completion.smart.aslist.hint", shortcut2, type.getPresentableText());
                }
            }
            if (CompletionUtil.shouldShowFeature(parameters, "editing.completion.second.smarttype.aslist") && (shortcut2 = JavaCompletionContributor.getActionShortcut((String)"SmartTypeCompletion")) != null) {
                for (PsiType psiType : psiTypes) {
                    PsiType componentType;
                    if (!(psiType instanceof PsiArrayType) || (componentType = ((PsiArrayType)psiType).getComponentType()) instanceof PsiPrimitiveType) continue;
                    return CompletionBundle.message("completion.smart.toar.hint", shortcut2, componentType.getPresentableText());
                }
            }
            if (CompletionUtil.shouldShowFeature(parameters, "editing.completion.second.smarttype.chain") && (shortcut2 = JavaCompletionContributor.getActionShortcut((String)"SmartTypeCompletion")) != null) {
                return CompletionBundle.message("completion.smart.chain.hint", shortcut2);
            }
        }
        return null;
    }

    public String handleEmptyLookup(@NotNull CompletionParameters parameters, Editor editor) {
        String suffix;
        if (parameters == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/completion/JavaCompletionContributor.handleEmptyLookup must not be null");
        }
        if (!(parameters.getOriginalFile() instanceof PsiJavaFile)) {
            return null;
        }
        String ad = this.advertise(parameters);
        String string = suffix = ad == null ? "" : "; " + StringUtil.decapitalize((String)ad);
        if (parameters.getCompletionType() == CompletionType.SMART) {
            Set<PsiType> expectedTypes;
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                PsiInstanceOfExpression instanceOfExpression;
                Project project = parameters.getPosition().getProject();
                PsiFile file = parameters.getOriginalFile();
                PsiExpression expression = (PsiExpression)PsiTreeUtil.getContextOfType((PsiElement)parameters.getPosition(), PsiExpression.class, (boolean)true);
                if (expression != null && expression.getParent() instanceof PsiExpressionList) {
                    int lbraceOffset = expression.getParent().getTextRange().getStartOffset();
                    new ShowParameterInfoHandler().invoke(project, editor, file, lbraceOffset, null);
                }
                if (expression instanceof PsiLiteralExpression) {
                    return LangBundle.message("completion.no.suggestions", new Object[0]) + suffix;
                }
                if (expression instanceof PsiInstanceOfExpression && PsiTreeUtil.isAncestor((PsiElement)(instanceOfExpression = (PsiInstanceOfExpression)expression).getCheckType(), (PsiElement)parameters.getPosition(), (boolean)false)) {
                    return LangBundle.message("completion.no.suggestions", new Object[0]) + suffix;
                }
            }
            if ((expectedTypes = JavaCompletionUtil.getExpectedTypes(parameters)) != null) {
                PsiType type;
                PsiType psiType = type = expectedTypes.size() == 1 ? expectedTypes.iterator().next() : null;
                if (type != null) {
                    PsiType deepComponentType = type.getDeepComponentType();
                    if (deepComponentType instanceof PsiClassType) {
                        if (((PsiClassType)deepComponentType).resolve() != null) {
                            return CompletionBundle.message("completion.no.suggestions.of.type", type.getPresentableText()) + suffix;
                        }
                        return CompletionBundle.message("completion.unknown.type", type.getPresentableText()) + suffix;
                    }
                    if (!PsiType.NULL.equals(type)) {
                        return CompletionBundle.message("completion.no.suggestions.of.type", type.getPresentableText()) + suffix;
                    }
                }
            }
        }
        return LangBundle.message("completion.no.suggestions", new Object[0]) + suffix;
    }

    private static boolean shouldSuggestSmartCompletion(PsiElement element) {
        if (JavaCompletionContributor.shouldSuggestClassNameCompletion(element)) {
            return false;
        }
        PsiElement parent = element.getParent();
        if (parent instanceof PsiReferenceExpression && ((PsiReferenceExpression)parent).getQualifier() != null) {
            return false;
        }
        if (parent instanceof PsiReferenceExpression && parent.getParent() instanceof PsiReferenceExpression) {
            return true;
        }
        return new ExpectedTypesGetter().get(element, null).length > 0;
    }

    private static boolean shouldSuggestClassNameCompletion(PsiElement element) {
        if (element == null) {
            return false;
        }
        PsiElement parent = element.getParent();
        if (parent == null) {
            return false;
        }
        return parent.getParent() instanceof PsiTypeElement || parent.getParent() instanceof PsiExpressionStatement || parent.getParent() instanceof PsiReferenceList;
    }

    public static void analyzeItem(LookupItem item, Object completion, PsiElement position) {
        if (completion instanceof PsiKeyword) {
            PsiElement scope;
            if ("break".equals(((PsiKeyword)completion).getText()) || "continue".equals(((PsiKeyword)completion).getText())) {
                scope = position;
                while (true) {
                    if (scope instanceof PsiFile || scope instanceof PsiMethod || scope instanceof PsiClassInitializer) {
                        item.setTailType(TailType.SEMICOLON);
                        break;
                    }
                    if (scope instanceof PsiLabeledStatement) {
                        item.setTailType(TailType.NONE);
                        break;
                    }
                    scope = scope.getParent();
                }
            }
            if ("return".equals(((PsiKeyword)completion).getText())) {
                scope = position;
                while (true) {
                    if (scope instanceof PsiFile || scope instanceof PsiClassInitializer) {
                        item.setTailType(TailType.NONE);
                        break;
                    }
                    if (scope instanceof PsiMethod) {
                        PsiMethod method = (PsiMethod)scope;
                        if (method.isConstructor() || PsiType.VOID.equals(method.getReturnType())) {
                            item.setTailType(TailType.SEMICOLON);
                            break;
                        }
                        item.setTailType(TailType.SPACE);
                        break;
                    }
                    scope = scope.getParent();
                }
            }
            if ("synchronized".equals(((PsiKeyword)completion).getText()) && PsiTreeUtil.getParentOfType((PsiElement)position, (Class[])new Class[]{PsiMember.class, PsiCodeBlock.class}) instanceof PsiCodeBlock) {
                item.setTailType(TailTypes.SYNCHRONIZED_LPARENTH);
            }
        }
    }

    public void beforeCompletion(@NotNull CompletionInitializationContext context) {
        if (context == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/completion/JavaCompletionContributor.beforeCompletion must not be null");
        }
        PsiFile file = context.getFile();
        Project project = context.getProject();
        JavaCompletionUtil.initOffsets(file, project, context.getOffsetMap());
        if (file instanceof PsiJavaFile) {
            JavaCompletionContributor.autoImport(file, context.getStartOffset() - 1, context.getEditor());
        }
        if (context.getCompletionType() == CompletionType.BASIC && file instanceof PsiJavaFile) {
            if (JavaCompletionContributor.semicolonNeeded(context)) {
                context.setFileCopyPatcher((FileCopyPatcher)new DummyIdentifierPatcher("IntellijIdeaRulezzz ".trim() + ";"));
                return;
            }
            PsiElement element = file.findElementAt(context.getStartOffset());
            if (((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().inside(PsiAnnotation.class)).accepts((Object)element)) {
                return;
            }
            context.setFileCopyPatcher((FileCopyPatcher)new DummyIdentifierPatcher("IntellijIdeaRulezzz ".trim()));
        }
    }

    private static boolean semicolonNeeded(CompletionInitializationContext context) {
        HighlighterIterator iterator = ((EditorEx)context.getEditor()).getHighlighter().createIterator(context.getStartOffset());
        if (iterator.atEnd()) {
            return false;
        }
        if (iterator.getTokenType() == JavaTokenType.IDENTIFIER) {
            iterator.advance();
        }
        if (!iterator.atEnd() && iterator.getTokenType() == JavaTokenType.LPARENTH) {
            return true;
        }
        while (!iterator.atEnd() && JavaTokenType.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(iterator.getTokenType())) {
            iterator.advance();
        }
        if (iterator.atEnd() || iterator.getTokenType() != JavaTokenType.IDENTIFIER) {
            return false;
        }
        iterator.advance();
        while (!iterator.atEnd() && JavaTokenType.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(iterator.getTokenType())) {
            iterator.advance();
        }
        if (iterator.atEnd()) {
            return false;
        }
        return iterator.getTokenType() == JavaTokenType.EQ || iterator.getTokenType() == JavaTokenType.LPARENTH;
    }

    private static void autoImport(PsiFile file, int offset, Editor editor) {
        PsiJavaCodeReferenceElement qualifier;
        CharSequence text = editor.getDocument().getCharsSequence();
        while (offset > 0 && Character.isJavaIdentifierPart(text.charAt(offset))) {
            --offset;
        }
        if (offset <= 0) {
            return;
        }
        while (offset > 0 && Character.isWhitespace(text.charAt(offset))) {
            --offset;
        }
        if (offset <= 0 || text.charAt(offset) != '.') {
            return;
        }
        --offset;
        while (offset > 0 && Character.isWhitespace(text.charAt(offset))) {
            --offset;
        }
        if (offset <= 0) {
            return;
        }
        PsiJavaCodeReferenceElement element = JavaCompletionContributor.extractReference(PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file, (int)offset, PsiExpression.class, (boolean)false));
        if (element == null) {
            return;
        }
        while ((qualifier = JavaCompletionContributor.extractReference(element.getQualifier())) != null) {
            element = qualifier;
        }
        if (!(element.getParent() instanceof PsiMethodCallExpression) && element.multiResolve(true).length == 0) {
            new ImportClassFix(element).doFix(editor, false, false);
        }
    }

    @Nullable
    private static PsiJavaCodeReferenceElement extractReference(@Nullable PsiElement expression) {
        if (expression instanceof PsiJavaCodeReferenceElement) {
            return (PsiJavaCodeReferenceElement)expression;
        }
        if (expression instanceof PsiMethodCallExpression) {
            return ((PsiMethodCallExpression)expression).getMethodExpression();
        }
        return null;
    }
}

