/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeEditor.printing;

import com.intellij.codeEditor.printing.CodeEditorBundle;
import com.intellij.codeEditor.printing.MultiFilePainter;
import com.intellij.codeEditor.printing.PageSizes;
import com.intellij.codeEditor.printing.PrintDialog;
import com.intellij.codeEditor.printing.PrintSettings;
import com.intellij.codeEditor.printing.TextPainter;
import com.intellij.ide.highlighter.HighlighterFactory;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.ArrayList;

class PrintManager {
    PrintManager() {
    }

    public static void executePrint(DataContext dataContext) {
        Printable painter;
        Project project = (Project)PlatformDataKeys.PROJECT.getData(dataContext);
        final PrinterJob printerJob = PrinterJob.getPrinterJob();
        PsiDirectory[] psiDirectory = new PsiDirectory[1];
        PsiElement psiElement = (PsiElement)LangDataKeys.PSI_ELEMENT.getData(dataContext);
        if (psiElement instanceof PsiDirectory) {
            psiDirectory[0] = (PsiDirectory)psiElement;
        }
        PsiFile psiFile = (PsiFile)LangDataKeys.PSI_FILE.getData(dataContext);
        String[] shortFileName = new String[1];
        String[] directoryName = new String[1];
        if (psiFile != null || psiDirectory[0] != null) {
            if (psiFile != null) {
                shortFileName[0] = psiFile.getVirtualFile().getName();
                if (psiDirectory[0] == null) {
                    psiDirectory[0] = psiFile.getContainingDirectory();
                }
            }
            if (psiDirectory[0] != null) {
                directoryName[0] = psiDirectory[0].getVirtualFile().getPresentableUrl();
            }
        }
        Editor editor = (Editor)PlatformDataKeys.EDITOR.getData(dataContext);
        boolean isSelectedTextEnabled = false;
        if (editor != null && editor.getSelectionModel().hasSelection()) {
            isSelectedTextEnabled = true;
        }
        PrintDialog printDialog = new PrintDialog(shortFileName[0], directoryName[0], isSelectedTextEnabled, project);
        printDialog.reset();
        printDialog.show();
        if (!printDialog.isOK()) {
            return;
        }
        printDialog.apply();
        final PageFormat pageFormat = PrintManager.createPageFormat();
        PrintSettings printSettings = PrintSettings.getInstance();
        if (printSettings.getPrintScope() != 4) {
            if (psiFile == null) {
                return;
            }
            TextPainter textPainter = PrintManager.initTextPainter(psiFile, project);
            if (textPainter == null) {
                return;
            }
            if (printSettings.getPrintScope() == 2 && editor != null && editor.getSelectionModel().hasSelection()) {
                int firstLine = editor.getDocument().getLineNumber(editor.getSelectionModel().getSelectionStart());
                textPainter.setSegment(editor.getSelectionModel().getSelectionStart(), editor.getSelectionModel().getSelectionEnd(), firstLine + 1);
            }
            painter = textPainter;
        } else {
            ArrayList<PsiFile> filesList = new ArrayList<PsiFile>();
            boolean isRecursive = printSettings.isIncludeSubdirectories();
            PrintManager.addToPsiFileList(psiDirectory[0], filesList, isRecursive);
            painter = new MultiFilePainter(filesList, project);
        }
        final TextPainter painter0 = painter;
        Pageable document = new Pageable(){

            @Override
            public int getNumberOfPages() {
                return -1;
            }

            @Override
            public PageFormat getPageFormat(int pageIndex) throws IndexOutOfBoundsException {
                return pageFormat;
            }

            @Override
            public Printable getPrintable(int pageIndex) throws IndexOutOfBoundsException {
                return painter0;
            }
        };
        printerJob.setPageable(document);
        printerJob.setPrintable(painter, pageFormat);
        try {
            if (!printerJob.printDialog()) {
                return;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    ProgressIndicator progress = ProgressManager.getInstance().getProgressIndicator();
                    if (painter0 instanceof MultiFilePainter) {
                        ((MultiFilePainter)painter0).setProgress(progress);
                    } else {
                        ((TextPainter)painter0).setProgress(progress);
                    }
                    printerJob.print();
                }
                catch (PrinterException e) {
                    e.printStackTrace();
                }
                catch (ProcessCanceledException e) {
                    printerJob.cancel();
                }
            }
        };
        ProgressManager.getInstance().runProcessWithProgressSynchronously(runnable, CodeEditorBundle.message("print.progress", new Object[0]), true, project);
    }

    private static void addToPsiFileList(PsiDirectory psiDirectory, ArrayList<PsiFile> filesList, boolean isRecursive) {
        PsiFile[] files;
        for (PsiFile file : files = psiDirectory.getFiles()) {
            filesList.add(file);
        }
        if (isRecursive) {
            PsiDirectory[] directories;
            for (PsiDirectory directory : directories = psiDirectory.getSubdirectories()) {
                PrintManager.addToPsiFileList(directory, filesList, isRecursive);
            }
        }
    }

    private static PageFormat createPageFormat() {
        PrintSettings printSettings = PrintSettings.getInstance();
        PageFormat pageFormat = new PageFormat();
        Paper paper = new Paper();
        String paperSize = printSettings.PAPER_SIZE;
        double paperWidth = PageSizes.getWidth(paperSize) * 72.0;
        double paperHeight = PageSizes.getHeight(paperSize) * 72.0;
        double leftMargin = printSettings.LEFT_MARGIN * 72.0f;
        double rightMargin = printSettings.RIGHT_MARGIN * 72.0f;
        double topMargin = printSettings.TOP_MARGIN * 72.0f;
        double bottomMargin = printSettings.BOTTOM_MARGIN * 72.0f;
        paper.setSize(paperWidth, paperHeight);
        if (printSettings.PORTRAIT_LAYOUT) {
            pageFormat.setOrientation(1);
            paper.setImageableArea(leftMargin, topMargin, paperWidth -= leftMargin + rightMargin, paperHeight -= topMargin + bottomMargin);
        } else {
            pageFormat.setOrientation(0);
            paper.setImageableArea(topMargin, rightMargin, paperWidth -= topMargin + bottomMargin, paperHeight -= leftMargin + rightMargin);
        }
        pageFormat.setPaper(paper);
        return pageFormat;
    }

    public static TextPainter initTextPainter(final PsiFile psiFile, final Project project) {
        final TextPainter[] res = new TextPainter[1];
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                res[0] = PrintManager.doInitTextPainter(psiFile, project);
            }
        });
        return res[0];
    }

    private static TextPainter doInitTextPainter(PsiFile psiFile, Project project) {
        String fileName = psiFile.getVirtualFile().getPresentableUrl();
        DocumentEx doc = (DocumentEx)PsiDocumentManager.getInstance((Project)project).getDocument(psiFile);
        if (doc == null) {
            return null;
        }
        EditorHighlighter highlighter = HighlighterFactory.createHighlighter((Project)project, (VirtualFile)psiFile.getVirtualFile());
        highlighter.setText(doc.getCharsSequence());
        return new TextPainter(doc, highlighter, fileName, psiFile, project);
    }
}

