/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.colors.highlighting;

import com.intellij.application.options.colors.highlighting.HighlightData;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import java.util.ArrayList;
import java.util.Map;
import java.util.Stack;

public class HighlightsExtractor {
    private final Map<String, TextAttributesKey> myTags;
    private int myStartOffset;
    private int myEndOffset;
    private int mySkippedLen;
    private int myIndex;
    private boolean myIsOpeningTag;
    private static final HighlightData[] EMPTY_DATA = new HighlightData[0];

    public HighlightsExtractor(Map<String, TextAttributesKey> tags) {
        this.myTags = tags;
    }

    public HighlightData[] extractHighlights(String text) {
        String tagName;
        if (this.myTags == null || this.myTags.isEmpty()) {
            return EMPTY_DATA;
        }
        this.resetIndices();
        ArrayList<HighlightData> highlights = new ArrayList<HighlightData>();
        Stack<HighlightData> highlightsStack = new Stack<HighlightData>();
        while ((tagName = this.findTagName(text)) != null) {
            HighlightData highlightData;
            if (!this.myTags.containsKey(tagName)) continue;
            if (this.myIsOpeningTag) {
                this.mySkippedLen += tagName.length() + 2;
                highlightData = new HighlightData(this.myStartOffset - this.mySkippedLen, this.myTags.get(tagName));
                highlightsStack.push(highlightData);
                continue;
            }
            highlightData = (HighlightData)highlightsStack.pop();
            highlightData.setEndOffset(this.myEndOffset - this.mySkippedLen);
            this.mySkippedLen += tagName.length() + 3;
            highlights.add(highlightData);
        }
        return highlights.toArray(new HighlightData[highlights.size()]);
    }

    private String findTagName(String text) {
        int closeTag;
        this.myIsOpeningTag = true;
        int openTag = text.indexOf(60, this.myIndex);
        if (openTag == -1) {
            return null;
        }
        if (text.charAt(openTag + 1) == '<') {
            ++openTag;
        }
        if (text.charAt(openTag + 1) == '/') {
            this.myIsOpeningTag = false;
            ++openTag;
        }
        if ((closeTag = text.indexOf(62, openTag + 1)) == -1) {
            return null;
        }
        String tagName = text.substring(openTag + 1, closeTag);
        if (this.myIsOpeningTag) {
            this.myStartOffset = openTag + tagName.length() + 2;
        } else {
            this.myEndOffset = openTag - 1;
        }
        this.myIndex = Math.max(this.myStartOffset, this.myEndOffset + 1);
        return tagName;
    }

    public String cutDefinedTags(String text) {
        if (this.myTags == null || this.myTags.isEmpty()) {
            return text;
        }
        StringBuffer sb = new StringBuffer();
        int index = 0;
        while (true) {
            int to;
            int from;
            if ((from = text.indexOf(60, index)) == -1) {
                sb.append(text.substring(index, text.length()));
                break;
            }
            if (text.charAt(from + 1) == '<') {
                ++from;
            }
            if ((to = text.indexOf(62, from + 1)) == -1) {
                sb.append(text.substring(index, text.length()));
                break;
            }
            String tag = text.charAt(from + 1) == '/' ? text.substring(from + 2, to) : text.substring(from + 1, to);
            if (this.myTags.containsKey(tag)) {
                sb.append(text.substring(index, from));
                index = to + 1;
                continue;
            }
            sb.append(text.substring(index, to + 1));
            index = to + 1;
        }
        return sb.toString();
    }

    private void resetIndices() {
        this.myIndex = 0;
        this.myStartOffset = 0;
        this.myEndOffset = 0;
        this.mySkippedLen = 0;
    }
}

