/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle;

import com.intellij.application.options.ExportSchemeAction;
import com.intellij.application.options.SaveSchemeDialog;
import com.intellij.application.options.SchemesToImportPopup;
import com.intellij.application.options.codeStyle.CodeStyleSchemesModel;
import com.intellij.application.options.codeStyle.NewCodeStyleSettingsPanel;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.SchemesManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.codeStyle.CodeStyleScheme;
import com.intellij.psi.codeStyle.CodeStyleSchemes;
import com.intellij.psi.impl.source.codeStyle.CodeStyleSchemeImpl;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class CodeStyleSchemesPanel {
    private JButton myExportButton;
    private JComboBox myCombo;
    private JButton mySaveAsButton;
    private JButton myDeleteButton;
    private final CodeStyleSchemesModel myModel;
    private JRadioButton myUseGlobalScheme;
    private JRadioButton myUseProjectScheme;
    private JButton myImportButton;
    private JPanel myPanel;
    private JButton myExportAsGlobalButton;
    private JButton myCopyToProjectButton;
    private boolean myIsReset = false;
    private NewCodeStyleSettingsPanel mySettingsPanel;

    public Collection<CodeStyleScheme> getSchemes() {
        ArrayList<CodeStyleScheme> result = new ArrayList<CodeStyleScheme>();
        for (int i = 0; i < this.myCombo.getItemCount(); ++i) {
            Object item = this.myCombo.getItemAt(i);
            if (!(item instanceof CodeStyleScheme)) continue;
            result.add((CodeStyleScheme)item);
        }
        return result;
    }

    public CodeStyleSchemesPanel(CodeStyleSchemesModel model) {
        this.myModel = model;
        this.$$$setupUI$$$();
        this.myUseGlobalScheme.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                CodeStyleSchemesPanel.this.myModel.setUsePerProjectSettings(!CodeStyleSchemesPanel.this.myUseGlobalScheme.isSelected());
            }
        });
        this.myUseProjectScheme.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                CodeStyleSchemesPanel.this.myModel.setUsePerProjectSettings(CodeStyleSchemesPanel.this.myUseProjectScheme.isSelected());
            }
        });
        final SchemesManager<CodeStyleScheme, CodeStyleSchemeImpl> schemesManager = CodeStyleSchemesModel.getSchemesManager();
        if (schemesManager.isExportAvailable()) {
            this.myExportButton.setVisible(true);
            this.myExportButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CodeStyleScheme selected = CodeStyleSchemesPanel.this.getSelectedScheme();
                    ExportSchemeAction.doExport((CodeStyleSchemeImpl)selected, schemesManager);
                }
            });
            this.myExportButton.setMnemonic('S');
        } else {
            this.myExportButton.setVisible(false);
        }
        if (schemesManager.isImportAvailable()) {
            this.myImportButton.setVisible(true);
            this.myImportButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SchemesToImportPopup<CodeStyleScheme, CodeStyleSchemeImpl> popup = new SchemesToImportPopup<CodeStyleScheme, CodeStyleSchemeImpl>((Component)CodeStyleSchemesPanel.this.myPanel){

                        @Override
                        protected void onSchemeSelected(CodeStyleSchemeImpl scheme) {
                            if (scheme != null) {
                                CodeStyleSchemesPanel.this.myModel.addScheme(scheme, true);
                            }
                        }
                    };
                    popup.show(schemesManager, CodeStyleSchemesPanel.this.getSchemes());
                }
            });
        } else {
            this.myImportButton.setVisible(false);
        }
        this.myCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!CodeStyleSchemesPanel.this.myIsReset) {
                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            CodeStyleSchemesPanel.this.onCombo();
                        }
                    });
                }
            }
        });
        this.mySaveAsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CodeStyleSchemesPanel.this.onSaveAs();
            }
        });
        this.myDeleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CodeStyleSchemesPanel.this.onDelete();
            }
        });
        this.myCopyToProjectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CodeStyleSchemesPanel.this.onCopyToProject();
            }
        });
        this.myExportAsGlobalButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CodeStyleSchemesPanel.this.onExportProjectScheme();
            }
        });
    }

    private void onExportProjectScheme() {
        String name = Messages.showInputDialog((String)"Enter new scheme name:", (String)"Copy Project Scheme to Global List", (Icon)Messages.getQuestionIcon());
        if (name != null) {
            CodeStyleScheme scheme = this.myModel.exportProjectScheme(name);
            int switchToGlobal = Messages.showYesNoDialog((String)("Project scheme was copied to global scheme list as '" + scheme.getName() + ".\n" + "Switch to this created scheme?"), (String)"Copy Project Scheme to Global List", (Icon)Messages.getQuestionIcon());
            if (switchToGlobal == 0) {
                this.myModel.setUsePerProjectSettings(false);
                this.myModel.selectScheme(scheme, null);
            }
        }
    }

    private void onDelete() {
        this.myModel.removeScheme(this.getSelectedScheme());
    }

    private void onCopyToProject() {
        this.myModel.copyToProject(this.getSelectedScheme());
        int switchToProject = Messages.showYesNoDialog((String)("Scheme '" + this.getSelectedScheme().getName() + "' was copied to be used as the project scheme.\n" + "Switch to this created scheme?"), (String)"Copy Scheme to Project", (Icon)Messages.getQuestionIcon());
        if (switchToProject == 0) {
            this.myModel.setUsePerProjectSettings(true);
        }
    }

    private void onSaveAs() {
        CodeStyleScheme[] schemes = CodeStyleSchemes.getInstance().getSchemes();
        ArrayList<String> names = new ArrayList<String>();
        for (int i = 0; i < schemes.length; ++i) {
            CodeStyleScheme scheme = schemes[i];
            names.add(scheme.getName());
        }
        SaveSchemeDialog saveDialog = new SaveSchemeDialog(this.myPanel, ApplicationBundle.message((String)"title.save.code.style.scheme.as", (Object[])new Object[0]), names);
        saveDialog.show();
        if (saveDialog.isOK()) {
            CodeStyleScheme selectedScheme = this.getSelectedScheme();
            CodeStyleScheme newScheme = this.myModel.createNewScheme(saveDialog.getSchemeName(), selectedScheme);
            this.myModel.addScheme(newScheme, true);
        }
    }

    private void onCombo() {
        CodeStyleScheme selected = this.getSelectedScheme();
        if (selected != null) {
            this.myModel.selectScheme(selected, this);
            this.updateButtons();
        }
    }

    private void updateButtons() {
        if (!this.myModel.isUsePerProjectSettings()) {
            boolean deleteEnabled = false;
            boolean saveAsEnabled = true;
            CodeStyleScheme selected = this.getSelectedScheme();
            if (selected != null) {
                deleteEnabled = !CodeStyleSchemesModel.cannotBeDeleted(selected);
            }
            this.myDeleteButton.setEnabled(deleteEnabled);
            if (this.myExportButton != null) {
                this.myExportButton.setEnabled(!CodeStyleSchemesModel.cannotBeModified(selected));
            }
            this.mySaveAsButton.setEnabled(saveAsEnabled);
            this.myCopyToProjectButton.setEnabled(true);
            this.myExportAsGlobalButton.setEnabled(false);
        } else {
            this.mySaveAsButton.setEnabled(false);
            this.myDeleteButton.setEnabled(false);
            this.myExportButton.setEnabled(false);
            this.myImportButton.setEnabled(false);
            this.myCopyToProjectButton.setEnabled(false);
            this.myExportAsGlobalButton.setEnabled(true);
        }
    }

    private CodeStyleScheme getSelectedScheme() {
        Object selected = this.myCombo.getSelectedItem();
        if (selected instanceof CodeStyleScheme) {
            return (CodeStyleScheme)selected;
        }
        return null;
    }

    public void disposeUIResources() {
        this.myPanel.removeAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetSchemesCombo() {
        this.myIsReset = true;
        try {
            Vector<CodeStyleScheme> schemesVector = new Vector<CodeStyleScheme>();
            schemesVector.addAll(this.myModel.getSchemes());
            DefaultComboBoxModel model = new DefaultComboBoxModel(schemesVector);
            this.myCombo.setModel(model);
            this.myCombo.setSelectedItem(this.myModel.getSelectedGlobalScheme());
            this.updateProjectSchemesRelatedUI();
        }
        finally {
            this.myIsReset = false;
        }
    }

    private void updateProjectSchemesRelatedUI() {
        if (this.myModel.isUsePerProjectSettings()) {
            this.myUseProjectScheme.setSelected(true);
            this.myCombo.setEnabled(false);
            this.updateButtons();
        } else if (!this.myModel.isUsePerProjectSettings()) {
            this.myUseGlobalScheme.setSelected(true);
            this.myCombo.setEnabled(true);
            this.updateButtons();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSelectedSchemeChanged() {
        this.myIsReset = true;
        try {
            this.myCombo.setSelectedItem(this.myModel.getSelectedGlobalScheme());
        }
        finally {
            this.myIsReset = false;
        }
        this.updateButtons();
    }

    public void usePerProjectSettingsOptionChanged() {
        this.updateProjectSchemesRelatedUI();
    }

    public JComponent getPanel() {
        return this.myPanel;
    }

    public void setCodeStyleSettingsPanel(NewCodeStyleSettingsPanel settingsPanel) {
        this.mySettingsPanel = settingsPanel;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        JButton jButton2;
        JButton jButton3;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JButton jButton4;
        JButton jButton5;
        JButton jButton6;
        JComboBox jComboBox;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 4, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(1, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 9, new Insets(0, 0, 4, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myCombo = jComboBox = new JComboBox();
        jPanel2.add(jComboBox, new GridConstraints(1, 2, 1, 1, 8, 1, 2, 0, null, null, null));
        this.mySaveAsButton = jButton6 = new JButton();
        this.$$$loadButtonText$$$(jButton6, ResourceBundle.getBundle("messages/ApplicationBundle").getString("button.save.as"));
        jPanel2.add((Component)jButton6, new GridConstraints(1, 3, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myDeleteButton = jButton5 = new JButton();
        this.$$$loadButtonText$$$(jButton5, ResourceBundle.getBundle("messages/ApplicationBundle").getString("button.delete"));
        jPanel2.add((Component)jButton5, new GridConstraints(1, 4, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myExportButton = jButton4 = new JButton();
        jButton4.setText("Share...");
        jButton4.setMnemonic('S');
        jButton4.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jButton4, new GridConstraints(1, 5, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myUseGlobalScheme = jRadioButton2 = new JRadioButton();
        jRadioButton2.setText("Use global settings");
        jPanel2.add((Component)jRadioButton2, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myUseProjectScheme = jRadioButton = new JRadioButton();
        jRadioButton.setText("Use per project settings");
        jPanel2.add((Component)jRadioButton, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myImportButton = jButton3 = new JButton();
        jButton3.setText("Import Shared...");
        jButton3.setMnemonic('I');
        jButton3.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jButton3, new GridConstraints(1, 7, 1, 1, 0, 1, 3, 0, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/ApplicationBundle").getString("editbox.scheme.name"));
        jPanel2.add((Component)jLabel, new GridConstraints(1, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myExportAsGlobalButton = jButton2 = new JButton();
        jButton2.setText("Export...");
        jPanel2.add((Component)jButton2, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myCopyToProjectButton = jButton = new JButton();
        jButton.setText("Copy to Project");
        jPanel2.add((Component)jButton, new GridConstraints(1, 6, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(1, 8, 1, 1, 0, 1, 6, 1, null, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton);
        buttonGroup.add(jRadioButton2);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

