/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.util.SystemProperties;
import java.io.File;
import org.jetbrains.idea.svn.SvnAuthenticationManager;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnConfiguration;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.auth.ProviderType;
import org.jetbrains.idea.svn.dialogs.SSHCredentialsDialog;
import org.jetbrains.idea.svn.dialogs.SSLCredentialsDialog;
import org.jetbrains.idea.svn.dialogs.SimpleCredentialsDialog;
import org.jetbrains.idea.svn.dialogs.UserNameCredentialsDialog;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationProvider;
import org.tmatesoft.svn.core.auth.SVNAuthentication;
import org.tmatesoft.svn.core.auth.SVNPasswordAuthentication;
import org.tmatesoft.svn.core.auth.SVNSSHAuthentication;
import org.tmatesoft.svn.core.auth.SVNSSLAuthentication;
import org.tmatesoft.svn.core.auth.SVNUserNameAuthentication;

public class SvnInteractiveAuthenticationProvider
implements ISVNAuthenticationProvider {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.idea.svn.dialogs.SvnInteractiveAuthenticationProvider");
    private final Project myProject;
    private static final ThreadLocal<MyCallState> myCallState = new ThreadLocal();
    private final SvnAuthenticationManager myManager;

    public SvnInteractiveAuthenticationProvider(SvnVcs vcs, SvnAuthenticationManager manager) {
        this.myManager = manager;
        this.myProject = vcs.getProject();
    }

    public static void clearCallState() {
        myCallState.set(null);
    }

    public static boolean wasCalled() {
        return myCallState.get() != null && myCallState.get().isWasCalled();
    }

    public static boolean wasCancelled() {
        return myCallState.get() != null && myCallState.get().isWasCancelled();
    }

    public SVNAuthentication requestClientAuthentication(String kind, final SVNURL url, final String realm, SVNErrorMessage errorMessage, final SVNAuthentication previousAuth, boolean authMayBeStored) {
        String userName;
        MyCallState callState = new MyCallState(true, false);
        myCallState.set(callState);
        SvnConfiguration configuration = SvnConfiguration.getInstance(this.myProject);
        configuration.clearCredentials(kind, realm);
        final SVNAuthentication[] result = new SVNAuthentication[1];
        Runnable command = null;
        final boolean authCredsOn = authMayBeStored && this.myManager.authCredsOn(url);
        String string = userName = previousAuth != null && previousAuth.getUserName() != null ? previousAuth.getUserName() : SystemProperties.getUserName();
        if ("svn.simple".equals(kind)) {
            command = new Runnable(){

                @Override
                public void run() {
                    SimpleCredentialsDialog dialog = new SimpleCredentialsDialog(SvnInteractiveAuthenticationProvider.this.myProject);
                    dialog.setup(realm, userName, authCredsOn);
                    if (previousAuth == null) {
                        dialog.setTitle(SvnBundle.message("dialog.title.authentication.required", new Object[0]));
                    } else {
                        dialog.setTitle(SvnBundle.message("dialog.title.authentication.required.was.failed", new Object[0]));
                    }
                    dialog.show();
                    if (dialog.isOK()) {
                        result[0] = new SVNPasswordAuthentication(dialog.getUserName(), dialog.getPassword(), dialog.isSaveAllowed(), url, false);
                    }
                }
            };
        } else if ("svn.username".equals(kind)) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                return new SVNUserNameAuthentication(userName, false);
            }
            command = new Runnable(){

                @Override
                public void run() {
                    UserNameCredentialsDialog dialog = new UserNameCredentialsDialog(SvnInteractiveAuthenticationProvider.this.myProject);
                    dialog.setup(realm, userName, authCredsOn);
                    if (previousAuth == null) {
                        dialog.setTitle(SvnBundle.message("dialog.title.authentication.required", new Object[0]));
                    } else {
                        dialog.setTitle(SvnBundle.message("dialog.title.authentication.required.was.failed", new Object[0]));
                    }
                    dialog.show();
                    if (dialog.isOK()) {
                        result[0] = new SVNUserNameAuthentication(dialog.getUserName(), dialog.isSaveAllowed(), url, false);
                    }
                }
            };
        } else if ("svn.ssh".equals(kind)) {
            command = new Runnable(){

                @Override
                public void run() {
                    SSHCredentialsDialog dialog = new SSHCredentialsDialog(SvnInteractiveAuthenticationProvider.this.myProject, realm, userName, authCredsOn, url.getPort());
                    if (previousAuth == null) {
                        dialog.setTitle(SvnBundle.message("dialog.title.authentication.required", new Object[0]));
                    } else {
                        dialog.setTitle(SvnBundle.message("dialog.title.authentication.required.was.failed", new Object[0]));
                    }
                    dialog.show();
                    if (dialog.isOK()) {
                        int port = dialog.getPortNumber();
                        if (dialog.getKeyFile() != null && dialog.getKeyFile().trim().length() > 0) {
                            String passphrase = dialog.getPassphrase();
                            if (passphrase != null && passphrase.length() == 0) {
                                passphrase = null;
                            }
                            result[0] = new SVNSSHAuthentication(dialog.getUserName(), new File(dialog.getKeyFile()), passphrase, port, dialog.isSaveAllowed(), url, false);
                        } else {
                            result[0] = new SVNSSHAuthentication(dialog.getUserName(), dialog.getPassword(), port, dialog.isSaveAllowed(), url, false);
                        }
                    }
                }
            };
        } else if ("svn.ssl.client-passphrase".equals(kind)) {
            command = new Runnable(){

                @Override
                public void run() {
                    SSLCredentialsDialog dialog = new SSLCredentialsDialog(SvnInteractiveAuthenticationProvider.this.myProject, realm, authCredsOn);
                    if (previousAuth == null) {
                        dialog.setTitle(SvnBundle.message("dialog.title.authentication.required", new Object[0]));
                    } else {
                        dialog.setTitle(SvnBundle.message("dialog.title.authentication.required.was.failed", new Object[0]));
                    }
                    dialog.show();
                    if (dialog.isOK()) {
                        result[0] = new SVNSSLAuthentication(new File(dialog.getCertificatePath()), String.valueOf(dialog.getCertificatePassword()), dialog.getSaveAuth(), url, false);
                    }
                }
            };
        }
        if (command != null) {
            Application application = ApplicationManager.getApplication();
            if (application.isDispatchThread()) {
                command.run();
            } else {
                ProgressIndicator pi = ProgressManager.getInstance().getProgressIndicator();
                application.invokeAndWait(command, pi == null ? ModalityState.defaultModalityState() : pi.getModalityState());
            }
            this.log("3 authentication result: " + result[0]);
        }
        boolean wasCanceled = result[0] == null;
        callState.setWasCancelled(wasCanceled);
        this.myManager.requested(ProviderType.interactive, url, realm, kind, wasCanceled);
        return result[0];
    }

    public int acceptServerAuthentication(SVNURL url, String realm, Object certificate, boolean resultMayBeStored) {
        return 0;
    }

    private void log(String s) {
        LOG.debug(s);
    }

    public static class MyCallState {
        private final boolean myWasCalled;
        private boolean myWasCancelled;

        public MyCallState(boolean wasCalled, boolean wasCancelled) {
            this.myWasCalled = wasCalled;
            this.myWasCancelled = wasCancelled;
        }

        public boolean isWasCalled() {
            return this.myWasCalled;
        }

        public boolean isWasCancelled() {
            return this.myWasCancelled;
        }

        public void setWasCancelled(boolean wasCancelled) {
            this.myWasCancelled = wasCancelled;
        }
    }
}

