/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.checkout;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.WindowManager;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNEventAction;

public class CheckoutEventHandler
implements ISVNEventHandler {
    private final ProgressIndicator myIndicator;
    private int myExternalsCount;
    private final SvnVcs myVCS;
    private final boolean myIsExport;

    public CheckoutEventHandler(SvnVcs vcs, boolean isExport, ProgressIndicator indicator) {
        this.myIndicator = indicator;
        this.myVCS = vcs;
        this.myExternalsCount = 1;
        this.myIsExport = isExport;
    }

    public void handleEvent(SVNEvent event, double progress) {
        String path = SvnUtil.getPathForProgress(event);
        if (path == null) {
            return;
        }
        if (event.getAction() == SVNEventAction.UPDATE_EXTERNAL) {
            ++this.myExternalsCount;
            this.myIndicator.setText(SvnBundle.message("progress.text2.fetching.external.location", event.getFile().getAbsolutePath()));
            this.myIndicator.setText2("");
        } else if (event.getAction() == SVNEventAction.UPDATE_ADD) {
            this.myIndicator.setText2(SvnBundle.message(this.myIsExport ? "progress.text2.exported" : "progress.text2.checked.out", event.getFile().getName()));
        } else if (event.getAction() == SVNEventAction.UPDATE_COMPLETED) {
            --this.myExternalsCount;
            this.myIndicator.setText2(SvnBundle.message(this.myIsExport ? "progress.text2.exported.revision" : "progress.text2.checked.out.revision", event.getRevision()));
            if (this.myExternalsCount == 0 && event.getRevision() >= 0L && this.myVCS != null) {
                StatusBar statusBar;
                this.myExternalsCount = 1;
                Project project = this.myVCS.getProject();
                if (project != null && (statusBar = WindowManager.getInstance().getStatusBar(project)) != null) {
                    statusBar.setInfo(SvnBundle.message(this.myIsExport ? "progress.text2.exported.revision" : "status.text.checked.out.revision", event.getRevision()));
                }
            }
        } else if (event.getAction() == SVNEventAction.COMMIT_ADDED) {
            this.myIndicator.setText2(SvnBundle.message("progress.text2.adding", path));
        } else if (event.getAction() == SVNEventAction.COMMIT_DELTA_SENT) {
            this.myIndicator.setText2(SvnBundle.message("progress.text2.transmitting.delta", path));
        }
    }

    public void checkCancelled() throws SVNCancelException {
        if (this.myIndicator.isCanceled()) {
            throw new SVNCancelException(SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CANCELLED, (String)"Operation cancelled"));
        }
    }
}

