/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.actions;

import com.intellij.openapi.progress.ProgressIndicator;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnUtil;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNEventAction;

public class CopyEventHandler
implements ISVNEventHandler {
    private final ProgressIndicator myProgress;

    public CopyEventHandler(ProgressIndicator progress) {
        this.myProgress = progress;
    }

    public void handleEvent(SVNEvent event, double p) {
        String path = SvnUtil.getPathForProgress(event);
        if (path == null) {
            return;
        }
        if (event.getAction() == SVNEventAction.COMMIT_ADDED) {
            this.myProgress.setText2(SvnBundle.message("progress.text2.adding", path));
        } else if (event.getAction() == SVNEventAction.COMMIT_DELETED) {
            this.myProgress.setText2(SvnBundle.message("progress.text2.deleting", path));
        } else if (event.getAction() == SVNEventAction.COMMIT_MODIFIED) {
            this.myProgress.setText2(SvnBundle.message("progress.text2.sending", path));
        } else if (event.getAction() == SVNEventAction.COMMIT_REPLACED) {
            this.myProgress.setText2(SvnBundle.message("progress.text2.replacing", path));
        } else if (event.getAction() == SVNEventAction.COMMIT_DELTA_SENT) {
            this.myProgress.setText2(SvnBundle.message("progress.text2.transmitting.delta", path));
        }
    }

    public void checkCancelled() {
    }
}

